/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldIFace;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.CurrencyValidator;
import org.apache.log4j.Logger;

public class ValFormattedTextFieldSingle
extends JTextField
implements ValFormattedTextFieldIFace,
UIRegistry.UndoableTextIFace {
    private static final Logger log = Logger.getLogger(ValFormattedTextFieldSingle.class);
    protected DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.getDefault());
    protected NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.getDefault());
    protected NumberFormat numIntFormatter = NumberFormat.getIntegerInstance(Locale.getDefault());
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper viewBGColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected boolean isViewOnly = false;
    protected boolean needsUpdating = false;
    protected List<DocumentListener> documentListeners = null;
    protected boolean doSetText = false;
    protected boolean isPartialOK = false;
    protected boolean isAutoFmtOn = true;
    protected JFormattedDoc document;
    protected String defaultValue = null;
    protected UIFieldFormatterIFace formatter;
    protected List<UIFieldFormatterField> fields = null;
    protected boolean isFromUIFmtOverride = false;
    protected Integer suggestedNumCols = null;
    protected Object origValue = null;
    protected UndoManager undoManager = null;
    protected String bgStr = null;
    protected Point pnt = null;
    protected Color textColor = new Color(200, 200, 200);
    protected Insets inner;
    protected BigDecimalValidator bdValidator = null;

    protected ValFormattedTextFieldSingle() {
    }

    public ValFormattedTextFieldSingle(UIFieldFormatterIFace formatter, boolean isViewOnly, boolean isPartialOK, boolean addFocusListeners) {
        this.init(formatter, isViewOnly, isPartialOK, null, addFocusListeners);
    }

    public ValFormattedTextFieldSingle(UIFieldFormatterIFace formatter, boolean isViewOnly, boolean isPartialOK) {
        this.init(formatter, isViewOnly, isPartialOK, null, false);
    }

    public ValFormattedTextFieldSingle(String formatterName, boolean isViewOnly, boolean isPartialOK, Integer suggestedNumCols) {
        this.init(UIFieldFormatterMgr.getInstance().getFormatter(formatterName), isViewOnly, isPartialOK, suggestedNumCols, false);
    }

    protected void init(UIFieldFormatterIFace formatterArg, boolean isViewOnlyArg, boolean isPartialOKArg, Integer suggNumCols, boolean addFocusListeners) {
        UIHelper.setControlSize(this);
        this.isPartialOK = isPartialOKArg;
        this.isViewOnly = isViewOnlyArg;
        this.suggestedNumCols = suggNumCols;
        this.initColors();
        this.inner = this.getInsets();
        this.setFormatterInternal(formatterArg);
        int numCols = this.suggestedNumCols != null ? Math.max(this.suggestedNumCols, this.formatter.getUILength()) : this.formatter.getUILength();
        this.setColumns(numCols);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
            }
        });
        if (addFocusListeners) {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    log.debug((Object)("[" + ValFormattedTextFieldSingle.this.getText() + "]"));
                    ((JTextField)e.getSource()).selectAll();
                    ValFormattedTextFieldSingle.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ValFormattedTextFieldSingle.this.isNew = false;
                    ValFormattedTextFieldSingle.this.validateState();
                    ValFormattedTextFieldSingle.this.repaint();
                }
            });
        }
        this.setBackground(this.isRequired ? requiredFieldColor.getColor() : viewBGColor.getColor());
        if (!isViewOnlyArg) {
            if (!formatterArg.isUserInputNeeded() && !this.isPartialOK && this.isAutoFmtOn) {
                ViewFactory.changeTextFieldUIForDisplay(this, false);
            } else {
                super.setEnabled(true);
            }
        }
    }

    public void addDocumentListener(DocumentListener dl) {
        if (this.documentListeners == null) {
            this.documentListeners = new Vector<DocumentListener>();
        }
        this.documentListeners.add(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        if (this.documentListeners != null) {
            this.documentListeners.remove(dl);
        }
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setPartialOK(boolean isPartialOK) {
        boolean isDifferent = this.isPartialOK ^ isPartialOK;
        this.isPartialOK = isPartialOK;
        if (isDifferent) {
            this.setRequired(this.isRequired);
        }
    }

    protected void setFormatterInternal(UIFieldFormatterIFace formatterArg) {
        if (formatterArg != null && this.formatter != formatterArg) {
            this.formatter = formatterArg;
            this.fields = this.formatter.getFields();
            int requiredLength = this.formatter.getLength();
            this.bgStr = this.formatter.toPattern();
            this.document = new JFormattedDoc(this, this.formatter, requiredLength);
            this.document.setIgnoreLenForValidation(this.isPartialOK);
            this.setDocument(this.document);
            this.document.addDocumentListener(new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    ValFormattedTextFieldSingle.this.isChanged = true;
                    if (ValFormattedTextFieldSingle.this.formatter.isLengthOK(ValFormattedTextFieldSingle.this.getText().length())) {
                        ValFormattedTextFieldSingle.this.setState(ValFormattedTextFieldSingle.this.formatter.isValid(ValFormattedTextFieldSingle.this.getText()) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error);
                        ValFormattedTextFieldSingle.this.repaint();
                    }
                    if (ValFormattedTextFieldSingle.this.documentListeners != null) {
                        for (DocumentListener dl : ValFormattedTextFieldSingle.this.documentListeners) {
                            dl.changedUpdate(null);
                        }
                    }
                }
            });
        }
    }

    public UIFieldFormatterIFace getFormatter() {
        return this.formatter;
    }

    public void setFormatter(UIFieldFormatterIFace formatter) {
        Object currentValue = this.isChanged ? this.getValue() : this.origValue;
        this.setFormatterInternal(formatter);
        this.setValue(currentValue, "");
    }

    public void initColors() {
        if (valTextColor == null || requiredFieldColor == null || viewBGColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
            viewBGColor = AppPrefsCache.getColorWrapper("ui", "formatting", "viewfieldcolor");
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    @Override
    public boolean isNotEmpty() {
        return !this.getText().isEmpty();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        String text = this.getText();
        if (!this.isViewOnly && this.needsUpdating && this.isEnabled() && text != null && text.length() < this.bgStr.length()) {
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(text);
            this.pnt = new Point(this.inner.left + w, this.inner.top + fm.getAscent());
            Rectangle r = g.getClipBounds();
            Dimension s = this.getSize();
            Insets i2 = this.getBorder().getBorderInsets(this);
            int x = i2.left - 1;
            int y = i2.top - 1;
            int hh = s.height - i2.bottom + 1;
            String str = this.bgStr.substring(text.length(), this.bgStr.length());
            int bgW = fm.stringWidth(str);
            g.setClip(x + w, y, Math.min(x + bgW, g.getClipBounds().width - x), hh);
            g.setColor(this.textColor);
            g.drawString(str, this.pnt.x, this.pnt.y);
            g.setClip(r.x, r.y, r.width, r.height);
        }
        if (this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, this.isNew ? new Color(249, 249, 0) : valTextColor.getColor(), this.getSize(), 1);
        } else if (this.valState == UIValidatable.ErrorType.Incomplete && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, new Color(249, 249, 0), this.getSize(), 1);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean isNeeded = this.formatter.isUserInputNeeded();
        if (enabled && isNeeded) {
            super.setEnabled(isNeeded);
        } else {
            super.setEnabled(enabled);
        }
        this.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : viewBGColor.getColor());
        if (enabled) {
            if (this.origValue == null && this.defaultValue != null) {
                this.setText(this.defaultValue, false);
            }
        } else if (this.origValue == null && this.defaultValue != null) {
            this.setText("", false);
        }
    }

    protected void setText(String text, boolean notify) {
        this.document.setIgnoreNotify(!notify);
        if (StringUtils.isEmpty((String)text)) {
            this.bgStr = this.formatter.toPattern();
        }
        this.doSetText = true;
        super.setText(text);
        this.doSetText = false;
        this.document.setIgnoreNotify(notify);
        this.repaint();
    }

    @Override
    public void setText(String text) {
        this.setText(text, false);
    }

    public boolean isOK() {
        return this.valState == UIValidatable.ErrorType.Valid;
    }

    public void setViewOnly(boolean isViewOnly) {
        this.isViewOnly = isViewOnly;
    }

    @Override
    public void updateAutoNumbers() {
        String nextNum;
        if (this.isAutoFmtOn && this.needsUpdating && this.formatter.getAutoNumber() != null && !this.isViewOnly && StringUtils.isNotEmpty((String)(nextNum = this.formatter.getNextNumber(this.getText())))) {
            try {
                this.setValue(nextNum, nextNum);
                this.bgStr = "";
                this.needsUpdating = false;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ValFormattedTextFieldSingle.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean isFormatterAutoNumber() {
        return this.formatter != null && this.formatter.getAutoNumber() != null;
    }

    @Override
    public void setAutoNumberEnabled(boolean turnOn) {
        if (this.isAutoFmtOn != turnOn && this.formatter.isIncrementer()) {
            if (turnOn) {
                ViewFactory.changeTextFieldUIForDisplay(this, false);
            } else {
                JTextField tf = new JTextField();
                ViewFactory.changeTextFieldUIForEdit(this, tf.getBorder(), tf.getForeground(), tf.getBackground(), tf.isOpaque());
            }
        }
        this.isAutoFmtOn = turnOn;
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired && !this.isViewOnly;
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (!this.isViewOnly) {
            this.setBackground(isRequired && this.isEnabled() ? requiredFieldColor.getColor() : viewBGColor.getColor());
            this.isRequired = isRequired;
        }
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        if (isNew && this.origValue == null) {
            this.setText(StringUtils.isNotEmpty((String)this.defaultValue) ? this.defaultValue : "");
        }
        this.isNew = this.isRequired || !this.formatter.isUserInputNeeded() ? isNew : false;
    }

    @Override
    public void reset() {
        this.origValue = null;
        this.setText(StringUtils.isNotEmpty((String)this.defaultValue) ? this.defaultValue : "", true);
        this.validateState();
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        if (this.isViewOnly) {
            this.valState = UIValidatable.ErrorType.Valid;
        } else if (this.formatter != null && this.formatter.isUserInputNeeded()) {
            String data = this.getText();
            if (StringUtils.isEmpty((String)data)) {
                this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
            } else if (this.formatter.isNumeric()) {
                this.valState = this.validateNumeric(data);
            } else if (!this.document.isIgnoreLenForValidation()) {
                UIValidatable.ErrorType errorType = this.valState = this.formatter.isLengthOK(data.length()) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error;
                if (this.valState == UIValidatable.ErrorType.Valid) {
                    this.valState = this.formatter.isValid(data) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error;
                }
            } else {
                this.valState = UIValidatable.ErrorType.Valid;
            }
        } else {
            this.valState = UIValidatable.ErrorType.Valid;
        }
        return this.valState;
    }

    @Override
    public int getColumns() {
        int w = super.getColumns();
        return w;
    }

    @Override
    protected int getColumnWidth() {
        int w = super.getColumnWidth();
        return w;
    }

    @Override
    public void setColumns(int arg0) {
        super.setColumns(arg0);
    }

    protected boolean isMinMaxOK(Number val) {
        if (val != null) {
            Number maxValue = this.formatter.getMaxValue();
            Number minValue = this.formatter.getMinValue();
            if (minValue != null && maxValue != null) {
                return !(val.doubleValue() > maxValue.doubleValue()) && !(val.doubleValue() < minValue.doubleValue());
            }
        }
        return true;
    }

    protected UIValidatable.ErrorType validateNumeric(String value) {
        Class<?> cls = this.formatter.getDataClass();
        try {
            if (cls == Long.class) {
                Number num = this.numIntFormatter.parse(value);
                Long val = num.longValue();
                return !this.isMinMaxOK(val) || val > Long.MAX_VALUE || val < -9223372036854775807L ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
            }
            if (cls == Integer.class) {
                Number num = this.numIntFormatter.parse(value);
                Integer val = num.intValue();
                return !this.isMinMaxOK(val) || val > Integer.MAX_VALUE || val < -2147483647 ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
            }
            if (cls == Short.class) {
                Number num = this.numIntFormatter.parse(value);
                Short val = num.shortValue();
                return !this.isMinMaxOK(val) || val > Short.MAX_VALUE || val < -32767 ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
            }
            if (cls == Byte.class) {
                Number num = this.numIntFormatter.parse(value);
                Byte val = num.byteValue();
                return !this.isMinMaxOK(val) || val > 127 || val < -127 ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
            }
            if (cls == Double.class) {
                Number num = this.numberFormatter.parse(value);
                Double val = num.doubleValue();
                return !this.isMinMaxOK(val) || val > Double.MAX_VALUE || val < -1.7976931348623157E308 ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
            }
            if (cls == Float.class) {
                Number num = this.numberFormatter.parse(value);
                Float val = Float.valueOf(num.floatValue());
                return !this.isMinMaxOK(val) || val.floatValue() > Float.MAX_VALUE || val.floatValue() < -3.4028235E38f ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
            }
            if (cls == BigDecimal.class) {
                if (this.bdValidator == null) {
                    this.bdValidator = CurrencyValidator.getInstance();
                }
                Number maxVal = this.formatter.getMaxValue();
                Number minVal = this.formatter.getMinValue();
                BigDecimal fooAmount = this.bdValidator.validate(value, Locale.getDefault());
                if (fooAmount == null) {
                    return UIValidatable.ErrorType.Error;
                }
                if (!this.bdValidator.minValue((Number)fooAmount, minVal) || !this.bdValidator.maxValue((Number)fooAmount, maxVal)) {
                    return UIValidatable.ErrorType.Error;
                }
                return UIValidatable.ErrorType.Valid;
            }
            throw new RuntimeException("Missing case for numeric class [" + cls.getName() + "]");
        }
        catch (Exception exception) {
            return UIValidatable.ErrorType.Error;
        }
    }

    @Override
    public void cleanUp() {
        this.document = null;
        this.formatter = null;
        this.fields = null;
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public UndoManager getUndoManager() {
        if (this.undoManager == null) {
            this.undoManager = new UndoManager();
            UIRegistry.getInstance().hookUpUndoableEditListener(this);
        }
        return this.undoManager;
    }

    @Override
    public JTextComponent getTextComponent() {
        return this;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        String data;
        this.defaultValue = defaultValue;
        this.document.setAllowText(true);
        if (value != null) {
            data = value instanceof String ? (String)value : (value instanceof Date ? this.formatter.getDateWrapper().format((Date)value) : (value instanceof Calendar ? this.formatter.getDateWrapper().format(((Calendar)value).getTime()) : (value instanceof Number ? (this.formatter != null ? this.formatter.formatToUI(value).toString() : value.toString()) : value.toString())));
        } else {
            data = this.isEnabled() && StringUtils.isNotEmpty((String)defaultValue) && this.formatter.getAutoNumber() == null && this.isNew ? defaultValue : "";
            this.needsUpdating = true;
        }
        if (this.origValue == null) {
            this.origValue = value;
        }
        if (this.formatter.isInBoundFormatter()) {
            this.setText((String)this.formatter.formatToUI(data));
            this.needsUpdating = StringUtils.isEmpty((String)data) && this.formatter.getAutoNumber() != null && this.formatter.isIncrementer();
        } else {
            this.setText(data);
        }
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
        this.document.setAllowText(false);
        this.validateState();
        this.repaint();
    }

    public void setFromUIFmtOverride(boolean isFromUIFmtOverride) {
        this.isFromUIFmtOverride = isFromUIFmtOverride;
    }

    @Override
    public Object getValue() {
        if (this.formatter.isDate()) {
            String value = this.getText();
            if (StringUtils.isNotEmpty((String)value)) {
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.formatter.getDateWrapper().getSimpleDateFormat().parse(value));
                    return cal;
                }
                catch (ParseException ex) {
                    log.error((Object)("Date is in error for parsing[" + value + "]"));
                }
            }
            return null;
        }
        String val = this.getText();
        if (this.formatter.isFromUIFormatter() && !this.isFromUIFmtOverride && StringUtils.isNotEmpty((String)val)) {
            return this.formatter.formatFromUI(this.getText());
        }
        return val != null && val.isEmpty() ? null : val;
    }

    public class JFormattedDoc
    extends ValPlainTextDocument {
        protected int docLimit;
        protected ValFormattedTextFieldSingle textField;
        protected UIFieldFormatterIFace docFormatter;
        protected UIFieldFormatterField[] docFields;
        protected boolean ignoreLenForValidation = false;
        protected boolean isReplacingSameSize = false;
        protected boolean allowText = false;

        public JFormattedDoc(ValFormattedTextFieldSingle textField, UIFieldFormatterIFace formatter, int limit) {
            this.textField = textField;
            this.docFormatter = formatter;
            this.docLimit = limit;
            this.docFields = new UIFieldFormatterField[limit];
            int inx = 0;
            for (UIFieldFormatterField f : this.docFormatter.getFields()) {
                int i = 0;
                while (i < f.getSize()) {
                    this.docFields[inx++] = f;
                    ++i;
                }
            }
        }

        public boolean isIgnoreLenForValidation() {
            return this.ignoreLenForValidation;
        }

        public void setIgnoreLenForValidation(boolean ignoreLenForValidation) {
            this.ignoreLenForValidation = ignoreLenForValidation;
        }

        public boolean isNumber(String string) {
            try {
                return ValFormattedTextFieldSingle.this.numberFormatter.parse(string) != null;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        protected boolean isCharOK(UIFieldFormatterField field, String str) {
            if (field.getType() == UIFieldFormatterField.FieldType.alpha && !StringUtils.isAlpha((String)str)) {
                return false;
            }
            if (field.getType() == UIFieldFormatterField.FieldType.alphanumeric && !StringUtils.isAlphanumeric((String)str)) {
                return false;
            }
            if (field.getType() == UIFieldFormatterField.FieldType.anychar) {
                return true;
            }
            if (field.getType() == UIFieldFormatterField.FieldType.numeric) {
                char decSep = ValFormattedTextFieldSingle.this.formatSymbols.getDecimalSeparator();
                String str1 = StringUtils.remove((String)str, (char)decSep);
                String str2 = StringUtils.remove((String)str1, (char)'-');
                if (StringUtils.isNumeric((String)str2)) {
                    Class<?> cls = ValFormattedTextFieldSingle.this.formatter.getDataClass();
                    if (cls == Integer.class || cls == Long.class || cls == Short.class || cls == Byte.class) {
                        return str1.length() == str.length();
                    }
                    return str2.length() == 0 || StringUtils.isNumericSpace((String)str2);
                }
                return false;
            }
            return true;
        }

        public void setAllowText(boolean allowText) {
            this.allowText = allowText;
        }

        protected boolean okToInsertText(String str) {
            int len = Math.min(str.length(), this.docLimit);
            int i = 0;
            while (i < len) {
                char c = str.charAt(i);
                if (this.docFields[i].getType() == UIFieldFormatterField.FieldType.separator && c != this.docFields[i].getValue().charAt(0)) {
                    return false;
                }
                String s = "";
                if (!this.isCharOK(this.docFields[i], s = String.valueOf(s) + c)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.docFormatter.isIncrementer() && !this.allowText && !ValFormattedTextFieldSingle.this.isPartialOK && ValFormattedTextFieldSingle.this.isAutoFmtOn) {
                return;
            }
            this.isReplacingSameSize = text.length() == length;
            super.replace(offset, length, text, attrs);
        }

        @Override
        public void remove(int offset, int len) {
            if (this.docFormatter.isIncrementer() && !this.allowText && !ValFormattedTextFieldSingle.this.isPartialOK && ValFormattedTextFieldSingle.this.isAutoFmtOn) {
                return;
            }
            try {
                int l = ValFormattedTextFieldSingle.this.formatter.isNumeric() || ValFormattedTextFieldSingle.this.formatter.isDate() || this.isReplacingSameSize ? len : this.getLength() - offset;
                super.remove(offset, l);
                ValFormattedTextFieldSingle.this.validateState();
            }
            catch (BadLocationException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ValFormattedTextFieldSingle.class, ex);
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void insertString(int offset, String strArg, AttributeSet attr) throws BadLocationException {
            String str = strArg;
            if (str == null) {
                return;
            }
            if (this.docFormatter.isIncrementer() && !this.allowText && !ValFormattedTextFieldSingle.this.isPartialOK && ValFormattedTextFieldSingle.this.isAutoFmtOn) {
                return;
            }
            if (str.length() > 1) {
                int len;
                if (!ValFormattedTextFieldSingle.this.doSetText && (len = Math.min(str.length(), this.docLimit)) < this.docLimit && this.docFields[len - 1].isIncrementer()) {
                    return;
                }
                if (this.okToInsertText(str)) {
                    super.insertString(offset, str, attr);
                }
                ValFormattedTextFieldSingle.this.validateState();
                return;
            }
            int len = this.getLength() + str.length();
            if (len <= this.docLimit) {
                int inx;
                UIFieldFormatterField field = this.docFields[offset];
                if (!this.isCharOK(field, str)) {
                    ValFormattedTextFieldSingle.this.validateState();
                    return;
                }
                if (field.getType() == UIFieldFormatterField.FieldType.separator) {
                    if (str.charAt(0) != field.getValue().charAt(0)) {
                        if (!this.isCharOK(this.docFields[offset + 1], str)) {
                            ValFormattedTextFieldSingle.this.validateState();
                            return;
                        }
                        str = String.valueOf(field.getValue()) + str;
                    }
                } else {
                    this.docFields[offset].isIncrementer();
                }
                super.insertString(offset, str, attr);
                String text = this.textField.getText();
                if (text != null && text.length() < this.docLimit && (field = this.docFields[inx = text.length()]) != null && (field.getType() == UIFieldFormatterField.FieldType.separator || field.isIncrementer())) {
                    StringBuilder sb = new StringBuilder(text.substring(offset + str.length()));
                    while (field != null && (field.getType() == UIFieldFormatterField.FieldType.separator || field.isIncrementer())) {
                        if (field.getType() == UIFieldFormatterField.FieldType.separator) {
                            sb.append(field.getValue());
                            ++inx;
                        } else {
                            int i = 0;
                            while (i < field.getSize()) {
                                sb.append("#");
                                ++i;
                            }
                            inx += field.getSize();
                        }
                        field = inx < this.docLimit ? this.docFields[inx] : null;
                    }
                    this.insertString(offset + str.length(), sb.toString(), attr);
                }
            }
            ValFormattedTextFieldSingle.this.validateState();
        }
    }
}

