/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldIFace;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.StringUtils;

public class ValFormattedTextField
extends JPanel
implements ValFormattedTextFieldIFace {
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected static ColorWrapper viewFieldColor = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected boolean isViewOnly = false;
    protected boolean isPartialOK = false;
    protected boolean isSearch = false;
    protected Color bgColor = null;
    protected JTextField viewtextField = null;
    protected boolean shouldIgnoreNotifyDoc = true;
    protected boolean needsUpdating = false;
    protected String currCachedValue = null;
    protected List<JFormattedDoc> documents = new Vector<JFormattedDoc>();
    protected String defaultValue = null;
    protected UIFieldFormatterIFace formatter;
    protected List<UIFieldFormatterField> fields = null;
    protected boolean isFromUIFmtOverride = false;
    protected List<DocumentListener> documentListeners = null;
    protected boolean isAutoFmtOn = true;
    protected Object origValue = null;
    protected ChangeListener changeListener = null;
    protected CardLayout cardLayout;
    protected JPanel cardPanel = null;
    protected BGTextField viewTF = null;
    protected JTextField editTF = null;
    protected Color textColor = new Color(0, 0, 0, 64);
    protected JComponent[] comps = null;
    protected char autoNumberChar = UIFieldFormatterMgr.getAutoNumberPatternChar();
    protected KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());

    protected ValFormattedTextField() {
        this.setOpaque(false);
    }

    public ValFormattedTextField(UIFieldFormatterIFace formatter, boolean isViewOnly, boolean isAllEditable) {
        this(formatter, isViewOnly, isAllEditable, false);
    }

    public ValFormattedTextField(UIFieldFormatterIFace formatter, boolean isViewOnly, boolean isAllEditable, boolean isPartialOK) {
        this();
        this.isViewOnly = isViewOnly;
        this.isPartialOK = isPartialOK;
        this.init(formatter, isAllEditable);
    }

    public ValFormattedTextField(UIFieldFormatterIFace formatter, boolean isViewOnly) {
        this(formatter, isViewOnly, false, false);
    }

    public ValFormattedTextField(String formatterName, boolean isViewOnly) {
        this(formatterName, isViewOnly, false, false);
    }

    public ValFormattedTextField(String formatterName, boolean isViewOnly, boolean isAllEditable, boolean isPartialOK) {
        this.isViewOnly = isViewOnly;
        this.isPartialOK = isPartialOK;
        this.init(UIFieldFormatterMgr.getInstance().getFormatter(formatterName), isAllEditable);
    }

    public ValFormattedTextField(String formatterName, boolean isViewOnly, boolean isAllEditable) {
        this.isViewOnly = isViewOnly;
        this.init(UIFieldFormatterMgr.getInstance().getFormatter(formatterName), isAllEditable);
    }

    public void setPartialOK(boolean isPartialOK) {
        boolean isDifferent = this.isPartialOK ^ isPartialOK;
        this.isPartialOK = isPartialOK;
        if (isDifferent) {
            this.setRequired(this.isRequired);
        }
    }

    @Override
    public void requestFocus() {
        if (this.comps != null && this.comps[0] != null) {
            this.comps[0].requestFocus();
        }
    }

    protected void init(UIFieldFormatterIFace formatterArg, boolean isAllEditable) {
        this.setFormatterInternal(formatterArg);
        this.createUI();
        if (!(this.isPartialOK || valTextColor != null && requiredFieldColor != null && viewFieldColor != null)) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
            viewFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "viewfieldcolor");
        }
        if (!this.isViewOnly && this.comps != null && !isAllEditable) {
            int inx = 0;
            for (UIFieldFormatterField field : this.fields) {
                if (field.isIncrementer() && !this.isPartialOK) {
                    if (this.comps[inx] instanceof JTextField) {
                        ViewFactory.changeTextFieldUIForDisplay((JTextField)this.comps[inx], this.getBackground(), false);
                    } else if (this.comps[inx] instanceof JPanel) {
                        ViewFactory.changeTextFieldUIForDisplay(this.viewTF, this.getBackground(), false);
                    }
                }
                ++inx;
            }
        }
    }

    public JTextField getTextField() {
        return this.viewtextField;
    }

    public JComponent[] getTextComps() {
        return this.comps;
    }

    protected void addFocusAdapter(JTextField textField) {
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getSource()).selectAll();
                ValFormattedTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValFormattedTextField.this.isNew = false;
                ValFormattedTextField.this.validateState();
                ValFormattedTextField.this.repaint();
            }
        });
    }

    protected void createUI() {
        CellConstraints cc = new CellConstraints();
        if (this.isViewOnly || !this.formatter.isUserInputNeeded() && this.fields.size() == 1) {
            this.viewtextField = new JTextField();
            UIHelper.setControlSize(this.viewtextField);
            ViewFactory.changeTextFieldUIForDisplay(this.viewtextField, false);
            PanelBuilder builder = new PanelBuilder(new FormLayout("1px,f:p:g,1px", "1px,f:p:g,1px"), (JPanel)this);
            builder.add((Component)this.viewtextField, cc.xy(2, 2));
            this.bgColor = this.viewtextField.getBackground();
        } else {
            JTextField txt = new JTextField();
            Font txtFont = txt.getFont();
            Font font = new Font("Courier", 0, txtFont.getSize());
            BufferedImage bi = new BufferedImage(1, 1, 1);
            Graphics2D g = bi.createGraphics();
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics(font);
            g.dispose();
            Insets ins = txt.getBorder().getBorderInsets(txt);
            int baseWidth = ins.left + ins.right;
            this.bgColor = txt.getBackground();
            StringBuilder sb = new StringBuilder("1px");
            int i = 0;
            for (UIFieldFormatterField f : this.fields) {
                sb.append(",");
                if (f.getType() == UIFieldFormatterField.FieldType.separator || f.getType() == UIFieldFormatterField.FieldType.constant) {
                    sb.append('p');
                } else {
                    sb.append(String.valueOf(fm.getMaxAdvance() * f.getSize() + baseWidth) + "px");
                }
                ++i;
            }
            sb.append(",1px");
            PanelBuilder builder = new PanelBuilder(new FormLayout(sb.toString(), "1px,P:G,1px"), (JPanel)this);
            this.comps = new JComponent[this.fields.size()];
            int inx = 0;
            for (UIFieldFormatterField f : this.fields) {
                JComponent comp = null;
                JComponent tfToAdd = null;
                if (f.getType() == UIFieldFormatterField.FieldType.separator || f.getType() == UIFieldFormatterField.FieldType.constant) {
                    comp = UIHelper.createLabel(f.getValue());
                    if (f.getType() == UIFieldFormatterField.FieldType.constant) {
                        comp.setBackground(Color.WHITE);
                        comp.setOpaque(true);
                    }
                    tfToAdd = comp;
                } else {
                    BGTextField tf = new BGTextField(f.getSize(), this.isViewOnly ? "" : f.getValue());
                    tfToAdd = tf;
                    if (inx == 0) {
                        tf.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyPressed(KeyEvent e) {
                                ValFormattedTextField.this.checkForPaste(e);
                            }
                        });
                    }
                    JFormattedDoc document = new JFormattedDoc(tf, this.formatter, f);
                    tf.setDocument(document);
                    document.addDocumentListener(new DocumentAdaptor(){

                        @Override
                        protected void changed(DocumentEvent e) {
                            ValFormattedTextField.this.isChanged = true;
                            if (!ValFormattedTextField.this.shouldIgnoreNotifyDoc) {
                                int len;
                                String fldStr = ValFormattedTextField.this.getText();
                                int n = len = StringUtils.isNotEmpty((String)fldStr) ? fldStr.length() : 0;
                                if (ValFormattedTextField.this.formatter != null && len > 0 && ValFormattedTextField.this.formatter.isLengthOK(len)) {
                                    ValFormattedTextField.this.setState(ValFormattedTextField.this.formatter.isValid(fldStr) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error);
                                    ValFormattedTextField.this.repaint();
                                }
                                if (ValFormattedTextField.this.changeListener != null) {
                                    ValFormattedTextField.this.changeListener.stateChanged(new ChangeEvent(this));
                                }
                                if (ValFormattedTextField.this.documentListeners != null) {
                                    for (DocumentListener dl : ValFormattedTextField.this.documentListeners) {
                                        dl.changedUpdate(null);
                                    }
                                }
                            }
                            ValFormattedTextField.this.currCachedValue = null;
                        }
                    });
                    this.documents.add(document);
                    this.addFocusAdapter(tf);
                    comp = tf;
                    comp.setFont(font);
                    if (f.isIncrementer()) {
                        this.editTF = tf;
                        this.cardLayout = new CardLayout();
                        this.cardPanel = new JPanel(this.cardLayout);
                        this.cardPanel.add("edit", tf);
                        this.viewTF = new BGTextField(f.getSize(), this.isViewOnly ? "" : f.getValue());
                        this.viewTF.setDocument(document);
                        this.cardPanel.add("view", this.viewTF);
                        this.cardLayout.show(this.cardPanel, "view");
                        comp = this.cardPanel;
                        tfToAdd = this.cardPanel;
                    }
                }
                UIHelper.setControlSize(tfToAdd);
                builder.add((Component)comp, cc.xy(inx + 2, 2));
                this.comps[inx] = tfToAdd;
                ++inx;
            }
        }
    }

    protected void checkForPaste(KeyEvent e) {
        String text;
        if (e.getKeyCode() == this.pasteKeyStroke.getKeyCode() && (text = UIHelper.getTextFromClipboard()) != null && text.length() <= this.formatter.getLength()) {
            this.setValue(text, null);
        }
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    protected void setFormatterInternal(UIFieldFormatterIFace formatterArg) {
        if (this.formatter != formatterArg && formatterArg != null) {
            this.formatter = formatterArg;
            this.fields = this.formatter.getFields();
        }
    }

    protected void setBGColor(Color color) {
        if (this.viewtextField != null) {
            this.viewtextField.setBackground(color);
        } else if (this.comps != null) {
            JComponent[] jComponentArray = this.comps;
            int n = this.comps.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent comp = jComponentArray[n2];
                if (comp instanceof JTextField) {
                    ((JTextField)comp).setBackground(color);
                }
                ++n2;
            }
        }
    }

    public void setFormatter(UIFieldFormatterIFace formatter) {
        Object currentValue = this.isChanged ? this.getValue() : this.origValue;
        this.setFormatterInternal(formatter);
        this.setValue(currentValue, "");
    }

    @Override
    public boolean isNotEmpty() {
        return !this.getText().isEmpty();
    }

    public String getText() {
        if (this.viewtextField != null) {
            return this.viewtextField.getText();
        }
        StringBuilder sb = new StringBuilder();
        int inx = 0;
        String prevStr = null;
        JComponent[] jComponentArray = this.comps;
        int n = this.comps.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent c = jComponentArray[n2];
            String val = null;
            if (c instanceof JLabel) {
                prevStr = val = ((JLabel)c).getText();
            } else if (c instanceof JTextField) {
                val = ((JTextField)c).getText();
            } else if (c instanceof JPanel) {
                if (this.isAutoFmtOn) {
                    val = this.viewTF.getText();
                    if (StringUtils.isEmpty((String)val)) {
                        val = this.viewTF.getBgStr();
                    }
                } else {
                    val = this.editTF.getText();
                }
            }
            if (StringUtils.isEmpty((String)val)) {
                if (this.formatter.getFields().get(inx).isIncrementer()) break;
                if (!this.isPartialOK) {
                    return null;
                }
                if (prevStr == null) break;
                sb.setLength(sb.length() - prevStr.length());
                break;
            }
            sb.append(val);
            if (!(c instanceof JLabel)) {
                prevStr = null;
            }
            ++inx;
            ++n2;
        }
        this.currCachedValue = sb.toString();
        return this.currCachedValue;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean isEnabled = enabled;
        if (!this.isViewOnly) {
            boolean isNeeded = this.formatter.isUserInputNeeded();
            isEnabled = enabled && isNeeded ? isNeeded : enabled;
            this.setBGColor(this.isRequired && isEnabled && !this.isViewOnly ? requiredFieldColor.getColor() : this.bgColor);
        }
        super.setEnabled(isEnabled);
        if (this.viewtextField != null) {
            this.viewtextField.setEnabled(isEnabled);
        } else if (this.comps != null) {
            JComponent[] jComponentArray = this.comps;
            int n = this.comps.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent comp = jComponentArray[n2];
                if (comp instanceof JTextField) {
                    ((JTextField)comp).setEnabled(isEnabled);
                } else if (comp instanceof JPanel) {
                    this.viewTF.setEnabled(isEnabled);
                    this.editTF.setEnabled(isEnabled);
                }
                ++n2;
            }
        }
    }

    public void setText(String text, boolean notify) {
        if (this.viewtextField != null) {
            this.viewtextField.setText(text);
            return;
        }
        this.shouldIgnoreNotifyDoc = !notify;
        boolean isTextEmpty = StringUtils.isEmpty((String)text);
        int txtLen = text.length();
        int inx = 0;
        int pos = 0;
        for (UIFieldFormatterField field : this.fields) {
            String val = isTextEmpty ? "" : (pos < txtLen ? text.substring(pos, Math.min(pos + field.getSize(), txtLen)) : "");
            if (this.comps[inx] instanceof JLabel) {
                if (!val.equals(field.getValue())) {
                    this.valState = UIValidatable.ErrorType.Error;
                }
            } else if (this.comps[inx] instanceof JPanel) {
                if (this.isAutoFmtOn) {
                    if (StringUtils.isNotEmpty((String)val)) {
                        this.viewTF.setText(val);
                    }
                } else {
                    this.editTF.setText(val);
                }
            } else {
                ((JTextField)this.comps[inx]).setText(val);
            }
            pos += field.getSize();
            ++inx;
        }
        this.shouldIgnoreNotifyDoc = false;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isViewOnly && !this.isPartialOK && !this.isNew && this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            Dimension size;
            if (this.comps != null && this.comps.length > 0) {
                size = this.getSize();
                JComponent lastComp = this.comps[this.comps.length - 1];
                size.width = lastComp.getBounds().x + lastComp.getBounds().width;
                --size.height;
            } else {
                size = this.editTF != null ? this.editTF.getSize() : this.getSize();
            }
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), size, 0);
        }
    }

    public boolean isOK() {
        return this.valState == UIValidatable.ErrorType.Valid;
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setViewOnly(boolean isViewOnly) {
        this.isViewOnly = isViewOnly;
    }

    @Override
    public void updateAutoNumbers() {
        if (this.isAutoFmtOn && this.needsUpdating) {
            String nextNum = this.formatter.getNextNumber(this.getText());
            if (StringUtils.isNotEmpty((String)nextNum)) {
                try {
                    this.setText(nextNum, false);
                    this.needsUpdating = false;
                    return;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ValFormattedTextField.class, ex);
                    ex.printStackTrace();
                }
            }
            this.needsUpdating = true;
        }
    }

    @Override
    public boolean isFormatterAutoNumber() {
        return !this.isPartialOK && this.formatter != null && this.formatter.getAutoNumber() != null;
    }

    @Override
    public void setAutoNumberEnabled(boolean turnOn) {
        if (this.formatter.isIncrementer() && this.cardPanel != null && this.isAutoFmtOn != turnOn) {
            this.cardLayout.show(this.cardPanel, turnOn ? "view" : "edit");
            this.isAutoFmtOn = turnOn;
            this.setChanged(true);
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        } else {
            this.isAutoFmtOn = turnOn;
        }
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired && !this.isViewOnly;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        this.setBGColor(!this.isPartialOK && isRequired && this.isEnabled() && !this.isViewOnly ? requiredFieldColor.getColor() : this.bgColor);
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public void reset() {
        this.origValue = null;
        if (StringUtils.isNotEmpty((String)this.defaultValue)) {
            this.setText(this.defaultValue);
        }
        this.validateState();
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isFilled() {
        try {
            int inx = 0;
            Iterator<UIFieldFormatterField> iterator = this.fields.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                UIFieldFormatterField f = iterator.next();
                if (f.isIncrementer() && this.isAutoFmtOn || f.getType() == UIFieldFormatterField.FieldType.constant || f.getType() == UIFieldFormatterField.FieldType.separator) continue;
                JFormattedDoc doc = this.documents.get(inx);
                int len = f.getSize();
                if (doc.getLength() != len) {
                    return false;
                }
                ++inx;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        UIValidatable.ErrorType oldState = this.valState;
        if (this.isPartialOK) {
            boolean hasText = false;
            int i = 0;
            while (i < this.documents.size()) {
                JFormattedDoc doc = this.documents.get(i);
                if (!hasText && doc.getLength() > 0 && i > 0) {
                    this.valState = UIValidatable.ErrorType.Error;
                    return this.valState;
                }
                if (doc.getLength() > 0) {
                    hasText = true;
                }
                ++i;
            }
            this.valState = UIValidatable.ErrorType.Valid;
            return this.valState;
        }
        if (this.isViewOnly) {
            this.valState = UIValidatable.ErrorType.Valid;
        } else if (this.formatter != null && this.formatter.isUserInputNeeded()) {
            String data = this.getText();
            if (StringUtils.isEmpty((String)data)) {
                this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
            } else if (!this.isPartialOK && !this.isFilled()) {
                UIValidatable.ErrorType errorType = this.valState = this.formatter.isLengthOK(data.length()) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error;
                if (this.valState == UIValidatable.ErrorType.Valid) {
                    this.valState = UIFieldFormatter.isValid(this.formatter, data, !this.isAutoFmtOn) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error;
                }
            } else {
                this.valState = this.isPartialOK ? (StringUtils.isNotEmpty((String)data) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error) : (UIFieldFormatter.isValid(this.formatter, data, !this.isAutoFmtOn) ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error);
            }
        } else {
            this.valState = UIValidatable.ErrorType.Valid;
        }
        if (oldState != this.valState) {
            this.repaint();
        }
        return this.valState;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeKeyListeners(this);
        for (JFormattedDoc document : this.documents) {
            DocumentListener[] documentListenerArray = document.getDocumentListeners();
            int n = documentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocumentListener l = documentListenerArray[n2];
                document.removeDocumentListener(l);
                ++n2;
            }
        }
        this.documents.clear();
        this.documents = null;
        this.formatter = null;
        this.fields = null;
        UIHelper.removeFocusListeners(this);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        String fmtVal;
        String data;
        this.defaultValue = defaultValue;
        if (value != null) {
            data = value instanceof String ? (String)value : (value instanceof Date ? this.formatter.getDateWrapper().format((Date)value) : (value instanceof Calendar ? this.formatter.getDateWrapper().format(((Calendar)value).getTime()) : value.toString()));
        } else {
            String string = data = StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : "";
        }
        if (this.origValue == null) {
            this.origValue = value;
        }
        if (this.formatter != null && !this.isPartialOK) {
            if (this.formatter.isInBoundFormatter()) {
                if (data.length() > 0 && data.length() != this.formatter.getLength()) {
                    UIRegistry.showError(UIRegistry.getLocalizedMessage("ValFormattedTextField.WR_SIZE", this.formatter.getName(), data.length(), this.formatter.getLength()));
                }
                this.needsUpdating = (StringUtils.isEmpty((String)data) || data.length() != this.formatter.getLength()) && this.formatter.getAutoNumber() != null && this.formatter.isIncrementer();
                fmtVal = (String)this.formatter.formatToUI(data);
            } else {
                if (value == null) {
                    this.needsUpdating = true;
                }
                fmtVal = data;
            }
        } else {
            fmtVal = data;
        }
        this.setText(fmtVal);
        this.validateState();
        this.repaint();
    }

    @Override
    public Object getValue() {
        if (this.formatter.isDate() && !this.isPartialOK) {
            return UIHelper.getCalendar(this.getText(), this.formatter.getDateWrapper());
        }
        String val = this.getText();
        if ((this.formatter.isFromUIFormatter() || this.isFromUIFmtOverride) && StringUtils.isNotEmpty((String)val)) {
            return this.formatter.formatFromUI(this.getText());
        }
        return val != null && val.isEmpty() ? null : val;
    }

    public void addDocumentListener(DocumentListener dl) {
        if (this.documentListeners == null) {
            this.documentListeners = new Vector<DocumentListener>();
        }
        this.documentListeners.add(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        if (this.documentListeners != null) {
            this.documentListeners.remove(dl);
        }
    }

    public void setFromUIFmtOverride(boolean isFromUIFmtOverride) {
        this.isFromUIFmtOverride = isFromUIFmtOverride;
    }

    class BGTextField
    extends JTextField {
        protected String bgStr;
        protected Point pnt;
        protected Insets inner;

        public BGTextField(int size, String bgStr) {
            super(size);
            this.bgStr = "";
            this.pnt = null;
            this.bgStr = bgStr;
            this.inner = this.getInsets();
        }

        public String getBgStr() {
            return this.bgStr;
        }

        @Override
        public void setText(String text) {
            JFormattedDoc document = (JFormattedDoc)this.getDocument();
            document.setIgnoreNotify(ValFormattedTextField.this.shouldIgnoreNotifyDoc);
            super.setText(this.isEnabled() ? text : "");
            document.setIgnoreNotify(false);
        }

        @Override
        public void paint(Graphics g) {
            int txtLen;
            super.paint(g);
            String text = this.getText();
            int bgStrLen = this.bgStr == null ? 0 : this.bgStr.length();
            int n = txtLen = text == null ? 0 : text.length();
            if (this.isEnabled()) {
                if (txtLen < bgStrLen) {
                    FontMetrics fm = g.getFontMetrics();
                    int w = fm.stringWidth(text);
                    this.pnt = new Point(this.inner.left + w, this.inner.top + fm.getAscent());
                    g.setColor(ValFormattedTextField.this.textColor);
                    g.drawString(this.bgStr.substring(text.length(), this.bgStr.length()), this.pnt.x, this.pnt.y);
                }
                if (ValFormattedTextField.this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
                    UIHelper.drawRoundedRect((Graphics2D)g, ValFormattedTextField.this.isNew ? new Color(249, 249, 0) : valTextColor.getColor(), this.getSize(), 1);
                } else if (ValFormattedTextField.this.valState == UIValidatable.ErrorType.Incomplete && this.isEnabled()) {
                    UIHelper.drawRoundedRect((Graphics2D)g, new Color(249, 249, 0), this.getSize(), 1);
                }
            }
        }
    }

    public class JFormattedDoc
    extends ValPlainTextDocument {
        protected int docLimit;
        protected JTextField textField;
        protected UIFieldFormatterIFace docFormatter;
        protected UIFieldFormatterField docField;

        public JFormattedDoc(JTextField textField, UIFieldFormatterIFace formatter, UIFieldFormatterField docField) {
            this.textField = textField;
            this.docFormatter = formatter;
            this.docField = docField;
            this.docLimit = docField.getSize();
        }

        protected boolean isCharOK(UIFieldFormatterField field, String str) {
            UIFieldFormatterField.FieldType type = field.getType();
            if (type == UIFieldFormatterField.FieldType.alpha && !StringUtils.isAlpha((String)str)) {
                return false;
            }
            if (type == UIFieldFormatterField.FieldType.alphanumeric && !StringUtils.isAlphanumeric((String)str)) {
                return false;
            }
            return type != UIFieldFormatterField.FieldType.numeric && type != UIFieldFormatterField.FieldType.year || StringUtils.isNumeric((String)str);
        }

        protected boolean okToInsertText(String str) {
            String contentStr = this.textField.getText();
            int newLen = contentStr.length() + str.length();
            if (newLen == this.docLimit && str.charAt(0) == ValFormattedTextField.this.autoNumberChar) {
                return true;
            }
            return newLen <= this.docLimit && this.isCharOK(this.docField, str);
        }

        @Override
        public void insertString(int offset, String strArg, AttributeSet attr) throws BadLocationException {
            String str = strArg;
            if (str == null) {
                return;
            }
            if (this.okToInsertText(str)) {
                super.insertString(offset, str, attr);
            }
            if (this.getLength() == this.docLimit) {
                int inx = 0;
                for (UIFieldFormatterField f : ValFormattedTextField.this.fields) {
                    int len = ValFormattedTextField.this.fields.size();
                    if (f == this.docField && inx < len - 1) {
                        int i = inx + 1;
                        while (i < len) {
                            UIFieldFormatterField nxtField = ValFormattedTextField.this.fields.get(i);
                            if (!nxtField.isByYear() && nxtField.isEntryField()) {
                                ValFormattedTextField.this.comps[i].requestFocus();
                                break;
                            }
                            ++i;
                        }
                    }
                    ++inx;
                }
            }
            if (!ValFormattedTextField.this.shouldIgnoreNotifyDoc) {
                ValFormattedTextField.this.validateState();
            }
        }
    }
}

