/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.db.JComboBoxFromQuery;
import edu.ku.brc.af.ui.db.TextFieldWithQuery;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchQueryBuilderIFace;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.SessionListenerIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextField;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ValComboBoxFromQuery
extends JPanel
implements UIValidatable,
ListSelectionListener,
GetSetValueIFace,
AppPrefsChangeListener,
SessionListenerIFace {
    protected static final Logger log = Logger.getLogger(ValComboBoxFromQuery.class);
    public static final int CREATE_EDIT_BTN = 1;
    public static final int CREATE_NEW_BTN = 2;
    public static final int CREATE_SEARCH_BTN = 4;
    public static final int CREATE_CLONE_BTN = 8;
    public static final int CREATE_VIEW_BTN = 16;
    public static final int CREATE_ALL = 31;
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected String cellName = null;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected boolean hasBeenVisited = false;
    protected Color bgColor = null;
    protected boolean doAdjustQuery = true;
    protected TextFieldWithQuery textWithQuery;
    protected JButton searchBtn = null;
    protected JButton createBtn = null;
    protected JButton editBtn = null;
    protected JButton cloneBtn = null;
    protected DBTableInfo tableInfo;
    protected String frameTitle = null;
    protected String keyName;
    protected String dataObjFormatterName;
    protected DataGetterForObj getter = null;
    protected String[] fieldNames;
    protected String helpContext;
    protected FormDataObjIFace dataObj = null;
    protected FormDataObjIFace newDataObj = null;
    protected MODE currentMode = MODE.Unknown;
    protected boolean hasFocus = false;
    protected boolean isRestricted;
    protected String restrictedStr;
    protected ViewBasedDisplayIFace frame = null;
    protected MultiView multiView = null;
    protected String searchDlgName = null;
    protected String displayDlgName = null;
    protected List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    protected Vector<ListSelectionListener> listSelectionListeners = null;
    protected ActionListener defaultSearchAction;
    protected ActionListener defaultEditAction;
    protected ActionListener defaultNewAction;
    protected ActionListener defaultCloneAction;
    protected ViewBasedSearchQueryBuilderIFace builder = null;
    protected DataProviderSessionIFace session;

    public ValComboBoxFromQuery(DBTableInfo tableInfo, String keyFieldName, String displayColumn, String keyName, String format, String uiFieldFormatterName, String dataObjFormatterName, String sqlTemplate, String helpContext, int btns) {
        if (StringUtils.isEmpty((String)displayColumn)) {
            FormDevHelper.showFormDevError("For ValComboBoxFromQuery table[" + tableInfo.getName() + "] displayColumn null.");
            return;
        }
        if (StringUtils.isEmpty((String)format) && StringUtils.isEmpty((String)uiFieldFormatterName)) {
            FormDevHelper.showFormDevError("For ValComboBoxFromQuery table[" + tableInfo.getName() + "] both format and fieldFormatterName are null.");
            return;
        }
        if (StringUtils.isEmpty((String)tableInfo.getNewObjDialog())) {
            FormDevHelper.showFormDevError("For ValComboBoxFromQuery table[" + tableInfo.getName() + "]  New Obj Dialog name (displayInfoDialogName) is null.");
            return;
        }
        this.tableInfo = tableInfo;
        this.keyName = keyName;
        this.dataObjFormatterName = dataObjFormatterName != null ? dataObjFormatterName : tableInfo.getDataObjFormatter();
        this.frameTitle = tableInfo.getTitle();
        this.helpContext = helpContext;
        this.textWithQuery = new TextFieldWithQuery(tableInfo, keyFieldName, displayColumn, format, uiFieldFormatterName, sqlTemplate);
        this.restrictedStr = FormHelper.checkForRestrictedValue(tableInfo);
        if (this.restrictedStr != null) {
            this.isRestricted = true;
            this.textWithQuery.setEnabled(false);
        } else {
            this.textWithQuery.addListSelectionListener(this);
            this.textWithQuery.setAddAddItem(true);
            this.textWithQuery.getTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ValComboBoxFromQuery.this.hasFocus = true;
                    super.focusGained(e);
                    ValComboBoxFromQuery.this.validateState();
                    ValComboBoxFromQuery.this.repaint();
                    for (FocusListener l : ValComboBoxFromQuery.this.focusListeners) {
                        l.focusGained(e);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ValComboBoxFromQuery.this.hasFocus = false;
                    super.focusLost(e);
                    ValComboBoxFromQuery.this.validateState();
                    ValComboBoxFromQuery.this.repaint();
                    for (FocusListener l : ValComboBoxFromQuery.this.focusListeners) {
                        l.focusLost(e);
                    }
                }
            });
        }
        this.init(tableInfo.getTitle(), btns);
        this.setOpaque(false);
    }

    public void setReadOnlyMode() {
        if (this.textWithQuery != null) {
            this.textWithQuery.setReadOnlyMode();
        }
        if (this.editBtn != null) {
            this.editBtn.setVisible(false);
        }
    }

    public void setDoAdjustQuery(boolean doAdjustQuery) {
        this.doAdjustQuery = doAdjustQuery;
        if (this.textWithQuery != null) {
            this.textWithQuery.setDoAdjustQuery(doAdjustQuery);
        }
    }

    public void setSqlTemplate(String sqlTemplate) {
        this.textWithQuery.setSqlTemplate(sqlTemplate);
    }

    public void setExternalQueryProvider(TextFieldWithQuery.ExternalQueryProviderIFace externalQueryProvider) {
        if (this.textWithQuery != null) {
            this.textWithQuery.setExternalQueryProvider(externalQueryProvider);
        }
    }

    public String getCellName() {
        return this.cellName;
    }

    public DBTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    @Override
    public void requestFocus() {
        this.textWithQuery.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean isEnabled = enabled;
        if (this.isRestricted) {
            isEnabled = false;
        }
        super.setEnabled(isEnabled);
        if (this.textWithQuery != null) {
            this.textWithQuery.setEnabled(isEnabled);
        }
        if (this.searchBtn != null) {
            this.searchBtn.setEnabled(isEnabled);
        }
        if (this.editBtn != null) {
            this.editBtn.setEnabled(isEnabled && (this.dataObj != null || this.textWithQuery.getSelectedId() != null));
        }
        if (this.createBtn != null) {
            this.createBtn.setEnabled(isEnabled);
        }
        if (this.cloneBtn != null) {
            this.cloneBtn.setEnabled(isEnabled && (this.dataObj != null || this.textWithQuery.getSelectedId() != null));
        }
        this.setRequired(this.isRequired);
    }

    public void setSearchDlgName(String searchDlgName) {
        this.searchDlgName = searchDlgName;
    }

    public String getSearchDlgName() {
        return this.searchDlgName;
    }

    public void setDisplayDlgName(String displayDlgName) {
        this.displayDlgName = displayDlgName;
    }

    @Override
    public boolean isNotEmpty() {
        return this.dataObj != null;
    }

    protected JButton createBtn(String iconName, String tooltipKey, String objTitle) {
        JButton btn = new JButton(IconManager.getIcon(iconName, IconManager.IconSize.Std16));
        btn.setOpaque(false);
        btn.setToolTipText(String.format(UIRegistry.getResourceString(tooltipKey), objTitle));
        btn.setFocusable(false);
        btn.setMargin(new Insets(1, 1, 1, 1));
        btn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return btn;
    }

    public void init(String objTitle, int btnMask) {
        this.fieldNames = StringUtils.split((String)StringUtils.deleteWhitespace((String)this.keyName), (String)",");
        int i = 0;
        while (i < this.fieldNames.length) {
            String fName = this.fieldNames[i];
            if (fName.indexOf(46) > -1) {
                this.fieldNames[i] = StringUtils.substringAfterLast((String)fName, (String)".");
            }
            ++i;
        }
        boolean hasSearchDlg = StringUtils.isNotEmpty((String)this.tableInfo.getSearchDialog());
        boolean hasSearchBtn = (btnMask & 4) != 0;
        boolean hasCloneBtn = (btnMask & 8) != 0;
        boolean hasEditBtn = (btnMask & 1) != 0;
        boolean hasAddBtn = (btnMask & 2) != 0;
        final boolean hasViewBtn = (btnMask & 0x10) != 0;
        StringBuilder sb = new StringBuilder("p:g,1px,p,1px,p");
        if (hasSearchDlg) {
            sb.append(",1px,p");
        }
        if (hasCloneBtn) {
            sb.append(",1px,p");
        }
        PanelBuilder pb = new PanelBuilder(new FormLayout(sb.toString(), "c:p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.textWithQuery, cc.xy(1, 1));
        PermissionSettings perm = AppContextMgr.isSecurityOn() ? this.tableInfo.getPermissions() : null;
        int x = 3;
        if (hasEditBtn || hasViewBtn) {
            String ttName;
            String iconName;
            if (hasEditBtn && (perm == null || perm.canModify())) {
                iconName = "EditIcon";
                ttName = "EditRecordTT";
            } else {
                iconName = "InfoIcon";
                ttName = "ShowRecordInfoTT";
            }
            this.editBtn = this.createBtn(iconName, ttName, objTitle);
            pb.add((Component)this.editBtn, cc.xy(x, 1));
            x += 2;
        }
        if (hasAddBtn && (perm == null || perm.canAdd())) {
            this.createBtn = this.createBtn("CreateObj", "NewRecordTT", objTitle);
            pb.add((Component)this.createBtn, cc.xy(x, 1));
            x += 2;
        }
        if (hasCloneBtn && (perm == null || perm.canAdd())) {
            this.cloneBtn = this.createBtn("CloneObj", "CloneRecordTT", objTitle);
            pb.add((Component)this.cloneBtn, cc.xy(x, 1));
            x += 2;
        }
        if (hasSearchDlg && hasSearchBtn && (perm == null || perm.canAdd())) {
            this.textWithQuery.setAddAddItem(hasAddBtn);
            this.searchBtn = this.createBtn("Search", "SearchForRecordTT", objTitle);
            pb.add((Component)this.searchBtn, cc.xy(x, 1));
            x += 2;
        }
        if (!UIHelper.isMacOS()) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.bgColor = this.textWithQuery.getTextField().getBackground();
        if (valTextColor == null || requiredFieldColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui.formatting.valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui.formatting.requiredfieldcolor");
        }
        AppPrefsCache.addChangeListener("ui.formatting.requiredfieldcolor", this);
        if (this.searchBtn != null) {
            this.defaultSearchAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValComboBoxFromQuery.this.displaySearchDialog();
                }
            };
            this.searchBtn.addActionListener(this.defaultSearchAction);
        }
        if (this.editBtn != null) {
            this.defaultEditAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValComboBoxFromQuery.this.currentMode = MODE.Editting;
                    ValComboBoxFromQuery.this.textWithQuery.setIgnoreFocusLost(true);
                    ValComboBoxFromQuery.this.createEditFrame(false, false, hasViewBtn);
                }
            };
            this.editBtn.addActionListener(this.defaultEditAction);
        }
        if (this.createBtn != null) {
            this.defaultNewAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValComboBoxFromQuery.this.currentMode = MODE.NewAndNotEmpty;
                    ValComboBoxFromQuery.this.textWithQuery.setIgnoreFocusLost(true);
                    ValComboBoxFromQuery.this.createEditFrame(true, false, false);
                }
            };
            this.createBtn.addActionListener(this.defaultNewAction);
        }
        if (this.cloneBtn != null) {
            this.defaultCloneAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValComboBoxFromQuery.this.dataObj = (FormDataObjIFace)ValComboBoxFromQuery.this.getValue();
                    ValComboBoxFromQuery.this.currentMode = MODE.NewAndNotEmpty;
                    ValComboBoxFromQuery.this.textWithQuery.setIgnoreFocusLost(true);
                    ValComboBoxFromQuery.this.createEditFrame(true, true, false);
                }
            };
            this.cloneBtn.addActionListener(this.defaultCloneAction);
        }
    }

    public String getSearchName() {
        return UIRegistry.getViewbasedFactory().getSearchName(StringUtils.isNotEmpty((String)this.searchDlgName) ? this.searchDlgName : this.tableInfo.getSearchDialog());
    }

    protected void displaySearchDialog() {
        String dlgName = StringUtils.isNotEmpty((String)this.searchDlgName) ? this.searchDlgName : this.tableInfo.getSearchDialog();
        ViewBasedSearchDialogIFace dlg = UIRegistry.getViewbasedFactory().createSearchDialog(UIHelper.getWindow(this.searchBtn), dlgName);
        dlg.setMultipleSelection(false);
        if (this.builder != null) {
            dlg.registerQueryBuilder(this.builder);
        }
        dlg.getDialog().setVisible(true);
        if (!dlg.isCancelled()) {
            block11: {
                Object dlgDataObj = dlg.getSelectedObject();
                if (dlgDataObj instanceof FormDataObjIFace) {
                    DataProviderSessionIFace localSession = null;
                    try {
                        try {
                            localSession = DataProviderFactory.getInstance().createSession();
                            localSession.attach(dlgDataObj);
                            this.setValue(dlgDataObj, null);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
                            ex.printStackTrace();
                            if (localSession != null) {
                                localSession.close();
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (localSession != null) {
                            localSession.close();
                        }
                        throw throwable;
                    }
                    if (localSession != null) {
                        localSession.close();
                    }
                }
            }
            this.valueHasChanged();
            this.notifyListeners(null);
        }
    }

    public void setEditAction(ActionListener al) {
        if (this.editBtn != null) {
            this.removeAllActionListeners(this.editBtn);
            if (al != null) {
                this.editBtn.addActionListener(al);
            }
        }
    }

    public void setSearchAction(ActionListener al) {
        if (this.searchBtn != null) {
            this.removeAllActionListeners(this.searchBtn);
            if (al != null) {
                this.searchBtn.addActionListener(al);
            }
        }
    }

    public void setNewAction(ActionListener al) {
        if (this.createBtn != null) {
            this.removeAllActionListeners(this.createBtn);
            if (al != null) {
                this.createBtn.addActionListener(al);
            }
        }
    }

    protected void removeAllActionListeners(JButton button) {
        ActionListener[] actionListenerArray = button.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener al = actionListenerArray[n2];
            button.removeActionListener(al);
            ++n2;
        }
    }

    protected void valueHasChanged() {
        if (this.frame != null) {
            MultiView mv = this.frame.getMultiView();
            if (mv != null && mv.hasChanged()) {
                this.setChanged(true);
            }
            this.frame.getMultiView().getDataFromUI();
            this.refreshUIFromData(true);
        }
    }

    public static void setIsPartial(Component comp, boolean isPartial) {
        if (comp instanceof ValFormattedTextField) {
            ((ValFormattedTextField)comp).setPartialOK(isPartial);
        } else if (comp instanceof ValFormattedTextFieldSingle) {
            ((ValFormattedTextFieldSingle)comp).setPartialOK(isPartial);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createEditFrame(boolean isNewObject, boolean isCloned, boolean isViewOnly) {
        boolean canModify;
        boolean bl = canModify = !isViewOnly;
        if (AppContextMgr.isSecurityOn() && this.tableInfo.getPermissions() != null) {
            canModify = this.tableInfo.getPermissions().canModify() && !isViewOnly;
        }
        int options = (isNewObject ? 4 : 0) | 8 | (canModify ? 768 : 0);
        String dlgName = StringUtils.isNotEmpty((String)this.displayDlgName) ? this.displayDlgName : this.tableInfo.getNewObjDialog();
        String closeBtnTitle = UIRegistry.getResourceString(canModify ? "SAVE" : "CLOSE");
        this.frame = UIRegistry.getViewbasedFactory().createDisplay(UIHelper.getWindow(this), dlgName, this.frameTitle, closeBtnTitle, canModify, options, this.helpContext, ViewBasedDialogFactoryIFace.FRAME_TYPE.DIALOG);
        if (this.frame == null) {
            return;
        }
        if (isNewObject) {
            block29: {
                if (isCloned) {
                    if (this.dataObj == null) {
                        UIRegistry.showError("There isn't anything to clone.\nPlease contact customer support about this issue.");
                        return;
                    }
                    DataProviderSessionIFace localSession = null;
                    try {
                        try {
                            localSession = DataProviderFactory.getInstance().createSession();
                            localSession.attach(this.dataObj);
                            this.newDataObj = (FormDataObjIFace)this.dataObj.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            e.printStackTrace();
                            UIRegistry.showError("Clone is not supported for " + (this.dataObj != null ? this.dataObj.getClass().getSimpleName() : "Unknow record type"));
                            if (localSession != null) {
                                localSession.close();
                            }
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        if (localSession != null) {
                            localSession.close();
                        }
                        throw throwable;
                    }
                    if (localSession != null) {
                        localSession.close();
                    }
                } else {
                    this.newDataObj = FormHelper.createAndNewDataObj(this.tableInfo.getClassObj());
                }
            }
            Component comp = null;
            DataObjectSettable ds = DataObjectSettableFactory.get(this.tableInfo.getClassObj().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
            if (ds != null) {
                FormViewObj fvo;
                MultiView mv;
                String value;
                String string = value = this.textWithQuery.getSelectedId() == null ? this.textWithQuery.getPrevEnteredText() : "";
                if (!isCloned) {
                    ds.setFieldValue(this.newDataObj, this.fieldNames[0], value);
                }
                if ((mv = this.frame.getMultiView()) != null && (fvo = mv.getCurrentViewAsFormViewObj()) != null) {
                    comp = fvo.getControlByName(this.fieldNames[0]);
                }
            }
            ValComboBoxFromQuery.setIsPartial(comp, true);
            this.frame.setData(this.newDataObj);
            ValComboBoxFromQuery.setIsPartial(comp, false);
        } else {
            this.dataObj = null;
            this.frame.setData(this.getValue());
        }
        this.frame.showDisplay(true);
        if (this.frame.getBtnPressed() == 1) {
            if (this.frame.isEditMode()) {
                FormViewObj fvo;
                if (this.currentMode == MODE.NewAndEmpty) {
                    if (this.multiView != null) {
                        Object parentDataObj;
                        fvo = this.frame.getMultiView().getCurrentViewAsFormViewObj();
                        if (fvo != null) {
                            fvo.saveObject();
                            this.newDataObj = (FormDataObjIFace)fvo.getDataObj();
                        }
                        if ((parentDataObj = this.multiView.getData()) instanceof FormDataObjIFace) {
                            ((FormDataObjIFace)parentDataObj).addReference(this.newDataObj, this.cellName);
                        } else {
                            FormHelper.addToParent(this.multiView != null ? this.multiView.getData() : null, this.newDataObj);
                        }
                    }
                    this.setValue(this.newDataObj, null);
                    this.newDataObj = null;
                } else {
                    fvo = this.frame.getMultiView().getCurrentViewAsFormViewObj();
                    if (fvo != null) {
                        fvo.saveObject();
                        this.newDataObj = (FormDataObjIFace)fvo.getDataObj();
                        this.setValue(this.newDataObj, null);
                        this.newDataObj = null;
                    }
                }
                this.valueHasChanged();
                this.notifyListeners(null);
            }
            this.currentMode = MODE.Unknown;
        } else if (!this.textWithQuery.hasId()) {
            this.textWithQuery.setText("");
            this.textWithQuery.setPrevEnteredText("");
        }
        this.frame.dispose();
        this.frame = null;
    }

    public void setFrameTitle(String frameTitle) {
        if (StringUtils.isNotEmpty((String)frameTitle)) {
            this.frameTitle = frameTitle;
        }
    }

    public void setMultiView(MultiView multiView) {
        this.multiView = multiView;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if ((!this.isNew || this.hasBeenVisited) && this.isInError() && this.textWithQuery != null && this.textWithQuery.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), this.getSize(), 1);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.listSelectionListeners == null) {
            this.listSelectionListeners = new Vector();
        }
        this.listSelectionListeners.add(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.listSelectionListeners != null && listSelectionListener != null) {
            this.listSelectionListeners.remove(listSelectionListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.focusListeners.add(l);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.focusListeners.remove(l);
    }

    public TextFieldWithQuery getTextWithQuery() {
        return this.textWithQuery;
    }

    private void refreshUIFromData(boolean useSession) {
        if (this.dataObj != null) {
            Object newVal;
            block22: {
                if (this.getter == null) {
                    this.getter = new DataGetterForObj();
                }
                newVal = this.dataObj;
                if (StringUtils.isEmpty((String)this.dataObjFormatterName)) {
                    Object[] val = UIHelper.getFieldValues(this.fieldNames, (Object)this.dataObj, (DataObjectGettable)this.getter);
                    UIFieldFormatterIFace uiFieldFormatter = this.textWithQuery.getUiFieldFormatter();
                    newVal = uiFieldFormatter != null ? (val != null && val.length > 0 && val[0] != null ? uiFieldFormatter.formatFromUI(val[0]).toString() : null) : (StringUtils.isNotEmpty((String)this.textWithQuery.getFormat()) ? UIHelper.getFormattedValue(this.textWithQuery.getFormat(), val) : this.dataObj);
                } else {
                    DataProviderSessionIFace localSession = null;
                    try {
                        try {
                            localSession = DataProviderFactory.getInstance().createSession();
                            newVal = DataObjFieldFormatMgr.getInstance().format((Object)this.dataObj, this.dataObjFormatterName);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
                            ex.printStackTrace();
                            if (localSession != null) {
                                localSession.close();
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        if (localSession != null) {
                            localSession.close();
                        }
                        throw throwable;
                    }
                    if (localSession != null) {
                        localSession.close();
                    }
                }
            }
            if (newVal != null && this.textWithQuery != null) {
                this.valState = UIValidatable.ErrorType.Valid;
                this.textWithQuery.setSelectedId(this.dataObj != null ? this.dataObj.getId() : null);
                final JTextField tf = this.textWithQuery.getTextField();
                this.textWithQuery.setText(newVal.toString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tf.setSelectionStart(-1);
                        tf.setSelectionEnd(-1);
                        tf.setCaretPosition(0);
                    }
                });
                this.textWithQuery.setSelectedId(this.dataObj != null ? this.dataObj.getId() : null);
                if (this.editBtn != null) {
                    this.editBtn.setEnabled(true);
                }
                if (this.cloneBtn != null) {
                    this.cloneBtn.setEnabled(false);
                }
            } else {
                if (this.textWithQuery != null) {
                    this.textWithQuery.clearSelection();
                }
                this.valState = UIValidatable.ErrorType.Incomplete;
            }
        } else {
            if (this.textWithQuery != null) {
                this.textWithQuery.clearSelection();
            }
            this.valState = UIValidatable.ErrorType.Incomplete;
            if (this.editBtn != null) {
                this.editBtn.setEnabled(false);
            }
            if (this.cloneBtn != null) {
                this.cloneBtn.setEnabled(false);
            }
            if (this.textWithQuery != null && this.textWithQuery.getTextField() != null) {
                this.textWithQuery.setText("");
                this.textWithQuery.getTextField().repaint();
            }
        }
        this.repaint();
    }

    @Override
    public void setSession(DataProviderSessionIFace session) {
        this.session = session;
    }

    @Override
    public boolean isInError() {
        if (this.valState == UIValidatable.ErrorType.Incomplete) {
            return this.isRequired;
        }
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (this.textWithQuery != null && this.textWithQuery.getTextField() != null) {
            this.textWithQuery.getTextField().setBackground(isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        }
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.isRequired && !this.textWithQuery.hasItem() ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public void reset() {
        this.textWithQuery.clearSelection();
        if (this.textWithQuery.getTextField() != null) {
            this.textWithQuery.setText("");
            this.textWithQuery.setPrevEnteredText(null);
        }
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        if (this.textWithQuery != null && this.textWithQuery.getTextField() != null) {
            UIHelper.removeFocusListeners(this.textWithQuery.getTextField());
            UIHelper.removeKeyListeners(this.textWithQuery.getTextField());
        }
        UIHelper.removeFocusListeners(this.textWithQuery);
        UIHelper.removeFocusListeners(this.textWithQuery);
        UIHelper.removeKeyListeners(this);
        this.tableInfo = null;
        this.getter = null;
        this.dataObj = null;
        this.frame = null;
        this.multiView = null;
        this.textWithQuery = null;
        if (this.listSelectionListeners != null) {
            this.listSelectionListeners.clear();
        }
        this.focusListeners.clear();
        this.textWithQuery = null;
        AppPrefsCache.removeChangeListener("ui.formatting.requiredfieldcolor", this);
    }

    @Override
    public String getReason() {
        return null;
    }

    public void registerQueryBuilder(ViewBasedSearchQueryBuilderIFace builderArg) {
        this.builder = builderArg;
        this.textWithQuery.setBuilder(builderArg);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean doEnable;
        if (e != null) {
            if (e.getSource() instanceof TextFieldWithQuery) {
                if (((TextFieldWithQuery)e.getSource()).getTextField().getText().length() == 0) {
                    this.dataObj = null;
                }
            } else {
                String itemLabel = null;
                if (e.getSource() instanceof JMenuItem) {
                    itemLabel = ((JMenuItem)e.getSource()).getText().toString();
                    this.dataObj = null;
                    this.getValue();
                    this.refreshUIFromData(true);
                } else if (e.getSource() instanceof JList) {
                    JList listBox = (JList)e.getSource();
                    if (listBox.getSelectedIndex() > -1) {
                        itemLabel = listBox.getSelectedValue().toString();
                        this.dataObj = null;
                    } else {
                        return;
                    }
                }
                if (itemLabel != null && itemLabel.equals(UIRegistry.getResourceString("TFWQ_ADD_LABEL"))) {
                    if (this.defaultNewAction != null) {
                        this.defaultNewAction.actionPerformed(null);
                    }
                    return;
                }
            }
        }
        this.isChanged = true;
        this.valueHasChanged();
        this.validateState();
        boolean bl = doEnable = this.dataObj != null || this.textWithQuery != null && this.textWithQuery.getSelectedId() != null;
        if (this.editBtn != null) {
            this.editBtn.setEnabled(doEnable);
        }
        if (this.cloneBtn != null) {
            this.cloneBtn.setEnabled(doEnable);
        }
        this.notifyListeners(e);
        this.repaint();
    }

    private void notifyListeners(ListSelectionEvent e) {
        if (this.listSelectionListeners != null) {
            for (ListSelectionListener l : this.listSelectionListeners) {
                l.valueChanged(e);
            }
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (this.isRestricted) {
            this.textWithQuery.setText(this.restrictedStr);
            return;
        }
        if (value == null || value instanceof FormDataObjIFace) {
            this.dataObj = (FormDataObjIFace)value;
            if (this.dataObj != null && this.session != null) {
                try {
                    this.session.attach(this.dataObj);
                }
                catch (Exception ex) {
                    this.session.refresh(this.dataObj);
                }
                this.dataObj.forceLoad();
            }
            this.refreshUIFromData(false);
            if (this.cloneBtn != null) {
                this.cloneBtn.setEnabled(this.dataObj != null || this.textWithQuery.getSelectedId() != null);
            }
        } else {
            if (Set.class.isAssignableFrom(value.getClass())) {
                UIRegistry.showError("The QueryComboBox cannot handle Sets! field name[" + this.cellName + "]");
            }
            throw new RuntimeException("Data does not extend FormDataObjIFace [" + value + "] " + value.getClass());
        }
    }

    @Override
    public Object getValue() {
        block10: {
            Integer id;
            Integer n = id = this.textWithQuery != null ? this.textWithQuery.getSelectedId() : null;
            if (id == null) {
                this.dataObj = null;
                return null;
            }
            if (this.dataObj != null && this.dataObj.getId().intValue() == id.intValue()) {
                return this.dataObj;
            }
            DataProviderSessionIFace localSession = null;
            try {
                try {
                    localSession = DataProviderFactory.getInstance().createSession();
                    List<?> list = localSession.getDataList(this.tableInfo.getClassObj(), this.tableInfo.getIdFieldName(), id, DataProviderSessionIFace.CompareType.Restriction);
                    if (list.size() != 0) {
                        this.dataObj = (FormDataObjIFace)list.get(0);
                        this.dataObj.forceLoad();
                        break block10;
                    }
                    log.error((Object)("**** Can't find the Object " + this.tableInfo.getClassObj() + " with ID: " + id));
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
                    ex.printStackTrace();
                    if (localSession != null) {
                        localSession.close();
                    }
                }
            }
            finally {
                if (localSession != null) {
                    localSession.close();
                }
            }
        }
        return this.dataObj;
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("ui.formatting.requiredfieldcolor")) {
            this.textWithQuery.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        }
    }

    protected static enum MODE {
        Unknown,
        Editting,
        NewAndEmpty,
        NewAndNotEmpty;

    }

    class ValTextWithQuery
    extends JComboBoxFromQuery
    implements DocumentListener {
        protected boolean localHasFocus;

        public ValTextWithQuery(String tableName, String idColumn, String keyColumn, String displayColumns, String format) {
            super(tableName, idColumn, keyColumn, displayColumns, format);
            this.localHasFocus = false;
            this.getTextField().getDocument().addDocumentListener(this);
            this.getTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    log.debug((Object)"focusGained");
                    ValTextWithQuery.this.localHasFocus = true;
                    super.focusGained(e);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    log.debug((Object)"focusLost");
                    ValTextWithQuery.this.localHasFocus = false;
                    super.focusLost(e);
                }
            });
        }

        @Override
        protected void tfFocusGained(FocusEvent e) {
            log.debug((Object)"tfFocusGained");
            super.tfFocusGained(e);
            ValComboBoxFromQuery.this.hasBeenVisited = true;
            for (FocusListener l : ValComboBoxFromQuery.this.focusListeners) {
                l.focusGained(e);
            }
        }

        @Override
        protected void tfFocusLost(FocusEvent e) {
            super.tfFocusLost(e);
            ValComboBoxFromQuery.this.isNew = false;
            ValComboBoxFromQuery.this.validateState();
            this.repaint();
            for (FocusListener l : ValComboBoxFromQuery.this.focusListeners) {
                l.focusLost(e);
            }
        }

        @Override
        protected String buildSQL(String searchText) {
            if (ValComboBoxFromQuery.this.builder != null) {
                return ValComboBoxFromQuery.this.builder.buildSQL(searchText, false);
            }
            return super.buildSQL(searchText);
        }

        protected void documentChanged() {
            if (this.localHasFocus && ValComboBoxFromQuery.this.textWithQuery.hasItem()) {
                ValComboBoxFromQuery.this.textWithQuery.clearSelection();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentChanged();
        }
    }
}

