/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.validation.FormControlSaveable;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.Java2sAutoComboBox;
import edu.ku.brc.ui.Java2sAutoTextField;
import edu.ku.brc.ui.TitleValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ValComboBox
extends JPanel
implements UIValidatable,
ListDataListener,
GetSetValueIFace,
AppPrefsChangeListener,
FormControlSaveable {
    private static final Logger log = Logger.getLogger(ValComboBox.class);
    protected static Color defaultTextBGColor = null;
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected Integer nullIndex = null;
    protected JComboBox comboBox = null;
    protected Java2sAutoTextField textEditor = null;
    protected String defaultValue = null;
    protected String currTypedValue = null;
    protected PickListDBAdapterIFace adapter = null;
    protected MultiView multiView = null;
    protected boolean isFormObjNew = false;
    protected Vector<ChangeListener> listeners = null;

    public ValComboBox(boolean editable) {
        if (editable) {
            this.comboBox = new Java2sAutoComboBox(new ArrayList());
        } else {
            this.comboBox = new ClearableComboBox();
            UIHelper.setControlSize(this.comboBox);
        }
        this.init(editable);
    }

    public ValComboBox(Object[] array, boolean editable) {
        if (editable) {
            ArrayList items = new ArrayList();
            Collections.addAll(items, array);
            this.comboBox = new Java2sAutoComboBox(items);
        } else {
            this.comboBox = new ClearableComboBox(array);
            UIHelper.setControlSize(this.comboBox);
        }
        this.init(editable);
    }

    public ValComboBox(Vector<?> vector, boolean editable) {
        if (editable) {
            this.comboBox = new Java2sAutoComboBox((List<?>)vector);
        } else {
            this.comboBox = new ClearableComboBox(vector);
            UIHelper.setControlSize(this.comboBox);
        }
        this.init(editable);
    }

    public ValComboBox(final PickListDBAdapterIFace adapter) {
        if (!adapter.isReadOnly()) {
            Java2sAutoComboBox cbx = new Java2sAutoComboBox((List<?>)adapter.getList());
            adapter.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (ValComboBox.this.comboBox instanceof Java2sAutoComboBox) {
                        Java2sAutoComboBox c = (Java2sAutoComboBox)ValComboBox.this.comboBox;
                        c.setDataList(adapter.getList());
                    }
                }
            });
            this.comboBox = cbx;
            UIHelper.setControlSize(this.comboBox);
            cbx.setStrict(false);
        } else if (adapter instanceof ComboBoxModel) {
            this.comboBox = new ClearableComboBox((ComboBoxModel)((Object)adapter));
            UIHelper.setControlSize(this.comboBox);
        } else {
            String msg = "PickListDBAdapterIFace is not an instanceof ComboBoxModel and MUST BE!";
            FormDevHelper.appendFormDevError(msg);
        }
        this.adapter = adapter;
        adapter.setAutoSaveOnAdd(false);
        this.init(!adapter.isReadOnly());
    }

    public void init(boolean makeEditable) {
        if (makeEditable) {
            Java2sAutoComboBox cbx = (Java2sAutoComboBox)this.comboBox;
            this.textEditor = cbx.getAutoTextFieldEditor().getAutoTextFieldEditor();
            this.textEditor.addKeyListener(this.getTextKeyAdapter());
            this.addPopupMenu(this.textEditor);
            this.comboBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    if (e.getKeyCode() == 27 || e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                        ValComboBox.this.comboBox.setSelectedIndex(-1);
                    }
                    ValComboBox.this.notifyChangeListeners(new ChangeEvent(ValComboBox.this));
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27 || e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                        ValComboBox.this.comboBox.setSelectedIndex(-1);
                    }
                    super.keyReleased(e);
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 27 || e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                        ValComboBox.this.comboBox.setSelectedIndex(-1);
                    }
                    super.keyTyped(e);
                }
            });
        }
        this.setOpaque(false);
        if (defaultTextBGColor == null) {
            defaultTextBGColor = new JTextField().getBackground();
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", "p:g:f"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.comboBox, cc.xy(1, 1));
        this.comboBox.getModel().addListDataListener(this);
        if (valTextColor == null || requiredFieldColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        if (valTextColor != null) {
            AppPrefsCache.addChangeListener("ui.formatting.valtextcolor", this);
            AppPrefsCache.addChangeListener("ui.formatting.requiredfieldcolor", this);
        }
    }

    private void addPopupMenu(JTextComponent txtComp) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem(UIRegistry.getResourceString("DELETE"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickListItemIFace pli = (PickListItemIFace)ValComboBox.this.comboBox.getSelectedItem();
                if (pli != null) {
                    PickListIFace pl = ValComboBox.this.adapter.getPickList();
                    pl.removeItem(pli);
                }
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public JTextField getTextField() {
        return this.textEditor;
    }

    private KeyAdapter getTextKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                ValComboBox.this.notifyChangeListeners(new ChangeEvent(ValComboBox.this));
            }

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
            }
        };
    }

    @Override
    public void requestFocus() {
        this.comboBox.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox.setEnabled(enabled);
        this.setRequired(this.isRequired);
    }

    public ComboBoxModel getModel() {
        return this.comboBox.getModel();
    }

    public void setModel(ComboBoxModel model) {
        this.comboBox.setModel(model);
        model.addListDataListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNew && this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), this.getSize(), 1);
        }
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public boolean hasText() {
        return this.textEditor != null ? this.textEditor.getText().length() > 0 : this.comboBox.getSelectedIndex() > -1;
    }

    @Override
    public boolean isNotEmpty() {
        return this.comboBox.getSelectedIndex() > -1 || this.hasText();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.comboBox.addFocusListener(l);
        if (this.textEditor != null) {
            this.textEditor.addFocusListener(l);
        }
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.comboBox.removeFocusListener(l);
        if (this.textEditor != null) {
            this.textEditor.removeFocusListener(l);
        }
    }

    @Override
    public boolean saveControlData() {
        String newValue;
        int inx = this.comboBox.getSelectedIndex();
        if (this.adapter != null && this.textEditor != null && StringUtils.isNotEmpty((String)(newValue = this.textEditor.getText()))) {
            if (inx == -1) {
                this.adapter.addItem(newValue, newValue);
            }
            this.adapter.save();
        }
        return true;
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (this.textEditor != null) {
            this.textEditor.setBackground(isRequired && this.isEnabled() ? requiredFieldColor.getColor() : defaultTextBGColor);
        }
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.isRequired && this.comboBox.getSelectedIndex() == -1 ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public void reset() {
        this.comboBox.setSelectedIndex(-1);
        if (this.textEditor != null) {
            this.textEditor.setText(StringUtils.isNotEmpty((String)this.defaultValue) ? this.defaultValue : "");
        }
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        if (this.textEditor != null) {
            UIHelper.removeFocusListeners(this.textEditor);
            UIHelper.removeKeyListeners(this.textEditor);
        }
        this.comboBox.getModel().removeListDataListener(this);
        UIHelper.removeFocusListeners(this.comboBox);
        UIHelper.removeKeyListeners(this);
        this.comboBox = null;
        AppPrefsCache.removeChangeListener("ui.formatting.requiredfieldcolor", this);
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    protected void notifyChangeListeners(ChangeEvent e) {
        if (this.listeners != null) {
            for (ChangeListener l : this.listeners) {
                l.stateChanged(e);
            }
        }
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.isChanged = true;
        this.validateState();
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    private MultiView getMultiView() {
        Container comp = this.getParent();
        while (true) {
            if (comp instanceof MultiView) {
                return (MultiView)comp;
            }
            if (comp == null) break;
            comp = comp.getParent();
        }
        return null;
    }

    @Override
    public void setValue(Object valueArg, String defaultValue) {
        if (this.multiView == null) {
            this.multiView = this.getMultiView();
        }
        if (this.multiView != null) {
            this.isNew = this.isFormObjNew = this.multiView.isNewForm();
        }
        String defVal = StringUtils.isEmpty((String)defaultValue) ? null : defaultValue;
        Object value = valueArg == null ? defVal : valueArg;
        Integer fndInx = -1;
        if (value != null) {
            ComboBoxModel model = this.comboBox.getModel();
            boolean isFormObjIFace = value instanceof FormDataObjIFace;
            if (this.adapter != null) {
                int i = 0;
                while (i < this.comboBox.getItemCount()) {
                    PickListItemIFace pli = (PickListItemIFace)model.getElementAt(i);
                    Object valObj = pli.getValueObject();
                    if (valObj != null) {
                        if (isFormObjIFace && valObj instanceof FormDataObjIFace) {
                            if (((FormDataObjIFace)value).getId().intValue() == ((FormDataObjIFace)valObj).getId().intValue()) {
                                fndInx = i;
                                break;
                            }
                        } else {
                            String pliVal;
                            String string = pliVal = pli.getValue() == null ? pli.getTitle() : pli.getValue();
                            if (pliVal != null && pliVal.equals(value.toString())) {
                                fndInx = i;
                                break;
                            }
                        }
                    } else {
                        String pliObj = pli.getValue();
                        if (pliObj != null && pliObj.equals(value.toString())) {
                            fndInx = i;
                            break;
                        }
                    }
                    ++i;
                }
                if (fndInx == -1 && this.adapter != null) {
                    ComboBoxModel cbxModel = this.comboBox.getModel();
                    if (cbxModel instanceof PickListDBAdapterIFace) {
                        PickListDBAdapterIFace pla = (PickListDBAdapterIFace)((Object)this.comboBox.getModel());
                        PickListIFace pickList = pla.getPickList();
                        if (!pickList.getReadOnly().booleanValue()) {
                            this.textEditor.setText(value.toString());
                        } else {
                            UIRegistry.showLocalizedError("ValComboBox.PL_ITEM_NOTFND", value.toString());
                        }
                    } else {
                        UIRegistry.showLocalizedError("ValComboBox.PL_ITEM_NOTFND", value.toString());
                    }
                }
            } else {
                int i = 0;
                while (i < this.comboBox.getItemCount()) {
                    Object item = model.getElementAt(i);
                    if (item instanceof String) {
                        String val;
                        String string = value != null && StringUtils.isEmpty((String)value.toString()) && StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : (val = value != null ? value.toString() : "");
                        if (((String)item).equals(val)) {
                            fndInx = i;
                            break;
                        }
                    } else {
                        PickListItemIFace pli;
                        String pliValue;
                        if (isFormObjIFace && item == value || item.equals(value)) {
                            fndInx = i;
                            break;
                        }
                        if (item instanceof PickListItemIFace && (pliValue = (pli = (PickListItemIFace)item).getValue()) != null && pliValue.equals(value)) {
                            fndInx = i;
                            break;
                        }
                    }
                    ++i;
                }
            }
            this.valState = fndInx != -1 ? UIValidatable.ErrorType.Valid : (this.adapter != null && this.isRequired || this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid);
        } else {
            if (this.nullIndex == null) {
                if (this.adapter != null) {
                    int inx = 0;
                    for (PickListItemIFace item : this.adapter.getList()) {
                        if (item != null && item.getValue() != null) {
                            if (item.getValue().equals("|null|")) {
                                this.nullIndex = inx;
                                this.comboBox.setSelectedIndex(this.nullIndex);
                                break;
                            }
                        } else if (item != null && item.getValueObject() == null) {
                            log.error((Object)("PickList item's value was null and it can't be. Title[" + item.getTitle() + "]"));
                        }
                        ++inx;
                    }
                    if (this.nullIndex == null) {
                        this.nullIndex = -1;
                    }
                }
            } else if (this.nullIndex > -1) {
                this.comboBox.setSelectedIndex(this.nullIndex);
                return;
            }
            if (this.isRequired && this.comboBox.getSelectedIndex() == -1 && this.adapter != null && this.adapter.getList() != null && this.adapter.getList().size() == 1) {
                fndInx = -1;
                this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ValComboBox.this.isNew) {
                            ValComboBox.this.valState = UIValidatable.ErrorType.Valid;
                            ValComboBox.this.comboBox.setSelectedIndex(0);
                        }
                    }
                });
            } else {
                UIValidatable.ErrorType errorType = this.valState = this.isRequired && this.comboBox.getSelectedIndex() == -1 ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
                if (this.textEditor != null) {
                    this.textEditor.setText("");
                }
            }
        }
        this.comboBox.setSelectedIndex(fndInx);
        if (this.textEditor != null && fndInx == -1 && (value != null || defaultValue != null)) {
            this.textEditor.setText(value != null ? value.toString() : defaultValue);
        }
        this.repaint();
    }

    @Override
    public Object getValue() {
        if (this.textEditor != null && StringUtils.isEmpty((String)this.textEditor.getText().trim())) {
            return null;
        }
        int inx = this.comboBox.getSelectedIndex();
        if (this.nullIndex != null && inx > -1 && inx == this.nullIndex) {
            return null;
        }
        Object selectedObj = this.comboBox.getSelectedItem();
        if (selectedObj != null) {
            if (this.adapter != null) {
                return selectedObj instanceof PickListItemIFace ? ((PickListItem)selectedObj).getValueObject() : selectedObj;
            }
            if (selectedObj instanceof TitleValueIFace) {
                return ((TitleValueIFace)selectedObj).getValue();
            }
        }
        return selectedObj;
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("ui.formatting.requiredfieldcolor") && this.textEditor != null) {
            this.textEditor.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : defaultTextBGColor);
        }
    }

    class ClearableComboBox
    extends JComboBox {
        public ClearableComboBox(ComboBoxModel model) {
            super(model);
            this.addKL();
        }

        public ClearableComboBox() {
            this.addKL();
        }

        public ClearableComboBox(Object[] items) {
            super(items);
            this.addKL();
        }

        public ClearableComboBox(Vector<?> items) {
            super(items);
            this.addKL();
        }

        private void addKL() {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    ClearableComboBox.this.checkKeyCode(e);
                }
            });
        }

        private void checkKeyCode(KeyEvent e) {
            if (e.getKeyCode() == 27 || e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                this.setSelectedIndex(-1);
            }
        }
    }
}

