/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ValCheckBox
extends JCheckBox
implements UIValidatable,
GetSetValueIFace {
    private static final Logger log = Logger.getLogger(ValCheckBox.class);
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isReadOnly = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected Boolean currentValue = null;

    public ValCheckBox(String label, boolean isRequired, boolean isReadOnly) {
        super(label);
        this.isRequired = isRequired;
        this.isReadOnly = isReadOnly;
        this.setOpaque(false);
        UIHelper.setControlSize(this);
        if (isReadOnly) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValCheckBox.this.setSelected(ValCheckBox.this.currentValue != null ? ValCheckBox.this.currentValue : false);
                }
            });
        } else {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValCheckBox.this.isChanged = true;
                }
            });
        }
    }

    public void setCurrentValue(Boolean currentValue) {
        this.currentValue = currentValue;
    }

    @Override
    public boolean isInError() {
        return false;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isNotEmpty() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        return this.valState;
    }

    @Override
    public void reset() {
        this.valState = UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeKeyListeners(this);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.currentValue = null;
        if (value != null) {
            if (value instanceof Boolean) {
                this.currentValue = (boolean)((Boolean)value);
            } else if (value instanceof String) {
                if (StringUtils.isNotEmpty((String)value.toString())) {
                    this.currentValue = ((String)value).toLowerCase().equals("true");
                }
            } else if (value instanceof Integer) {
                this.currentValue = (Integer)value != 0;
            } else if (value instanceof Short) {
                this.currentValue = (Short)value != 0;
            } else if (value instanceof Long) {
                this.currentValue = (Long)value != 0L;
            } else {
                log.error((Object)("Can't value from class [" + value.getClass().getName() + "]"));
            }
        } else if (StringUtils.isNotEmpty((String)defaultValue)) {
            this.currentValue = defaultValue.toLowerCase().equals("true");
        }
        if (this.currentValue != null) {
            this.setSelected(this.currentValue);
        } else {
            this.setSelected(false);
        }
        this.isChanged = false;
    }

    @Override
    public Object getValue() {
        if (this.isChanged) {
            return this.isSelected();
        }
        return this.currentValue;
    }
}

