/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValidationListener;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UIValidator {
    private static final Logger log = Logger.getLogger(UIValidator.class);
    protected static boolean ignoreAllValidation = false;
    protected static Object ignoreOwner = null;
    protected static int ignoreCnt = 0;
    protected JexlContext jc = null;
    protected Expression exp = null;
    protected Component comp = null;
    protected UIValidatable uiv = null;
    protected Type type = Type.OK;
    protected Vector<ValidationListener> listeners = new Vector();

    protected UIValidator(Component comp, Type type) {
        this.comp = comp;
        this.type = type;
        if (comp instanceof UIValidatable) {
            this.uiv = (UIValidatable)((Object)comp);
        }
    }

    public UIValidator(Component comp, Type type, String expression) {
        this(comp, type);
        if (StringUtils.isNotEmpty((String)expression)) {
            try {
                this.exp = ExpressionFactory.createExpression((String)expression);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIValidator.class, e);
                log.debug((Object)("Exp[" + expression + "]"));
                e.printStackTrace();
            }
        } else if (this.uiv != null) {
            this.uiv.isRequired();
        }
    }

    public void setAsNew(boolean isNew) {
        if (this.uiv != null && this.type != Type.OK) {
            this.uiv.setAsNew(isNew);
        }
    }

    public void setChanged(boolean isChanged) {
        if (this.uiv != null) {
            this.uiv.setChanged(isChanged);
        }
    }

    public static Type parseValidationType(String type) {
        if (StringUtils.isNotEmpty((String)type)) {
            try {
                return Type.valueOf(type);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIValidator.class, ex);
                return Type.OK;
            }
        }
        return Type.OK;
    }

    public boolean isRequired() {
        return this.uiv != null && this.uiv.isRequired();
    }

    public boolean validate() {
        boolean isTextField;
        if (ignoreAllValidation) {
            return true;
        }
        if (!this.comp.isEnabled()) {
            return true;
        }
        UIValidatable.ErrorType errorState = UIValidatable.ErrorType.Valid;
        boolean bl = isTextField = this.uiv != null && this.uiv.getValidatableUIComp() instanceof JTextField || this.comp instanceof JTextField;
        if (this.uiv != null) {
            errorState = this.uiv.validateState();
        }
        if (errorState == UIValidatable.ErrorType.Valid && isTextField && this.jc != null && this.exp != null) {
            try {
                Object result = this.exp.evaluate(this.jc);
                if (result instanceof Boolean) {
                    errorState = (Boolean)result != false ? UIValidatable.ErrorType.Valid : UIValidatable.ErrorType.Error;
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIValidator.class, e);
                e.printStackTrace();
            }
            if (this.uiv != null) {
                this.uiv.setState(errorState);
            }
        }
        if (isTextField && this.uiv.isRequired()) {
            this.uiv.setState(errorState);
            this.notifyValidationListeners();
        } else if (this.type != Type.OK) {
            this.notifyValidationListeners();
        }
        return errorState == UIValidatable.ErrorType.Valid;
    }

    public boolean isInError() {
        return this.uiv != null ? this.uiv.isInError() : false;
    }

    public void addValidationListener(ValidationListener l) {
        this.listeners.addElement(l);
    }

    public void removeValidationListener(ValidationListener l) {
        this.listeners.remove(l);
    }

    protected void notifyValidationListeners() {
        for (ValidationListener vl : this.listeners) {
            vl.wasValidated(this);
        }
    }

    public void setJc(JexlContext jc) {
        this.jc = jc;
    }

    public Component getComp() {
        return this.comp;
    }

    public Type getType() {
        return this.type;
    }

    public UIValidatable getUIV() {
        return this.uiv;
    }

    public void cleanUp() {
        this.listeners.clear();
    }

    public static void setIgnoreAllValidation(Object ignoreOwnerArg, boolean ignoreAllValidationArg) {
        if (ignoreAllValidationArg) {
            ++ignoreCnt;
            if (ignoreOwner == null) {
                ignoreOwner = ignoreOwnerArg;
                ignoreAllValidation = true;
            }
        } else {
            --ignoreCnt;
            if (ignoreOwner != null && ignoreOwner == ignoreOwnerArg) {
                ignoreOwner = null;
                ignoreAllValidation = false;
            }
        }
    }

    public static boolean isIgnoreAllValidation() {
        return ignoreAllValidation;
    }

    public static enum Type {
        None,
        Focus,
        Changed,
        OK;

    }
}

