/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import org.apache.commons.lang.StringUtils;

public class TypeSearchInfo
implements Comparable<TypeSearchInfo> {
    protected int tableId;
    protected String name;
    protected String displayColumns;
    protected String searchFieldName;
    protected String format;
    protected String uiFieldFormatterName;
    protected String dataObjFormatterName;
    protected String sqlTemplate = null;
    protected Boolean isSystem;

    public TypeSearchInfo(int tableId, String name, String displayColumns, String searchFieldName, String format, String uiFieldFormatterName, String dataObjFormatterName, Boolean isSystem) {
        this.tableId = tableId;
        this.name = name;
        this.displayColumns = displayColumns;
        this.searchFieldName = StringUtils.isNotBlank((String)searchFieldName) ? searchFieldName : null;
        this.format = StringUtils.isNotBlank((String)format) ? format : null;
        this.uiFieldFormatterName = StringUtils.isNotBlank((String)uiFieldFormatterName) ? uiFieldFormatterName : null;
        this.dataObjFormatterName = StringUtils.isNotBlank((String)dataObjFormatterName) ? dataObjFormatterName : null;
        this.isSystem = isSystem;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTableId() {
        return this.tableId;
    }

    public String getDisplayColumns() {
        return this.displayColumns;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUiFieldFormatterName() {
        return this.uiFieldFormatterName;
    }

    public String getDataObjFormatterName() {
        return this.dataObjFormatterName;
    }

    public String getSearchFieldName() {
        return this.searchFieldName;
    }

    public String getSqlTemplate() {
        return this.sqlTemplate;
    }

    public void setSqlTemplate(String sqlTemplate) {
        if (StringUtils.isNotBlank((String)sqlTemplate)) {
            this.sqlTemplate = sqlTemplate;
        }
    }

    public Boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(Boolean isSystem) {
        if (StringUtils.isNotBlank((String)this.sqlTemplate)) {
            this.isSystem = isSystem;
        }
    }

    private String getStr(String str) {
        return str == null ? "" : str;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public void setDisplayColumns(String displayColumns) {
        this.displayColumns = displayColumns;
    }

    public void setSearchFieldName(String searchFieldName) {
        this.searchFieldName = searchFieldName;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setUiFieldFormatterName(String uiFieldFormatterName) {
        this.uiFieldFormatterName = uiFieldFormatterName;
    }

    public void setDataObjFormatterName(String dataObjFormatterName) {
        this.dataObjFormatterName = dataObjFormatterName;
    }

    public String getXML() {
        String xmlFmt = "    <typesearch tableid=\"%d\"  name=\"%s\" searchfield=\"%s\" displaycols=\"%s\" format=\"%s\" uifieldformatter=\"%s\" dataobjformatter=\"%s\" system=\"%s\"";
        String xml = String.format(xmlFmt, this.tableId, this.name, this.getStr(this.searchFieldName), this.getStr(this.displayColumns), this.getStr(this.format), this.getStr(this.uiFieldFormatterName), this.getStr(this.dataObjFormatterName), this.isSystem.toString());
        if (StringUtils.isNotEmpty((String)this.sqlTemplate)) {
            xml = String.valueOf(xml) + ">\n        " + this.sqlTemplate + "\n";
            xml = String.valueOf(xml) + "    </typesearch>\n";
        } else {
            xml = String.valueOf(xml) + "/>\n";
        }
        return xml;
    }

    public String toString() {
        return String.valueOf(this.name) + (this.isSystem != false ? " (System)" : "");
    }

    @Override
    public int compareTo(TypeSearchInfo o) {
        return this.name.compareTo(o.getName());
    }
}

