/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.TextFieldWithInfo;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.validation.TypeSearchInfo;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class TypeSearchForQueryFactory {
    public static final String factoryName = "edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory";
    private static final Logger log = Logger.getLogger(TypeSearchForQueryFactory.class);
    private static final String TYPESEARCHES = "TypeSearches";
    protected static TypeSearchForQueryFactory instance = null;
    protected static boolean doingLocal = false;
    protected Hashtable<String, TypeSearchInfo> hash = new Hashtable();

    protected TypeSearchForQueryFactory() {
    }

    public Vector<TypeSearchInfo> getList() {
        Vector<TypeSearchInfo> list = new Vector<TypeSearchInfo>(TypeSearchForQueryFactory.instance.hash.values());
        Collections.sort(list);
        return list;
    }

    protected Element getDOM() {
        String pathName = "backstop/typesearch_def.xml";
        if (doingLocal) {
            return XMLHelper.readDOMFromConfigDir("backstop/typesearch_def.xml");
        }
        return this.getDOMFromResource(TYPESEARCHES, "backstop/typesearch_def.xml");
    }

    public Element getDOMFromResource(String name, String localPath) {
        return XMLHelper.readDOMFromConfigDir(localPath);
    }

    public void load() {
        if (this.hash.size() == 0) {
            try {
                Element root = this.getDOM();
                if (root != null) {
                    List typeSearches = root.selectNodes("/typesearches/typesearch");
                    for (Object fObj : typeSearches) {
                        Element tsElement = (Element)fObj;
                        String name = tsElement.attributeValue("name");
                        if (StringUtils.isNotBlank((String)name)) {
                            TypeSearchInfo tsi = new TypeSearchInfo(XMLHelper.getAttr(tsElement, "tableid", -1), name, tsElement.attributeValue("displaycols"), tsElement.attributeValue("searchfield"), XMLHelper.getAttr(tsElement, "format", null), XMLHelper.getAttr(tsElement, "uifieldformatter", null), XMLHelper.getAttr(tsElement, "dataobjformatter", null), XMLHelper.getAttr(tsElement, "system", true));
                            this.hash.put(name, tsi);
                            String sqlTemplate = tsElement.getTextTrim();
                            if (!StringUtils.isNotEmpty((String)sqlTemplate)) continue;
                            tsi.setSqlTemplate(sqlTemplate);
                            continue;
                        }
                        log.error((Object)"TypeSearchInfo element is missing or has a blank name!");
                    }
                } else {
                    log.debug((Object)"Couldn't open typesearch_def.xml");
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TypeSearchForQueryFactory.class, ex);
                ex.printStackTrace();
            }
        }
    }

    public TextFieldWithInfo getTextFieldWithInfo(String name, String dataObjFormatterNameArg) {
        instance.load();
        TypeSearchInfo typeSearchInfo = TypeSearchForQueryFactory.instance.hash.get(name);
        if (typeSearchInfo != null) {
            DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(typeSearchInfo.getTableId());
            if (tblInfo != null) {
                String dofName;
                String string = dofName = StringUtils.isNotEmpty((String)dataObjFormatterNameArg) ? dataObjFormatterNameArg : typeSearchInfo.getDataObjFormatterName();
                if (StringUtils.isNotEmpty((String)tblInfo.getDataObjFormatter())) {
                    dofName = tblInfo.getDataObjFormatter();
                }
                return new TextFieldWithInfo(tblInfo.getClassName(), tblInfo.getIdFieldName(), typeSearchInfo.getSearchFieldName(), typeSearchInfo.getFormat(), typeSearchInfo.getUiFieldFormatterName(), dofName, tblInfo.getNewObjDialog(), tblInfo.getTitle());
            }
            log.error((Object)("Table with ID[" + typeSearchInfo.getTableId() + "] not found."));
        } else {
            log.error((Object)("Object Type Search Name [" + name + "] not found."));
        }
        return null;
    }

    public String getDataObjFormatterName(String name) {
        instance.load();
        TypeSearchInfo typeSearchInfo = TypeSearchForQueryFactory.instance.hash.get(name);
        if (typeSearchInfo != null) {
            return typeSearchInfo.getDataObjFormatterName();
        }
        log.error((Object)("Object Type Search Name [" + name + "] not found."));
        UIRegistry.showError("Couldn't create ValComboBoxFromQuery because the entry [" + name + "] is not in the typesearch_def.xml");
        return null;
    }

    public ValComboBoxFromQuery createValComboBoxFromQuery(String name, int btnOpts, String dataObjFormatterNameArg, String helpContextArg) {
        instance.load();
        TypeSearchInfo typeSearchInfo = TypeSearchForQueryFactory.instance.hash.get(name);
        if (typeSearchInfo != null) {
            DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(typeSearchInfo.getTableId());
            if (tblInfo != null) {
                String dofName = StringUtils.isNotEmpty((String)dataObjFormatterNameArg) ? dataObjFormatterNameArg : typeSearchInfo.getDataObjFormatterName();
                return new ValComboBoxFromQuery(tblInfo, typeSearchInfo.getSearchFieldName(), typeSearchInfo.getDisplayColumns(), typeSearchInfo.getSearchFieldName(), typeSearchInfo.getFormat(), typeSearchInfo.getUiFieldFormatterName(), dofName, typeSearchInfo.getSqlTemplate(), helpContextArg, btnOpts);
            }
            log.error((Object)("Table with ID[" + typeSearchInfo.getTableId() + "] not found."));
        } else {
            log.error((Object)("Object Type Search Name [" + name + "] not found."));
        }
        String msg = "Couldn't create ValComboBoxFromQuery because the entry [" + name + "] is not in the typesearch_def.xml";
        FormDevHelper.appendFormDevError(msg);
        UIRegistry.showError(msg);
        return null;
    }

    public static void setDoingLocal(boolean doingLocal) {
        TypeSearchForQueryFactory.doingLocal = doingLocal;
    }

    public Hashtable<String, TypeSearchInfo> getHash() {
        return this.hash;
    }

    public void remove(TypeSearchInfo tsi) {
        this.hash.remove(tsi.getName());
    }

    public void add(TypeSearchInfo tsi) {
        if (this.hash.get(tsi.getName()) == null) {
            this.hash.put(tsi.getName(), tsi);
        } else {
            UIRegistry.showLocalizedError("Name is taken");
        }
    }

    public void save() {
        ArrayList<TypeSearchInfo> list = new ArrayList<TypeSearchInfo>(this.hash.values());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<typesearches>\n");
        for (TypeSearchInfo tsi : list) {
            sb.append(tsi.getXML());
        }
        sb.append("</typesearches>\n");
        if (doingLocal) {
            this.writeToFile(sb.toString());
            return;
        }
        this.saveResource(TYPESEARCHES, sb.toString());
    }

    public void saveResource(String resName, String xml) {
        this.writeToFile(xml.toString());
    }

    private void writeToFile(String xml) {
        File file = XMLHelper.getConfigDir("backstop/typesearch_def.xml");
        try {
            PrintWriter pw = new PrintWriter(file);
            pw.print(xml);
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static TypeSearchForQueryFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(TypeSearchForQueryFactory.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (TypeSearchForQueryFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SecurityMgr.class, e);
                InternalError error = new InternalError("Can't instantiate TypeSearchForQueryFactory factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        instance = new TypeSearchForQueryFactory();
        return instance;
    }
}

