/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.validation.FormValidationRuleIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.log4j.Logger;

public class RuleExpression
implements FormValidationRuleIFace {
    private static final Logger log = Logger.getLogger(RuleExpression.class);
    protected String id;
    protected String rule;
    protected Expression expression;

    public RuleExpression(String id, String rule) {
        this.id = id;
        this.rule = rule;
        try {
            this.expression = ExpressionFactory.createExpression((String)rule);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(RuleExpression.class, ex);
            log.error((Object)ex);
        }
    }

    public void cleanUp() {
        this.expression = null;
    }

    @Override
    public boolean evaluate(JexlContext context) {
        try {
            Object result = this.expression.evaluate(context);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            log.debug((Object)("the return from the evaluation is of class " + result));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(RuleExpression.class, ex);
            log.error((Object)ex);
        }
        return false;
    }

    @Override
    public FormValidationRuleIFace.Scope getScope() {
        return FormValidationRuleIFace.Scope.Field;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

