/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.FormattedTextValidatorIFace;
import edu.ku.brc.ui.DateWrapper;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class FormattedDateValidator
implements FormattedTextValidatorIFace {
    protected int[] daysInMonth;
    protected String reason;
    protected DateWrapper scrDateFormat;
    protected char separator;
    protected boolean isValid;

    public FormattedDateValidator() {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        this.daysInMonth = nArray;
        this.reason = "";
        this.scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
        this.separator = (char)47;
        this.isValid = true;
        this.separator = this.discoverSeparator();
    }

    protected char discoverSeparator() {
        String formatStr = this.scrDateFormat.getSimpleDateFormat().toPattern();
        int i = 0;
        while (i < formatStr.length()) {
            if (!Character.isLetter(formatStr.charAt(i))) {
                return formatStr.charAt(i);
            }
            ++i;
        }
        return Character.valueOf('/').charValue();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean validate(UIFieldFormatterIFace formatter, String value) {
        this.reason = "";
        int len = formatter.getLength();
        if (StringUtils.isNotEmpty((String)value)) {
            if (formatter.isDate()) {
                Vector<UIFieldFormatterField> fields = formatter.getFields();
                int pos = 0;
                int mon = -1;
                int day = -1;
                int year = -1;
                for (UIFieldFormatterField field : fields) {
                    if (pos >= len || pos + field.getSize() > value.length()) {
                        this.reason = "Partial";
                        break;
                    }
                    if (field.getType() == UIFieldFormatterField.FieldType.numeric) {
                        String part = value.substring(pos, pos + field.getSize());
                        if (StringUtils.isNumeric((String)part)) {
                            char c = field.getValue().charAt(0);
                            int numPart = Integer.parseInt(part);
                            if (c == 'M' || c == 'm') {
                                mon = numPart;
                            } else if (c == 'd' || c == 'D') {
                                day = numPart;
                            } else if (c == 'Y' || c == 'y') {
                                year = numPart;
                            }
                        } else {
                            if (part.indexOf(this.separator) > -1) {
                                this.reason = "Wrong format";
                                this.isValid = false;
                                return false;
                            }
                            this.reason = this.getFieldSpecificError(field, " is Not numeric");
                            this.isValid = false;
                            return false;
                        }
                    }
                    pos += field.getSize();
                }
                if (mon != -1 && day != -1 && year != -1) {
                    int n = this.daysInMonth[1] = year % 4 == 0 || year % 100 == 0 && year % 400 != 0 ? 29 : 28;
                    if (mon < 1 || mon > 12) {
                        this.reason = "Invalid Month";
                        this.isValid = false;
                        return false;
                    }
                    if (day < 1 || day > this.daysInMonth[mon - 1]) {
                        this.reason = "Invalid Day";
                        this.isValid = false;
                        return false;
                    }
                    this.isValid = true;
                    return true;
                }
                if (mon != -1 && day != -1) {
                    this.daysInMonth[1] = 29;
                    if (mon < 1 || mon > 12) {
                        this.reason = "Invalid Month";
                        this.isValid = false;
                        return false;
                    }
                    if (day < 1 || day > this.daysInMonth[mon]) {
                        this.reason = "Invalid Day";
                        this.isValid = false;
                        return false;
                    }
                    this.isValid = true;
                    return true;
                }
                if (mon != -1) {
                    if (mon < 1 || mon > 12) {
                        this.reason = "Invalid Month";
                        this.isValid = false;
                        return false;
                    }
                } else if (day > -1 && (day < 1 || day > 31)) {
                    this.reason = "Invalid Day";
                    this.isValid = false;
                    return false;
                }
            }
            this.isValid = true;
            return true;
        }
        this.reason = "Date is Empty";
        this.isValid = false;
        return false;
    }

    protected String getFieldSpecificError(UIFieldFormatterField field, String msg) {
        char c = field.getValue().charAt(0);
        if (c == 'M' || c == 'm') {
            return "Month" + msg;
        }
        if (c == 'd' || c == 'D') {
            return "Day" + msg;
        }
        if (c == 'Y' || c == 'y') {
            return "Year" + msg;
        }
        return "";
    }

    protected static List<UIFieldFormatter> getDateFormatters() {
        Vector<UIFieldFormatter> formatters = new Vector<UIFieldFormatter>();
        Vector<UIFieldFormatterField> fields = new Vector<UIFieldFormatterField>();
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "MM", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, "/", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "dd", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, "/", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 4, "YYYY", false));
        UIFieldFormatter uif = new UIFieldFormatter("Date", true, "*", UIFieldFormatterIFace.FormatterType.date, UIFieldFormatterIFace.PartialDateEnum.Full, Date.class, true, false, fields);
        formatters.add(uif);
        fields = new Vector();
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "dd", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, "/", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "MM", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, "/", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 4, "YYYY", false));
        uif = new UIFieldFormatter("Date", true, "*", UIFieldFormatterIFace.FormatterType.date, UIFieldFormatterIFace.PartialDateEnum.Full, Date.class, true, false, fields);
        formatters.add(uif);
        fields = new Vector();
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 4, "YYYY", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, "/", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "MM", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, "/", false));
        fields.add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "dd", false));
        uif = new UIFieldFormatter("Date", true, "*", UIFieldFormatterIFace.FormatterType.date, UIFieldFormatterIFace.PartialDateEnum.Full, Date.class, true, false, fields);
        formatters.add(uif);
        return formatters;
    }

    public static void main(String[] args) {
        String[] dates;
        FormattedDateValidator formattedDateValidator = new FormattedDateValidator();
        String[] stringArray = dates = new String[]{"02/29/2008", "02/29/2007", "01/01/07", "32/01/07", "01/32/07", "01/32", "32/01", "32", "32", "32"};
        int n = dates.length;
        int n2 = 0;
        while (n2 < n) {
            String dateStr = stringArray[n2];
            for (UIFieldFormatterIFace uIFieldFormatterIFace : FormattedDateValidator.getDateFormatters()) {
                boolean isValid = formattedDateValidator.validate(uIFieldFormatterIFace, dateStr);
                System.out.println("For [" + uIFieldFormatterIFace.toPattern() + "] [" + dateStr + "]  " + isValid + "   " + formattedDateValidator.getReason());
            }
            System.out.println(" ");
            ++n2;
        }
    }
}

