/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class FormValidatorInfo
extends JPanel {
    protected JTable table;
    protected FormValidatorInfoModel model;
    protected FormValidator formValidator;

    public FormValidatorInfo(FormValidator formValidator) {
        this.model = new FormValidatorInfoModel(formValidator);
        this.table = new JTable(this.model);
        this.formValidator = formValidator;
        this.setLayout(new BorderLayout());
        this.add((Component)UIHelper.createScrollPane(this.table), "Center");
    }

    public void cleanUp() {
        this.formValidator = null;
    }

    class FormValidatorInfoModel
    extends AbstractTableModel {
        protected Vector<Pair<String, String>> rows = new Vector();
        protected String[] header = new String[]{UIRegistry.getResourceString("VAL_CONTROLSUBFORM_LABEL"), UIRegistry.getResourceString("VAL_STATUS_LABEL")};

        public FormValidatorInfoModel(FormValidator validator) {
            for (FormValidator kidValidator : validator.getKids()) {
                if (!kidValidator.isRequired() || kidValidator.isFormValid()) continue;
                this.rows.add(new Pair<String, String>(kidValidator.getName(), kidValidator.getState().toString()));
            }
            for (DataChangeNotifier dcn : validator.getDCNs().values()) {
                String reason;
                UIValidatable uval;
                if (dcn.getUIV() == null || (uval = dcn.getUIV().getUIV()) == null || !uval.getValidatableUIComp().isEnabled() || (!uval.isRequired() || uval.getState() == UIValidatable.ErrorType.Valid) && (uval.isRequired() || uval.getState() != UIValidatable.ErrorType.Error)) continue;
                String titleStr = validator.getLabelTextForId(dcn.getId());
                if (titleStr == null || titleStr.trim().length() == 0) {
                    titleStr = uval.getValidatableUIComp().getClass().getSimpleName();
                }
                if (StringUtils.isEmpty((String)(reason = uval.getReason()))) {
                    reason = uval.getState().toString();
                }
                this.rows.add(new Pair<String, String>(titleStr, reason));
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.header[column];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Pair<String, String> item = this.rows.get(row);
            return column == 0 ? (String)item.first : UIRegistry.getResourceString(((String)item.second).toString());
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

