/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidationRuleIFace;
import edu.ku.brc.af.ui.forms.validation.RuleExpression;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.af.ui.forms.validation.ValidationListener;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FormValidator
implements ValidationListener,
DataChangeListener {
    private static final Logger log = Logger.getLogger(FormValidator.class);
    private String name = "";
    protected JexlContext jc = null;
    protected Expression exp = null;
    protected FormValidator parent;
    protected Vector<FormValidator> kids = new Vector();
    protected List<FormValidationRuleIFace> formRules = new Vector<FormValidationRuleIFace>();
    protected Hashtable<String, DataChangeNotifier> dcNotifiers = new Hashtable();
    protected List<UIValidator> validators = new Vector<UIValidator>();
    protected Hashtable<String, Component> fields = new Hashtable();
    protected Hashtable<String, JLabel> labels = new Hashtable();
    protected Hashtable<EnableType, Vector<Component>> enableHash = new Hashtable();
    protected JComponent saveComp = null;
    protected EnableType saveEnableType = EnableType.ValidAndChangedItems;
    protected boolean isTopLevel = false;
    protected boolean enabled = false;
    protected boolean hasChanged = false;
    protected boolean isNewObj = false;
    protected boolean isRequired = true;
    protected UIValidatable.ErrorType formValidationState = UIValidatable.ErrorType.Valid;
    protected UIValidatable.ErrorType kidsValState = UIValidatable.ErrorType.Valid;
    protected boolean processRulesAreOK = true;
    protected boolean ignoreValidationNotifications = false;
    protected boolean okToDataChangeNotification = true;
    protected JButton validationInfoBtn = null;
    protected List<DataChangeListener> dcListeners = new ArrayList<DataChangeListener>();
    protected List<ValidationListener> valListeners = new ArrayList<ValidationListener>();

    public FormValidator(FormValidator parent) {
        this.parent = parent;
        this.jc = JexlHelper.createContext();
        this.addRuleObjectMapping("form", this);
        EnableType[] enableTypeArray = EnableType.values();
        int n = enableTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnableType type = enableTypeArray[n2];
            this.enableHash.put(type, new Vector());
            ++n2;
        }
    }

    public FormValidator getParent() {
        return this.parent;
    }

    public void setSaveComp(JComponent saveComp, EnableType saveEnableType) {
        this.saveComp = saveComp;
        this.saveEnableType = saveEnableType;
    }

    public void setParent(FormValidator parent) {
        this.parent = parent;
    }

    protected List<UIValidator> getValidators() {
        return this.validators;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setNewObj(boolean isNewObj) {
        this.isNewObj = isNewObj;
        this.enableUIItems(this.getState() == UIValidatable.ErrorType.Valid && !isNewObj, EnableType.ValidItems);
        this.enableUIItems(this.getState() == UIValidatable.ErrorType.Valid && !isNewObj, EnableType.ValidNotNew);
        this.updateValidationBtnUIState();
    }

    public void add(FormValidator val) {
        this.kids.add(val);
    }

    public void remove(FormValidator val) {
        this.kids.remove(val);
    }

    public void clearKids() {
        this.kids.clear();
    }

    protected Vector<FormValidator> getKids() {
        return this.kids;
    }

    public void addEnableItem(Component comp, EnableType type) {
        Vector<Component> list = this.enableHash.get((Object)type);
        list.add(comp);
        comp.setEnabled(false);
    }

    public void removeEnabledItem(Component comp, EnableType type) {
        Vector<Component> list = this.enableHash.get((Object)type);
        list.remove(comp);
    }

    public boolean isFormValid() {
        return this.isFormValid(true);
    }

    protected boolean isFormValid(boolean checkKids) {
        if (checkKids) {
            for (FormValidator kid : this.kids) {
                if (kid.isFormValid()) continue;
                return false;
            }
        }
        return this.formValidationState == UIValidatable.ErrorType.Valid && this.processRulesAreOK;
    }

    public void setFormValidationState(UIValidatable.ErrorType formValidationState) {
        if (this.enabled) {
            if (this.formValidationState != formValidationState) {
                this.updateValidationBtnUIState();
            }
            this.formValidationState = formValidationState;
        }
    }

    public UIValidatable.ErrorType getState() {
        return !this.hasChanged && this.isNewObj ? UIValidatable.ErrorType.Valid : (this.processRulesAreOK ? this.formValidationState : UIValidatable.ErrorType.Error);
    }

    public void setState(UIValidatable.ErrorType state) {
        this.formValidationState = state;
        this.updateValidationBtnUIState();
    }

    public boolean hasChanged() {
        for (FormValidator kid : this.kids) {
            if (!kid.hasChanged()) continue;
            return true;
        }
        return this.hasChanged;
    }

    public void setDataChangeNotification(boolean okToDataChangeNotification) {
        this.okToDataChangeNotification = okToDataChangeNotification;
        for (FormValidator kid : this.kids) {
            kid.setDataChangeNotification(okToDataChangeNotification);
        }
    }

    public void addEnableRule(String id, String rule) {
        this.formRules.add(new RuleExpression(id, rule));
    }

    public void addRule(FormValidationRuleIFace rule) {
        this.formRules.add(rule);
    }

    public void setUIValidatorsToNew(boolean isNew) {
        if (this.enabled) {
            for (UIValidator uiv : this.validators) {
                uiv.setAsNew(isNew);
            }
            this.updateValidationBtnUIState();
            for (FormValidator kid : this.kids) {
                kid.setUIValidatorsToNew(isNew);
            }
        }
    }

    public void setUIValidatorsToNotChanged() {
        this.hasChanged = false;
        for (UIValidator uiv : this.validators) {
            uiv.setChanged(false);
        }
        if (this.enabled) {
            this.updateValidationBtnUIState();
        }
        for (FormValidator kid : this.kids) {
            kid.setUIValidatorsToNotChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void enabledTreeForUI(FormValidator parentFV, boolean enable, EnableType type) {
        this.enableUIItems(enable, type);
        for (FormValidator kid : parentFV.kids) {
            this.enabledTreeForUI(kid, enable, type);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (!enabled) {
                this.hasChanged = false;
                this.formValidationState = UIValidatable.ErrorType.Valid;
                this.kidsValState = UIValidatable.ErrorType.Valid;
                this.resetFields();
            }
            this.enabled = enabled;
            for (FormValidator kid : this.kids) {
                kid.setEnabled(enabled);
            }
        }
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public void setTopLevel(boolean isTopLevel) {
        this.isTopLevel = isTopLevel;
    }

    public boolean isNewObj() {
        return this.isNewObj;
    }

    public void reset(boolean isNewObjArg) {
        if (this.enabled) {
            this.hasChanged = false;
            this.resetFields();
            this.setDataChangeNotification(true);
            if (isNewObjArg) {
                this.isNewObj = isNewObjArg;
            } else {
                this.validateForm();
            }
            this.updateValidationBtnUIState();
            for (FormValidator kid : this.kids) {
                kid.reset(isNewObjArg);
            }
        }
    }

    public boolean processFormRules() {
        boolean formIsOK = true;
        boolean debug = false;
        if (debug) {
            Object[] keys;
            log.debug((Object)(String.valueOf(this.name) + " ****** processFormRules  "));
            Map map = this.jc.getVars();
            Object[] objectArray = keys = map.keySet().toArray();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                log.debug((Object)(String.valueOf(this.name) + " ### [" + key + "][" + map.get(key).getClass().toString() + "]"));
                ++n2;
            }
        }
        for (FormValidationRuleIFace rule : this.formRules) {
            try {
                boolean result = rule.evaluate(this.jc);
                if (rule.getScope() == FormValidationRuleIFace.Scope.Field) {
                    JLabel lbl;
                    Component comp = this.getComp(rule.getId());
                    if (comp != null) {
                        comp.setEnabled(result);
                    }
                    if ((lbl = this.labels.get(rule.getId())) == null) continue;
                    lbl.setEnabled(result);
                    continue;
                }
                if (rule.getScope() != FormValidationRuleIFace.Scope.Form) continue;
                formIsOK &= result;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormValidator.class, ex);
                log.error((Object)(String.valueOf(this.name) + " " + ex.toString()));
                formIsOK = false;
            }
        }
        return formIsOK;
    }

    public void hookupTextField(JTextComponent textField, String id, boolean isRequiredArg, UIValidator.Type valType, String valStr, boolean changeListenerOnly) {
        this.fields.put(id, textField);
        UIValidator.Type type = isRequiredArg ? UIValidator.Type.Changed : valType;
        UIValidator uiv = null;
        if (StringUtils.isEmpty((String)valStr)) {
            if (valType != UIValidator.Type.None) {
                uiv = this.createValidator(textField, valType);
            }
        } else {
            UIValidator uIValidator = uiv = changeListenerOnly ? null : this.createValidator(textField, type, valStr);
        }
        if (uiv != null) {
            DataChangeNotifier dcn = new DataChangeNotifier(id, textField, uiv);
            dcn.addDataChangeListener(this);
            this.dcNotifiers.put(id, dcn);
            if (type == UIValidator.Type.Changed || isRequiredArg || changeListenerOnly) {
                textField.getDocument().addDocumentListener(dcn);
            } else if (type == UIValidator.Type.Focus) {
                textField.addFocusListener(dcn);
            }
        }
        this.addRuleObjectMapping(id, textField);
    }

    public DataChangeNotifier hookupComponent(JComponent comp, String id, UIValidator.Type valType, String valStr, boolean changeListenerOnly) {
        this.fields.put(id, comp);
        UIValidator uiv = null;
        uiv = StringUtils.isEmpty((String)valStr) ? this.createValidator(comp, valType) : (changeListenerOnly ? null : this.createValidator(comp, valType, valStr));
        DataChangeNotifier dcn = new DataChangeNotifier(id, comp, uiv);
        dcn.addDataChangeListener(this);
        this.dcNotifiers.put(id, dcn);
        this.addRuleObjectMapping(id, comp);
        return dcn;
    }

    public JLabel createLabel(String labelName, String labelStr) {
        JLabel lbl = UIHelper.createLabel(labelStr);
        UIHelper.setControlSize(lbl);
        this.labels.put(labelName, lbl);
        return lbl;
    }

    public JLabel addUILabel(String labelName, JLabel lbl) {
        this.labels.put(labelName, lbl);
        return lbl;
    }

    public ValTextField getTextField(String id) {
        Component comp = this.fields.get(id);
        if (comp instanceof ValTextField) {
            return (ValTextField)comp;
        }
        throw new RuntimeException("Desired JComponent [" + id + "]is not of type ValTextField" + comp);
    }

    public Component getComp(String id) {
        return this.fields.get(id);
    }

    public Component addUIComp(String id, Component comp) {
        this.fields.put(id, comp);
        this.addRuleObjectMapping(id, comp);
        return comp;
    }

    public String getLabelTextForId(String id) {
        JLabel label = this.labels.get(id);
        if (label != null) {
            String labelStr = label.getText();
            if (labelStr.endsWith(":")) {
                return labelStr.substring(0, labelStr.length() - 1);
            }
            return labelStr;
        }
        return "";
    }

    public void addRuleObjectMapping(String id, Object comp) {
        if (StringUtils.isNotEmpty((String)id) && comp != null) {
            if (this.jc != null && this.jc.getVars() != null) {
                this.jc.getVars().put(id, comp);
            }
        } else if (!UIRegistry.isRelease()) {
            throw new RuntimeException("id[" + id + "] or Comp[" + comp + "] is null.");
        }
    }

    protected UIValidator createValidator(JComponent comp, UIValidator.Type valType, String valStr) {
        if (comp instanceof UIValidatable) {
            UIValidator validator = new UIValidator(comp, valType, valStr);
            validator.setJc(this.jc);
            validator.addValidationListener(this);
            this.validators.add(validator);
            return validator;
        }
        throw new RuntimeException("Component is NOT an UIValidatable " + comp);
    }

    public UIValidator createValidator(JComponent comp, UIValidator.Type valType) {
        UIValidator validator = new UIValidator(comp, valType);
        validator.setJc(this.jc);
        validator.addValidationListener(this);
        this.validators.add(validator);
        return validator;
    }

    protected void checkForValidForm() {
        this.processRulesAreOK = this.processFormRules();
        if (this.processRulesAreOK) {
            this.formValidationState = UIValidatable.ErrorType.Valid;
            for (UIValidator uiv : this.validators) {
                if (!uiv.getComp().isEnabled() || !uiv.isInError()) continue;
                switch (uiv.getUIV().getState()) {
                    case Valid: {
                        break;
                    }
                    case Incomplete: {
                        if (this.formValidationState != UIValidatable.ErrorType.Valid) break;
                        this.formValidationState = UIValidatable.ErrorType.Incomplete;
                        break;
                    }
                    case Error: {
                        this.formValidationState = UIValidatable.ErrorType.Error;
                    }
                }
                if (this.formValidationState == UIValidatable.ErrorType.Error) break;
            }
        }
        boolean isValid = this.getState() == UIValidatable.ErrorType.Valid;
        this.enableUIItems(isValid && this.hasChanged, EnableType.ValidAndChangedItems);
        this.enableUIItems(isValid, EnableType.ValidItems);
        this.enableUIItems(isValid && !this.isNewObj, EnableType.ValidNotNew);
        if (this.parent != null) {
            FormValidator parentFV = this.parent;
            parentFV.validateForm();
            while (parentFV.parent != null) {
                parentFV = parentFV.parent;
                parentFV.validateForm();
            }
        }
    }

    protected FormValidator getRoot() {
        if (this.parent == null) {
            return this;
        }
        FormValidator parentFV = this.parent;
        while (parentFV.parent != null) {
            parentFV = this.parent;
        }
        return parentFV;
    }

    public void setIgnoreValidationNotifications(boolean ignoreValidationNotifications) {
        this.ignoreValidationNotifications = ignoreValidationNotifications;
    }

    public void validateForm() {
        if (this.enabled) {
            boolean curIgnoreVal = this.ignoreValidationNotifications;
            this.ignoreValidationNotifications = true;
            this.kidsValState = UIValidatable.ErrorType.Valid;
            for (FormValidator kid : this.kids) {
                kid.validateForm();
                if (kid.getState().ordinal() <= this.kidsValState.ordinal()) continue;
                this.kidsValState = kid.getState();
            }
            this.processRulesAreOK = this.processFormRules();
            if (this.processRulesAreOK) {
                this.formValidationState = UIValidatable.ErrorType.Valid;
                for (DataChangeNotifier dcn : this.dcNotifiers.values()) {
                    if (!dcn.isEnabled()) continue;
                    dcn.manualCheckForDataChanged();
                    UIValidator uiv = dcn.getUIV();
                    if (uiv == null || uiv.validate()) continue;
                    switch (uiv.getUIV().getState()) {
                        case Valid: {
                            break;
                        }
                        case Incomplete: {
                            if (this.formValidationState != UIValidatable.ErrorType.Valid) break;
                            this.formValidationState = UIValidatable.ErrorType.Incomplete;
                            break;
                        }
                        case Error: {
                            this.formValidationState = UIValidatable.ErrorType.Error;
                        }
                    }
                }
            } else {
                this.formValidationState = UIValidatable.ErrorType.Error;
            }
            if (this.kidsValState.ordinal() > this.formValidationState.ordinal()) {
                this.formValidationState = this.kidsValState;
            }
            boolean isValid = this.isFormValid();
            this.enableUIItems(this.hasChanged && isValid, EnableType.ValidAndChangedItems);
            this.enableUIItems(isValid, EnableType.ValidItems);
            this.enableUIItems(isValid && !this.isNewObj, EnableType.ValidNotNew);
            this.updateValidationBtnUIState();
            this.ignoreValidationNotifications = curIgnoreVal;
        }
    }

    protected void cascadeHasChanged(boolean changed) {
        this.hasChanged = changed;
        if (this.parent != null) {
            FormValidator parentFV = this.parent;
            while (parentFV != null) {
                if (!parentFV.hasChanged && changed) {
                    parentFV.hasChanged = changed;
                }
                parentFV = parentFV.parent;
            }
        }
    }

    public void setDataChangeInNotifier(Component comp) {
        if (comp != null) {
            this.cascadeHasChanged(true);
            for (DataChangeNotifier dcn : this.dcNotifiers.values()) {
                UIValidator uiv = dcn.getUIV();
                if (uiv == null || uiv.getComp() != comp) continue;
                dcn.setDataChanged(true);
            }
        }
    }

    public void resetFields() {
        if (this.enabled) {
            Enumeration<DataChangeNotifier> e = this.dcNotifiers.elements();
            while (e.hasMoreElements()) {
                DataChangeNotifier dcn = e.nextElement();
                dcn.reset();
            }
        }
    }

    public DataChangeNotifier createDataChangeNotifer(String id, Component comp, UIValidator uiv) {
        DataChangeNotifier dcn = new DataChangeNotifier(id, comp, uiv);
        dcn.addDataChangeListener(this);
        this.dcNotifiers.put(id, dcn);
        if (uiv != null && !this.validators.contains(uiv)) {
            this.validators.add(uiv);
        }
        return dcn;
    }

    public void cleanUp() {
        this.jc = null;
        this.exp = null;
        for (FormValidator formValidator : this.kids) {
            formValidator.cleanUp();
        }
        this.parent = null;
        for (DataChangeNotifier dataChangeNotifier : this.dcNotifiers.values()) {
            dataChangeNotifier.cleanUp();
        }
        this.dcNotifiers.clear();
        for (UIValidator uIValidator : this.validators) {
            uIValidator.cleanUp();
        }
        this.validators.clear();
        this.fields.clear();
        this.labels.clear();
        for (FormValidationRuleIFace formValidationRuleIFace : this.formRules) {
            if (!(formValidationRuleIFace instanceof RuleExpression)) continue;
            ((RuleExpression)formValidationRuleIFace).cleanUp();
        }
        this.formRules.clear();
        for (Vector vector : this.enableHash.values()) {
            vector.clear();
        }
        this.dcListeners.clear();
        this.valListeners.clear();
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.dcListeners.add(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.dcListeners.remove(l);
    }

    public void addValidationListener(ValidationListener l) {
        this.valListeners.add(l);
    }

    public void removeValidationListener(ValidationListener l) {
        this.valListeners.remove(l);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, DataChangeNotifier> getDCNs() {
        return this.dcNotifiers;
    }

    public void dumpState(boolean doBrief, int level) {
        String displayName;
        String string = displayName = this.name != null ? this.name : "No Name";
        if (doBrief) {
            log.debug((Object)(String.valueOf(level) + " *** " + displayName + "  isValid: " + this.isFormValid() + " " + (Object)((Object)this.getState())));
        } else {
            StringBuilder strBuf = new StringBuilder(64);
            log.debug((Object)("\n" + level + " ------------" + displayName + "-------------"));
            log.debug((Object)("Valid: " + this.isFormValid()));
            log.debug((Object)"\n");
            int maxLen = 0;
            for (DataChangeNotifier dcn : this.dcNotifiers.values()) {
                int len = dcn.getId().length();
                maxLen = Math.max(maxLen, len);
            }
            for (DataChangeNotifier dcn : this.dcNotifiers.values()) {
                String nm = dcn.getId();
                strBuf.setLength(0);
                strBuf.append(nm);
                int i = 0;
                while (i <= maxLen - nm.length()) {
                    strBuf.append(" ");
                    ++i;
                }
                UIValidator uiv = dcn.getUIV();
                if (uiv != null) {
                    strBuf.append("UIV: ");
                    strBuf.append((Object)uiv.getType());
                    strBuf.append(" ");
                    strBuf.append((Object)uiv.getUIV().getState());
                }
                log.debug((Object)strBuf.toString());
            }
            log.debug((Object)"-------------------------");
        }
        for (FormValidator kid : this.kids) {
            kid.dumpState(doBrief, level + 1);
        }
    }

    public void setValidationBtn(JButton valInfoBtn) {
        this.validationInfoBtn = valInfoBtn;
    }

    public void updateValidationBtnUIState() {
        if (this.validationInfoBtn != null) {
            boolean enable = true;
            ImageIcon icon = IconManager.getIcon("ValidationValid", IconManager.IconSize.Std16);
            UIValidatable.ErrorType state = this.getState();
            if (this.kidsValState.ordinal() > state.ordinal()) {
                state = this.kidsValState;
            }
            if (state == UIValidatable.ErrorType.Incomplete) {
                icon = IconManager.getIcon("ValidationWarning", IconManager.IconSize.Std16);
            } else if (state == UIValidatable.ErrorType.Error) {
                icon = IconManager.getIcon("ValidationError", IconManager.IconSize.Std16);
            } else {
                enable = false;
            }
            this.validationInfoBtn.setEnabled(enable);
            this.validationInfoBtn.setIcon(icon);
        }
    }

    protected void enableUIItems(boolean itsOKToEnable, EnableType type) {
        for (Component comp : this.enableHash.get((Object)type)) {
            comp.setEnabled(itsOKToEnable);
        }
        this.updateValidationBtnUIState();
        if (!(type != this.saveEnableType && type != EnableType.ValidAndChangedItems || this.saveComp == null || UIValidator.isIgnoreAllValidation())) {
            if (itsOKToEnable) {
                this.saveComp.setEnabled(this.isFormValid(true));
            } else {
                this.saveComp.setEnabled(false);
            }
        }
    }

    public void updateSaveUIEnabledState() {
        if (this.saveComp != null) {
            this.saveComp.setEnabled(this.isFormValid(true));
        }
    }

    @Override
    public void wasValidated(UIValidator validator) {
        if (!this.ignoreValidationNotifications) {
            if (validator != null && this.validators.contains(validator)) {
                this.cascadeHasChanged(true);
            }
            this.checkForValidForm();
            for (ValidationListener vcl : this.valListeners) {
                vcl.wasValidated(validator);
            }
            this.updateValidationBtnUIState();
        }
    }

    public void validateRoot() {
        FormValidator fvParent = this;
        while (fvParent.getParent() != null) {
            fvParent = fvParent.getParent();
        }
        fvParent.validateForm();
    }

    @Override
    public void dataChanged(String dcName, Component comp, DataChangeNotifier dcn) {
        UIValidator uiv;
        if (!this.okToDataChangeNotification || UIValidator.isIgnoreAllValidation()) {
            return;
        }
        this.cascadeHasChanged(true);
        UIValidator uIValidator = uiv = dcn != null ? dcn.getUIV() : null;
        if (uiv == null) {
            this.validateRoot();
        }
        for (DataChangeListener dcl : this.dcListeners) {
            dcl.dataChanged(dcName, comp, dcn);
        }
        boolean isValid = this.formValidationState == UIValidatable.ErrorType.Valid;
        this.enableUIItems(this.hasChanged && isValid, EnableType.ValidAndChangedItems);
        this.enableUIItems(isValid, EnableType.ValidItems);
        this.enableUIItems(isValid && !this.isNewObj, EnableType.ValidNotNew);
        this.updateValidationBtnUIState();
    }

    public void setHasChanged(boolean hasChanged) {
        this.cascadeHasChanged(hasChanged);
    }

    public static enum EnableType {
        ValidItems,
        ValidAndChangedItems,
        ValidNotNew;

    }
}

