/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.MultiStateIconButon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class DataChangeNotifier
implements FocusListener,
KeyListener,
ChangeListener,
ListDataListener,
ListSelectionListener,
PropertyChangeListener,
ActionListener,
DocumentListener,
ItemListener {
    protected UIValidator uiv;
    protected boolean hasDataChanged = false;
    protected Vector<DataChangeListener> dcListeners = new Vector();
    protected Component comp;
    protected String id;
    protected String cachedData = null;

    public DataChangeNotifier(String id, Component comp, UIValidator uiv) {
        this.id = id;
        this.comp = comp;
        this.uiv = uiv;
    }

    public DataChangeNotifier(String id, Component comp) {
        this.id = id;
        this.comp = comp;
        this.uiv = null;
    }

    public void addDataChangeListener(DataChangeListener dcl) {
        this.dcListeners.addElement(dcl);
    }

    public void removeDataChangeListener(DataChangeListener dcl) {
        this.dcListeners.removeElement(dcl);
    }

    protected void notifyDataChangeListeners() {
        this.hasDataChanged = true;
        if (this.comp instanceof UIValidatable) {
            ((UIValidatable)((Object)this.comp)).setChanged(true);
        }
        for (DataChangeListener dcl : this.dcListeners) {
            dcl.dataChanged(this.id, this.comp, this);
        }
    }

    public String getValueForControl(Component component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof JToggleButton) {
            return Boolean.toString(((JToggleButton)component).isSelected());
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedItem().toString();
        }
        if (component instanceof JList) {
            JList list = (JList)component;
            int inx = list.getSelectedIndex();
            return inx == -1 ? "" : list.getModel().getElementAt(inx).toString();
        }
        if (component instanceof JCheckBox) {
            return ((JCheckBox)component).isSelected() ? "true" : "false";
        }
        if (component instanceof GetSetValueIFace) {
            Object value = ((GetSetValueIFace)((Object)component)).getValue();
            return value != null ? value.toString() : null;
        }
        if (component instanceof MultiStateIconButon) {
            return String.valueOf(((MultiStateIconButon)component).getState());
        }
        throw new RuntimeException("Can't get a value for componentonent: " + component);
    }

    public void reset() {
        this.hasDataChanged = false;
        if (this.comp instanceof UIValidatable) {
            UIValidatable uiVal = (UIValidatable)((Object)this.comp);
            uiVal.setChanged(false);
        } else {
            this.cachedData = this.getValueForControl(this.comp);
        }
    }

    public boolean manualCheckForDataChanged() {
        if (!this.hasDataChanged) {
            if (this.comp instanceof UIValidatable) {
                this.hasDataChanged = ((UIValidatable)((Object)this.comp)).isChanged();
            } else if (this.cachedData != null) {
                if (!this.cachedData.equals(this.getValueForControl(this.comp))) {
                    this.hasDataChanged = true;
                }
            } else {
                String str = this.getValueForControl(this.comp);
                if (StringUtils.isNotEmpty((String)str)) {
                    this.hasDataChanged = true;
                }
            }
        }
        return this.hasDataChanged;
    }

    public boolean isDataChanged() {
        return this.hasDataChanged;
    }

    public void setDataChanged(boolean hasDataChanged) {
        this.hasDataChanged = hasDataChanged;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UIValidator getUIV() {
        return this.uiv;
    }

    public void cleanUp() {
        this.uiv = null;
        this.dcListeners.clear();
        this.comp = null;
    }

    protected void doValidateOnChange() {
        if (this.uiv != null && this.uiv.getType() == UIValidator.Type.Changed) {
            this.uiv.validate();
        }
        this.notifyDataChangeListeners();
    }

    public UIValidator.Type getValidationType() {
        return this.uiv != null ? this.uiv.getType() : UIValidator.Type.None;
    }

    public boolean isEnabled() {
        return this.comp != null && this.comp.isEnabled();
    }

    public void setComp(Component comp) {
        this.comp = comp;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!(this.comp instanceof UIValidatable)) {
            this.cachedData = this.getValueForControl(this.comp);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.comp instanceof UIValidatable) {
            if (((UIValidatable)((Object)this.comp)).isChanged()) {
                if (this.uiv != null && this.uiv.getType() == UIValidator.Type.Focus) {
                    this.uiv.validate();
                }
                this.notifyDataChangeListeners();
            }
        } else {
            if (this.uiv != null && this.uiv.getType() == UIValidator.Type.Focus) {
                this.uiv.validate();
            }
            if (this.cachedData != null && !this.cachedData.equals(this.getValueForControl(this.comp))) {
                this.notifyDataChangeListeners();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.notifyDataChangeListeners();
        if (this.uiv != null && this.uiv.getType() == UIValidator.Type.Changed) {
            this.uiv.validate();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.doValidateOnChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doValidateOnChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doValidateOnChange();
    }
}

