/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewLoader;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ViewSet
implements Comparable<ViewSetIFace>,
ViewSetIFace {
    private static final Logger log = Logger.getLogger(ViewSet.class);
    private static boolean ALWAYS_LOAD = false;
    protected ViewSetIFace.Type type = ViewSetIFace.Type.User;
    protected String name = null;
    protected String title = null;
    protected String fileName = null;
    protected File dirPath = null;
    protected String i18NResourceName = null;
    protected boolean isDiskBased = true;
    protected boolean hasLoadedViews = false;
    protected Hashtable<String, ViewIFace> transientViews = null;
    protected Hashtable<String, ViewDefIFace> transientViewDefs = null;
    protected Hashtable<String, ViewIFace> views = new Hashtable();
    protected Hashtable<String, ViewDefIFace> viewDefs = new Hashtable();

    public ViewSet() {
    }

    public ViewSet(Element rootDOM, boolean doMapDefinitions) throws Exception {
        this.isDiskBased = false;
        this.loadDOM(rootDOM, true, doMapDefinitions);
    }

    public ViewSet(ViewSetIFace.Type type, String name, String title, String fileName, File dirPath) {
        this.type = type;
        this.name = name;
        this.title = title;
        this.fileName = fileName;
        this.dirPath = dirPath;
        this.isDiskBased = true;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public boolean isDiskBased() {
        return this.isDiskBased;
    }

    public void setDiskBased(boolean isDiskBased) {
        this.isDiskBased = isDiskBased;
    }

    public static ViewSetIFace.Type parseType(String typeStr) {
        if (typeStr.equalsIgnoreCase("user")) {
            return ViewSetIFace.Type.User;
        }
        return ViewSetIFace.Type.System;
    }

    @Override
    public void cleanUp() {
        if (this.views != null) {
            this.views.clear();
        }
        if (this.views != null) {
            this.viewDefs.clear();
        }
        this.hasLoadedViews = false;
    }

    public void loadViews() {
        if ((ALWAYS_LOAD || !this.hasLoadedViews) && this.dirPath != null && this.fileName != null) {
            try {
                this.loadViewFile(new FileInputStream(new File(this.dirPath + File.separator + this.fileName)));
            }
            catch (FileNotFoundException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ViewSet.class, ex);
                log.error((Object)ex);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ViewSet.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
        if (this.transientViews != null) {
            for (String viewName : this.transientViews.keySet()) {
                this.views.put(viewName, this.transientViews.get(viewName));
            }
        }
        if (this.transientViewDefs != null) {
            for (String viewName : this.transientViewDefs.keySet()) {
                this.viewDefs.put(viewName, this.transientViewDefs.get(viewName));
            }
        }
    }

    @Override
    public ViewIFace getView(String nameStr) {
        this.loadViews();
        return this.views.get(nameStr);
    }

    @Override
    public Hashtable<String, ViewIFace> getViews() {
        this.loadViews();
        return this.views;
    }

    @Override
    public Hashtable<String, ViewDefIFace> getViewDefs() {
        return this.viewDefs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ViewSetIFace.Type getType() {
        return this.type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getI18NResourceName() {
        return this.i18NResourceName;
    }

    public void setI18NResourceName(String resourceName) {
        this.i18NResourceName = resourceName;
    }

    @Override
    public boolean isSystem() {
        return this.type == ViewSetIFace.Type.System;
    }

    public void addTransientView(ViewIFace view) {
        if (this.transientViews == null) {
            this.transientViews = new Hashtable();
        } else if (this.transientViews.get(view.getName()) != null) {
            throw new RuntimeException("Transient View Name [" + view.getName() + "] is already being used!");
        }
        this.transientViews.put(view.getName(), view);
        this.views.put(view.getName(), view);
    }

    public void addTransientViewDef(ViewDefIFace viewDef) {
        if (this.transientViewDefs == null) {
            this.transientViewDefs = new Hashtable();
        } else if (this.transientViews.get(viewDef.getName()) != null) {
            String msg = "Transient View Name [" + viewDef.getName() + "] is already being used!";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
            return;
        }
        this.transientViewDefs.put(viewDef.getName(), viewDef);
        this.viewDefs.put(viewDef.getName(), viewDef);
    }

    public void removeTransientView(ViewIFace view) {
        if (this.transientViews != null) {
            this.transientViews.remove(view.getName());
            this.views.remove(view.getName());
            view.cleanUp();
        }
    }

    public void removeTransientViewDef(ViewDefIFace viewDef) {
        if (this.transientViewDefs != null) {
            this.transientViewDefs.remove(viewDef.getName());
            this.viewDefs.remove(viewDef.getName());
            viewDef.cleanUp();
        }
    }

    protected void loadDOM(Element rootDOM, boolean doSetName, boolean doMapDefinitions) throws Exception {
        if (rootDOM != null) {
            this.viewDefs.clear();
            this.views.clear();
            Hashtable<AltViewIFace, String> altViewsViewDefName = new Hashtable<AltViewIFace, String>();
            this.i18NResourceName = XMLHelper.getAttr(rootDOM, "i18nresname", null);
            String viewsName = ViewLoader.getViews(rootDOM, this.views, altViewsViewDefName);
            if (viewsName != null) {
                block15: {
                    if (doSetName) {
                        this.name = viewsName;
                    } else if (!viewsName.equals(this.name)) {
                        String msg = "The name in the registry doesn't match the name in the file![" + this.name + "][" + viewsName + "]";
                        log.error((Object)msg);
                        FormDevHelper.appendFormDevError(msg);
                        return;
                    }
                    boolean hasResBundleName = StringUtils.isNotEmpty((String)this.i18NResourceName);
                    if (hasResBundleName) {
                        UIRegistry.loadAndPushResourceBundle(this.i18NResourceName);
                    }
                    try {
                        try {
                            ViewLoader.getViewDefs(rootDOM, this.viewDefs, this.views, doMapDefinitions);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(ViewSet.class, ex);
                            if (hasResBundleName) {
                                UIRegistry.popResourceBundle();
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (hasResBundleName) {
                            UIRegistry.popResourceBundle();
                        }
                        throw throwable;
                    }
                    if (hasResBundleName) {
                        UIRegistry.popResourceBundle();
                    }
                }
                this.verifyViewsAndViewDefs(altViewsViewDefName);
            }
        } else {
            String msg = "The root element for the document was null!";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
            this.hasLoadedViews = false;
            return;
        }
        this.hasLoadedViews = true;
    }

    protected void verifyViewsAndViewDefs(Hashtable<AltViewIFace, String> altViewsViewDefName) {
        for (ViewIFace view : this.views.values()) {
            for (AltViewIFace av : view.getAltViews()) {
                String viewDefName = altViewsViewDefName.get(av);
                if (av.getViewDef() != null) continue;
                if (StringUtils.isNotEmpty((String)viewDefName)) {
                    ViewDefIFace referredToViewDef = this.viewDefs.get(viewDefName);
                    if (referredToViewDef != null) {
                        av.setViewDef(referredToViewDef);
                        continue;
                    }
                    String msg = "ViewSet[" + this.name + "] View[" + view + "] AltView [" + av.getName() + "] refers to a non-existent ViewDef with name[" + av.getViewDefName() + "]";
                    log.error((Object)msg);
                    FormDevHelper.appendFormDevError(msg);
                    continue;
                }
                String msg = "ViewSet[" + this.name + "] Couldn't find the ViewDef Name for the AltView!";
                log.error((Object)msg);
                FormDevHelper.appendFormDevError(msg);
            }
        }
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("<viewset name=\"" + this.name + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        sb.append("  <views>\n");
        Vector<ViewIFace> viewsList = new Vector<ViewIFace>(this.views.values());
        Collections.sort(viewsList);
        for (ViewIFace view : viewsList) {
            view.toXML(sb);
        }
        sb.append("  </views>\n");
        sb.append("  <viewdefs>\n");
        Vector<ViewDefIFace> viewDefsList = new Vector<ViewDefIFace>(this.viewDefs.values());
        Collections.sort(viewDefsList);
        for (ViewDefIFace viewDef : viewDefsList) {
            viewDef.toXML(sb);
        }
        sb.append("  </viewdefs>\n");
        sb.append("</viewset>\n");
    }

    protected void loadViewFile(FileInputStream fileInputStream) throws Exception {
        this.isDiskBased = true;
        this.loadDOM(XMLHelper.readFileToDOM4J(fileInputStream), false, true);
    }

    @Override
    public int compareTo(ViewSetIFace obj) {
        return this.name.compareTo(obj.getName());
    }
}

