/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.persist.AltView;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCell;
import edu.ku.brc.af.ui.forms.persist.FormCellCommand;
import edu.ku.brc.af.ui.forms.persist.FormCellField;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellLabel;
import edu.ku.brc.af.ui.forms.persist.FormCellLabelIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellPanel;
import edu.ku.brc.af.ui.forms.persist.FormCellSeparator;
import edu.ku.brc.af.ui.forms.persist.FormCellSubView;
import edu.ku.brc.af.ui.forms.persist.FormColumn;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.FormRow;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.FormViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.TableViewDef;
import edu.ku.brc.af.ui.forms.persist.TableViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.View;
import edu.ku.brc.af.ui.forms.persist.ViewDef;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSet;
import edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class ViewLoader {
    public static final int DEFAULT_ROWS = 4;
    public static final int DEFAULT_COLS = 10;
    public static final int DEFAULT_SUBVIEW_ROWS = 5;
    private static final Logger log = Logger.getLogger(ViewLoader.class);
    private static final ViewLoader instance = new ViewLoader();
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String LABEL = "label";
    private static final String DESC = "desc";
    private static final String TITLE = "title";
    private static final String CLASSNAME = "class";
    private static final String GETTABLE = "gettable";
    private static final String SETTABLE = "settable";
    private static final String INITIALIZE = "initialize";
    private static final String DSPUITYPE = "dspuitype";
    private static final String VALIDATION = "validation";
    private static final String ISREQUIRED = "isrequired";
    private static final String RESOURCELABELS = "useresourcelabels";
    protected boolean doingResourceLabels = false;
    protected String viewSetName = null;
    protected static boolean doFieldVerification = true;
    protected static boolean isTreeClass = false;
    protected static DBTableInfo fldVerTableInfo = null;
    protected static FormViewDef fldVerFormViewDef = null;
    protected static String colDefType = null;
    protected static CustomFrame verifyDlg = null;
    protected FieldVerifyTableModel fldVerTableModel = null;

    static {
        doFieldVerification = AppPreferences.getLocalPrefs().getBoolean("verify_field_names", false);
    }

    protected ViewLoader() {
    }

    protected static ViewIFace createView(Element element, Hashtable<AltViewIFace, String> altViewsViewDefName) throws Exception {
        Element altviews;
        String name = element.attributeValue(NAME);
        String objTitle = XMLHelper.getAttr(element, "objtitle", null);
        String className = element.attributeValue(CLASSNAME);
        String desc = ViewLoader.getDesc(element);
        String businessRules = XMLHelper.getAttr(element, "busrules", null);
        boolean isInternal = XMLHelper.getAttr(element, "isinternal", true);
        DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(className);
        if (ti != null && StringUtils.isEmpty((String)objTitle)) {
            objTitle = ti.getTitle();
        }
        View view = new View(ViewLoader.instance.viewSetName, name, objTitle, className, businessRules != null ? businessRules.trim() : null, XMLHelper.getAttr(element, "usedefbusrule", true), isInternal, desc);
        if (ti != null) {
            view.setTitle(ti.getTitle());
        }
        if ((altviews = (Element)element.selectSingleNode("altviews")) != null) {
            AltView defaultAltView = null;
            AltViewIFace.CreationMode defaultMode = AltView.parseMode(XMLHelper.getAttr(altviews, "mode", ""), AltViewIFace.CreationMode.VIEW);
            String selectorName = altviews.attributeValue("selector");
            view.setDefaultMode(defaultMode);
            view.setSelectorName(selectorName);
            Hashtable<String, Boolean> nameCheckHash = new Hashtable<String, Boolean>();
            Iterator i = altviews.elementIterator("altview");
            while (i.hasNext()) {
                Boolean nameExists;
                Element altElement = (Element)i.next();
                AltViewIFace.CreationMode mode = AltView.parseMode(XMLHelper.getAttr(altElement, "mode", ""), AltViewIFace.CreationMode.VIEW);
                String altName = altElement.attributeValue(NAME);
                String viewDefName = altElement.attributeValue("viewdef");
                String title = altElement.attributeValue(TITLE);
                boolean isValidated = XMLHelper.getAttr(altElement, "validated", mode == AltViewIFace.CreationMode.EDIT);
                boolean isDefault = XMLHelper.getAttr(altElement, "default", false);
                if (defaultAltView != null && isDefault) {
                    isDefault = false;
                }
                if ((nameExists = (Boolean)nameCheckHash.get(altName)) == null) {
                    AltView altView = new AltView(view, altName, title, mode, isValidated, isDefault, null);
                    altViewsViewDefName.put(altView, viewDefName);
                    if (StringUtils.isNotEmpty((String)selectorName)) {
                        altView.setSelectorName(selectorName);
                        String selectorValue = altElement.attributeValue("selector_value");
                        if (StringUtils.isNotEmpty((String)selectorValue)) {
                            altView.setSelectorValue(selectorValue);
                        } else {
                            FormDevHelper.appendFormDevError("Selector Value is missing for viewDefName[" + viewDefName + "] altName[" + altName + "]");
                        }
                    }
                    if (defaultAltView == null && isDefault) {
                        defaultAltView = altView;
                    }
                    view.addAltView(altView);
                    nameCheckHash.put(altName, true);
                } else {
                    log.error((Object)("The altView name[" + altName + "] already exists!"));
                }
                nameCheckHash.clear();
            }
            if (defaultAltView == null && view.getAltViews() != null && view.getAltViews().size() > 0) {
                view.getAltViews().get(0).setDefault(true);
            }
        }
        return view;
    }

    private static ViewDef createViewDef(Element element) throws Exception {
        String name = element.attributeValue(NAME);
        String className = element.attributeValue(CLASSNAME);
        String gettableClassName = element.attributeValue(GETTABLE);
        String settableClassName = element.attributeValue(SETTABLE);
        String desc = ViewLoader.getDesc(element);
        String resLabels = XMLHelper.getAttr(element, RESOURCELABELS, "false");
        boolean useResourceLabels = resLabels.equals("true");
        if (StringUtils.isEmpty((String)name)) {
            FormDevHelper.appendFormDevError("Name is null for element[" + element.asXML() + "]");
            return null;
        }
        if (StringUtils.isEmpty((String)className)) {
            FormDevHelper.appendFormDevError("className is null. name[" + name + "] for element[" + element.asXML() + "]");
            return null;
        }
        if (StringUtils.isEmpty((String)gettableClassName)) {
            FormDevHelper.appendFormDevError("gettableClassName Name is null.name[" + name + "] classname[" + className + "]");
            return null;
        }
        DBTableInfo tableinfo = DBTableIdMgr.getInstance().getByClassName(className);
        ViewDefIFace.ViewType type = null;
        try {
            type = ViewDefIFace.ViewType.valueOf(element.attributeValue(TYPE));
        }
        catch (Exception ex) {
            String msg = "view[" + name + "] has illegal type[" + element.attributeValue(TYPE) + "]";
            log.error((Object)msg, (Throwable)ex);
            FormDevHelper.appendFormDevError(msg, ex);
            return null;
        }
        ViewDef viewDef = null;
        switch (type) {
            case form: 
            case formtable: 
            case rstable: {
                viewDef = ViewLoader.createFormViewDef(element, type, name, className, gettableClassName, settableClassName, desc, useResourceLabels, tableinfo);
                break;
            }
            case table: {
                break;
            }
            case field: {
                break;
            }
            case iconview: {
                viewDef = ViewLoader.createIconViewDef(type, name, className, gettableClassName, settableClassName, desc, useResourceLabels);
            }
        }
        return viewDef;
    }

    protected static String getDesc(Element element) {
        String desc = null;
        Element descElement = (Element)element.selectSingleNode(DESC);
        if (descElement != null) {
            desc = descElement.getTextTrim();
        }
        return desc;
    }

    public static String getViews(Element doc, Hashtable<String, ViewIFace> views, Hashtable<AltViewIFace, String> altViewsViewDefName) throws Exception {
        ViewLoader.instance.viewSetName = doc.attributeValue(NAME);
        Element viewsElement = (Element)doc.selectSingleNode("views");
        if (viewsElement != null) {
            Iterator i = viewsElement.elementIterator("view");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                ViewIFace view = ViewLoader.createView(element, altViewsViewDefName);
                if (view == null) continue;
                if (views.get(view.getName()) == null) {
                    views.put(view.getName(), view);
                    continue;
                }
                String msg = "View Set [" + ViewLoader.instance.viewSetName + "] [" + view.getName() + "] is not unique.";
                log.error((Object)msg);
                FormDevHelper.appendFormDevError(msg);
            }
        }
        return ViewLoader.instance.viewSetName;
    }

    public static String getViewDefs(Element doc, Hashtable<String, ViewDefIFace> viewDefs, Hashtable<String, ViewIFace> views, boolean doMapDefinitions) throws Exception {
        colDefType = AppPreferences.getLocalPrefs().get("ui.formatting.formtype", UIHelper.getOSTypeAsStr());
        ViewLoader.instance.viewSetName = doc.attributeValue(NAME);
        Element viewDefsElement = (Element)doc.selectSingleNode("viewdefs");
        if (viewDefsElement != null) {
            Iterator i = viewDefsElement.elementIterator("viewdef");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                ViewDef viewDef = ViewLoader.createViewDef(element);
                if (viewDef == null) continue;
                if (viewDefs.get(viewDef.getName()) == null) {
                    viewDefs.put(viewDef.getName(), viewDef);
                    continue;
                }
                String msg = "View Set [" + ViewLoader.instance.viewSetName + "] the View Def Name [" + viewDef.getName() + "] is not unique.";
                log.error((Object)msg);
                FormDevHelper.appendFormDevError(msg);
            }
            if (doMapDefinitions) {
                ViewLoader.mapDefinitionViewDefs(viewDefs);
            }
        }
        return ViewLoader.instance.viewSetName;
    }

    public static void mapDefinitionViewDefs(Hashtable<String, ViewDefIFace> viewDefs) throws Exception {
        for (ViewDefIFace viewDef : new Vector<ViewDefIFace>(viewDefs.values())) {
            String viewDefName;
            if (viewDef.getType() != ViewDefIFace.ViewType.formtable || (viewDefName = ((FormViewDefIFace)viewDef).getDefinitionName()) == null) continue;
            ViewDefIFace actualDef = viewDefs.get(viewDefName);
            if (actualDef != null) {
                viewDefs.remove(viewDef.getName());
                actualDef = (ViewDef)actualDef.clone();
                actualDef.setType(ViewDefIFace.ViewType.formtable);
                actualDef.setName(viewDef.getName());
                viewDefs.put(actualDef.getName(), actualDef);
                continue;
            }
            String msg = "Couldn't find the ViewDef for formtable definition name[" + ((FormViewDefIFace)viewDef).getDefinitionName() + "]";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
        }
    }

    public static Hashtable<String, String> getEnableRules(Element element) {
        Hashtable<String, String> rulesList = new Hashtable<String, String>();
        if (element != null) {
            Element enableRules = (Element)element.selectSingleNode("enableRules");
            if (enableRules != null) {
                Iterator i = enableRules.elementIterator("rule");
                while (i.hasNext()) {
                    Element ruleElement = (Element)i.next();
                    String id = XMLHelper.getAttr(ruleElement, ID, "");
                    if (StringUtils.isNotEmpty((String)id)) {
                        rulesList.put(id, ruleElement.getTextTrim());
                        continue;
                    }
                    String msg = "The name is missing for rule[" + ruleElement.getTextTrim() + "] is missing.";
                    log.error((Object)msg);
                    FormDevHelper.appendFormDevError(msg);
                }
            }
        } else {
            log.error((Object)("View Set [" + ViewLoader.instance.viewSetName + "] element [" + element + "] is null."));
        }
        return rulesList;
    }

    protected static String createDef(Element element, String attrName, int numRows, FormViewDef.JGDefItem item) {
        Element cellDef = null;
        if (attrName.equals("columnDef")) {
            List list = element.selectNodes(attrName);
            if (list.size() == 1) {
                cellDef = (Element)list.get(0);
            } else {
                String osTypeStr = UIHelper.getOSTypeAsStr();
                Element defCD = null;
                Element defOSCD = null;
                Element ovrOSCD = null;
                for (Object obj : list) {
                    Element ce = (Element)obj;
                    String osType = XMLHelper.getAttr(ce, "os", null);
                    if (osType == null) {
                        defCD = ce;
                        continue;
                    }
                    if (osType.equals(osTypeStr)) {
                        defOSCD = ce;
                    }
                    if (colDefType == null || !osType.equals(colDefType)) continue;
                    ovrOSCD = ce;
                }
                cellDef = ovrOSCD != null ? ovrOSCD : (defOSCD != null ? defOSCD : (defCD != null ? defCD : (Element)list.get(0)));
            }
        } else {
            cellDef = (Element)element.selectSingleNode(attrName);
        }
        if (cellDef != null) {
            String cellText = cellDef.getText();
            String cellStr = XMLHelper.getAttr(cellDef, "cell", null);
            String sepStr = XMLHelper.getAttr(cellDef, "sep", null);
            item.setDefStr(cellText);
            item.setCellDefStr(cellStr);
            item.setSepDefStr(sepStr);
            if (StringUtils.isNotEmpty((String)cellStr) && StringUtils.isNotEmpty((String)sepStr)) {
                boolean auto = XMLHelper.getAttr(cellDef, "auto", false);
                item.setAuto(auto);
                if (auto) {
                    String autoStr = String.valueOf(UIHelper.createDuplicateJGoodiesDef(cellStr, sepStr, numRows)) + (StringUtils.isNotEmpty((String)cellText) ? "," + cellText : "");
                    item.setDefStr(autoStr);
                    return autoStr;
                }
                FormDevHelper.appendFormDevError("Element [" + element.getName() + "] Cell or Sep is null for 'dup' or 'auto 'on column def.");
                return "";
            }
            item.setAuto(false);
            return cellText;
        }
        String msg = "Element [" + element.getName() + "] must have a columnDef";
        log.error((Object)msg);
        FormDevHelper.appendFormDevError(msg);
        return "";
    }

    protected static String getResourceLabel(String label) {
        if (StringUtils.isNotEmpty((String)label) && StringUtils.deleteWhitespace((String)label).length() > 0) {
            return ViewLoader.instance.doingResourceLabels ? UIRegistry.getResourceString(label) : label;
        }
        return "";
    }

    protected static String getLabel(Element cellElement) {
        String lbl = XMLHelper.getAttr(cellElement, LABEL, null);
        if (lbl == null || lbl.equals("##")) {
            return "##";
        }
        return ViewLoader.getResourceLabel(lbl);
    }

    protected static void processRows(Element element, List<FormRowIFace> cellRows, DBTableInfo tableinfo) {
        Element rowsElement = (Element)element.selectSingleNode("rows");
        if (rowsElement != null) {
            byte rowNumber = 0;
            Iterator i = rowsElement.elementIterator("row");
            while (i.hasNext()) {
                Element rowElement = (Element)i.next();
                FormRow formRow = new FormRow();
                formRow.setRowNumber(rowNumber);
                Iterator cellIter = rowElement.elementIterator("cell");
                block28: while (cellIter.hasNext()) {
                    Element cellElement = (Element)cellIter.next();
                    String cellId = XMLHelper.getAttr(cellElement, ID, "");
                    String cellName = XMLHelper.getAttr(cellElement, NAME, cellId);
                    int colspan = XMLHelper.getAttr(cellElement, "colspan", 1);
                    int rowspan = XMLHelper.getAttr(cellElement, "rowspan", 1);
                    FormCellIFace.CellType cellType = null;
                    FormCellIFace cell = null;
                    try {
                        cellType = FormCellIFace.CellType.valueOf(cellElement.attributeValue(TYPE));
                    }
                    catch (IllegalArgumentException ex) {
                        FormDevHelper.appendFormDevError(ex.toString());
                        FormDevHelper.appendFormDevError(String.format("Cell Name[%s] Id[%s] Type[%s]", cellName, cellId, cellElement.attributeValue(TYPE)));
                        return;
                    }
                    if (doFieldVerification && fldVerTableInfo != null && cellType == FormCellIFace.CellType.field && StringUtils.isNotEmpty((String)cellId) && !cellName.equals("this")) {
                        ViewLoader.processFieldVerify(cellName, cellId, rowNumber);
                    }
                    switch (cellType) {
                        case label: {
                            cell = formRow.addCell(new FormCellLabel(cellId, cellName, ViewLoader.getLabel(cellElement), XMLHelper.getAttr(cellElement, "labelfor", ""), XMLHelper.getAttr(cellElement, "icon", null), XMLHelper.getAttr(cellElement, "recordobj", false), colspan));
                            String initialize = XMLHelper.getAttr(cellElement, INITIALIZE, null);
                            if (!StringUtils.isNotEmpty((String)initialize)) break;
                            cell.setProperties(UIHelper.parseProperties(initialize));
                            break;
                        }
                        case separator: {
                            cell = formRow.addCell(new FormCellSeparator(cellId, cellName, ViewLoader.getLabel(cellElement), XMLHelper.getAttr(cellElement, "collapse", ""), colspan));
                            String initialize = XMLHelper.getAttr(cellElement, INITIALIZE, null);
                            if (!StringUtils.isNotEmpty((String)initialize)) break;
                            cell.setProperties(UIHelper.parseProperties(initialize));
                            break;
                        }
                        case field: {
                            String str;
                            Element valNode;
                            String uitypeStr = XMLHelper.getAttr(cellElement, "uitype", "");
                            String format = XMLHelper.getAttr(cellElement, "format", "");
                            String formatName = XMLHelper.getAttr(cellElement, "formatname", "");
                            String uiFieldFormatterName = XMLHelper.getAttr(cellElement, "uifieldformatter", "");
                            int cols = XMLHelper.getAttr(cellElement, "cols", 10);
                            int rows = XMLHelper.getAttr(cellElement, "rows", 4);
                            String validationType = XMLHelper.getAttr(cellElement, "valtype", "Changed");
                            String validationRule = XMLHelper.getAttr(cellElement, VALIDATION, "");
                            String initialize = XMLHelper.getAttr(cellElement, INITIALIZE, "");
                            boolean isRequired = XMLHelper.getAttr(cellElement, ISREQUIRED, false);
                            String pickListName = XMLHelper.getAttr(cellElement, "picklist", "");
                            if (StringUtils.isNotEmpty((String)format) && StringUtils.isNotEmpty((String)formatName)) {
                                String msg = "Both format and formatname cannot both be set! [" + cellName + "] ignoring format";
                                log.error((Object)msg);
                                FormDevHelper.appendFormDevError(msg);
                                format = "";
                            }
                            Properties properties = UIHelper.parseProperties(initialize);
                            if (StringUtils.isEmpty((String)uitypeStr)) {
                                uitypeStr = "text";
                            }
                            FormCellFieldIFace.FieldType uitype = null;
                            try {
                                uitype = FormCellFieldIFace.FieldType.valueOf(uitypeStr);
                            }
                            catch (IllegalArgumentException ex) {
                                FormDevHelper.appendFormDevError(ex.toString());
                                FormDevHelper.appendFormDevError(String.format("Cell Name[%s] Id[%s] uitype[%s] is in error", cellName, cellId, uitypeStr));
                                uitype = FormCellFieldIFace.FieldType.text;
                            }
                            String dspUITypeStr = null;
                            switch (uitype) {
                                case textarea: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "dsptextarea");
                                    break;
                                }
                                case textareabrief: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "textareabrief");
                                    break;
                                }
                                case querycbx: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "textfieldinfo");
                                    String fmtName = TypeSearchForQueryFactory.getInstance().getDataObjFormatterName(properties.getProperty(NAME));
                                    if (!StringUtils.isEmpty((String)formatName) || !StringUtils.isNotEmpty((String)fmtName)) break;
                                    formatName = fmtName;
                                    break;
                                }
                                case formattedtext: {
                                    DBFieldInfo fieldInfo;
                                    validationRule = XMLHelper.getAttr(cellElement, VALIDATION, "formatted");
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "formattedtext");
                                    if (StringUtils.isNotEmpty((String)uiFieldFormatterName)) {
                                        UIFieldFormatterIFace uiFormatter = UIFieldFormatterMgr.getInstance().getFormatter(uiFieldFormatterName);
                                        if (uiFormatter != null) break;
                                        String msg = "Couldn't find formatter[" + uiFieldFormatterName + "]";
                                        log.error((Object)msg);
                                        FormDevHelper.appendFormDevError(msg);
                                        uiFieldFormatterName = "";
                                        uitype = FormCellFieldIFace.FieldType.text;
                                        break;
                                    }
                                    if (tableinfo == null || (fieldInfo = tableinfo.getFieldByName(cellName)) == null) break;
                                    if (fieldInfo.getFormatter() != null) {
                                        uiFieldFormatterName = fieldInfo.getFormatter().getName();
                                        break;
                                    }
                                    if (fieldInfo.getDataClass().isAssignableFrom(Date.class) || fieldInfo.getDataClass().isAssignableFrom(Calendar.class)) {
                                        String msg = "Missing Date Formatter for [" + cellName + "]";
                                        log.error((Object)msg);
                                        FormDevHelper.appendFormDevError(msg);
                                        uiFieldFormatterName = "Date";
                                        UIFieldFormatterIFace uiFormatter = UIFieldFormatterMgr.getInstance().getFormatter(uiFieldFormatterName);
                                        if (uiFormatter != null) break;
                                        uiFieldFormatterName = "";
                                        uitype = FormCellFieldIFace.FieldType.text;
                                        break;
                                    }
                                    uiFieldFormatterName = "";
                                    uitype = FormCellFieldIFace.FieldType.text;
                                    break;
                                }
                                case url: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, uitypeStr);
                                    properties = UIHelper.parseProperties(initialize);
                                    break;
                                }
                                case image: 
                                case checkbox: 
                                case tristate: 
                                case password: 
                                case list: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, uitypeStr);
                                    break;
                                }
                                case button: 
                                case plugin: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, uitypeStr);
                                    properties = UIHelper.parseProperties(initialize);
                                    String ttl = properties.getProperty(TITLE);
                                    if (ttl == null) break;
                                    properties.put(TITLE, ViewLoader.getResourceLabel(ttl));
                                    break;
                                }
                                case spinner: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "dsptextfield");
                                    properties = UIHelper.parseProperties(initialize);
                                    break;
                                }
                                case combobox: {
                                    DBFieldInfo fieldInfo;
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "textpl");
                                    if (tableinfo == null || (fieldInfo = tableinfo.getFieldByName(cellName)) == null) break;
                                    if (StringUtils.isNotEmpty((String)pickListName)) {
                                        fieldInfo.setPickListName(pickListName);
                                        break;
                                    }
                                    pickListName = fieldInfo.getPickListName();
                                    break;
                                }
                                default: {
                                    dspUITypeStr = XMLHelper.getAttr(cellElement, DSPUITYPE, "dsptextfield");
                                }
                            }
                            FormCellFieldIFace.FieldType dspUIType = FormCellFieldIFace.FieldType.valueOf(dspUITypeStr);
                            try {
                                dspUIType = FormCellFieldIFace.FieldType.valueOf(dspUITypeStr);
                            }
                            catch (IllegalArgumentException ex) {
                                FormDevHelper.appendFormDevError(ex.toString());
                                FormDevHelper.appendFormDevError(String.format("Cell Name[%s] Id[%s] dspuitype[%s] is in error", new Object[]{cellName, cellId, dspUIType}));
                                uitype = FormCellFieldIFace.FieldType.label;
                            }
                            if (StringUtils.isEmpty((String)validationRule) && (valNode = (Element)cellElement.selectSingleNode(VALIDATION)) != null && StringUtils.isNotEmpty((String)(str = valNode.getTextTrim()))) {
                                validationRule = str;
                            }
                            boolean isEncrypted = XMLHelper.getAttr(cellElement, "isencrypted", false);
                            boolean isReadOnly = uitype == FormCellFieldIFace.FieldType.dsptextfield || uitype == FormCellFieldIFace.FieldType.dsptextarea || uitype == FormCellFieldIFace.FieldType.label;
                            FormCellField field = new FormCellField(FormCellIFace.CellType.field, cellId, cellName, uitype, dspUIType, format, formatName, uiFieldFormatterName, isRequired, cols, rows, colspan, rowspan, validationType, validationRule, isEncrypted);
                            String labelStr = uitype == FormCellFieldIFace.FieldType.checkbox ? ViewLoader.getLabel(cellElement) : XMLHelper.getAttr(cellElement, LABEL, "");
                            field.setLabel(labelStr);
                            field.setReadOnly(XMLHelper.getAttr(cellElement, "readonly", isReadOnly));
                            field.setDefaultValue(XMLHelper.getAttr(cellElement, "default", ""));
                            field.setPickListName(pickListName);
                            field.setChangeListenerOnly(XMLHelper.getAttr(cellElement, "changesonly", true) && !isRequired);
                            field.setProperties(properties);
                            cell = formRow.addCell(field);
                            break;
                        }
                        case command: {
                            cell = formRow.addCell(new FormCellCommand(cellId, cellName, ViewLoader.getLabel(cellElement), XMLHelper.getAttr(cellElement, "commandtype", ""), XMLHelper.getAttr(cellElement, "action", "")));
                            String initialize = XMLHelper.getAttr(cellElement, INITIALIZE, null);
                            if (!StringUtils.isNotEmpty((String)initialize)) break;
                            cell.setProperties(UIHelper.parseProperties(initialize));
                            break;
                        }
                        case panel: {
                            FormCellPanel cellPanel = new FormCellPanel(cellId, cellName, XMLHelper.getAttr(cellElement, "paneltype", ""), XMLHelper.getAttr(cellElement, "coldef", "p"), XMLHelper.getAttr(cellElement, "rowdef", "p"), colspan, rowspan);
                            String initialize = XMLHelper.getAttr(cellElement, INITIALIZE, null);
                            if (StringUtils.isNotEmpty((String)initialize)) {
                                cellPanel.setProperties(UIHelper.parseProperties(initialize));
                            }
                            ViewLoader.processRows(cellElement, cellPanel.getRows(), tableinfo);
                            ViewLoader.fixLabels(cellPanel.getName(), cellPanel.getRows(), tableinfo);
                            cell = formRow.addCell(cellPanel);
                            break;
                        }
                        case subview: {
                            String title;
                            Properties properties = UIHelper.parseProperties(XMLHelper.getAttr(cellElement, INITIALIZE, null));
                            String svViewSetName = cellElement.attributeValue("viewsetname");
                            if (StringUtils.isEmpty((String)svViewSetName)) {
                                svViewSetName = null;
                            }
                            if (ViewLoader.instance.doingResourceLabels && properties != null && (title = properties.getProperty(TITLE)) != null) {
                                properties.setProperty(TITLE, UIRegistry.getResourceString(title));
                            }
                            String viewName = XMLHelper.getAttr(cellElement, "viewname", null);
                            cell = formRow.addCell(new FormCellSubView(cellId, cellName, svViewSetName, viewName, cellElement.attributeValue(CLASSNAME), XMLHelper.getAttr(cellElement, DESC, ""), XMLHelper.getAttr(cellElement, "defaulttype", null), XMLHelper.getAttr(cellElement, "rows", 5), colspan, rowspan, XMLHelper.getAttr(cellElement, "single", false)));
                            cell.setProperties(properties);
                            break;
                        }
                        case iconview: {
                            String vsName = cellElement.attributeValue("viewsetname");
                            if (StringUtils.isEmpty((String)vsName)) {
                                vsName = ViewLoader.instance.viewSetName;
                            }
                            String viewName = XMLHelper.getAttr(cellElement, "viewname", null);
                            cell = formRow.addCell(new FormCellSubView(cellId, cellName, vsName, viewName, cellElement.attributeValue(CLASSNAME), XMLHelper.getAttr(cellElement, DESC, ""), colspan, rowspan));
                            break;
                        }
                        case statusbar: {
                            cell = formRow.addCell(new FormCell(FormCellIFace.CellType.statusbar, cellId, cellName, colspan, rowspan));
                            break;
                        }
                        default: {
                            log.error((Object)"Encountered unknown cell type");
                            continue block28;
                        }
                    }
                    cell.setIgnoreSetGet(XMLHelper.getAttr(cellElement, "ignore", false));
                }
                cellRows.add(formRow);
                rowNumber = (byte)(rowNumber + 1);
            }
        }
    }

    private static void processFieldVerify(String cellName, String cellId, int rowNumber) {
        try {
            boolean isOK = false;
            if (StringUtils.contains((String)cellName, (char)'.')) {
                DBTableInfo tblInfo = fldVerTableInfo;
                String[] fieldNames = StringUtils.split((String)cellName, (String)".");
                int i = 0;
                while (i < fieldNames.length - 1) {
                    DBRelationshipInfo relInfo;
                    String type = null;
                    DBTableChildIFace child = tblInfo.getItemByName(fieldNames[i]);
                    if (child instanceof DBFieldInfo) {
                        DBFieldInfo fldInfo = (DBFieldInfo)child;
                        type = fldInfo.getType();
                        if (type != null) {
                            DBTableInfo tInfo = DBTableIdMgr.getInstance().getByClassName(type);
                            tblInfo = tInfo != null ? tInfo : tblInfo;
                        }
                        isOK = tblInfo.getItemByName(fieldNames[fieldNames.length - 1]) != null;
                    } else if (child instanceof DBRelationshipInfo && (type = (relInfo = (DBRelationshipInfo)child).getDataClass().getName()) != null) {
                        tblInfo = DBTableIdMgr.getInstance().getByClassName(type);
                    }
                    ++i;
                }
                if (tblInfo != null) {
                    isOK = tblInfo.getItemByName(fieldNames[fieldNames.length - 1]) != null;
                }
            } else {
                boolean bl = isOK = fldVerTableInfo.getItemByName(cellName) != null;
            }
            if (!isOK) {
                String msg = " ViewSet[" + ViewLoader.instance.viewSetName + "]\n ViewDef[" + fldVerFormViewDef.getName() + "]\n The cell name [" + cellName + "] for cell with Id [" + cellId + "] is not a field\n in Data Object[" + fldVerTableInfo.getName() + "]\n on Row [" + rowNumber + "]";
                if (!isTreeClass) {
                    ViewLoader.instance.fldVerTableModel.addRow(ViewLoader.instance.viewSetName, fldVerFormViewDef.getName(), cellId, cellName, Integer.toString(rowNumber));
                }
                log.error((Object)msg);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    protected static FormViewDef createFormViewDef(Element element, ViewDefIFace.ViewType type, String name, String className, String gettableClassName, String settableClassName, String desc, boolean useResourceLabels, DBTableInfo tableinfo) {
        FormViewDef formViewDef = new FormViewDef(type, name, className, gettableClassName, settableClassName, desc, useResourceLabels);
        fldVerTableInfo = null;
        if (type != ViewDefIFace.ViewType.formtable) {
            if (doFieldVerification) {
                if (ViewLoader.instance.fldVerTableModel == null) {
                    instance.createFieldVerTableModel();
                }
                try {
                    log.debug((Object)className);
                    Class<?> classObj = Class.forName(className);
                    if (FormDataObjIFace.class.isAssignableFrom(classObj)) {
                        fldVerTableInfo = DBTableIdMgr.getInstance().getByClassName(className);
                        isTreeClass = fldVerTableInfo != null && fldVerTableInfo.getFieldByName("highestChildNodeNumber") != null;
                        fldVerFormViewDef = formViewDef;
                    }
                }
                catch (ClassNotFoundException ex) {
                    String msg = "ClassNotFoundException[" + className + "]  Name[" + name + "]";
                    log.error((Object)msg);
                    FormDevHelper.appendFormDevError(msg);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ViewLoader.class, ex);
                }
            }
        } else {
            String defName;
            Node defNode = element.selectSingleNode("definition");
            if (defNode != null && StringUtils.isNotEmpty((String)(defName = defNode.getText()))) {
                formViewDef.setDefinitionName(defName);
                return formViewDef;
            }
            String msg = "formtable is missing or has empty <defintion> node";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
            return null;
        }
        Vector<FormRowIFace> rows = formViewDef.getRows();
        ViewLoader.instance.doingResourceLabels = useResourceLabels;
        ViewLoader.processRows(element, rows, tableinfo);
        ViewLoader.instance.doingResourceLabels = false;
        ViewLoader.createDef(element, "columnDef", rows.size(), formViewDef.getColumnDefItem());
        ViewLoader.createDef(element, "rowDef", rows.size(), formViewDef.getRowDefItem());
        formViewDef.setEnableRules(ViewLoader.getEnableRules(element));
        ViewLoader.fixLabels(formViewDef.getName(), rows, tableinfo);
        return formViewDef;
    }

    protected static String getTitleFromFieldName(String fieldName, DBTableInfo tableInfo) {
        DBTableChildIFace tblChild;
        DBTableChildIFace derivedCI = null;
        if (fieldName.indexOf(".") > -1 && (derivedCI = FormHelper.getChildInfoFromPath(fieldName, tableInfo)) == null) {
            String msg = "The name 'path' [" + fieldName + "] was not valid in ViewSet [" + ViewLoader.instance.viewSetName + "]";
            FormDevHelper.appendFormDevError(msg);
            log.error((Object)msg);
            return "";
        }
        DBTableChildIFace dBTableChildIFace = tblChild = derivedCI != null ? derivedCI : tableInfo.getItemByName(fieldName);
        if (tblChild == null) {
            String msg = "The Field Name [" + fieldName + "] was not in the Table [" + tableInfo.getTitle() + "] in ViewSet [" + ViewLoader.instance.viewSetName + "]";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
            return "";
        }
        return tblChild.getTitle();
    }

    protected static void fixLabels(String name, List<FormRowIFace> rows, DBTableInfo tableInfo) {
        if (tableInfo == null) {
            return;
        }
        Hashtable<String, String> fldIdMap = new Hashtable<String, String>();
        for (FormRowIFace row : rows) {
            for (FormCellIFace cell : row.getCells()) {
                if (cell.getType() != FormCellIFace.CellType.field && cell.getType() != FormCellIFace.CellType.subview) continue;
                fldIdMap.put(cell.getIdent(), cell.getName());
            }
        }
        for (FormRowIFace row : rows) {
            for (FormCellIFace cell : row.getCells()) {
                FormCellFieldIFace fcf;
                if (cell.getType() == FormCellIFace.CellType.label) {
                    String idFor;
                    FormCellLabelIFace lblCell = (FormCellLabelIFace)cell;
                    String label = lblCell.getLabel();
                    if (label.length() != 0 && !label.equals("##") || !StringUtils.isNotEmpty((String)(idFor = lblCell.getLabelFor()))) continue;
                    String fieldName = (String)fldIdMap.get(idFor);
                    if (StringUtils.isNotEmpty((String)fieldName)) {
                        if (fieldName.equals("this")) continue;
                        lblCell.setLabel(ViewLoader.getTitleFromFieldName(fieldName, tableInfo));
                        continue;
                    }
                    String msg = "Setting Label - Form control with id[" + idFor + "] is not in ViewDef or Panel [" + name + "] in ViewSet [" + ViewLoader.instance.viewSetName + "]";
                    log.error((Object)msg);
                    FormDevHelper.appendFormDevError(msg);
                    continue;
                }
                if (cell.getType() != FormCellIFace.CellType.field || !(cell instanceof FormCellFieldIFace) || ((FormCellFieldIFace)cell).getUiType() != FormCellFieldIFace.FieldType.checkbox && ((FormCellFieldIFace)cell).getUiType() != FormCellFieldIFace.FieldType.tristate || !(fcf = (FormCellFieldIFace)cell).getLabel().equals("##")) continue;
                fcf.setLabel(ViewLoader.getTitleFromFieldName(cell.getName(), tableInfo));
            }
        }
    }

    protected static ViewDef createIconViewDef(ViewDefIFace.ViewType type, String name, String className, String gettableClassName, String settableClassName, String desc, boolean useResourceLabels) {
        ViewDef formView = new ViewDef(type, name, className, gettableClassName, settableClassName, desc, useResourceLabels);
        return formView;
    }

    protected static TableViewDefIFace createTableView(Element element, String name, String className, String gettableClassName, String settableClassName, String desc, boolean useResourceLabels) {
        TableViewDef tableView = new TableViewDef(name, className, gettableClassName, settableClassName, desc, useResourceLabels);
        Element columns = (Element)element.selectSingleNode("columns");
        if (columns != null) {
            Iterator i = columns.elementIterator("column");
            while (i.hasNext()) {
                Element colElement = (Element)i.next();
                FormColumn column = new FormColumn(colElement.attributeValue(NAME), colElement.attributeValue(LABEL), XMLHelper.getAttr(colElement, "dataobjformatter", null), XMLHelper.getAttr(colElement, "format", null));
                tableView.addColumn(column);
            }
        }
        return tableView;
    }

    public static void save(ViewSet viewSet, String filename) {
        try {
            Vector<ViewSet> viewsets = new Vector<ViewSet>();
            viewsets.add(viewSet);
            File file = new File(filename);
            FileWriter fw = new FileWriter(file);
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            BeanWriter beanWriter = new BeanWriter((Writer)fw);
            XMLIntrospector introspector = beanWriter.getXMLIntrospector();
            introspector.getConfiguration().setWrapCollectionsInElement(false);
            beanWriter.getBindingConfiguration().setMapIDs(false);
            beanWriter.setWriteEmptyElements(false);
            beanWriter.enablePrettyPrint();
            beanWriter.write((Object)viewSet);
            fw.close();
        }
        catch (Exception ex) {
            log.error((Object)"error writing views", (Throwable)ex);
        }
    }

    public void createFieldVerTableModel() {
        this.fldVerTableModel = new FieldVerifyTableModel();
    }

    public static boolean isDoFieldVerification() {
        return doFieldVerification;
    }

    public static void setDoFieldVerification(boolean doFieldVerification) {
        ViewLoader.doFieldVerification = doFieldVerification;
    }

    public static void clearFieldVerInfo() {
        if (ViewLoader.instance.fldVerTableModel != null) {
            ViewLoader.instance.fldVerTableModel.clear();
        }
    }

    public static void displayFieldVerInfo() {
        if (verifyDlg != null) {
            verifyDlg.setVisible(false);
            verifyDlg.dispose();
            verifyDlg = null;
        }
        System.err.println("------------- " + (ViewLoader.instance.fldVerTableModel != null ? Integer.valueOf(ViewLoader.instance.fldVerTableModel.getRowCount()) : "null"));
        if (ViewLoader.instance.fldVerTableModel != null && ViewLoader.instance.fldVerTableModel.getRowCount() > 0) {
            JLabel lbl = UIHelper.createLabel("<html><i>(Some of fields are special buttons or labal names. Review them to make sure you have not <br>mis-named any of the fields you are working with.)");
            final JTable table = new JTable(ViewLoader.instance.fldVerTableModel);
            UIHelper.calcColumnWidths(table);
            CellConstraints cc = new CellConstraints();
            JScrollPane sp = new JScrollPane(table, 20, 30);
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,4px,p"));
            pb.add((Component)sp, cc.xy(1, 1));
            pb.add((Component)lbl, cc.xy(1, 3));
            pb.setDefaultDialogBorder();
            verifyDlg = new CustomFrame("Field Names on Form, but not in Database : " + ViewLoader.instance.fldVerTableModel.getRowCount(), 1, pb.getPanel()){

                @Override
                protected void okButtonPressed() {
                    super.okButtonPressed();
                    table.setModel(new DefaultTableModel());
                    this.dispose();
                    verifyDlg = null;
                }
            };
            verifyDlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
            verifyDlg.createUI();
            verifyDlg.setVisible(true);
        }
    }

    class FieldVerifyTableModel
    extends DefaultTableModel {
        protected Vector<List<String>> rowData = new Vector();
        protected String[] colNames = new String[]{"ViewSet", "View Def", "Cell Id", "Cell Name", "Row"};
        protected Hashtable<String, Boolean> nameHash = new Hashtable();

        public void clear() {
            for (List<String> list : this.rowData) {
                list.clear();
            }
            this.rowData.clear();
            this.nameHash.clear();
        }

        public void addRow(String viewSet, String viewDef, String cellId, String cellName, String rowInx) {
            String key = String.valueOf(viewSet) + viewDef + cellId;
            if (this.nameHash.get(key) == null) {
                ArrayList<String> row = new ArrayList<String>(5);
                row.add(viewSet);
                row.add(viewDef);
                row.add(cellId);
                row.add(cellName);
                row.add(rowInx);
                this.rowData.add(row);
                this.nameHash.put(key, true);
            }
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.colNames[column];
        }

        @Override
        public int getRowCount() {
            return this.rowData == null ? 0 : this.rowData.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            List<String> rowList = this.rowData.get(row);
            return rowList.get(column);
        }
    }
}

