/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewDef
implements Cloneable,
ViewDefIFace {
    private static final Logger log = Logger.getLogger(ViewDef.class);
    protected ViewDefIFace.ViewType type;
    protected String name;
    protected String desc;
    protected String className;
    protected String dataGettableName;
    protected String dataSettableName;
    protected boolean isAbsoluteLayout = false;
    protected DataObjectGettable dataGettable = null;
    protected DataObjectSettable dataSettable = null;
    protected boolean useResourceLabels;
    protected String resourceLabels = null;
    protected int xCoord = -1;
    protected int yCoord = -1;
    protected int width = -1;
    protected int height = -1;

    public ViewDef() {
    }

    public ViewDef(ViewDefIFace.ViewType type, String name, String className, String dataGettableName, String dataSettableName, String desc, boolean useResourceLabels) {
        this.type = type;
        this.name = name;
        this.className = className;
        this.dataGettableName = dataGettableName;
        this.dataSettableName = dataSettableName;
        this.desc = desc;
        this.useResourceLabels = useResourceLabels;
        this.resourceLabels = useResourceLabels ? "true" : "false";
        try {
            if (StringUtils.isNotEmpty((String)dataGettableName)) {
                this.dataGettable = DataObjectGettableFactory.get(className, dataGettableName);
            } else {
                log.error((Object)("dataGettableName or is null for " + name));
            }
            if (StringUtils.isNotEmpty((String)dataSettableName)) {
                this.dataSettable = DataObjectSettableFactory.get(className, dataSettableName);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ViewDef.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
    }

    public ViewDef(ViewDef viewDef) {
        this(viewDef.type, viewDef.name, viewDef.className, viewDef.dataGettableName, viewDef.dataSettableName, viewDef.desc, viewDef.useResourceLabels);
        this.dataGettable = viewDef.dataGettable;
        this.dataSettable = viewDef.dataSettable;
    }

    @Override
    public Class<?> getDerivedInterface() {
        return ViewDefIFace.class;
    }

    @Override
    public void cleanUp() {
        this.dataGettable = null;
        this.dataSettable = null;
    }

    @Override
    public ViewDefIFace.ViewType getType() {
        return this.type;
    }

    @Override
    public void setType(ViewDefIFace.ViewType type) {
        this.type = type;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getDataGettableName() {
        return this.dataGettableName;
    }

    @Override
    public void setDataGettableName(String dataGettableName) {
        this.dataGettableName = dataGettableName;
    }

    @Override
    public DataObjectGettable getDataGettable() {
        return this.dataGettable;
    }

    @Override
    public String getDataSettableName() {
        return this.dataSettableName;
    }

    @Override
    public void setDataSettableName(String dataSettableName) {
        this.dataSettableName = dataSettableName;
    }

    @Override
    public DataObjectSettable getDataSettable() {
        return this.dataSettable;
    }

    @Override
    public boolean isUseResourceLabels() {
        return this.useResourceLabels;
    }

    @Override
    public String getResourceLabels() {
        return this.resourceLabels;
    }

    @Override
    public Boolean isAbsoluteLayout() {
        return this.isAbsoluteLayout;
    }

    public void setAbsoluteLayout(boolean isAbsoluteLayout) {
        this.isAbsoluteLayout = isAbsoluteLayout;
    }

    @Override
    public int getXCoord() {
        return this.xCoord;
    }

    @Override
    public void setXCoord(int coord) {
        this.xCoord = coord;
    }

    @Override
    public int getYCoord() {
        return this.yCoord;
    }

    @Override
    public void setYCoord(int coord) {
        this.yCoord = coord;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    protected void toXMLAttrs(StringBuilder sb) {
    }

    protected void toXMLNodes(StringBuilder sb) {
    }

    @Override
    public void toXML(StringBuilder sb) {
        String indent = "\n        ";
        sb.append("    <viewdef");
        XMLHelper.xmlAttr(sb, "type", this.type.toString());
        sb.append(indent);
        XMLHelper.xmlAttr(sb, "name", this.name);
        sb.append(indent);
        XMLHelper.xmlAttr(sb, "class", this.className);
        sb.append(indent);
        XMLHelper.xmlAttr(sb, "resourcelabels", this.useResourceLabels);
        sb.append(indent);
        XMLHelper.xmlAttr(sb, "gettable", this.dataGettableName);
        sb.append(indent);
        XMLHelper.xmlAttr(sb, "settable", this.dataSettableName);
        if (this.xCoord > -1) {
            sb.append(indent);
            XMLHelper.xmlAttr(sb, "x", this.xCoord);
        }
        if (this.yCoord > -1) {
            sb.append(indent);
            XMLHelper.xmlAttr(sb, "y", this.yCoord);
        }
        if (this.width > -1) {
            sb.append(indent);
            XMLHelper.xmlAttr(sb, "width", this.width);
        }
        if (this.height > -1) {
            sb.append(indent);
            XMLHelper.xmlAttr(sb, "height", this.height);
        }
        this.toXMLAttrs(sb);
        sb.append(">\n    ");
        XMLHelper.xmlNode(sb, "desc", this.desc, true);
        this.toXMLNodes(sb);
        sb.append("    </viewdef>\n\n");
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ViewDefIFace obj) {
        return this.name.compareTo(obj.getName());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ViewDef viewDef = (ViewDef)super.clone();
        viewDef.type = this.type;
        viewDef.name = this.name;
        viewDef.className = this.className;
        viewDef.dataGettableName = this.dataGettableName;
        viewDef.dataSettableName = this.dataSettableName;
        viewDef.desc = this.desc;
        viewDef.dataGettable = this.dataGettable;
        viewDef.dataSettable = this.dataSettable;
        viewDef.useResourceLabels = this.useResourceLabels;
        viewDef.resourceLabels = this.resourceLabels;
        return viewDef;
    }

    protected String createEnableRulesXML(Hashtable<String, String> enableRules) {
        if (enableRules.keySet().size() > 0) {
            StringBuilder sb = new StringBuilder("<enableRules>");
            for (String key : enableRules.keySet()) {
                sb.append("<rule id=\"");
                sb.append(key);
                sb.append("\"><![CDATA[");
                sb.append(enableRules.get(key));
                sb.append("]]></rule>");
            }
            sb.append("</enableRules>");
            return sb.toString();
        }
        return null;
    }
}

