/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class View
implements ViewIFace {
    protected String viewSetName;
    protected String name;
    protected String desc;
    protected String objTitle;
    protected String className;
    protected String businessRulesClassName;
    protected List<AltViewIFace> altViews = new Vector<AltViewIFace>();
    protected AltViewIFace.CreationMode defaultMode = AltViewIFace.CreationMode.VIEW;
    protected String selectorName = null;
    protected boolean useDefaultBusRules = false;
    protected boolean isInternal = false;
    protected String title = null;
    protected Boolean isSpecial = null;

    public View(String viewSetName, String name, String objTitle, String className, String businessRulesClassName, boolean useDefaultBusRules, boolean isInternal, String desc) {
        this.viewSetName = viewSetName;
        this.name = name;
        this.objTitle = objTitle;
        this.className = className;
        this.businessRulesClassName = businessRulesClassName;
        this.desc = desc;
        this.useDefaultBusRules = useDefaultBusRules;
        this.isInternal = isInternal;
    }

    @Override
    public AltViewIFace addAltView(AltViewIFace altView) {
        this.altViews.add(altView);
        return altView;
    }

    @Override
    public AltViewIFace getDefaultAltView(AltViewIFace.CreationMode creationMode, String altViewType) {
        if (creationMode != null && StringUtils.isNotEmpty((String)altViewType)) {
            AltViewIFace defAltView = null;
            boolean isForm = altViewType.equals("form");
            ArrayList<AltViewIFace> list = new ArrayList<AltViewIFace>();
            for (AltViewIFace altView : this.altViews) {
                if (altView.getViewDef() != null) {
                    ViewDefIFace.ViewType type = altView.getViewDef().getType();
                    if (type != null) {
                        if ((isForm && type == ViewDefIFace.ViewType.form || !isForm && type != ViewDefIFace.ViewType.form) && altView.getMode() == creationMode) {
                            list.add(altView);
                        }
                        if (!altView.isDefault()) continue;
                        defAltView = altView;
                        continue;
                    }
                    FormDevHelper.appendFormDevError(String.format("ViewDef's (%s) Type is null for AltView %s", altView.getViewDef().getName(), altView.getName()));
                    continue;
                }
                FormDevHelper.appendFormDevError(String.format("ViewDef is null for AltView %s", altView.getName()));
            }
            if (list.size() > 0) {
                if (defAltView != null && list.contains(defAltView)) {
                    return defAltView;
                }
                return (AltViewIFace)list.get(0);
            }
            if (defAltView != null) {
                return defAltView;
            }
        } else {
            for (AltViewIFace altView : this.altViews) {
                if (!altView.isDefault()) continue;
                return altView;
            }
        }
        FormDevHelper.appendFormDevError("No default Alt View in View[" + this.name + "]");
        return null;
    }

    @Override
    public AltViewIFace getDefaultAltView() {
        return this.getDefaultAltView(null, null);
    }

    @Override
    public AltViewIFace getDefaultAltViewWithMode(AltViewIFace.CreationMode creationMode, String defAltViewType) {
        AltViewIFace defAltView = this.getDefaultAltView(creationMode, defAltViewType);
        if (defAltView.getMode() == creationMode || this.altViews.size() == 1) {
            return defAltView;
        }
        StringBuilder sb = new StringBuilder();
        for (AltViewIFace av : this.altViews) {
            if (av.getViewDefName() != null) {
                if (defAltView.getViewDefName() != null) {
                    if (av.isDefault() || !av.getViewDefName().equals(defAltView.getViewDefName())) continue;
                    return av;
                }
                sb.append(String.format("The defAltView's ViewDefName is NULL for Alt View '%s' for creationMode: '%s'\n", defAltView.getName(), creationMode.toString()));
                continue;
            }
            sb.append(String.format("The ViewDefName is NULL for Alt View '%s' for creationMode: '%s'\n", av.getName(), creationMode.toString()));
        }
        if (sb.length() > 0) {
            UIRegistry.showError(sb.toString());
        }
        return defAltView;
    }

    @Override
    public AltViewIFace getAltView(String nameStr) {
        if (nameStr == null) {
            return this.getDefaultAltView();
        }
        for (AltViewIFace altView : this.altViews) {
            if (!altView.getName().equals(nameStr)) continue;
            return altView;
        }
        return null;
    }

    @Override
    public boolean isSpecialViewAndEdit() {
        if (this.isSpecial == null) {
            if (this.altViews.size() == 2) {
                AltViewIFace av0 = this.altViews.get(0);
                AltViewIFace av1 = this.altViews.get(1);
                this.isSpecial = av0.getViewDefName().equals(av1.getViewDefName());
            } else {
                this.isSpecial = false;
            }
        }
        return this.isSpecial;
    }

    @Override
    public BusinessRulesIFace createBusinessRule() {
        BusinessRulesIFace businessRule = null;
        if (StringUtils.isNotEmpty((String)this.businessRulesClassName)) {
            try {
                businessRule = (BusinessRulesIFace)Class.forName(this.businessRulesClassName).newInstance();
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(View.class, e);
                InternalError error = new InternalError("Can't instantiate BusinessRulesIFace [" + this.businessRulesClassName + "]");
                error.initCause(e);
                throw error;
            }
        } else if (this.useDefaultBusRules) {
            businessRule = DBTableIdMgr.getInstance().getBusinessRule(this.className);
        }
        return businessRule;
    }

    @Override
    public boolean useDefaultBusinessRules() {
        return this.useDefaultBusRules;
    }

    @Override
    public String getBusinessRulesClassName() {
        return this.businessRulesClassName;
    }

    @Override
    public void setBusinessRulesClassName(String businessRulesClassName) {
        this.businessRulesClassName = businessRulesClassName;
    }

    @Override
    public void cleanUp() {
        this.altViews.clear();
    }

    @Override
    public int compareTo(ViewIFace obj) {
        return this.name.compareTo(obj.getName());
    }

    @Override
    public List<AltViewIFace> getAltViews() {
        return this.altViews;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getObjTitle() {
        return StringUtils.isNotEmpty((String)this.objTitle) ? this.objTitle : this.name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getViewSetName() {
        return this.viewSetName;
    }

    @Override
    public AltViewIFace.CreationMode getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public String getSelectorName() {
        return this.selectorName;
    }

    @Override
    public void setDefaultMode(AltViewIFace.CreationMode defaultMode) {
        this.defaultMode = defaultMode;
    }

    @Override
    public void setSelectorName(String selectorName) {
        this.selectorName = selectorName;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("    <view ");
        XMLHelper.xmlAttr(sb, "name", this.name);
        XMLHelper.xmlAttr(sb, "class", this.className);
        XMLHelper.xmlAttr(sb, "busrule", this.businessRulesClassName);
        XMLHelper.xmlAttr(sb, "usedefbusrule", this.useDefaultBusRules);
        if (!this.isInternal) {
            XMLHelper.xmlAttr(sb, "isinternal", this.isInternal);
        }
        sb.append(">\n    ");
        XMLHelper.xmlNode(sb, "desc", this.desc, true);
        sb.append("      <altviews");
        XMLHelper.xmlAttr(sb, "defaultmode", this.defaultMode.toString().toLowerCase());
        XMLHelper.xmlAttr(sb, "selector", this.selectorName);
        sb.append(">\n");
        for (AltViewIFace av : this.altViews) {
            av.toXML(sb);
        }
        sb.append("      </altviews>\n");
        sb.append("    </view>\n");
    }
}

