/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FormDevHelper {
    private static Boolean isFormDevMode = null;
    private static CustomDialog frame = null;
    private static JTextArea msgArea;
    private static StringBuilder buffer;

    static {
        buffer = new StringBuilder();
    }

    public static JDialog getLogFrame() {
        if (frame == null) {
            msgArea = UIHelper.createTextArea(10, 60);
            msgArea.setLineWrap(true);
            msgArea.setWrapStyleWord(true);
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)UIHelper.createScrollPane(msgArea, true), "Center");
            frame = new CustomDialog((Frame)UIRegistry.getTopWindow(), "Form Development Errors", false, 3, (Component)p){

                @Override
                protected void cancelButtonPressed() {
                    buffer.setLength(0);
                    msgArea.setText("");
                }
            };
            frame.setOkLabel("Close");
            frame.setCancelLabel("Clear");
            frame.setSize(800, 600);
            frame.setDefaultCloseOperation(0);
        }
        return frame;
    }

    public static void clearErrors() {
        buffer.setLength(0);
    }

    public static boolean isFormDevMode() {
        if (isFormDevMode == null) {
            isFormDevMode = AppPreferences.getLocalPrefs().getBoolean("form.devmode", false);
        }
        return isFormDevMode;
    }

    public static void setIsFormDevMode(Boolean isFormDevMode) {
        FormDevHelper.isFormDevMode = isFormDevMode;
        AppPreferences.getLocalPrefs().putBoolean("form.devmode", isFormDevMode);
    }

    public static void appendFormDevError(String msg, Throwable throwable) {
        FormDevHelper.appendFormDevError(String.valueOf(msg) + " Exception " + throwable.getMessage());
    }

    public static void appendFormDevError(Throwable throwable) {
        FormDevHelper.appendFormDevError(" Exception " + throwable.getMessage());
    }

    public static void showFormDevError(String msg) {
        FormDevHelper.appendFormDevError(msg);
        UIRegistry.showError(msg);
    }

    public static void showFormDevError(Throwable throwable) {
        FormDevHelper.showFormDevError(throwable);
    }

    public static void appendFormDevError(String msg) {
        if (isFormDevMode != null) {
            if (isFormDevMode.booleanValue()) {
                if (msgArea != null) {
                    boolean showFirstTime = frame == null;
                    FormDevHelper.getLogFrame();
                    buffer.append(msg);
                    buffer.append("\n");
                    if (buffer.length() > 4096) {
                        int overage = buffer.length() - 4096;
                        int inx = buffer.indexOf("\n", overage);
                        buffer.replace(0, inx, "");
                    }
                    msgArea.setText(buffer.toString());
                    msgArea.setCaretPosition(msgArea.getDocument().getLength());
                    if (showFirstTime) {
                        frame.setSize(800, 600);
                        UIHelper.centerAndShow(frame);
                    } else {
                        frame.setVisible(false);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                frame.setVisible(true);
                            }
                        });
                    }
                } else {
                    System.err.println(msg);
                }
            } else {
                System.err.println(msg);
            }
        }
    }

    public static void appendLocalizedFormDevError(String key, Object ... args) {
        FormDevHelper.appendFormDevError(String.format(UIRegistry.getResourceString(key), args));
    }
}

