/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCell;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.DateWrapper;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public final class FormCellField
extends FormCell
implements FormCellFieldIFace {
    protected static DateWrapper scrDateFormat = null;
    protected FormCellFieldIFace.FieldType uiType;
    protected FormCellFieldIFace.FieldType dspUIType;
    protected String format;
    protected String formatName;
    protected String uiFieldFormatterName;
    protected boolean isRequired = false;
    protected boolean isReadOnly = false;
    protected boolean isEncrypted = false;
    protected boolean isPassword = false;
    protected boolean useThisData = false;
    protected String label = null;
    protected String defaultValue = null;
    protected Boolean defaultDateToday = null;
    protected String pickListName = null;
    protected int cols = 10;
    protected int rows = 1;
    protected String validationType = "";
    protected String validationRule = "";
    protected boolean isTextField = false;
    protected boolean isDSPTextField = false;
    protected boolean isEditOnCreate = false;
    protected boolean isDerived = false;

    public FormCellField(FormCellIFace.CellType type, String id, String name, int colspan, int rowspan) {
        super(type, id, name, colspan, rowspan);
        this.useThisData = name.equals("this");
    }

    public FormCellField(FormCellIFace.CellType type, String id, String name, FormCellFieldIFace.FieldType uiType, FormCellFieldIFace.FieldType dspUIType, String format, String formatName, String uiFieldFormatterName, boolean isRequired, int cols, int rows, int colspan, int rowspan, String validationType, String validationRule, boolean isEncrypted) {
        this(type, id, name, colspan, rowspan);
        this.format = format;
        this.formatName = formatName;
        this.uiFieldFormatterName = uiFieldFormatterName;
        this.cols = cols;
        this.rows = rows;
        this.validationRule = validationRule;
        this.validationType = validationType;
        this.isRequired = isRequired;
        this.isEncrypted = isEncrypted;
        this.setUiType(uiType);
        this.setDspUIType(dspUIType);
    }

    @Override
    public int getTxtCols() {
        return this.cols;
    }

    @Override
    public void setTxtCols(int cols) {
        this.cols = cols;
    }

    @Override
    public boolean isPassword() {
        return this.isPassword;
    }

    public void setPassword(boolean isPassword) {
        this.isPassword = isPassword;
    }

    @Override
    public FormCellFieldIFace.FieldType getDspUIType() {
        return this.dspUIType;
    }

    @Override
    public void setDspUIType(FormCellFieldIFace.FieldType dspUIType) {
        this.dspUIType = dspUIType;
        this.isDSPTextField = dspUIType == FormCellFieldIFace.FieldType.dsptextfield || dspUIType == FormCellFieldIFace.FieldType.dsptextarea;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    @Override
    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    @Override
    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean useThisData() {
        return this.useThisData;
    }

    @Override
    public String getDefaultValue() {
        if (this.defaultDateToday == null) {
            this.defaultDateToday = this.uiFieldFormatterName.equals("Date") && this.defaultValue.equals("today");
        }
        if (this.defaultDateToday.booleanValue()) {
            Date date = new Date();
            if (scrDateFormat == null) {
                scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
            }
            return scrDateFormat.format(date);
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public boolean isTextFieldForMode(AltViewIFace.CreationMode mode) {
        return mode == AltViewIFace.CreationMode.VIEW ? this.isDSPTextField : this.isTextField;
    }

    @Override
    public boolean isTextField() {
        return this.isTextField;
    }

    public void setTextField(boolean isTextField) {
        this.isTextField = isTextField;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getPickListName() {
        return this.pickListName;
    }

    @Override
    public void setPickListName(String pickListName) {
        this.pickListName = pickListName;
    }

    @Override
    public int getTxtRows() {
        return this.rows;
    }

    @Override
    public void setTxtRows(int rows) {
        this.rows = rows;
    }

    @Override
    public String getUIFieldFormatterName() {
        return this.uiFieldFormatterName;
    }

    @Override
    public void setUIFieldFormatterName(String uiFieldFormatterName) {
        this.uiFieldFormatterName = uiFieldFormatterName;
    }

    @Override
    public FormCellFieldIFace.FieldType getUiType() {
        return this.uiType;
    }

    @Override
    public void setUiType(FormCellFieldIFace.FieldType uiType) {
        this.uiType = uiType;
        this.isTextField = uiType == FormCellFieldIFace.FieldType.text || uiType == FormCellFieldIFace.FieldType.formattedtext || uiType == FormCellFieldIFace.FieldType.textarea || uiType == FormCellFieldIFace.FieldType.textareabrief;
    }

    @Override
    public String getValidationRule() {
        return this.validationRule;
    }

    @Override
    public void setValidationRule(String validationRule) {
        this.validationRule = validationRule;
    }

    @Override
    public String getValidationType() {
        return this.validationType;
    }

    @Override
    public void setValidationType(String validationType) {
        this.validationType = validationType;
    }

    @Override
    public boolean isEditOnCreate() {
        return this.isEditOnCreate;
    }

    public void setEditOnCreate(boolean isEditOnCreate) {
        this.isEditOnCreate = isEditOnCreate;
    }

    @Override
    public boolean isDerived() {
        return this.isDerived;
    }

    public void setDerived(boolean isDerived) {
        this.isDerived = isDerived;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FormCellField fcf = (FormCellField)super.clone();
        fcf.uiType = this.uiType;
        fcf.dspUIType = this.dspUIType;
        fcf.format = this.format;
        fcf.formatName = this.formatName;
        fcf.uiFieldFormatterName = this.uiFieldFormatterName;
        fcf.isRequired = this.isRequired;
        fcf.isReadOnly = this.isReadOnly;
        fcf.isEncrypted = this.isEncrypted;
        fcf.label = this.label;
        fcf.defaultValue = this.defaultValue;
        fcf.defaultDateToday = this.defaultDateToday;
        fcf.pickListName = this.pickListName;
        fcf.cols = this.cols;
        fcf.rows = this.rows;
        fcf.validationType = this.validationType;
        fcf.validationRule = this.validationRule;
        fcf.isTextField = this.isTextField;
        fcf.isDSPTextField = this.isDSPTextField;
        return fcf;
    }

    @Override
    public String toString() {
        return String.valueOf(StringUtils.isNotEmpty((String)this.name) ? this.name : this.id) + " (" + (Object)((Object)this.uiType) + ")";
    }

    @Override
    public void toXMLAttrs(StringBuilder sb) {
        XMLHelper.xmlAttr(sb, "uitype", this.uiType.toString());
        XMLHelper.xmlAttr(sb, "dsptype", this.dspUIType.toString());
        switch (this.uiType) {
            case text: {
                if (this.cols != 10) {
                    XMLHelper.xmlAttr(sb, "cols", this.cols);
                }
                if (this.isEncrypted) {
                    XMLHelper.xmlAttr(sb, "isencrypted", this.isEncrypted);
                }
                if (!this.isPassword) break;
                XMLHelper.xmlAttr(sb, "ispassword", this.isPassword);
                break;
            }
            case textarea: 
            case textareabrief: {
                if (this.rows != 4) {
                    XMLHelper.xmlAttr(sb, "rows", this.rows);
                }
                if (this.cols == 10) break;
                XMLHelper.xmlAttr(sb, "cols", this.cols);
                break;
            }
            case combobox: {
                XMLHelper.xmlAttr(sb, "picklist", this.pickListName);
                break;
            }
        }
        XMLHelper.xmlAttr(sb, "format", this.format);
        XMLHelper.xmlAttr(sb, "formatname", this.formatName);
        XMLHelper.xmlAttr(sb, "uifieldformatter", this.uiFieldFormatterName);
        if (this.isRequired) {
            XMLHelper.xmlAttr(sb, "isrequired", this.isRequired);
        }
        if (StringUtils.isNotEmpty((String)this.validationType) && !this.validationType.equals("Changed")) {
            XMLHelper.xmlAttr(sb, "valtype", this.validationType);
        }
        if (this.isReadOnly) {
            XMLHelper.xmlAttr(sb, "readonly", this.isReadOnly);
        }
        XMLHelper.xmlAttr(sb, "validation", this.validationRule);
    }
}

