/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.persist;

import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.helpers.XMLHelper;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class FormCell
implements Comparable<FormCellIFace>,
Cloneable,
FormCellIFace {
    protected FormCellIFace.CellType type;
    protected String id;
    protected String name;
    protected boolean ignoreSetGet = false;
    protected boolean changeListenerOnly = false;
    protected boolean isMultiField = false;
    protected String[] fieldNames = null;
    protected int colspan = 1;
    protected int rowspan = 1;
    protected int xCoord = -1;
    protected int yCoord = -1;
    protected int width = -1;
    protected int height = -1;
    protected Properties properties = null;

    public FormCell() {
    }

    public FormCell(FormCellIFace.CellType type, String id, String name) {
        this.type = type;
        this.id = id;
        this.name = name;
        boolean bl = this.isMultiField = name.indexOf(44) > -1;
        if (StringUtils.isNotBlank((String)name)) {
            this.fieldNames = StringUtils.split((String)StringUtils.deleteWhitespace((String)name), (String)",");
        }
    }

    public FormCell(FormCellIFace.CellType type, String id, String name, int colspan, int rowspan) {
        this(type, id, name);
        this.colspan = colspan;
        this.rowspan = rowspan;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdent() {
        return this.id;
    }

    @Override
    public int getRowspan() {
        return this.rowspan;
    }

    @Override
    public FormCellIFace.CellType getType() {
        return this.type;
    }

    @Override
    public boolean isIgnoreSetGet() {
        return this.ignoreSetGet;
    }

    @Override
    public boolean isChangeListenerOnly() {
        return this.changeListenerOnly;
    }

    @Override
    public boolean isMultiField() {
        return this.isMultiField;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setChangeListenerOnly(boolean changeListenerOnly) {
        this.changeListenerOnly = changeListenerOnly;
    }

    @Override
    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    @Override
    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    @Override
    public void setIgnoreSetGet(boolean ignoreSetGet) {
        this.ignoreSetGet = ignoreSetGet;
    }

    @Override
    public void setMultiField(boolean isMultiField) {
        this.isMultiField = isMultiField;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setIdent(String id) {
        this.id = id;
    }

    @Override
    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    @Override
    public void setType(FormCellIFace.CellType type) {
        this.type = type;
    }

    @Override
    public int compareTo(FormCellIFace obj) {
        if (obj == null || obj.getIdent() == null) {
            return 0;
        }
        return this.id.compareTo(obj.getIdent());
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void addProperty(String nameStr, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(nameStr, value);
    }

    @Override
    public String getProperty(String nameStr) {
        if (this.properties != null) {
            return this.properties.getProperty(nameStr);
        }
        return null;
    }

    @Override
    public int getPropertyAsInt(String nameStr, int defVal) {
        String str;
        if (this.properties != null && StringUtils.isNotEmpty((String)(str = this.properties.getProperty(nameStr)))) {
            return Integer.parseInt(str);
        }
        return defVal;
    }

    public Integer getPropertyAsInteger(String nameStr, Integer defVal) {
        String str;
        if (this.properties != null && StringUtils.isNotEmpty((String)(str = this.properties.getProperty(nameStr)))) {
            return Integer.parseInt(str);
        }
        return defVal;
    }

    @Override
    public boolean getPropertyAsBoolean(String nameStr, boolean defVal) {
        String str;
        if (this.properties != null && StringUtils.isNotEmpty((String)(str = this.properties.getProperty(nameStr)))) {
            return str.equalsIgnoreCase("true");
        }
        return defVal;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    @Override
    public int getXCoord() {
        return this.xCoord;
    }

    @Override
    public void setXCoord(int coord) {
        this.xCoord = coord;
    }

    @Override
    public int getYCoord() {
        return this.yCoord;
    }

    @Override
    public void setYCoord(int coord) {
        this.yCoord = coord;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FormCell formCell = (FormCell)super.clone();
        formCell.type = this.type;
        formCell.id = this.id;
        formCell.name = this.name;
        formCell.isMultiField = this.isMultiField;
        formCell.ignoreSetGet = this.ignoreSetGet;
        formCell.changeListenerOnly = this.changeListenerOnly;
        formCell.fieldNames = this.fieldNames != null ? (String[])this.fieldNames.clone() : null;
        formCell.colspan = this.colspan;
        formCell.rowspan = this.colspan;
        formCell.properties = this.properties != null ? (Properties)this.properties.clone() : null;
        formCell.xCoord = this.xCoord;
        formCell.yCoord = this.yCoord;
        formCell.width = this.width;
        formCell.height = this.height;
        return formCell;
    }

    protected void toXMLAttrs(StringBuilder sb) {
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("          <cell");
        XMLHelper.xmlAttr(sb, "type", this.type.toString());
        XMLHelper.xmlAttr(sb, "id", this.id);
        XMLHelper.xmlAttr(sb, "name", this.name);
        if (this.changeListenerOnly) {
            XMLHelper.xmlAttr(sb, "changesonly", this.changeListenerOnly);
        }
        this.toXMLAttrs(sb);
        if (this.colspan > 1) {
            XMLHelper.xmlAttr(sb, "colspan", this.colspan);
        }
        if (this.rowspan > 1) {
            XMLHelper.xmlAttr(sb, "rowspan", this.rowspan);
        }
        if (this.xCoord > -1) {
            XMLHelper.xmlAttr(sb, "x", this.xCoord);
            XMLHelper.xmlAttr(sb, "y", this.yCoord);
            XMLHelper.xmlAttr(sb, "width", this.width);
            XMLHelper.xmlAttr(sb, "height", this.height);
        }
        if (this.properties != null && this.properties.size() > 0) {
            sb.append(" initialize=\"");
            XMLHelper.xmlProps(sb, this.properties);
            sb.append("\"");
        }
        sb.append("/>\n");
    }

    public String toString() {
        return String.valueOf(StringUtils.isNotEmpty((String)this.name) ? this.name : this.id) + " (" + (Object)((Object)this.type) + ")";
    }
}

