/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterParsingException;
import edu.ku.brc.ui.UIRegistry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UITextFieldFormatterFactory
extends UIFieldFormatterFactory {
    public UITextFieldFormatterFactory(DBFieldInfo fieldInfo) {
        super(fieldInfo);
    }

    @Override
    public UIFieldFormatter createFormat(String formattingString) throws UIFieldFormatterParsingException {
        UIFieldFormatterField field;
        Class<?> clazz = this.fieldInfo.getTableInfo().getClassObj();
        UIFieldFormatter fmt = new UIFieldFormatter(null, false, this.fieldInfo.getName(), UIFieldFormatterIFace.FormatterType.generic, UIFieldFormatterIFace.PartialDateEnum.None, clazz, false, false, null);
        AutoNumberIFace autoNumber = UIFieldFormatterMgr.getInstance().createAutoNumber("edu.ku.brc.af.core.db.AutoNumberGeneric", clazz.getName(), this.fieldInfo.getName(), fmt.getFields().size() == 1);
        fmt.setAutoNumber(autoNumber);
        Pattern splitPattern = Pattern.compile("([\\/\\-\\_ ])+");
        Matcher matcher = splitPattern.matcher(formattingString);
        String fieldString = "";
        int begin = 0;
        boolean isIncrementer = false;
        while (matcher.find()) {
            fieldString = formattingString.substring(begin, matcher.start());
            field = UIFieldFormatterField.factory(fieldString);
            fmt.addField(field);
            begin = matcher.end();
            if (field.isIncrementer()) {
                isIncrementer = true;
            }
            String value = matcher.group();
            field = new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, value.length(), value, false);
            fmt.addField(field);
        }
        fieldString = formattingString.substring(begin);
        field = UIFieldFormatterField.factory(fieldString);
        fmt.addField(field);
        if (field.isIncrementer()) {
            isIncrementer = true;
        }
        fmt.setIncrementer(isIncrementer);
        return fmt;
    }

    @Override
    public String getHelpHtml() {
        return UIRegistry.getResourceString("FFE_HELP_TEXT_HTML");
    }
}

