/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterParsingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UINumericFieldFormatterFactory
extends UIFieldFormatterFactory {
    public UINumericFieldFormatterFactory(DBFieldInfo fieldInfo) {
        super(fieldInfo);
    }

    @Override
    public UIFieldFormatter createFormat(String formattingString) throws UIFieldFormatterParsingException {
        Class<?> clazz = this.fieldInfo.getTableInfo().getClassObj();
        UIFieldFormatter fmt = new UIFieldFormatter(null, false, this.fieldInfo.getName(), UIFieldFormatterIFace.FormatterType.numeric, UIFieldFormatterIFace.PartialDateEnum.None, clazz, false, false, null);
        Pattern splitPattern = Pattern.compile(this.getRegEx());
        Matcher matcher = splitPattern.matcher(formattingString);
        if (!matcher.find()) {
            throw new UIFieldFormatterParsingException("Invalid formatting string: " + formattingString, formattingString);
        }
        String value = matcher.group();
        UIFieldFormatterField field = new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, value.length(), value, false);
        fmt.addField(field);
        return fmt;
    }

    protected abstract String getRegEx();
}

