/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberGeneric;
import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DefEditDeleteAddPanel;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFormatterEditorDlg;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class UIFormatterListEdtDlg
extends CustomDialog {
    protected DBFieldInfo fieldInfo = null;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected UIFieldFormatterFactory formatFactory;
    protected JList formatList;
    protected DefEditDeleteAddPanel dedaPanel;
    protected ListSelectionListener formatListSelectionListener = null;
    protected boolean hasChanged = false;
    protected boolean doProcessSamples;

    public UIFormatterListEdtDlg(Frame frame, DBFieldInfo fieldInfo, boolean doProcessSamples, UIFieldFormatterMgr uiFieldFormatterMgrCache) throws HeadlessException {
        super(frame, UIRegistry.getResourceString("FFE_DLG_TITLE"), true, 7, null);
        this.fieldInfo = fieldInfo;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.formatFactory = UIFieldFormatterMgr.getFormatFactory(fieldInfo);
        this.helpContext = "UIF_LIST_EDITOR";
        this.doProcessSamples = doProcessSamples;
    }

    @Override
    public void createUI() {
        super.createUI();
        CellConstraints cc = new CellConstraints();
        Vector<UIFieldFormatterIFace> fmtrs = new Vector<UIFieldFormatterIFace>(this.uiFieldFormatterMgrCache.getFormatterList(this.fieldInfo.getTableInfo().getClassObj(), this.fieldInfo.getName()));
        Collections.sort(fmtrs, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        PanelBuilder tblInfoPB = new PanelBuilder(new FormLayout("r:p,2px,f:p:g", "p,2px,p,2px,p,10px"));
        String typeStr = this.fieldInfo.getType();
        typeStr = typeStr.indexOf(46) > -1 ? StringUtils.substringAfterLast((String)this.fieldInfo.getType(), (String)".") : typeStr;
        JLabel tableTitleLbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("FFE_TABLE")) + ":");
        JLabel tableTitleValueLbl = UIHelper.createLabel(this.fieldInfo.getTableInfo().getTitle());
        tableTitleValueLbl.setBackground(Color.WHITE);
        tableTitleValueLbl.setOpaque(true);
        JLabel fieldTitleLbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("FFE_FIELD")) + ":");
        JLabel fieldTitleValueLbl = UIHelper.createLabel(this.fieldInfo.getTitle());
        fieldTitleValueLbl.setBackground(Color.WHITE);
        fieldTitleValueLbl.setOpaque(true);
        JLabel fieldLengthLbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("FFE_LENGTH")) + ":");
        JLabel fieldLengthValueLbl = UIHelper.createLabel(Integer.toString(this.fieldInfo.getLength()));
        fieldLengthValueLbl.setBackground(Color.WHITE);
        fieldLengthValueLbl.setOpaque(true);
        int y = 1;
        tblInfoPB.add((Component)tableTitleLbl, cc.xy(1, y));
        tblInfoPB.add((Component)tableTitleValueLbl, cc.xy(3, y));
        tblInfoPB.add((Component)fieldTitleLbl, cc.xy(1, y += 2));
        tblInfoPB.add((Component)fieldTitleValueLbl, cc.xy(3, y));
        tblInfoPB.add((Component)fieldLengthLbl, cc.xy(1, y += 2));
        tblInfoPB.add((Component)fieldLengthValueLbl, cc.xy(3, y));
        y += 2;
        DefaultListModel<UIFieldFormatterIFace> listModel = new DefaultListModel<UIFieldFormatterIFace>();
        for (UIFieldFormatterIFace format : fmtrs) {
            listModel.addElement(format);
        }
        this.formatList = UIHelper.createList(listModel);
        this.formatList.setSelectionMode(0);
        this.hookFormatListSelectionListener();
        this.hookFormatListMouseListener();
        ActionListener deleteListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterListEdtDlg.this.deleteFormatter();
            }
        };
        ActionListener editListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterListEdtDlg.this.editFormatter((UIFieldFormatter)UIFormatterListEdtDlg.this.formatList.getSelectedValue(), false);
            }
        };
        ActionListener addListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterListEdtDlg.this.addFormatter();
            }
        };
        ActionListener defListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterListEdtDlg.this.setAsDefFormatter();
            }
        };
        this.dedaPanel = new DefEditDeleteAddPanel(defListener, editListener, deleteListener, addListener, "FFE_DEF", "FFE_EDT", "FFE_DEL", "FFE_ADD");
        this.dedaPanel.getAddBtn().setEnabled(true);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:max(250px;p):g", "p,4px,p,2px,f:p:g,4px,p"));
        y = 1;
        pb.add((Component)tblInfoPB.getPanel(), cc.xy(1, y));
        pb.add((Component)UIHelper.createI18NLabel("FFE_AVAILABLE_FORMATS", 2), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createScrollPane(this.formatList), cc.xy(1, y += 2));
        pb.add((Component)this.dedaPanel, cc.xy(1, y += 2));
        y += 2;
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.okBtn.setEnabled(false);
        this.pack();
    }

    private void hookFormatListMouseListener() {
        MouseAdapter mAdp = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = UIFormatterListEdtDlg.this.formatList.locationToIndex(e.getPoint());
                    UIFormatterListEdtDlg.this.formatList.ensureIndexIsVisible(index);
                    UIFormatterListEdtDlg.this.editFormatter((UIFieldFormatter)UIFormatterListEdtDlg.this.formatList.getSelectedValue(), false);
                }
            }
        };
        this.formatList.addMouseListener(mAdp);
    }

    private void hookFormatListSelectionListener() {
        if (this.formatListSelectionListener == null) {
            this.formatListSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    UIFormatterListEdtDlg.this.updateUIEnabled();
                }
            };
        }
        this.formatList.addListSelectionListener(this.formatListSelectionListener);
    }

    protected void updateUIEnabled() {
        UIFieldFormatterIFace uif = (UIFieldFormatterIFace)this.formatList.getSelectedValue();
        boolean selected = uif != null && !uif.isSystem();
        this.dedaPanel.getDelBtn().setEnabled(selected);
        this.dedaPanel.getEditBtn().setEnabled(selected);
        this.dedaPanel.getDefBtn().setEnabled(uif != null);
        this.okBtn.setEnabled(this.formatList.getSelectedIndex() > -1);
    }

    protected void setAsDefFormatter() {
        UIFieldFormatter selected = (UIFieldFormatter)this.formatList.getSelectedValue();
        DefaultListModel model = (DefaultListModel)this.formatList.getModel();
        int i = 0;
        while (i < model.getSize()) {
            UIFieldFormatter uif;
            uif.setDefault((uif = (UIFieldFormatter)model.get(i)) == selected);
            ++i;
        }
        if (this.fieldInfo != null) {
            this.fieldInfo.setFormatter(selected);
        }
        this.setHasChanged(true);
        this.formatList.repaint();
    }

    protected void editFormatter(UIFieldFormatterIFace uif, boolean isNew) {
        try {
            UIFieldFormatterIFace tempCopy = isNew ? uif : (UIFieldFormatterIFace)uif.clone();
            boolean isDefault = tempCopy.isDefault();
            UIFormatterEditorDlg dlg = new UIFormatterEditorDlg(this, this.fieldInfo, tempCopy, isNew, this.doProcessSamples, this.uiFieldFormatterMgrCache);
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                UIFieldFormatterIFace selectedUIF = dlg.getSelectedFormat();
                selectedUIF.setDefault(isDefault);
                if (selectedUIF.isIncrementer() && selectedUIF.getAutoNumber() == null) {
                    AutoNumberIFace autoNum = UIFieldFormatterMgr.getInstance().createAutoNumber(AutoNumberGeneric.class.getName(), this.fieldInfo.getTableInfo().getClassName(), this.fieldInfo.getName(), tempCopy.getFields().size() == 1);
                    selectedUIF.setAutoNumber(autoNum);
                }
                DefaultListModel model = (DefaultListModel)this.formatList.getModel();
                if (isNew) {
                    model.addElement(selectedUIF);
                    this.uiFieldFormatterMgrCache.addFormatter(selectedUIF);
                    if (model.size() == 1) {
                        selectedUIF.setDefault(true);
                        this.formatList.setSelectedValue(selectedUIF, true);
                    }
                } else {
                    model.removeElement(uif);
                    model.addElement(selectedUIF);
                    this.uiFieldFormatterMgrCache.removeFormatter(uif);
                    this.uiFieldFormatterMgrCache.addFormatter(selectedUIF);
                }
                this.setHasChanged(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(UIFormatterListEdtDlg.class, ex);
        }
    }

    protected void deleteFormatter() {
        UIFieldFormatterIFace uif = (UIFieldFormatterIFace)this.formatList.getSelectedValue();
        if (uif != null) {
            DefaultListModel model = (DefaultListModel)this.formatList.getModel();
            model.removeElement(uif);
            this.uiFieldFormatterMgrCache.removeFormatter(uif);
            this.setHasChanged(true);
        }
    }

    protected void addFormatter() {
        UIFieldFormatter uif = new UIFieldFormatter();
        this.editFormatter(uif, true);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        if (this.hasChanged != hasChanged) {
            this.setWindowModified(hasChanged);
        }
        this.hasChanged = hasChanged;
        this.updateUIEnabled();
    }

    public UIFieldFormatterIFace getSelectedFormat() {
        return (UIFieldFormatterIFace)this.formatList.getSelectedValue();
    }

    @Override
    protected void okButtonPressed() {
        super.okButtonPressed();
    }

    class FmtListRenderer
    extends DefaultListCellRenderer {
        FmtListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            UIFieldFormatterIFace fmt = (UIFieldFormatterIFace)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setText(String.valueOf(fmt.getTitle()) + "  (" + fmt.toPattern() + ")");
            return label;
        }
    }
}

