/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.AutoNumberGeneric;
import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterInvalidatesExistingValueException;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterSampler;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class UIFormatterEditorDlg
extends CustomDialog {
    protected DBFieldInfo fieldInfo = null;
    protected UIFieldFormatterIFace selectedFormat = null;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected UIFieldFormatterFactory formatFactory;
    protected UIFieldFormatterSampler fieldFormatterSampler;
    protected JLabel sampleLabel;
    protected JTextField nameTF;
    protected JTextField titleTF;
    protected JCheckBox byYearCB;
    protected JButton deleteBtn;
    protected JTable fieldsTbl;
    protected Vector<UIFieldFormatterField> fields;
    protected FieldsTableModel fieldsModel;
    protected JButton orderDwnBtn;
    protected JButton orderUpBtn;
    protected EditDeleteAddPanel fieldsPanel;
    protected JLabel fieldTypeLbl;
    protected JComboBox fieldTypeCbx;
    protected JButton closeBtn;
    protected boolean fieldHasChanged = false;
    protected UIFieldFormatterField currentField = null;
    protected JLabel totLenLbl;
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel;
    protected JTextField fieldTxt;
    protected JSpinner sizeSpinner;
    protected JComboBox sepCbx;
    protected JCheckBox isIncChk;
    protected ListSelectionListener fieldsTblSL = null;
    protected boolean hasChanged = false;
    protected boolean isNew;
    protected String fmtErrMsg = null;
    protected Color currentTxtBGColor = null;

    public UIFormatterEditorDlg(CustomDialog parentDlg, DBFieldInfo fieldInfo, UIFieldFormatterIFace selectedFormat, boolean isNew, boolean doProcessSamples, UIFieldFormatterMgr uiFieldFormatterMgrCache) throws HeadlessException {
        super(parentDlg, UIRegistry.getResourceString("FFE_DLG_TITLE"), true, 7, null);
        this.fieldInfo = fieldInfo;
        this.selectedFormat = selectedFormat;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.isNew = isNew;
        this.fieldFormatterSampler = doProcessSamples ? new UIFieldFormatterSampler(fieldInfo) : null;
        this.formatFactory = UIFieldFormatterMgr.getFormatFactory(fieldInfo);
        this.helpContext = "UIF_EDITOR";
        this.fields = selectedFormat.getFields();
    }

    @Override
    public void createUI() {
        super.createUI();
        CellConstraints cc = new CellConstraints();
        this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "TCGD_MOVE_UP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = UIFormatterEditorDlg.this.fieldsTbl.getSelectedRow();
                UIFieldFormatterField item = UIFormatterEditorDlg.this.fields.get(inx);
                UIFormatterEditorDlg.this.fields.remove(inx);
                UIFormatterEditorDlg.this.fields.insertElementAt(item, inx - 1);
                UIFormatterEditorDlg.this.fieldsTbl.getSelectionModel().setSelectionInterval(inx - 1, inx - 1);
                UIFormatterEditorDlg.this.selectedFormat.resetLength();
                UIFormatterEditorDlg.this.updateEnabledState();
                UIFormatterEditorDlg.this.updateUIEnabled();
            }
        });
        this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "TCGD_MOVE_DOWN", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = UIFormatterEditorDlg.this.fieldsTbl.getSelectedRow();
                UIFieldFormatterField item = UIFormatterEditorDlg.this.fields.get(inx);
                UIFormatterEditorDlg.this.fields.remove(inx);
                UIFormatterEditorDlg.this.fields.insertElementAt(item, inx + 1);
                UIFormatterEditorDlg.this.fieldsTbl.getSelectionModel().setSelectionInterval(inx + 1, inx + 1);
                UIFormatterEditorDlg.this.selectedFormat.resetLength();
                UIFormatterEditorDlg.this.updateEnabledState();
                UIFormatterEditorDlg.this.updateUIEnabled();
            }
        });
        Vector<UIFieldFormatterIFace> fmtrs = new Vector<UIFieldFormatterIFace>(this.uiFieldFormatterMgrCache.getFormatterList(this.fieldInfo.getTableInfo().getClassObj(), this.fieldInfo.getName()));
        Collections.sort(fmtrs, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.toPattern().compareTo(o2.toPattern());
            }
        });
        PanelBuilder tblInfoPB = new PanelBuilder(new FormLayout("r:p,2px,f:p:g", "p,2px,p,2px,p,10px"));
        String typeStr = this.fieldInfo.getType();
        typeStr = typeStr.indexOf(46) > -1 ? StringUtils.substringAfterLast((String)this.fieldInfo.getType(), (String)".") : typeStr;
        JLabel tableTitleLbl = UIHelper.createI18NFormLabel("FFE_TABLE");
        JLabel tableTitleValueLbl = UIHelper.createLabel(this.fieldInfo.getTableInfo().getTitle());
        tableTitleValueLbl.setBackground(Color.WHITE);
        tableTitleValueLbl.setOpaque(true);
        JLabel fieldTitleLbl = UIHelper.createI18NFormLabel("FFE_FIELD");
        JLabel fieldTitleValueLbl = UIHelper.createLabel(this.fieldInfo.getTitle());
        fieldTitleValueLbl.setBackground(Color.WHITE);
        fieldTitleValueLbl.setOpaque(true);
        JLabel fieldLengthLbl = UIHelper.createI18NFormLabel("FFE_LENGTH");
        JLabel fieldLengthValueLbl = UIHelper.createLabel(Integer.toString(this.fieldInfo.getLength()));
        fieldLengthValueLbl.setBackground(Color.WHITE);
        fieldLengthValueLbl.setOpaque(true);
        int y = 1;
        tblInfoPB.add((Component)tableTitleLbl, cc.xy(1, y));
        tblInfoPB.add((Component)tableTitleValueLbl, cc.xy(3, y));
        tblInfoPB.add((Component)fieldTitleLbl, cc.xy(1, y += 2));
        tblInfoPB.add((Component)fieldTitleValueLbl, cc.xy(3, y));
        tblInfoPB.add((Component)fieldLengthLbl, cc.xy(1, y += 2));
        tblInfoPB.add((Component)fieldLengthValueLbl, cc.xy(3, y));
        y += 2;
        this.sampleLabel = UIHelper.createLabel("", 2);
        JPanel samplePanel = new JPanel();
        samplePanel.setBorder(BorderFactory.createTitledBorder(UIRegistry.getResourceString("FFE_SAMPLE")));
        samplePanel.add(this.sampleLabel);
        this.nameTF = UIHelper.createTextField(20);
        this.titleTF = UIHelper.createTextField(20);
        this.byYearCB = UIHelper.createCheckBox(UIRegistry.getResourceString("FFE_BY_YEAR_CHECKBOX"));
        this.hookByYearCheckBoxListener();
        this.fieldsPanel = new EditDeleteAddPanel(this.getSaveAL(), this.getDelAL(), this.getAddAL());
        this.fieldsModel = new FieldsTableModel();
        this.fieldsTbl = new JTable(this.fieldsModel);
        this.fieldTypeCbx = new JComboBox<UIFieldFormatterField.FieldType>(UIFieldFormatterField.FieldType.values());
        this.fieldTxt = UIHelper.createTextField(20);
        this.fieldsPanel.getAddBtn().setEnabled(true);
        this.fieldsPanel.getEditBtn().setIcon(IconManager.getIcon("Green Arrow Up", IconManager.IconSize.Std16));
        UIHelper.makeTableHeadersCentered(this.fieldsTbl, true);
        this.fieldsTbl.getSelectionModel().setSelectionMode(0);
        int width = this.fieldTypeCbx.getPreferredSize().width;
        y = 1;
        PanelBuilder subPB = new PanelBuilder(new FormLayout("r:p,2px,p", "p,4px, p,4px, p,4px, p,4px"));
        subPB.add((Component)UIHelper.createI18NFormLabel("FFE_NAME"), cc.xy(1, y));
        subPB.add((Component)this.nameTF, cc.xy(3, y));
        subPB.add((Component)UIHelper.createI18NFormLabel("FFE_TITLE"), cc.xy(1, y += 2));
        subPB.add((Component)this.titleTF, cc.xy(3, y));
        subPB.add((Component)this.byYearCB, cc.xy(3, y += 2));
        y += 2;
        SpinnerNumberModel retModel = new SpinnerNumberModel(1, 1, this.fieldInfo.getLength(), 1);
        this.sizeSpinner = new JSpinner(retModel);
        this.isIncChk = new JCheckBox("Is Incrementer");
        String colDefs = "f:p:g,p,2px," + width + "px,2px,p";
        this.closeBtn = this.createClose(0);
        PanelBuilder numPB = new PanelBuilder(new FormLayout(colDefs, "p,2px,p,2px,p"));
        numPB.add((Component)UIHelper.createI18NFormLabel("FFE_LENGTH"), cc.xy(2, 1));
        numPB.add((Component)this.sizeSpinner, cc.xy(4, 1));
        numPB.add((Component)this.isIncChk, cc.xy(4, 3));
        this.sepCbx = new JComboBox<String>(new String[]{"-", ".", "/", "(space)", "_"});
        this.closeBtn = this.createClose(1);
        PanelBuilder sepPB = new PanelBuilder(new FormLayout(colDefs, "p,2px,p"));
        sepPB.add((Component)UIHelper.createI18NFormLabel("FFE_SEP"), cc.xy(2, 1));
        sepPB.add((Component)this.sepCbx, cc.xy(4, 1));
        this.closeBtn = this.createClose(2);
        PanelBuilder txtPB = new PanelBuilder(new FormLayout(colDefs, "p,2px,p"));
        txtPB.add((Component)UIHelper.createI18NFormLabel("FFE_TEXT"), cc.xy(2, 1));
        txtPB.add((Component)this.fieldTxt, cc.xy(4, 1));
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add("size", numPB.getPanel());
        this.cardPanel.add("text", txtPB.getPanel());
        this.cardPanel.add("sep", sepPB.getPanel());
        this.cardPanel.add("none", new JLabel(" "));
        y = 1;
        PanelBuilder leftPB = new PanelBuilder(new FormLayout("f:p:g", "t:p,10px,p,f:p:g"));
        leftPB.add((Component)tblInfoPB.getPanel(), cc.xy(1, y));
        leftPB.add((Component)subPB.getPanel(), cc.xy(1, y += 2));
        y += 2;
        PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
        upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
        upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
        this.totLenLbl = UIHelper.createLabel("XXXXX");
        y = 1;
        PanelBuilder rightPB = new PanelBuilder(new FormLayout("p:g,2px,p,2px,p", "200px,2px,p,2px,p,2px,p"));
        rightPB.add((Component)UIHelper.createScrollPane(this.fieldsTbl), cc.xywh(1, y, 3, 1));
        rightPB.add((Component)upDownPanel.getPanel(), cc.xywh(5, y, 1, 1));
        rightPB.add((Component)this.totLenLbl, cc.xy(1, y += 2));
        rightPB.add((Component)this.fieldsPanel, cc.xywh(3, y, 1, 1));
        this.fieldTypeLbl = UIHelper.createI18NFormLabel("FFE_TYPE");
        rightPB.add((Component)this.fieldTypeLbl, cc.xy(1, y += 2));
        rightPB.add((Component)this.fieldTypeCbx, cc.xy(3, y));
        rightPB.add((Component)this.closeBtn, cc.xy(5, y));
        rightPB.add((Component)this.cardPanel, cc.xyw(1, y += 2, 3));
        y += 2;
        y = 1;
        PanelBuilder pb = new PanelBuilder(new FormLayout("p:g,10px,p,10px,p:g,10px,p", "f:p:g,10px,p"));
        Color bg = this.getBackground();
        pb.add((Component)new VerticalSeparator(bg.darker(), bg.brighter()), cc.xywh(3, 1, 1, 1));
        pb.add((Component)leftPB.getPanel(), cc.xy(1, y));
        pb.add((Component)rightPB.getPanel(), cc.xy(5, y));
        pb.add((Component)samplePanel, cc.xyw(1, y += 2, 7));
        y += 2;
        this.setByYearSelected(this.selectedFormat);
        this.nameTF.setEditable(this.isNew);
        this.nameTF.setText(this.selectedFormat.getName());
        this.titleTF.setText(this.selectedFormat.getTitle());
        this.updateSample();
        this.hookTextChangeListener(this.nameTF, "FFE_NO_NAME", 32);
        this.hookTextChangeListener(this.titleTF, "FFE_NO_TITLE", 32);
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.updateUIEnabled();
        this.pack();
        this.enabledEditorUI(false);
        this.hookFieldsTblSelectionListener();
        this.fieldTypeCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UIFormatterEditorDlg.this.typeChanged();
            }
        });
        this.sepCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UIFormatterEditorDlg.this.fieldHasChanged = true;
                UIFormatterEditorDlg.this.updateEnabledState();
                UIFormatterEditorDlg.this.hasChanged = true;
                UIFormatterEditorDlg.this.updateUIEnabled();
            }
        });
        this.fieldTxt.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                UIFormatterEditorDlg.this.fieldHasChanged = true;
                UIFormatterEditorDlg.this.updateEnabledState();
                UIFormatterEditorDlg.this.hasChanged = true;
                UIFormatterEditorDlg.this.updateUIEnabled();
            }
        });
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UIFormatterEditorDlg.this.fieldHasChanged = true;
                UIFormatterEditorDlg.this.updateEnabledState();
                UIFormatterEditorDlg.this.hasChanged = true;
                UIFormatterEditorDlg.this.updateUIEnabled();
            }
        });
        this.isIncChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterEditorDlg.this.fieldHasChanged = true;
                if (!UIFormatterEditorDlg.this.isIncChk.isSelected()) {
                    UIFormatterEditorDlg.this.byYearCB.setSelected(false);
                }
                UIFormatterEditorDlg.this.updateEntry();
                UIFormatterEditorDlg.this.updateUIEnabled();
                UIFormatterEditorDlg.this.updateEnabledState();
                UIFormatterEditorDlg.this.fieldsTbl.repaint();
            }
        });
        this.fieldTypeCbx.setSelectedIndex(-1);
        this.fieldHasChanged = false;
        this.updateEnabledState();
    }

    private JButton createClose(int type) {
        JButton btn = UIHelper.createIconBtn("Close", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterEditorDlg.this.checkForChanges();
                UIFormatterEditorDlg.this.cardLayout.show(UIFormatterEditorDlg.this.cardPanel, "none");
                UIFormatterEditorDlg.this.resetUI();
            }
        });
        btn.setRolloverEnabled(true);
        btn.setRolloverIcon(IconManager.getIcon("CloseHover"));
        btn.setEnabled(true);
        return btn;
    }

    private boolean hasIncrementor() {
        for (UIFieldFormatterField fld : this.fields) {
            if (fld == this.currentField || !fld.isIncrementer()) continue;
            System.out.println("TRUE");
            return true;
        }
        System.out.println("FALSE");
        return false;
    }

    private void typeChanged() {
        this.fieldHasChanged = true;
        this.updateEnabledState();
        this.hasChanged = true;
        this.updateUIEnabled();
        String cardKey = "none";
        if (this.fieldTypeCbx.getSelectedIndex() > -1) {
            this.isIncChk.setVisible(false);
            UIFieldFormatterField.FieldType fieldType = (UIFieldFormatterField.FieldType)((Object)this.fieldTypeCbx.getSelectedItem());
            switch (fieldType) {
                case alphanumeric: 
                case alpha: 
                case anychar: {
                    cardKey = "size";
                    break;
                }
                case constant: {
                    cardKey = "text";
                    break;
                }
                case numeric: {
                    cardKey = "size";
                    this.isIncChk.setVisible(true);
                    break;
                }
                case separator: {
                    cardKey = "sep";
                    break;
                }
                case year: {
                    cardKey = "none";
                }
            }
        }
        this.cardLayout.show(this.cardPanel, cardKey);
    }

    private void unhookFieldsTblSelectionListener() {
        this.fieldsTbl.getSelectionModel().removeListSelectionListener(this.fieldsTblSL);
    }

    protected void checkForChanges() {
        if (this.fieldHasChanged) {
            Object[] options = new Object[]{UIRegistry.getResourceString("SAVE"), UIRegistry.getResourceString("DISCARD")};
            int retVal = JOptionPane.showOptionDialog(null, UIRegistry.getResourceString("FFE_SAVE_CHG"), UIRegistry.getResourceString("SaveChangesTitle"), 1, 3, null, options, options[0]);
            if (retVal == 0) {
                this.fieldsPanel.getEditBtn().doClick();
            }
        }
    }

    private void hookFieldsTblSelectionListener() {
        if (this.fieldsTblSL == null) {
            this.fieldsTblSL = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        UIFormatterEditorDlg.this.checkForChanges();
                        int inx = UIFormatterEditorDlg.this.fieldsTbl.getSelectedRow();
                        if (inx > -1) {
                            UIFormatterEditorDlg.this.currentField = UIFormatterEditorDlg.this.fields.get(inx);
                            UIFormatterEditorDlg.this.fieldTypeCbx.setSelectedIndex(UIFormatterEditorDlg.this.currentField.getType().ordinal());
                            UIFormatterEditorDlg.this.isIncChk.setSelected(UIFormatterEditorDlg.this.currentField.isIncrementer());
                            UIFormatterEditorDlg.this.fieldTxt.setText(UIFormatterEditorDlg.this.currentField.getValue());
                            UIFormatterEditorDlg.this.sizeSpinner.setValue(Math.max(1, UIFormatterEditorDlg.this.currentField.getSize()));
                            UIFormatterEditorDlg.this.enabledEditorUI(true);
                        } else {
                            UIFormatterEditorDlg.this.fieldTypeCbx.setSelectedIndex(-1);
                            UIFormatterEditorDlg.this.enabledEditorUI(false);
                        }
                        UIFormatterEditorDlg.this.fieldHasChanged = false;
                        UIFormatterEditorDlg.this.updateEnabledState();
                    }
                }
            };
        }
        this.fieldsTbl.getSelectionModel().addListSelectionListener(this.fieldsTblSL);
    }

    protected void enabledEditorUI(boolean enable) {
        this.fieldTypeCbx.setEnabled(enable);
        this.closeBtn.setVisible(enable);
        this.fieldTypeLbl.setEnabled(enable);
        this.fieldTxt.setEnabled(enable);
        this.sizeSpinner.setEnabled(enable);
    }

    protected String getValueStr(int size, char ch) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < size) {
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    protected ActionListener getSaveAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterEditorDlg.this.saveEntry();
            }
        };
    }

    protected void updateEntry() {
        if (!this.fields.contains(this.currentField)) {
            this.fields.add(this.currentField);
            this.selectedFormat.resetLength();
        }
        UIFieldFormatterField.FieldType fieldType = (UIFieldFormatterField.FieldType)((Object)this.fieldTypeCbx.getSelectedItem());
        this.currentField.setType(fieldType);
        int size = (Integer)this.sizeSpinner.getValue();
        boolean isByYear = fieldType == UIFieldFormatterField.FieldType.year;
        boolean isIncr = this.isIncChk.isSelected() && fieldType == UIFieldFormatterField.FieldType.numeric;
        switch (fieldType) {
            case alphanumeric: {
                this.currentField.setSize(size);
                this.currentField.setValue(this.getValueStr(size, 'A'));
                break;
            }
            case alpha: {
                this.currentField.setSize(size);
                this.currentField.setValue(this.getValueStr(size, 'a'));
                break;
            }
            case anychar: {
                this.currentField.setSize(size);
                this.currentField.setValue(this.getValueStr(size, 'X'));
                break;
            }
            case numeric: {
                this.currentField.setSize(size);
                this.currentField.setValue(this.getValueStr(size, isIncr ? (char)'#' : 'N'));
                break;
            }
            case constant: {
                this.currentField.setSize(this.fieldTxt.getText().length());
                this.currentField.setValue(this.fieldTxt.getText());
                break;
            }
            case separator: {
                this.currentField.setSize(1);
                String sepStr = (String)this.sepCbx.getSelectedItem();
                if (sepStr.startsWith("(")) {
                    sepStr = " ";
                }
                this.currentField.setValue(String.valueOf(sepStr.charAt(0)));
                break;
            }
            case year: {
                this.currentField.setValue("YEAR");
                this.currentField.setSize(4);
            }
        }
        this.currentField.setByYear(isByYear);
        this.currentField.setIncrementer(isIncr);
    }

    protected void saveEntry() {
        this.updateEntry();
        this.resetUI();
    }

    protected void resetUI() {
        this.fieldTypeCbx.setSelectedIndex(-1);
        this.fieldTxt.setText("");
        this.sizeSpinner.setValue(1);
        this.isIncChk.setSelected(false);
        this.fieldHasChanged = false;
        this.enabledEditorUI(false);
        this.updateEnabledState();
        this.fieldsModel.fireChange();
        this.updateUIEnabled();
    }

    protected ActionListener getDelAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterEditorDlg.this.fieldTypeCbx.setSelectedIndex(-1);
                UIFormatterEditorDlg.this.fieldTxt.setText("");
                UIFormatterEditorDlg.this.fields.remove(UIFormatterEditorDlg.this.fieldsTbl.getSelectedRow());
                UIFormatterEditorDlg.this.selectedFormat.resetLength();
                UIFormatterEditorDlg.this.unhookFieldsTblSelectionListener();
                UIFormatterEditorDlg.this.fieldHasChanged = false;
                UIFormatterEditorDlg.this.fieldsTbl.clearSelection();
                UIFormatterEditorDlg.this.fieldsModel.fireChange();
                UIFormatterEditorDlg.this.enabledEditorUI(false);
                UIFormatterEditorDlg.this.updateUIEnabled();
                UIFormatterEditorDlg.this.hookFieldsTblSelectionListener();
                UIFormatterEditorDlg.this.fieldsPanel.getEditBtn().setEnabled(false);
                UIFormatterEditorDlg.this.fieldsPanel.getDelBtn().setEnabled(false);
            }
        };
    }

    protected void setDataIntoUI() {
        if (this.currentField != null) {
            this.fieldTypeCbx.setSelectedIndex(this.currentField.getType().ordinal());
            this.isIncChk.setSelected(this.currentField.isByYear());
            this.fieldTxt.setText(this.currentField.getValue());
            this.sizeSpinner.setValue(Math.max(1, this.currentField.getSize()));
        }
    }

    protected ActionListener getAddAL() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIFormatterEditorDlg.this.fieldsTbl.clearSelection();
                UIFormatterEditorDlg.this.currentField = new UIFieldFormatterField();
                UIFormatterEditorDlg.this.setDataIntoUI();
                UIFormatterEditorDlg.this.enabledEditorUI(true);
                UIFormatterEditorDlg.this.fieldHasChanged = false;
                UIFormatterEditorDlg.this.updateUIEnabled();
            }
        };
    }

    protected void updateEnabledState() {
        int inx = this.fieldsTbl.getSelectedRow();
        boolean isSelected = inx > -1;
        this.fieldsPanel.getDelBtn().setEnabled(isSelected);
        if (this.currentField != null) {
            this.fieldsPanel.getEditBtn().setEnabled(this.fieldHasChanged && (this.currentField.getType() != UIFieldFormatterField.FieldType.constant || !this.fieldTxt.getText().isEmpty()));
        }
        this.orderUpBtn.setEnabled(inx > 0);
        this.orderDwnBtn.setEnabled(inx > -1 && inx < this.fields.size() - 1);
    }

    protected void getDataFromUI() {
        this.selectedFormat.setTitle(this.titleTF.getText());
        this.selectedFormat.setName(this.nameTF.getText());
        this.selectedFormat.setByYear(this.byYearCB.isSelected());
        this.selectedFormat.setDefault(false);
        this.selectedFormat.setDataClass(this.fieldInfo.getTableInfo().getClassObj());
        this.selectedFormat.setFieldName(this.fieldInfo != null ? this.fieldInfo.getName() : null);
        this.selectedFormat.setIncrementer(false);
        for (UIFieldFormatterField f : this.fields) {
            if (!f.isIncrementer()) continue;
            this.selectedFormat.setIncrementer(true);
            break;
        }
        if (this.selectedFormat.isIncrementer()) {
            if (this.selectedFormat.getAutoNumber() == null) {
                AutoNumberIFace autoNum = UIFieldFormatterMgr.getInstance().createAutoNumber(AutoNumberGeneric.class.getName(), this.fieldInfo.getTableInfo().getClassName(), this.fieldInfo.getName(), this.fields.size() == 1);
                this.selectedFormat.setAutoNumber(autoNum);
            }
        } else {
            this.selectedFormat.setAutoNumber(null);
        }
        if (this.fields.size() != 1 || this.fields.get(0).getType() != UIFieldFormatterField.FieldType.numeric) {
            this.selectedFormat.setType(UIFieldFormatterIFace.FormatterType.generic);
        }
    }

    @Override
    protected void okButtonPressed() {
        if (this.fieldsPanel.getEditBtn().isEnabled()) {
            int userChoice = 1;
            Object[] options = new Object[]{UIRegistry.getResourceString("Continue"), UIRegistry.getResourceString("CANCEL")};
            UIRegistry.loadAndPushResourceBundle("masterusrpwd");
            userChoice = JOptionPane.showOptionDialog(this, UIRegistry.getResourceString("UIFEDlg.ITEM_CHG"), UIRegistry.getResourceString("UIFEDlg.CHG_TITLE"), 0, 3, null, options, options[0]);
            if (userChoice == 1) {
                return;
            }
        }
        super.okButtonPressed();
        this.getDataFromUI();
    }

    private void updateSample() {
        this.sampleLabel.setText(this.selectedFormat != null ? this.selectedFormat.getSample() : " ");
        this.resetError();
    }

    private void resetError() {
        this.sampleLabel.setForeground(Color.BLACK);
        this.fmtErrMsg = null;
    }

    private void setError(String message, boolean doClearFmt) {
        this.selectedFormat = doClearFmt ? null : this.selectedFormat;
        this.sampleLabel.setForeground(Color.red);
        this.sampleLabel.setText(message);
    }

    private void hookByYearCheckBoxListener() {
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem() == UIFormatterEditorDlg.this.byYearCB && UIFormatterEditorDlg.this.selectedFormat != null) {
                    UIFormatterEditorDlg.this.selectedFormat.setByYear(e.getStateChange() == 1);
                }
            }
        };
        this.byYearCB.addItemListener(il);
    }

    private void hookTextChangeListener(final JTextField txtFld, final String errMsgKey, final int maxLen) {
        txtFld.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                if (StringUtils.isEmpty((String)txtFld.getText())) {
                    UIFormatterEditorDlg.this.setError(UIRegistry.getResourceString(errMsgKey), false);
                    UIFormatterEditorDlg.this.updateUIEnabled();
                } else if (UIFormatterEditorDlg.this.selectedFormat == null) {
                    UIFormatterEditorDlg.this.setError(UIFormatterEditorDlg.this.fmtErrMsg, true);
                } else {
                    UIFormatterEditorDlg.this.updateUIEnabled();
                    if (UIFormatterEditorDlg.this.checkFieldLen(txtFld.getDocument().getLength(), maxLen)) {
                        UIFormatterEditorDlg.this.sampleLabel.setText("");
                        UIFormatterEditorDlg.this.updateSample();
                    }
                }
                UIFormatterEditorDlg.this.hasChanged = true;
            }
        });
    }

    protected boolean checkFieldLen(int currLen, int maxLen) {
        if (currLen <= maxLen) {
            if (this.currentTxtBGColor != null) {
                this.fieldTxt.setBackground(this.currentTxtBGColor);
                this.fieldTxt.repaint();
                this.currentTxtBGColor = null;
            }
            return true;
        }
        if (currLen > maxLen) {
            if (this.currentTxtBGColor != Color.RED) {
                this.currentTxtBGColor = this.fieldTxt.getBackground();
                this.fieldTxt.setBackground(Color.RED);
            }
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        if (this.currentTxtBGColor != null) {
            this.fieldTxt.setBackground(this.currentTxtBGColor);
        }
        return true;
    }

    private void setByYearSelected(Object obj) {
        if (obj instanceof UIFieldFormatterIFace) {
            UIFieldFormatterIFace fmt = (UIFieldFormatterIFace)obj;
            this.byYearCB.setSelected(fmt.getByYear());
        }
    }

    protected void updateUIEnabled() {
        boolean txtFldHasError = false;
        this.isIncChk.setEnabled(!this.hasIncrementor());
        if (this.fieldFormatterSampler != null && this.selectedFormat != null && this.selectedFormat.getFields().size() > 0) {
            try {
                this.fieldFormatterSampler.isValid(this.selectedFormat);
                this.resetError();
            }
            catch (UIFieldFormatterInvalidatesExistingValueException e) {
                this.setError(String.format(UIRegistry.getResourceString("FFE_FORMAT_INVALIDATES_FIELD_VALUE"), this.selectedFormat.getSample(), e.getInvalidatedValue().toString()), false);
                txtFldHasError = true;
            }
        }
        boolean byYearEnabled = this.selectedFormat != null && this.selectedFormat.byYearApplies();
        this.byYearCB.setEnabled(byYearEnabled);
        if (!byYearEnabled) {
            this.byYearCB.setSelected(false);
        }
        int totalLen = 0;
        if (this.fields.size() > 0) {
            UIFieldFormatterField.FieldType fieldType;
            for (UIFieldFormatterField f : this.fields) {
                totalLen += f.getSize();
            }
            if ((this.fieldsTbl.getSelectedRowCount() == 0 || this.fieldHasChanged) && (fieldType = (UIFieldFormatterField.FieldType)((Object)this.fieldTypeCbx.getSelectedItem())) != null) {
                switch (fieldType) {
                    case numeric: 
                    case alphanumeric: 
                    case alpha: 
                    case anychar: {
                        totalLen += ((Integer)this.sizeSpinner.getValue()).intValue();
                        break;
                    }
                    case constant: {
                        totalLen += this.fieldTxt.getDocument().getLength();
                        break;
                    }
                    case separator: {
                        ++totalLen;
                        break;
                    }
                    case year: {
                        totalLen += 4;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            totalLen = this.fieldTxt.getText().length();
        }
        if (!txtFldHasError) {
            txtFldHasError = this.nameTF.getText().length() == 0 || this.titleTF.getText().length() == 0;
        }
        this.totLenLbl.setText(String.format("%d / %d", totalLen, this.fieldInfo.getLength()));
        boolean lenOK = this.checkFieldLen(totalLen, this.fieldInfo.getLength());
        this.okBtn.setEnabled(this.hasChanged && !txtFldHasError && this.fields.size() > 0 && lenOK);
        if (!txtFldHasError) {
            StringBuilder pattern = new StringBuilder();
            for (UIFieldFormatterField ff : this.fields) {
                pattern.append(ff.getSample());
            }
            this.sampleLabel.setText(pattern.toString());
        }
    }

    public UIFieldFormatterIFace getSelectedFormat() {
        return this.selectedFormat;
    }

    class FieldsTableModel
    extends AbstractTableModel {
        protected String[] colHeaders = new String[]{"Type", "Value", "Size", "Is By Year", "Is Incrementer"};

        public void fireChange() {
            super.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return super.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            return this.colHeaders[column];
        }

        @Override
        public int getColumnCount() {
            return this.colHeaders.length;
        }

        @Override
        public int getRowCount() {
            return UIFormatterEditorDlg.this.selectedFormat.getFields().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UIFieldFormatterField fld = UIFormatterEditorDlg.this.selectedFormat.getFields().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return fld.getType();
                }
                case 1: {
                    return fld.getValue();
                }
                case 2: {
                    return fld.getType() == UIFieldFormatterField.FieldType.separator ? 1 : fld.getSize();
                }
                case 3: {
                    return fld.getType() == UIFieldFormatterField.FieldType.separator ? "" : UIRegistry.getResourceString(fld.isByYear() ? "YES" : "NO");
                }
                case 4: {
                    return fld.getType() == UIFieldFormatterField.FieldType.separator ? "" : UIRegistry.getResourceString(fld.isIncrementer() ? "YES" : "NO");
                }
            }
            return null;
        }
    }
}

