/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterInvalidatesExistingValueException;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import edu.ku.brc.util.Pair;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;

public class UIFieldFormatterSampler
implements SQLExecutionListener {
    protected static final Logger log = Logger.getLogger(UIFieldFormatterSampler.class);
    protected DBFieldInfo fieldInfo;
    protected List<Object> results = new ArrayList<Object>();
    protected boolean ready;
    static DBTableInfo userGroupScopeFakeTableInfo = new DBTableInfo(-1, UserGroupScope.class.getCanonicalName(), "UserGroupScope", "", "");

    public UIFieldFormatterSampler(DBFieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.ready = false;
        this.processSamples();
    }

    public boolean isValid(UIFieldFormatterIFace formatter) throws UIFieldFormatterInvalidatesExistingValueException {
        if (formatter != null) {
            if (!this.ready) {
                return true;
            }
            for (Object obj : this.results) {
                if (obj != null && formatter.isValid(obj.toString())) continue;
                throw new UIFieldFormatterInvalidatesExistingValueException("Format invalidates existing field value.", formatter.toPattern(), obj == null ? "NULL" : obj.toString());
            }
            return true;
        }
        log.error((Object)"Formatter was null!");
        return false;
    }

    protected void processSamples() {
        String sql = this.getSql();
        if (sql != null) {
            SQLExecutionProcessor sqlProc = new SQLExecutionProcessor(this, sql);
            sqlProc.start();
        }
    }

    @Override
    public void exectionDone(SQLExecutionProcessor process, ResultSet rs) {
        try {
            this.results.clear();
            while (rs.next()) {
                this.results.add(rs.getObject(1));
            }
            rs.close();
            this.ready = true;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(UIFieldFormatterSampler.class, e);
            this.results.clear();
            this.ready = false;
        }
    }

    @Override
    public void executionError(SQLExecutionProcessor process, Exception ex) {
        log.debug((Object)("Error processing SQL to get field value samples. " + ex.getMessage()));
        ex.printStackTrace();
        this.ready = false;
    }

    protected String getSql() {
        DBTableInfo tblInfo = this.fieldInfo.getTableInfo();
        String tableName = tblInfo.getName();
        if (tblInfo != null) {
            DBFieldInfo colMemIdField = tblInfo.getFieldByColumnName("CollectionMemberID");
            String fieldName = this.fieldInfo.getName();
            String joins = tableName.equals("collectionobject") ? "" : this.getJoins();
            String sql = "SELECT " + tableName + "." + fieldName + " " + "FROM " + tableName + joins + " WHERE " + fieldName + " IS NOT NULL " + (colMemIdField != null ? "AND " + tableName + ".CollectionMemberID = COLMEMID" : "");
            sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
            return sql;
        }
        return null;
    }

    protected String getJoins() {
        StringBuilder joins = new StringBuilder();
        List<Pair<DBTableInfo, DBRelationshipInfo>> path = this.getShortestPath();
        for (Pair<DBTableInfo, DBRelationshipInfo> node : path) {
            DBRelationshipInfo rel = (DBRelationshipInfo)node.second;
            DBTableInfo firstTable = (DBTableInfo)node.first;
            DBTableInfo secondTable = DBTableIdMgr.getInstance().getByClassName(rel.getClassName());
            String sql = "";
            if (rel.getType() == DBRelationshipInfo.RelationshipType.OneToMany) {
                rel = secondTable.getRelationshipByName(rel.getOtherSide());
                sql = " INNER JOIN " + secondTable.getName() + " ON " + secondTable.getName() + "." + rel.getColName() + " = " + firstTable.getName() + "." + firstTable.getIdColumnName();
            } else if (rel.getType() == DBRelationshipInfo.RelationshipType.ManyToOne || rel.getType() == DBRelationshipInfo.RelationshipType.OneToOne) {
                sql = " INNER JOIN " + secondTable.getName() + " ON " + firstTable.getName() + "." + rel.getColName() + " = " + secondTable.getName() + "." + secondTable.getIdColumnName();
            } else if (rel.getType() == DBRelationshipInfo.RelationshipType.ManyToMany) {
                String joinTable = String.valueOf(firstTable.getName()) + "_" + secondTable.getName();
                String joinTableSecondIdColumnName = secondTable.getIdColumnName();
                sql = " INNER JOIN " + joinTable + " ON " + firstTable.getName() + "." + firstTable.getIdColumnName() + " = " + joinTable + "." + firstTable.getIdColumnName() + " INNER JOIN " + secondTable.getName() + " ON " + secondTable.getName() + "." + secondTable.getIdColumnName() + " = " + joinTable + "." + joinTableSecondIdColumnName;
            } else {
                log.warn((Object)("Relationship Type: " + (Object)((Object)rel.getType())));
            }
            joins.append(sql);
        }
        return joins.toString();
    }

    protected List<Pair<DBTableInfo, DBRelationshipInfo>> getShortestPath() {
        Hashtable<DBTableInfo, Integer> distance = new Hashtable<DBTableInfo, Integer>();
        Hashtable<DBTableInfo, Pair<DBTableInfo, DBRelationshipInfo>> previous = new Hashtable<DBTableInfo, Pair<DBTableInfo, DBRelationshipInfo>>();
        HashSet<DBTableInfo> visited = new HashSet<DBTableInfo>();
        Stack<DBTableInfo> stack = new Stack<DBTableInfo>();
        stack.push(this.fieldInfo.getTableInfo());
        distance.put(this.fieldInfo.getTableInfo(), 0);
        boolean destinationReached = false;
        DBTableInfo currentVertex = null;
        block0: while (stack.size() > 0 && !destinationReached) {
            currentVertex = (DBTableInfo)stack.pop();
            visited.add(currentVertex);
            Integer distanceToCurrent = (Integer)distance.get(currentVertex);
            List<DBRelationshipInfo> relationships = currentVertex.getRelationships();
            for (DBRelationshipInfo relationship : relationships) {
                DBTableInfo neighborTable = this.getTableInfo(relationship.getClassName());
                if (visited.contains(neighborTable) || neighborTable.getName().equals(currentVertex.getName())) continue;
                Integer distanceToNeighbor = (Integer)distance.get(neighborTable);
                if (distanceToNeighbor == null || distanceToCurrent + 1 < distanceToNeighbor) {
                    distance.put(neighborTable, new Integer(distanceToCurrent + 1));
                    previous.put(neighborTable, new Pair<DBTableInfo, DBRelationshipInfo>(currentVertex, relationship));
                }
                if ("collectionobject".equals(neighborTable.getName())) {
                    currentVertex = neighborTable;
                    destinationReached = true;
                    continue block0;
                }
                stack.push(neighborTable);
            }
        }
        ArrayList<Pair<DBTableInfo, DBRelationshipInfo>> path = new ArrayList<Pair<DBTableInfo, DBRelationshipInfo>>();
        if (destinationReached) {
            Pair node = (Pair)previous.get(currentVertex);
            while (node != null) {
                path.add(0, node);
                DBTableInfo relTable = DBTableIdMgr.getInstance().getInfoByTableName(((DBTableInfo)node.first).getName());
                node = (Pair)previous.get(relTable);
            }
        }
        return path;
    }

    private DBTableInfo getTableInfo(String className) {
        if (UserGroupScope.class.getCanonicalName().equals(className)) {
            return userGroupScopeFakeTableInfo;
        }
        return DBTableIdMgr.getInstance().getByClassName(className);
    }
}

