/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFloatFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UIIntegerFieldFormatterFactory;
import edu.ku.brc.af.ui.forms.formatters.UITextFieldFormatterFactory;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class UIFieldFormatterMgr
implements AppPrefsChangeListener {
    public static final String factoryName = "edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr";
    private static final Logger log = Logger.getLogger(UIFieldFormatterMgr.class);
    protected static UIFieldFormatterMgr instance = null;
    protected static boolean doingLocal = false;
    protected boolean hasChanged = false;
    protected Hashtable<String, UIFieldFormatterIFace> hash = new Hashtable();
    protected Hashtable<Class<?>, Vector<UIFieldFormatterIFace>> classToListHash = new Hashtable();
    private AppContextMgr appContextMgr = null;

    protected UIFieldFormatterMgr() {
    }

    public AppContextMgr getAppContextMgr() {
        if (this.appContextMgr == null) {
            this.appContextMgr = AppContextMgr.getInstance();
        }
        return this.appContextMgr;
    }

    public void setAppContextMgr(AppContextMgr appContextMgr) {
        this.appContextMgr = appContextMgr;
    }

    public void shutdown() {
        this.hash.clear();
        this.cleanClassToListHash();
        this.appContextMgr = null;
    }

    public void reset() {
        if (instance != null) {
            instance.save();
        }
        instance = null;
    }

    public UIFieldFormatterMgr(UIFieldFormatterMgr source) {
        this.setHash(source.getHash());
    }

    public void copyFrom(UIFieldFormatterMgr source) {
        this.hasChanged = source.hasChanged;
        this.setHash(source.getHash());
    }

    public static UIFieldFormatterMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        if (StringUtils.isEmpty((String)factoryName)) {
            instance = new UIFieldFormatterMgr();
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(UIFieldFormatterMgr.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (UIFieldFormatterMgr)Class.forName(factoryNameStr).newInstance();
                instance.load();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIFieldFormatterMgr.class, e);
                InternalError error = new InternalError("Can't instantiate UIFieldFormatterMgr factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        throw new RuntimeException("Can't instantiate UIFieldFormatterMgr factory [" + factoryNameStr + "]");
    }

    public static void setDoingLocal(boolean doingLocal) {
        UIFieldFormatterMgr.doingLocal = doingLocal;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public List<UIFieldFormatterIFace> getFormatters() {
        Vector<UIFieldFormatterIFace> list = new Vector<UIFieldFormatterIFace>();
        for (UIFieldFormatterIFace fmt : this.hash.values()) {
            boolean isUIF = fmt instanceof UIFieldFormatter;
            if (isUIF && ((UIFieldFormatter)fmt).getType() != UIFieldFormatterIFace.FormatterType.generic) continue;
            list.add(fmt);
        }
        return list;
    }

    protected UIFieldFormatterIFace getFormatterInternal(String name) {
        return StringUtils.isNotEmpty((String)name) ? this.hash.get(name) : null;
    }

    public UIFieldFormatterIFace getFormatter(String name) {
        return StringUtils.isNotEmpty((String)name) ? this.getFormatterInternal(name) : null;
    }

    public UIFieldFormatterIFace getFormatterInternal(Class<?> clazz) {
        UIFieldFormatterIFace formatter = null;
        Enumeration<UIFieldFormatterIFace> e = this.hash.elements();
        while (e.hasMoreElements()) {
            UIFieldFormatterIFace f = e.nextElement();
            if (clazz != f.getDataClass()) continue;
            if (f.isDefault()) {
                return f;
            }
            if (formatter != null) continue;
            formatter = f;
        }
        return formatter;
    }

    public UIFieldFormatterIFace getFormatter(Class<?> clazz) {
        return this.getFormatterInternal(clazz);
    }

    public UIFieldFormatterIFace getDateFormatter(UIFieldFormatterIFace.PartialDateEnum type) {
        Enumeration<UIFieldFormatterIFace> e = this.hash.elements();
        while (e.hasMoreElements()) {
            UIFieldFormatterIFace f = e.nextElement();
            if (Date.class != f.getDataClass() || f.getPartialDateType() != type) continue;
            return f;
        }
        return null;
    }

    public List<UIFieldFormatterIFace> getDateFormatterList(boolean isForPartial) {
        Vector<UIFieldFormatterIFace> list = new Vector<UIFieldFormatterIFace>();
        for (UIFieldFormatterIFace f : this.hash.values()) {
            boolean isPartial;
            if (!f.isDate()) continue;
            boolean bl = isPartial = f.getPartialDateType() == UIFieldFormatterIFace.PartialDateEnum.Month || f.getPartialDateType() == UIFieldFormatterIFace.PartialDateEnum.Year;
            if (isForPartial != isPartial) continue;
            list.add(f);
        }
        return list;
    }

    public List<UIFieldFormatterIFace> getFormatterList(Class<?> clazz) {
        return this.getFormatterList(clazz, null);
    }

    public List<UIFieldFormatterIFace> getFormatterList(Class<?> clazz, String fieldName) {
        Vector<UIFieldFormatterIFace> list;
        if (fieldName == null && (list = this.classToListHash.get(clazz)) != null) {
            return list;
        }
        list = new Vector();
        UIFieldFormatterIFace defFormatter = null;
        Enumeration<UIFieldFormatterIFace> e = this.hash.elements();
        while (e.hasMoreElements()) {
            UIFieldFormatterIFace fmt = e.nextElement();
            if (clazz != fmt.getDataClass() || fieldName != null && !fieldName.equals(fmt.getFieldName()) && !fieldName.equals("*")) continue;
            if (fmt.isDefault() && defFormatter == null) {
                defFormatter = fmt;
                continue;
            }
            list.add(fmt);
        }
        if (defFormatter != null) {
            list.insertElementAt(defFormatter, 0);
        }
        if (fieldName == null) {
            this.classToListHash.put(clazz, list);
        }
        return list;
    }

    protected void cleanClassToListHash() {
        for (Class<?> key : this.classToListHash.keySet()) {
            Vector<UIFieldFormatterIFace> list = this.classToListHash.get(key);
            list.clear();
        }
        this.classToListHash.clear();
    }

    private String getFormatterUniqueName(UIFieldFormatterIFace formatter) {
        String name = formatter.getName();
        if (StringUtils.isEmpty((String)name)) {
            int i = 1;
            Set<String> names = this.hash.keySet();
            String prefix = formatter.getFieldName();
            name = String.valueOf(prefix) + "." + Integer.toString(i);
            while (names.contains(name)) {
                name = String.valueOf(prefix) + "." + Integer.toString(++i);
            }
        }
        formatter.setName(name);
        return null;
    }

    public void addFormatter(UIFieldFormatterIFace formatter) {
        this.getFormatterUniqueName(formatter);
        this.addFormatterToMgr(formatter);
    }

    protected void addFormatterToMgr(UIFieldFormatterIFace formatter) {
        List<UIFieldFormatterIFace> list = (List<UIFieldFormatterIFace>)this.classToListHash.get(formatter.getDataClass());
        if (list == null && (list = this.getFormatterList(formatter.getDataClass())) == null) {
            Vector<UIFieldFormatterIFace> newList = new Vector<UIFieldFormatterIFace>();
            this.classToListHash.put(formatter.getDataClass(), newList);
            list = newList;
        }
        list.add(formatter);
        this.hash.put(formatter.getName(), formatter);
        this.hasChanged = true;
    }

    public void removeFormatter(UIFieldFormatterIFace formatter) {
        this.hash.remove(formatter.getName());
        Vector<UIFieldFormatterIFace> list = this.classToListHash.get(formatter.getDataClass());
        if (list != null) {
            list.remove(formatter);
            this.classToListHash.put(formatter.getDataClass(), list);
        }
        this.hasChanged = true;
    }

    protected Element getDOM() throws Exception {
        throw new RuntimeException("Not implemented.");
    }

    public boolean addFormatter(File xmlFile) {
        try {
            UIFieldFormatterIFace formatter = this.createFormatterFromXML(XMLHelper.readFileToDOM4J(xmlFile));
            if (formatter != null) {
                this.addFormatterToMgr(formatter);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    protected AutoNumberIFace createAutoNum(Element formatElement, String name, String dataClassName, String fieldName, boolean isSingleField) {
        AutoNumberIFace autoNumberObj = null;
        Element autoNumberElement = (Element)formatElement.selectSingleNode("autonumber");
        if (autoNumberElement != null) {
            String autoNumberClassName = autoNumberElement.getTextTrim();
            if (StringUtils.isNotEmpty((String)autoNumberClassName) && StringUtils.isNotEmpty((String)dataClassName) && StringUtils.isNotEmpty((String)fieldName)) {
                autoNumberObj = this.createAutoNumber(autoNumberClassName, dataClassName, fieldName, isSingleField);
            } else {
                throw new RuntimeException("The class cannot be empty for an external formatter! [" + name + "] or missing field name [" + fieldName + "] or missing data Class name [" + dataClassName + "]");
            }
        }
        return autoNumberObj;
    }

    public UIFieldFormatterIFace createFormatterFromXML(Element formatElement) {
        UIFieldFormatterIFace formatter = null;
        String name = formatElement.attributeValue("name");
        String fType = formatElement.attributeValue("type");
        String fieldName = XMLHelper.getAttr(formatElement, "fieldname", "*");
        String dataClassName = formatElement.attributeValue("class");
        int precision = XMLHelper.getAttr(formatElement, "precision", 12);
        int scale = XMLHelper.getAttr(formatElement, "scale", 2);
        boolean isDefault = XMLHelper.getAttr(formatElement, "default", false);
        boolean isSystem = XMLHelper.getAttr(formatElement, "system", false);
        Element external = (Element)formatElement.selectSingleNode("external");
        if (external != null) {
            String externalClassName = external.getTextTrim();
            if (StringUtils.isNotEmpty((String)externalClassName)) {
                try {
                    formatter = Class.forName(externalClassName).asSubclass(UIFieldFormatterIFace.class).newInstance();
                    formatter.setName(name);
                    formatter.setAutoNumber(this.createAutoNum(formatElement, name, dataClassName, fieldName, formatter.getFields().size() == 1));
                    formatter.setDefault(isDefault);
                    this.hash.put(name, formatter);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(UIFieldFormatterMgr.class, ex);
                }
            } else {
                throw new RuntimeException("The value cannot be empty for an external formatter! [" + name + "]");
            }
        }
        List fieldsList = formatElement.selectNodes("field");
        Vector<UIFieldFormatterField> fields = new Vector<UIFieldFormatterField>();
        boolean isInc = false;
        String partialDateTypeStr = formatElement.attributeValue("partialdate");
        for (Object fldObj : fieldsList) {
            Element fldElement = (Element)fldObj;
            int size = XMLHelper.getAttr(fldElement, "size", 1);
            String value = fldElement.attributeValue("value");
            String typeStr = fldElement.attributeValue("type");
            boolean increm = XMLHelper.getAttr(fldElement, "inc", false);
            boolean byYear = false;
            UIFieldFormatterField.FieldType type = null;
            try {
                type = UIFieldFormatterField.FieldType.valueOf(typeStr);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIFieldFormatterMgr.class, ex);
                log.error((Object)("[" + typeStr + "]" + ex.toString()));
            }
            if (type == UIFieldFormatterField.FieldType.year) {
                size = 4;
                byYear = XMLHelper.getAttr(fldElement, "byyear", false);
            }
            fields.add(new UIFieldFormatterField(type, size, value, increm, byYear));
            if (!increm) continue;
            isInc = true;
        }
        UIFieldFormatterIFace.FormatterType type = UIFieldFormatterIFace.FormatterType.generic;
        UIFieldFormatterIFace.PartialDateEnum partialDateType = UIFieldFormatterIFace.PartialDateEnum.None;
        if (StringUtils.isNotEmpty((String)fType) && fType.equals("numeric")) {
            type = UIFieldFormatterIFace.FormatterType.numeric;
        } else if (StringUtils.isNotEmpty((String)fType) && fType.equals("date")) {
            type = UIFieldFormatterIFace.FormatterType.date;
            partialDateType = StringUtils.isNotEmpty((String)partialDateTypeStr) ? UIFieldFormatterIFace.PartialDateEnum.valueOf(partialDateTypeStr) : UIFieldFormatterIFace.PartialDateEnum.Full;
        }
        Class<Object> dataClass = null;
        if (StringUtils.isNotEmpty((String)dataClassName)) {
            try {
                dataClass = Class.forName(dataClassName);
            }
            catch (Exception ex) {
                log.error((Object)("Couldn't load class [" + dataClassName + "] for [" + name + "]"));
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIFieldFormatterMgr.class, ex);
            }
        } else if (StringUtils.isNotEmpty((String)fType) && fType.equals("date")) {
            dataClass = Date.class;
        }
        if (formatter == null) {
            formatter = new UIFieldFormatter(name, isSystem, fieldName, type, partialDateType, dataClass, isDefault, isInc, fields);
            this.hash.put(name, formatter);
        } else {
            formatter.setPartialDateType(partialDateType);
        }
        if (formatter instanceof UIFieldFormatter) {
            UIFieldFormatter fmt = (UIFieldFormatter)formatter;
            fmt.setType(type);
            if (type == UIFieldFormatterIFace.FormatterType.date && fields.size() == 0) {
                this.addFieldsForDate(fmt);
            } else if (type == UIFieldFormatterIFace.FormatterType.numeric && fields.size() == 0) {
                fmt.setPrecision(precision);
                fmt.setScale(scale);
                this.addFieldsForNumeric(fmt);
            }
        }
        formatter.setAutoNumber(this.createAutoNum(formatElement, name, dataClassName, fieldName, formatter.getFields().size() == 1));
        return formatter;
    }

    public void load() {
        this.hash.clear();
        this.cleanClassToListHash();
        try {
            Element root = this.getDOM();
            if (root != null) {
                boolean hasDefault = false;
                List formats = root.selectNodes("/formats/format");
                for (Object fObj : formats) {
                    Element formatElement = (Element)fObj;
                    UIFieldFormatterIFace formatter = this.createFormatterFromXML(formatElement);
                    if (!formatter.isDefault()) continue;
                    if (!hasDefault) {
                        hasDefault = true;
                        continue;
                    }
                    formatter.setDefault(false);
                }
            } else {
                log.debug((Object)"Couldn't open DOM for uiformatters.xml");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(UIFieldFormatterMgr.class, ex);
            log.error((Object)ex);
        }
    }

    public void applyChanges(UIFieldFormatterMgr source) {
        if (source.hasChanged) {
            this.copyFrom(source);
            this.save();
        } else {
            log.debug((Object)"Not saved = No Changes");
        }
    }

    public void save() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<formats>\n");
        Vector<UIFieldFormatterIFace> formatVector = this.getFormatterToSave();
        Collections.sort(formatVector, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (UIFieldFormatterIFace format : formatVector) {
            format.toXML(sb);
        }
        sb.append("\n</formats>\n");
        this.saveXML(sb.toString());
    }

    protected Vector<UIFieldFormatterIFace> getFormatterToSave() {
        return new Vector<UIFieldFormatterIFace>(this.hash.values());
    }

    protected void saveXML(String xml) {
        throw new RuntimeException("Not implemented.");
    }

    public static UIFieldFormatterFactory getFormatFactory(DBFieldInfo fieldInfo) {
        if (String.class.getCanonicalName().equals(fieldInfo.getType())) {
            return new UITextFieldFormatterFactory(fieldInfo);
        }
        if (Float.class.getCanonicalName().equals(fieldInfo.getType())) {
            return new UIFloatFieldFormatterFactory(fieldInfo);
        }
        if (Integer.class.getCanonicalName().equals(fieldInfo.getType())) {
            return new UIIntegerFieldFormatterFactory(fieldInfo);
        }
        return null;
    }

    public AutoNumberIFace createAutoNumber(String autoNumberClassName, String dataClassName, String fieldName, boolean isSingleField) {
        AutoNumberIFace autoNumberObj = null;
        try {
            autoNumberObj = Class.forName(autoNumberClassName).asSubclass(AutoNumberIFace.class).newInstance();
            Properties props = new Properties();
            props.put("class", dataClassName);
            props.put("field", fieldName);
            autoNumberObj.setProperties(props);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(UIFieldFormatterMgr.class, ex);
        }
        return autoNumberObj;
    }

    protected void addFieldsForDate(UIFieldFormatter formatter) {
        formatter.getFields().clear();
        String prefPostFix = "";
        UIFieldFormatterIFace.PartialDateEnum partialType = formatter.getPartialDateType();
        if (partialType == UIFieldFormatterIFace.PartialDateEnum.Month) {
            prefPostFix = "mon";
        } else if (partialType == UIFieldFormatterIFace.PartialDateEnum.Year) {
            prefPostFix = "year";
        }
        DateWrapper dateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat" + prefPostFix);
        if (partialType == UIFieldFormatterIFace.PartialDateEnum.Search) {
            dateFormat = new DateWrapper(new SimpleDateFormat("yyyy-MM-dd"));
        }
        StringBuilder newFormatStr = new StringBuilder();
        String formatStr = dateFormat.getSimpleDateFormat().toPattern();
        boolean wasConsumed = false;
        char currChar = ' ';
        int i = 0;
        while (i < formatStr.length()) {
            char c = formatStr.charAt(i);
            if (c != currChar) {
                UIFieldFormatterField f;
                if (c == 'M') {
                    if (partialType == UIFieldFormatterIFace.PartialDateEnum.Full || partialType == UIFieldFormatterIFace.PartialDateEnum.Search || partialType == UIFieldFormatterIFace.PartialDateEnum.Month) {
                        String s = "";
                        s = String.valueOf(s) + c;
                        s = String.valueOf(s) + c;
                        f = new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, s.toUpperCase(), false);
                        formatter.getFields().add(f);
                        currChar = c;
                        newFormatStr.append(c);
                        newFormatStr.append(c);
                    } else {
                        wasConsumed = true;
                    }
                } else if (c == 'd') {
                    if (partialType == UIFieldFormatterIFace.PartialDateEnum.Full || partialType == UIFieldFormatterIFace.PartialDateEnum.Search) {
                        String s = "";
                        s = String.valueOf(s) + c;
                        s = String.valueOf(s) + c;
                        f = new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, s.toUpperCase(), false);
                        formatter.getFields().add(f);
                        currChar = c;
                        newFormatStr.append(c);
                        newFormatStr.append(c);
                    } else {
                        wasConsumed = true;
                    }
                } else if (c == 'y') {
                    int start = i;
                    while (i < formatStr.length() && formatStr.charAt(i) == 'y') {
                        ++i;
                        newFormatStr.append(c);
                    }
                    f = i - start > 2 ? new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 4, "YYYY", false) : new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, 2, "YY", false);
                    formatter.getFields().add(f);
                    currChar = c;
                    --i;
                } else if (!wasConsumed) {
                    String s = "";
                    s = String.valueOf(s) + c;
                    f = new UIFieldFormatterField(UIFieldFormatterField.FieldType.separator, 1, s, false);
                    formatter.getFields().add(f);
                    newFormatStr.append(c);
                } else {
                    wasConsumed = false;
                }
            }
            ++i;
        }
        if (partialType == UIFieldFormatterIFace.PartialDateEnum.Full || partialType == UIFieldFormatterIFace.PartialDateEnum.Search) {
            formatter.setDateWrapper(dateFormat);
        } else {
            dateFormat.setSimpleDateFormat(new SimpleDateFormat(newFormatStr.toString()));
            formatter.setDateWrapper(dateFormat);
        }
    }

    protected void addFieldsForNumeric(UIFieldFormatter formatter) {
        int len;
        Class<?> cls = formatter.getDataClass();
        if (cls == BigDecimal.class) {
            len = formatter.getPrecision() + formatter.getScale() + 1;
        } else {
            len = cls == Long.class ? Long.toString(Long.MAX_VALUE).length() : (cls == Integer.class ? Integer.toString(Integer.MAX_VALUE).length() : (cls == Short.class ? Short.toString((short)Short.MAX_VALUE).length() : (cls == Byte.class ? Byte.toString((byte)127).length() : (cls == Double.class ? String.format("%f", Double.MAX_VALUE).length() : (cls == Float.class ? String.format("%f", Float.valueOf(Float.MAX_VALUE)).length() : formatter.getLength())))));
            len = Math.min(len, 10);
        }
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            sb.append(' ');
            ++i;
        }
        formatter.getFields().add(new UIFieldFormatterField(UIFieldFormatterField.FieldType.numeric, len, sb.toString(), false));
    }

    public static String getFormatterPattern(boolean isAutoNumber, UIFieldFormatterField.FieldType fieldType, int length) {
        String key;
        String charPattern;
        char defChar = 'A';
        if (fieldType != null) {
            switch (fieldType) {
                case numeric: {
                    defChar = 'N';
                    break;
                }
                case alphanumeric: {
                    defChar = 'A';
                    break;
                }
                case alpha: {
                    defChar = 'a';
                    break;
                }
                case separator: {
                    defChar = '#';
                    break;
                }
                case year: {
                    defChar = 'Y';
                    break;
                }
                case anychar: {
                    defChar = ' ';
                    break;
                }
                default: {
                    defChar = '?';
                    break;
                }
            }
        } else if (!isAutoNumber) {
            throw new RuntimeException("Can't have a null fieldType and not be autonumbered");
        }
        char pChar = isAutoNumber ? UIFieldFormatterMgr.getAutoNumberPatternChar() : (fieldType != UIFieldFormatterField.FieldType.anychar ? (fieldType != null ? ((charPattern = UIRegistry.getResourceString(key = "UIFieldFormatterMgr." + fieldType.toString())).length() > 0 ? charPattern.charAt(0) : defChar) : defChar) : defChar);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append(pChar);
            ++i;
        }
        return sb.toString();
    }

    public Hashtable<String, UIFieldFormatterIFace> getHash() {
        return this.hash;
    }

    public void setHash(Hashtable<String, UIFieldFormatterIFace> hash) {
        this.hash = hash;
    }

    public void reloadDateFormatter() {
        for (UIFieldFormatterIFace fmt : this.hash.values()) {
            if (fmt.getDataClass() != Date.class || !(fmt instanceof UIFieldFormatter)) continue;
            this.addFieldsForDate((UIFieldFormatter)fmt);
        }
    }

    public static char getAutoNumberPatternChar() {
        String key = "UIFieldFormatterMgr.autonumber";
        String charPattern = UIRegistry.getResourceString(key);
        return charPattern.length() > 0 ? charPattern.charAt(0) : (char)'#';
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("ui.formatting.scrdateformat")) {
            this.reloadDateFormatter();
        }
    }
}

