/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterParsingException;
import edu.ku.brc.helpers.XMLHelper;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UIFieldFormatterField
implements Cloneable {
    private static String alphaSample = "";
    private static String anyCharSample = "";
    private static String alphaNumericSample = "";
    private static String anyNumericSample = "";
    protected FieldType type;
    protected int size;
    protected String value;
    protected boolean incrementer;
    protected boolean byYear;

    static {
        int i = 0;
        while (i < 255) {
            alphaNumericSample = String.valueOf(alphaNumericSample) + "A";
            alphaSample = String.valueOf(alphaSample) + "a";
            anyCharSample = String.valueOf(anyCharSample) + "X";
            anyNumericSample = String.valueOf(anyNumericSample) + "N";
            ++i;
        }
    }

    public UIFieldFormatterField() {
        this.type = FieldType.alphanumeric;
        this.size = 1;
        this.value = "";
        this.incrementer = false;
        this.byYear = false;
    }

    public UIFieldFormatterField(FieldType type, int size, String value, boolean incrementer, boolean byYear) {
        this.type = type;
        this.size = size;
        this.value = value;
        this.incrementer = incrementer;
        this.byYear = byYear;
        if (incrementer && type == FieldType.numeric) {
            this.value = UIFieldFormatterMgr.getFormatterPattern(incrementer, null, size);
        }
    }

    public UIFieldFormatterField(FieldType type, int size, String value, boolean incrementer) {
        this(type, size, value, incrementer, false);
    }

    public static UIFieldFormatterField factory(String formattingString) throws UIFieldFormatterParsingException {
        UIFieldFormatterField field = new UIFieldFormatterField();
        Pattern pattern = Pattern.compile("^(A+|X+|a+|N+|\\#+|YEAR|\"[^\"]*\")$");
        Matcher matcher = pattern.matcher(formattingString);
        if (matcher.find()) {
            String val = formattingString.substring(matcher.start(), matcher.end());
            field.setValue(val);
            field.setSize(val.length());
            char firstChar = val.charAt(0);
            switch (firstChar) {
                case 'A': {
                    field.setType(FieldType.alphanumeric);
                    break;
                }
                case 'a': {
                    field.setType(FieldType.alpha);
                    break;
                }
                case 'N': {
                    field.setType(FieldType.numeric);
                    field.setIncrementer(false);
                    break;
                }
                case '#': {
                    field.setType(FieldType.numeric);
                    field.setIncrementer(true);
                    break;
                }
                case 'Y': {
                    field.setType(FieldType.year);
                    break;
                }
                case '\"': {
                    field.setType(FieldType.constant);
                }
            }
        } else {
            throw new UIFieldFormatterParsingException("Invalid formatting string: " + formattingString, formattingString);
        }
        return field;
    }

    public int getSize() {
        return this.size;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public String getSample() {
        String sample = "";
        if (this.type == FieldType.separator) {
            return this.value;
        }
        if (this.type == FieldType.alphanumeric) {
            return alphaNumericSample.substring(0, this.value.length());
        }
        if (this.type == FieldType.alpha) {
            return alphaSample.substring(0, this.value.length());
        }
        if (this.type == FieldType.anychar) {
            return anyCharSample.substring(0, this.value.length());
        }
        if (this.type == FieldType.numeric) {
            if (this.isIncrementer()) {
                sample = String.format("%0" + this.size + "d", 1);
            } else {
                return anyNumericSample.substring(0, this.size);
            }
        }
        if (this.type == FieldType.year) {
            sample = Integer.toString(Calendar.getInstance().get(1));
        }
        if (this.type == FieldType.constant) {
            return this.value.substring(0, this.value.length());
        }
        if (this.type == FieldType.anychar) {
            return this.value.substring(0, this.value.length());
        }
        if (sample.length() == 0) {
            return "";
        }
        return sample.substring(0, this.value.length());
    }

    public boolean isEntryField() {
        return !this.isIncrementer() && this.type != FieldType.separator;
    }

    public boolean isIncrementer() {
        return this.incrementer;
    }

    public boolean isByYear() {
        return this.byYear;
    }

    public boolean isSeparator() {
        return this.type == FieldType.separator;
    }

    public boolean isConstant() {
        return this.type == FieldType.constant;
    }

    public String toString() {
        return "Type[" + (Object)((Object)this.type) + "]  size[" + this.size + "]  value[" + this.value + "] incr[" + this.incrementer + "]";
    }

    public void toXML(StringBuilder sb) {
        sb.append("    <field");
        XMLHelper.xmlAttr(sb, "type", this.type.toString());
        XMLHelper.xmlAttr(sb, "size", this.size);
        if (this.type != FieldType.numeric) {
            XMLHelper.xmlAttr(sb, "value", this.value.replaceAll("\"", "&quot;"));
        }
        if (this.incrementer) {
            XMLHelper.xmlAttr(sb, "inc", this.incrementer);
        }
        if (this.byYear) {
            XMLHelper.xmlAttr(sb, "byyear", this.byYear);
        }
        sb.append("/>\n");
    }

    public void setType(FieldType type) {
        this.type = type;
        if (this.incrementer && type != FieldType.numeric) {
            this.incrementer = false;
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setIncrementer(boolean incrementer) {
        this.incrementer = incrementer;
    }

    public void setByYear(boolean byYear) {
        this.byYear = byYear;
    }

    public boolean isCurrentYear() {
        return this.type == FieldType.year && this.value.equals("YEAR");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static enum FieldType {
        numeric,
        alphanumeric,
        alpha,
        separator,
        year,
        anychar,
        constant;

    }
}

