/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UIFieldFormatter
implements UIFieldFormatterIFace,
Cloneable {
    private static final Logger log = Logger.getLogger(UIFieldFormatter.class);
    protected static DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    public static int[] daysInMon = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static final String deftitle = UIRegistry.getResourceString("FFE_DEFAULT");
    protected static final String systitle = UIRegistry.getResourceString("FFE_SYSTEM");
    protected String fieldName;
    protected String name;
    protected boolean isSystem;
    protected boolean isExternal;
    protected String title;
    protected Class<?> dataClass;
    protected UIFieldFormatterIFace.FormatterType type;
    protected UIFieldFormatterIFace.PartialDateEnum partialDateType;
    protected boolean isDefault;
    protected Vector<UIFieldFormatterField> fields;
    protected boolean isIncrementer;
    protected DateWrapper dateWrapper = null;
    protected AutoNumberIFace autoNumber = null;
    protected int precision = 0;
    protected int scale = 0;
    protected Number minValue = null;
    protected Number maxValue = null;
    protected Boolean hasDash = null;
    private Integer fieldLength = null;

    public UIFieldFormatter() {
        this.fields = new Vector();
        this.isExternal = false;
    }

    public UIFieldFormatter(String name, boolean isSystem, String fieldName, UIFieldFormatterIFace.FormatterType type, UIFieldFormatterIFace.PartialDateEnum partialDateType, Class<?> dataClass, boolean isDefault, boolean isIncrementer, Vector<UIFieldFormatterField> fields) {
        this.name = name;
        this.isSystem = isSystem;
        this.isExternal = false;
        this.fieldName = fieldName;
        this.dataClass = dataClass;
        this.partialDateType = partialDateType;
        this.type = type;
        this.isDefault = isDefault;
        this.fields = fields;
        this.isIncrementer = isIncrementer;
    }

    public String getText() {
        return this.toPattern();
    }

    @Override
    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @Override
    public String getTitle() {
        return this.title == null ? this.name : this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Vector<UIFieldFormatterField> getFields() {
        return this.fields;
    }

    public void addField(UIFieldFormatterField field) {
        this.fieldLength = null;
        if (this.fields == null) {
            this.resetFields();
        }
        this.fields.add(field);
    }

    public void resetFields() {
        this.fieldLength = null;
        this.fields = new Vector();
    }

    @Override
    public UIFieldFormatterField getYear() {
        UIFieldFormatterField year = null;
        for (UIFieldFormatterField field : this.fields) {
            if (field.getType() != UIFieldFormatterField.FieldType.year) continue;
            if (year != null) {
                if (!field.isByYear()) continue;
                return field;
            }
            if (field.isByYear()) {
                return field;
            }
            year = field;
        }
        return year;
    }

    @Override
    public boolean byYearApplies() {
        boolean hasYearField = false;
        boolean hasAutoNumber = false;
        for (UIFieldFormatterField field : this.fields) {
            hasYearField |= field.isCurrentYear();
            hasAutoNumber |= field.isIncrementer();
        }
        return hasYearField && hasAutoNumber;
    }

    @Override
    public boolean getByYear() {
        for (UIFieldFormatterField field : this.fields) {
            if (!field.isByYear()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setByYear(boolean byYear) {
        if (!this.byYearApplies()) {
            return;
        }
        for (UIFieldFormatterField field : this.fields) {
            if (!field.isCurrentYear()) continue;
            field.setByYear(byYear);
        }
    }

    public void setMinValue(Number minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDate() {
        return this.type == UIFieldFormatterIFace.FormatterType.date && (this.partialDateType == null || this.partialDateType != UIFieldFormatterIFace.PartialDateEnum.Search);
    }

    @Override
    public boolean isNumeric() {
        return this.type == UIFieldFormatterIFace.FormatterType.numeric;
    }

    @Override
    public Number getMaxValue() {
        if (this.maxValue == null && this.dataClass == BigDecimal.class) {
            if (this.precision > 0 && this.precision - this.scale > 0) {
                String nines = "99999999999999999999";
                String mask = String.valueOf(nines.substring(0, this.precision - this.scale)) + "." + nines.substring(0, this.scale);
                this.maxValue = new BigDecimal(Double.parseDouble(mask));
            } else {
                this.maxValue = Double.MAX_VALUE;
            }
        }
        return this.maxValue;
    }

    @Override
    public Number getMinValue() {
        if (this.minValue == null && this.dataClass == BigDecimal.class) {
            this.minValue = Double.MIN_VALUE;
        }
        return this.minValue;
    }

    @Override
    public Class<?> getDataClass() {
        return this.dataClass;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean isIncrementer() {
        return this.isIncrementer;
    }

    @Override
    public void setIncrementer(boolean isIncrementer) {
        this.isIncrementer = isIncrementer;
    }

    @Override
    public UIFieldFormatterIFace.PartialDateEnum getPartialDateType() {
        return this.partialDateType;
    }

    @Override
    public void setPartialDateType(UIFieldFormatterIFace.PartialDateEnum partialDateType) {
        this.partialDateType = partialDateType;
    }

    @Override
    public int getLength() {
        if (this.fieldLength == null) {
            int len = 0;
            for (UIFieldFormatterField field : this.fields) {
                len += field.getSize();
            }
            this.fieldLength = len;
        }
        return this.fieldLength;
    }

    @Override
    public void resetLength() {
        this.fieldLength = null;
    }

    @Override
    public int getUILength() {
        return this.getLength();
    }

    @Override
    public Pair<Integer, Integer> getIncPosition() {
        int len = 0;
        for (UIFieldFormatterField field : this.fields) {
            if (field.isIncrementer()) {
                return new Pair<Integer, Integer>(len, len + field.getSize());
            }
            len += field.getSize();
        }
        return null;
    }

    @Override
    public Pair<Integer, Integer> getYearPosition() {
        int len = 0;
        for (UIFieldFormatterField field : this.fields) {
            if (field.getType() == UIFieldFormatterField.FieldType.year) {
                return new Pair<Integer, Integer>(len, len + field.getSize());
            }
            len += field.getSize();
        }
        return null;
    }

    @Override
    public String toPattern() {
        StringBuilder str = new StringBuilder();
        for (UIFieldFormatterField field : this.fields) {
            str.append(field.getValue());
        }
        return str.toString();
    }

    @Override
    public String getSample() {
        StringBuilder str = new StringBuilder();
        for (UIFieldFormatterField field : this.fields) {
            str.append(field.getSample());
        }
        return str.toString();
    }

    @Override
    public DateWrapper getDateWrapper() {
        return this.dateWrapper;
    }

    public void setDateWrapper(DateWrapper dateWrapper) {
        this.dateWrapper = dateWrapper;
    }

    @Override
    public boolean isFromUIFormatter() {
        return false;
    }

    @Override
    public Object formatFromUI(Object data) {
        return data;
    }

    @Override
    public AutoNumberIFace getAutoNumber() {
        return this.autoNumber;
    }

    @Override
    public void setAutoNumber(AutoNumberIFace autoNumber) {
        this.autoNumber = autoNumber;
    }

    @Override
    public String getNextNumber(String value) {
        return this.getNextNumber(value, false);
    }

    @Override
    public String getNextNumber(String value, boolean incrementValue) {
        if (this.autoNumber != null) {
            String number = this.autoNumber.getNextNumber(this, value, incrementValue);
            if (number == null && this.autoNumber.isInError()) {
                UIRegistry.showError(this.autoNumber.getErrorMsg());
            } else {
                return number;
            }
        }
        return null;
    }

    @Override
    public Object formatToUI(Object ... datas) {
        Object data = datas[0];
        boolean isStr = data instanceof String;
        if (this.autoNumber != null && isStr && StringUtils.isEmpty((String)((String)data))) {
            Pair<Integer, Integer> pos;
            String pattern = this.toPattern();
            UIFieldFormatterField yearField = this.getYear();
            if (yearField != null && (pos = this.getYearPosition()) != null) {
                StringBuilder sb = new StringBuilder(pattern);
                Calendar cal = Calendar.getInstance();
                sb.replace((Integer)pos.first, (Integer)pos.second, Integer.toString(cal.get(1)));
                return sb.toString();
            }
            return pattern;
        }
        if (data instanceof Number) {
            int size = this.fields.get(0).getSize();
            String fmt = data instanceof Float || data instanceof Double ? "%" + (size - 2) + ".2f" : (data instanceof BigDecimal ? "%" + (size - 2) + ".2f" : "%d");
            return String.format(fmt, data).trim();
        }
        if (data instanceof Calendar) {
            return scrDateFormat.format((Calendar)data);
        }
        if (data instanceof Date) {
            return scrDateFormat.format((Date)data);
        }
        return data;
    }

    @Override
    public boolean isInBoundFormatter() {
        return this.autoNumber != null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getTitle());
        str.append(" [");
        for (UIFieldFormatterField field : this.fields) {
            String val = field.getValue();
            if (StringUtils.isEmpty((String)val)) {
                val = field.getSample();
            }
            str.append(val);
        }
        str.append("]");
        if (this.isSystem || this.isDefault) {
            str.append(" (");
            str.append(this.isDefault ? deftitle : "");
            str.append(this.isSystem ? String.valueOf(this.isDefault ? ", " : "") + systitle : "");
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public boolean isUserInputNeeded() {
        for (UIFieldFormatterField f : this.fields) {
            UIFieldFormatterField.FieldType typ = f.getType();
            if (typ == UIFieldFormatterField.FieldType.alphanumeric || typ == UIFieldFormatterField.FieldType.alpha) {
                return true;
            }
            if (typ == UIFieldFormatterField.FieldType.numeric && !f.isIncrementer()) {
                return true;
            }
            if (typ != UIFieldFormatterField.FieldType.year) continue;
            return true;
        }
        return false;
    }

    public UIFieldFormatterIFace.FormatterType getType() {
        return this.type;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public boolean isValid(String text) {
        return UIFieldFormatter.isValid(this, text, false);
    }

    protected static boolean isLeapYear(int year) {
        if (year % 4 == 0) {
            if (year % 100 == 0 && year % 400 == 0) {
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean isDateValid(UIFieldFormatterIFace formatter, String text) {
        UIFieldFormatterField month = null;
        UIFieldFormatterField day = null;
        UIFieldFormatterField year = null;
        int monthInx = 0;
        int dayInx = 0;
        int yearInx = 0;
        int inx = 0;
        for (UIFieldFormatterField field : formatter.getFields()) {
            if (month == null && field.getValue().equals("MM")) {
                month = field;
                monthInx = inx;
            } else if (day == null && field.getValue().equals("DD")) {
                day = field;
                dayInx = inx;
            } else if (year == null && field.getValue().equals("YYYY")) {
                year = field;
                yearInx = inx;
            }
            inx += field.getSize();
        }
        int yearVal = -1;
        if (year != null) {
            String val = text.substring(yearInx, yearInx + year.getSize());
            if (StringUtils.isNumericSpace((String)val)) {
                yearVal = Integer.parseInt(val);
                if (yearVal == 0 || yearVal > 2500) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (month != null) {
            int monVal = 0;
            String val = text.substring(monthInx, monthInx + month.getSize()).trim();
            if (StringUtils.isNumericSpace((String)val)) {
                monVal = Integer.parseInt(val);
                if (monVal < 1 || monVal > 12) {
                    return false;
                }
            } else {
                return false;
            }
            if (day != null) {
                UIFieldFormatter.daysInMon[1] = UIFieldFormatter.isLeapYear(yearVal) ? 29 : 28;
                val = text.substring(dayInx, dayInx + day.getSize());
                if (StringUtils.isNumericSpace((String)val)) {
                    int dayVal = Integer.parseInt(val);
                    if (dayVal < 1 || dayVal > daysInMon[monVal - 1]) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isValid(UIFieldFormatterIFace formatter, String text, boolean doValidateAll) {
        block15: {
            int txtLen;
            if (!StringUtils.isNotEmpty((String)text) || !formatter.isLengthOK(txtLen = text.length())) break block15;
            if (formatter.isDate()) {
                return UIFieldFormatter.isDateValid(formatter, text);
            }
            int inx = 0;
            int pos = 0;
            for (UIFieldFormatterField field : formatter.getFields()) {
                block17: {
                    block16: {
                        if (pos >= txtLen) break block16;
                        if (field.isIncrementer() && !doValidateAll) break block17;
                        String val = text.substring(pos, Math.min(pos + field.getSize(), txtLen));
                        switch (field.getType()) {
                            case numeric: {
                                String str1 = StringUtils.remove((String)val, (char)'.');
                                String str2 = StringUtils.remove((String)str1, (char)'-');
                                if (StringUtils.isNumeric((String)str2)) {
                                    Class<?> cls = formatter.getDataClass();
                                    if (cls == Integer.class || cls == Long.class || cls == Short.class || cls == Byte.class) {
                                        return str1.length() == val.length();
                                    }
                                    return true;
                                }
                                return false;
                            }
                            case alphanumeric: {
                                if (!StringUtils.isAlphanumeric((String)val)) {
                                    return false;
                                }
                                break block17;
                            }
                            case alpha: {
                                if (!StringUtils.isAlpha((String)val)) {
                                    return false;
                                }
                                break block17;
                            }
                            case year: {
                                if (!StringUtils.isNumeric((String)val)) {
                                    return false;
                                }
                                int year = Integer.parseInt(val);
                                return year > 0 && year < 2100;
                            }
                            case separator: 
                            case constant: {
                                if (!val.equals(field.getValue())) {
                                    return false;
                                }
                                break block17;
                            }
                        }
                        break block17;
                    }
                    return false;
                }
                pos += field.getSize();
                ++inx;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isLengthOK(int lengthOfData) {
        if (this.type == UIFieldFormatterIFace.FormatterType.numeric) {
            return lengthOfData < this.getLength();
        }
        return lengthOfData == this.getLength();
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("  <format");
        XMLHelper.xmlAttr(sb, "system", this.isSystem);
        XMLHelper.xmlAttr(sb, "name", this.name);
        if (this.dataClass != null) {
            XMLHelper.xmlAttr(sb, "class", this.dataClass.getName());
        }
        if (StringUtils.isNotEmpty((String)this.fieldName) && !this.fieldName.equals("*")) {
            XMLHelper.xmlAttr(sb, "fieldname", this.fieldName);
        }
        if (this.isDefault) {
            XMLHelper.xmlAttr(sb, "default", this.isDefault);
        }
        if (this.type != UIFieldFormatterIFace.FormatterType.generic && this.type != null) {
            XMLHelper.xmlAttr(sb, "type", this.type.toString());
        }
        if (this.partialDateType != null && this.partialDateType != UIFieldFormatterIFace.PartialDateEnum.None) {
            XMLHelper.xmlAttr(sb, "partialdate", this.partialDateType.toString());
        }
        sb.append(">\n");
        if (this.autoNumber != null) {
            this.autoNumber.toXML(sb);
        }
        if (this.type != UIFieldFormatterIFace.FormatterType.date) {
            for (UIFieldFormatterField field : this.fields) {
                field.toXML(sb);
            }
        }
        if (this.isExternal) {
            sb.append("    <external>");
            sb.append("    <external>");
            sb.append("    </extneral>\n");
        }
        sb.append("  </format>\n\n");
    }

    public void setSystem(boolean isSystem) {
        this.isSystem = isSystem;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public void setType(UIFieldFormatterIFace.FormatterType type) {
        this.type = type;
    }

    @Override
    public boolean hasDash() {
        if (this.hasDash == null) {
            this.hasDash = false;
            for (UIFieldFormatterField fld : this.getFields()) {
                if (!fld.isSeparator() && !fld.isConstant() || !fld.getValue().equals("-")) continue;
                this.hasDash = true;
                break;
            }
        }
        return this.hasDash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UIFieldFormatter uif = (UIFieldFormatter)super.clone();
        uif.fields = new Vector();
        for (UIFieldFormatterField fld : this.fields) {
            uif.fields.add((UIFieldFormatterField)fld.clone());
        }
        return uif;
    }
}

