/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory;
import edu.ku.brc.af.ui.forms.validation.TypeSearchInfo;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValTextArea;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QueryComboboxEditor
extends CustomDialog {
    private static final String UIF_NAME = "uiFieldFormatterNameCBX";
    private static final String DOF_NAME = "dataObjFormatterNameCBX";
    private static final String TBL_NAME = "tableCBX";
    protected JList list;
    protected EditDeleteAddPanel edaPanel;
    protected Vector<TypeSearchInfo> itemsList;

    public QueryComboboxEditor() throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), "Query Combobox Editor", true, 1, null);
    }

    @Override
    public void createUI() {
        this.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        super.createUI();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,2px,p"));
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryComboboxEditor.this.addItem();
            }
        };
        ActionListener delAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryComboboxEditor.this.delItem();
            }
        };
        ActionListener edtAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryComboboxEditor.this.editItem();
            }
        };
        this.itemsList = TypeSearchForQueryFactory.getInstance().getList();
        this.list = new JList<TypeSearchInfo>(this.itemsList);
        this.edaPanel = new EditDeleteAddPanel(edtAL, delAL, addAL);
        this.edaPanel.getAddBtn().setEnabled(true);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createScrollPane(this.list), cc.xy(1, 1));
        pb.add((Component)this.edaPanel, cc.xy(1, 3));
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    QueryComboboxEditor.this.updateUI();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    QueryComboboxEditor.this.editItem();
                }
            }
        });
        this.setSize(300, 350);
    }

    protected void updateUI() {
        int inx = this.list.getSelectedIndex();
        this.edaPanel.getAddBtn().setEnabled(true);
        if (inx > -1) {
            TypeSearchInfo tsi = (TypeSearchInfo)this.list.getSelectedValue();
            this.edaPanel.getDelBtn().setEnabled(tsi.isSystem() == false);
        }
        this.edaPanel.getEditBtn().setEnabled(inx > -1);
    }

    private void editItem() {
        TypeSearchInfo tsi;
        int inx = this.list.getSelectedIndex();
        if (inx > -1 && this.edit(tsi = (TypeSearchInfo)this.list.getSelectedValue(), false)) {
            TypeSearchForQueryFactory.getInstance().save();
        }
    }

    private void addItem() {
        TypeSearchInfo tsi = new TypeSearchInfo(-1, null, null, null, null, null, null, false);
        while (this.edit(tsi, true)) {
            if (TypeSearchForQueryFactory.getInstance().getHash().get(tsi.getName()) != null) continue;
            TypeSearchForQueryFactory.getInstance().save();
            break;
        }
    }

    private void delItem() {
        TypeSearchInfo tsi;
        int inx = this.list.getSelectedIndex();
        if (inx > -1 && !(tsi = (TypeSearchInfo)this.list.getSelectedValue()).isSystem().booleanValue()) {
            TypeSearchForQueryFactory.getInstance().remove(tsi);
            TypeSearchForQueryFactory.getInstance().save();
            this.list.remove(inx);
        }
    }

    protected boolean edit(final TypeSearchInfo tsi, final boolean isNewItem) {
        boolean isOK;
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Dialog)UIRegistry.getMostRecentWindow(), "SystemSetup", "TypeSearchInfo", null, UIRegistry.getResourceString(UIRegistry.getResourceString("EDIT")), "OK", null, null, true, 792);
        dlg.setHelpContext("CHANGE_PWD");
        dlg.setWhichBtns(3);
        dlg.setFormAdjuster(new FormPane.FormPaneAdjusterIFace(){

            @Override
            public void adjustForm(FormViewObj fvo) {
                QueryComboboxEditor.this.adjustDlgForm(tsi, isNewItem, fvo);
            }
        });
        dlg.setData(tsi);
        UIHelper.centerAndShow(dlg);
        boolean bl = isOK = !dlg.isCancelled();
        if (isOK) {
            FormViewObj fvo = dlg.getMultiView().getCurrentViewAsFormViewObj();
            ValComboBox uifCBX = (ValComboBox)fvo.getCompById(UIF_NAME);
            UIFieldFormatterIFace uif = (UIFieldFormatterIFace)uifCBX.getValue();
            tsi.setUiFieldFormatterName(uif != null ? uif.getName() : null);
            ValComboBox dofCBX = (ValComboBox)fvo.getCompById(DOF_NAME);
            DataObjSwitchFormatter dof = (DataObjSwitchFormatter)dofCBX.getValue();
            tsi.setDataObjFormatterName(dof != null ? dof.getName() : null);
            ValComboBox tableCBX = (ValComboBox)fvo.getCompById(TBL_NAME);
            DBTableInfo tblInfo = (DBTableInfo)tableCBX.getValue();
            tsi.setTableId(tblInfo.getTableId());
            fvo.getDataFromUI();
        }
        return isOK;
    }

    private void adjustDlgForm(TypeSearchInfo tsi, final boolean isNewItem, FormViewObj fvo) {
        final ValTextField nameTF = (ValTextField)fvo.getCompById("name");
        final ValTextArea dispColsTF = (ValTextArea)fvo.getCompById("displayColumns");
        if (tsi.isSystem().booleanValue()) {
            ViewFactory.changeTextFieldUIForDisplay(nameTF, false);
        }
        final ValComboBox tableCBX = (ValComboBox)fvo.getCompById(TBL_NAME);
        final Vector<DBTableInfo> tableList = new Vector<DBTableInfo>(DBTableIdMgr.getInstance().getTables());
        Collections.sort(tableList);
        tableCBX.setModel(new DefaultComboBoxModel<DBTableInfo>(tableList));
        if (tableList.size() > 0) {
            int i = 0;
            int inx = -1;
            for (DBTableInfo tbl : tableList) {
                if (tbl.getTableId() == tsi.getTableId()) {
                    inx = i;
                    break;
                }
                ++i;
            }
            tableCBX.getComboBox().setSelectedIndex(inx);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (tableList.size() == 0 || !isNewItem) {
                    tableCBX.getComboBox().setEnabled(false);
                    nameTF.setEditable(isNewItem);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (tableList.size() == 0 || !isNewItem) {
                                dispColsTF.requestFocus();
                            }
                        }
                    });
                }
            }
        });
        final ValComboBox uiFmtCbx = (ValComboBox)fvo.getCompById(UIF_NAME);
        Vector<UIFieldFormatterIFace> uiffList = new Vector<UIFieldFormatterIFace>(UIFieldFormatterMgr.getInstance().getFormatters());
        Collections.sort(uiffList, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        uiFmtCbx.setModel(new DefaultComboBoxModel<UIFieldFormatterIFace>(uiffList));
        if (uiffList.size() > 0) {
            int i = 0;
            int inx = -1;
            for (UIFieldFormatterIFace dof : uiffList) {
                if (dof.getName().equals(tsi.getUiFieldFormatterName())) {
                    inx = i;
                    break;
                }
                ++i;
            }
            uiFmtCbx.getComboBox().setSelectedIndex(inx);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    uiFmtCbx.getComboBox().setEnabled(false);
                }
            });
        }
        int tblId = tsi.getTableId();
        if (tblId > 0) {
            Class<?> cls = DBTableIdMgr.getInstance().getInfoById(tblId).getClassObj();
            List<DataObjSwitchFormatter> dofClsList = DataObjFieldFormatMgr.getInstance().getFormatterList(cls);
            final ValComboBox dataObjFmtCbx = (ValComboBox)fvo.getCompById(DOF_NAME);
            Vector<DataObjSwitchFormatter> dofList = new Vector<DataObjSwitchFormatter>(dofClsList);
            dataObjFmtCbx.setModel(new DefaultComboBoxModel<DataObjSwitchFormatter>(dofList));
            if (dofList.size() > 0) {
                int i = 0;
                int inx = -1;
                for (DataObjSwitchFormatter dof : dofList) {
                    if (dof.getName().equals(tsi.getDataObjFormatterName())) {
                        inx = i;
                        break;
                    }
                    ++i;
                }
                dataObjFmtCbx.getComboBox().setSelectedIndex(inx);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dataObjFmtCbx.getComboBox().setEnabled(false);
                    }
                });
            }
        }
    }
}

