/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.specify.ui.BaseUIFieldFormatter;
import edu.ku.brc.util.Pair;
import java.util.Vector;

public class GenericStringUIFieldFormatter
extends BaseUIFieldFormatter {
    private Class<?> dataClass;

    public GenericStringUIFieldFormatter(String name, Class<?> tableClass, String fieldName, String localizedTitle, int uiDisplayLen) {
        this.name = name;
        this.title = localizedTitle;
        DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(tableClass.getSimpleName());
        DBFieldInfo fi = ti.getFieldByName(fieldName);
        this.dataClass = tableClass;
        this.length = fi.getLength();
        this.uiLength = uiDisplayLen;
        this.isNumericCatalogNumber = false;
        this.isIncrementer = false;
        this.autoNumber = null;
        this.pattern = UIFieldFormatterMgr.getFormatterPattern(this.isIncrementer, UIFieldFormatterField.FieldType.anychar, this.length);
        this.field = new UIFieldFormatterField(UIFieldFormatterField.FieldType.anychar, this.length, this.pattern, this.isIncrementer, false);
        this.fields = new Vector();
        this.fields.add(this.field);
        this.incPos = new Pair<Integer, Integer>(0, this.length);
    }

    @Override
    public boolean isLengthOK(int lengthOfData) {
        return lengthOfData < this.length;
    }

    @Override
    public Class<?> getDataClass() {
        return this.dataClass;
    }
}

