/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DefEditDeleteAddPanel;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class FmtListEditorDlgBase
extends CustomDialog {
    protected DBInfoBase baseInfo;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected boolean hasChanged = false;
    protected JList list;
    protected DefaultListModel listModel;
    protected DefEditDeleteAddPanel dedaPanel;

    public FmtListEditorDlgBase(Frame frame, String titleKey, String helpContext, DBInfoBase baseInfo, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache) throws HeadlessException {
        super(frame, UIRegistry.getResourceString(titleKey), true, 5, null);
        this.baseInfo = baseInfo;
        this.dataObjFieldFormatMgrCache = dataObjFieldFormatMgrCache;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.helpContext = helpContext;
        this.okLabel = UIRegistry.getResourceString("CLOSE");
    }

    @Override
    public void createUI() {
        super.createUI();
        CellConstraints cc = new CellConstraints();
        PanelBuilder tblInfoPB = new PanelBuilder(new FormLayout("p,p:g", "p"));
        JLabel tableTitleLbl = UIHelper.createI18NFormLabel("FmtListEditorBase." + (this.baseInfo instanceof DBTableInfo ? "TABLE" : "FIELD"));
        JLabel tableTitleValueLbl = UIHelper.createLabel(this.baseInfo.getTitle());
        tableTitleValueLbl.setBackground(Color.WHITE);
        tableTitleValueLbl.setOpaque(true);
        tblInfoPB.add((Component)tableTitleLbl, cc.xy(1, 1));
        tblInfoPB.add((Component)tableTitleValueLbl, cc.xy(2, 1));
        this.createList();
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmtListEditorDlgBase.this.addItem();
            }
        };
        ActionListener delAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmtListEditorDlgBase.this.deleteSelectedItem();
            }
        };
        ActionListener edtAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmtListEditorDlgBase.this.editItem(FmtListEditorDlgBase.this.list.getSelectedValue(), false);
            }
        };
        ActionListener defAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmtListEditorDlgBase.this.setDefaultItem();
            }
        };
        String[] toolTipKeys = this.getDEDAToolTipKeys();
        this.dedaPanel = new DefEditDeleteAddPanel(defAL, edtAL, delAL, addAL, toolTipKeys[0], toolTipKeys[1], toolTipKeys[2], toolTipKeys[3]);
        this.dedaPanel.getAddBtn().setEnabled(true);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:max(250px;p):g", "p,6px,f:max(250px;p):g,2px,p"));
        int y = 1;
        pb.add((Component)tblInfoPB.getPanel(), cc.xy(1, y));
        pb.add((Component)UIHelper.createScrollPane(this.list), cc.xy(1, y += 2));
        pb.add((Component)this.dedaPanel, cc.xy(1, y += 2));
        y += 2;
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.updateUIEnabled();
        this.pack();
    }

    protected void createList() {
        this.listModel = this.createListDataModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        ListCellRenderer cellRenderer = this.getListCellRenderer();
        if (cellRenderer != null) {
            this.list.setCellRenderer(cellRenderer);
        }
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FmtListEditorDlgBase.this.updateUIEnabled();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    FmtListEditorDlgBase.this.editItem(FmtListEditorDlgBase.this.list.getSelectedValue(), false);
                }
            }
        });
    }

    protected ListCellRenderer getListCellRenderer() {
        return null;
    }

    protected abstract String[] getDEDAToolTipKeys();

    protected abstract DefaultListModel createListDataModel();

    protected abstract void deleteSelectedItem();

    protected abstract void editItem(Object var1, boolean var2);

    protected abstract void setDefaultItem();

    protected abstract void addItem();

    protected void updateUIEnabled() {
        Object item = this.list.getSelectedValue();
        this.dedaPanel.getDelBtn().setEnabled(item != null);
        this.dedaPanel.getDefBtn().setEnabled(item != null);
        this.dedaPanel.getEditBtn().setEnabled(item != null);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        if (this.hasChanged != hasChanged) {
            this.setWindowModified(hasChanged);
        }
        this.hasChanged = hasChanged;
        this.updateUIEnabled();
    }
}

