/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIHelper;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataObjSwitchFormatter
implements Comparable<DataObjSwitchFormatter>,
Cloneable {
    protected static final Logger log = Logger.getLogger(DataObjSwitchFormatter.class);
    protected String name;
    protected String title;
    protected boolean isSingle;
    protected boolean isDefault;
    protected Class<?> dataClass;
    protected String fieldName;
    protected DBFieldInfo fieldInfo;
    protected DataObjDataFieldFormatIFace single = null;
    protected Vector<DataObjDataFieldFormatIFace> formatsVector = new Vector();
    protected DBTableInfo tableInfo = null;

    public DataObjSwitchFormatter(String name, String title, boolean isSingle, boolean isDefault, Class<?> dataClass, String fieldName) {
        this.name = name;
        this.title = title;
        this.isSingle = isSingle;
        this.isDefault = isDefault;
        this.dataClass = dataClass;
        this.fieldName = fieldName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    public void setSingle(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public void setSingle(DataObjDataFieldFormatIFace single) {
        this.single = single;
    }

    public void clearFields() {
        this.single = null;
        this.formatsVector.clear();
    }

    public void add(DataObjDataFieldFormatIFace dff) {
        if (this.isSingle) {
            this.single = dff;
        } else {
            this.formatsVector.add(dff);
        }
    }

    public void set(int index, DataObjDataFieldFormatIFace dff) {
        if (this.formatsVector.size() == 0 || index > this.formatsVector.size()) {
            this.formatsVector.add(dff);
        } else {
            this.formatsVector.set(index, dff);
        }
    }

    public void remove(DataObjDataFieldFormatIFace dff) {
        if (!this.isSingle && this.formatsVector != null) {
            this.formatsVector.remove(dff);
        }
    }

    public DataObjDataFieldFormatIFace getFormatterForValue(String value) {
        if (this.isSingle) {
            return this.single;
        }
        for (DataObjDataFieldFormatIFace field : this.formatsVector) {
            if (!field.getValue().equals(value)) continue;
            return field;
        }
        return null;
    }

    public boolean hasFormatters() {
        return this.isSingle && this.single != null || this.formatsVector != null && this.formatsVector.size() > 0;
    }

    public Collection<DataObjDataFieldFormatIFace> getFormatters() {
        if (this.isSingle) {
            Vector<DataObjDataFieldFormatIFace> vector = new Vector<DataObjDataFieldFormatIFace>();
            if (this.single != null) {
                vector.add(this.single);
            }
            return vector;
        }
        return this.formatsVector;
    }

    protected DataObjDataFieldFormatIFace getDataFormatter(Object dataObj) {
        DataObjDataFieldFormatIFace dff = null;
        if (dataObj != null) {
            if (this.isSingle()) {
                return this.getFormatterForValue(null);
            }
            DataObjectGettable getter = DataObjectGettableFactory.get(dataObj.getClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            Object[] values = UIHelper.getFieldValues(new String[]{this.getFieldName()}, dataObj, getter);
            if (values != null) {
                String value = values[0] != null ? values[0].toString() : "null";
                dff = this.getFormatterForValue(value);
                if (dff == null) {
                    log.error((Object)("Couldn't find a switchable data formatter for [" + this.getName() + "] field[" + this.getFieldName() + "] value[" + value + "]"));
                }
            } else {
                throw new RuntimeException("Values Array was null for Class[" + dataObj.getClass().getSimpleName() + "] couldn't find field[" + this.getFieldName() + "] (you probably passed in the wrong type of object)");
            }
        }
        return dff;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String toString() {
        return StringUtils.isNotEmpty((String)this.title) ? this.title : (StringUtils.isNotEmpty((String)this.name) ? this.name : "");
    }

    public String getName() {
        return this.name;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public DataObjDataFieldFormatIFace getSingle() {
        return this.single;
    }

    public boolean isDirectFormatter() {
        return false;
    }

    public String format(Object dataObj) {
        throw new RuntimeException("This method cannot be called on this type of object[" + this.name + "][" + dataObj.getClass().getSimpleName() + "]");
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public DBTableInfo getTableInfo() {
        if (this.tableInfo == null) {
            this.tableInfo = DBTableIdMgr.getInstance().getByClassName(this.dataClass.getName());
            if (this.tableInfo == null) {
                log.error((Object)("No DBTableInfo for class[" + this.dataClass.getName() + "]"));
            }
        }
        return this.tableInfo;
    }

    public void setTableAndFieldInfo() {
        if (StringUtils.isNotEmpty((String)this.fieldName)) {
            DBTableInfo tableInfo = this.getTableInfo();
            this.fieldInfo = tableInfo.getFieldByName(this.fieldName);
        }
        if (this.single != null) {
            this.single.setTableAndFieldInfo();
            return;
        }
        if (this.formatsVector.size() == 0) {
            return;
        }
        for (DataObjDataFieldFormatIFace format : this.formatsVector) {
            format.setTableAndFieldInfo();
        }
    }

    public void toXML(StringBuilder sb) {
        String spaces = "       ";
        sb.append("    <format\n");
        sb.append(spaces);
        XMLHelper.xmlAttr(sb, "name", this.name);
        sb.append("\n");
        sb.append(spaces);
        XMLHelper.xmlAttr(sb, "title", this.title);
        if (this.dataClass != null) {
            sb.append("\n");
            sb.append(spaces);
            XMLHelper.xmlAttr(sb, "class", this.dataClass.getName());
        }
        if (this.isDefault) {
            sb.append("\n");
            sb.append(spaces);
            XMLHelper.xmlAttr(sb, "default", this.isDefault);
        }
        sb.append("\n");
        sb.append(spaces);
        sb.append(" >\n");
        sb.append(spaces);
        sb.append(" <switch");
        XMLHelper.xmlAttr(sb, "single", this.isSingle);
        XMLHelper.xmlAttr(sb, "field", this.fieldName);
        sb.append(">\n");
        if (this.isSingle && this.single != null) {
            this.single.toXML(sb);
        } else {
            for (DataObjDataFieldFormatIFace field : this.formatsVector) {
                field.toXML(sb);
            }
        }
        sb.append(spaces);
        sb.append(" </switch>\n");
        sb.append("    </format>\n\n");
    }

    protected Object clone() throws CloneNotSupportedException {
        DataObjSwitchFormatter dfo = (DataObjSwitchFormatter)super.clone();
        dfo.formatsVector = new Vector();
        for (DataObjDataFieldFormatIFace dodf : this.formatsVector) {
            DataObjDataFieldFormatIFace ddf = (DataObjDataFieldFormatIFace)dodf.clone();
            ddf.setDataObjSwitchFormatter(dfo);
            dfo.formatsVector.add(ddf);
        }
        if (dfo.single != null) {
            dfo.single = (DataObjDataFieldFormatIFace)this.single.clone();
            dfo.single.setDataObjSwitchFormatter(dfo);
        }
        return dfo;
    }

    @Override
    public int compareTo(DataObjSwitchFormatter o) {
        return this.name.compareTo(o.name);
    }
}

