/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.formatters.AvailableFieldsComponent;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormat;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldWrapper;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatPanel;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatterContainerIface;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFormatterListEdtDlg;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;

public class DataObjFieldFormatSinglePanel
extends DataObjFieldFormatPanel {
    protected AvailableFieldsComponent availableFieldsComp;
    protected JTextPane formatEditor;
    protected JButton addFieldBtn;
    protected JTextField sepText;
    protected JLabel sepLbl;
    protected Set<String> uniqueNameSet = new HashSet<String>();
    protected SimpleAttributeSet normalAttr;
    protected SimpleAttributeSet fieldDefAttr;
    protected boolean ignoreFmtChange = false;

    public DataObjFieldFormatSinglePanel(DBTableInfo tableInfo, DataObjSwitchFormatterContainerIface formatContainer, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache, ChangeListener listener, JButton okButton) {
        super(tableInfo, formatContainer, dataObjFieldFormatMgrCache, uiFieldFormatterMgrCache, listener, okButton);
    }

    @Override
    protected void buildUI() {
        CellConstraints cc = new CellConstraints();
        JLabel currentFieldsLbl = UIHelper.createI18NLabel("DOF_DISPLAY_FORMAT");
        this.formatEditor = new JTextPane();
        this.formatEditor.setMinimumSize(new Dimension(200, 50));
        this.formatEditor.setPreferredSize(new Dimension(350, 100));
        this.formatEditor.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            public void changed(DocumentEvent e) {
                DataObjFieldFormatSinglePanel.this.updateUIEnabled();
            }
        });
        PanelBuilder addFieldPB = new PanelBuilder(new FormLayout("p,2px,p,f:p:g,r:m", "p,2px,p"));
        this.sepText = UIHelper.createTextField(4);
        this.addFieldBtn = UIHelper.createButton(UIRegistry.getResourceString("DOF_ADD_FIELD"));
        this.sepLbl = UIHelper.createI18NFormLabel("DOF_SEP_TXT");
        addFieldPB.add((Component)this.sepLbl, cc.xy(1, 1));
        addFieldPB.add((Component)this.sepText, cc.xy(3, 1));
        addFieldPB.add((Component)this.addFieldBtn, cc.xy(5, 1));
        this.sepText.setDocument(new FilteredDoc());
        this.addFieldBtn.setEnabled(false);
        this.sepLbl.setEnabled(false);
        this.sepText.setEnabled(false);
        if (AppPreferences.hasRemotePrefs()) {
            this.sepText.setText(AppPreferences.getRemote().get("DOF_SEP", ", "));
        } else {
            this.sepText.setText(", ");
        }
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:d:g", "10px,p,f:p:g,2px,p,10px,p,f:250px:g,"), (JPanel)this);
        int y = 2;
        pb.add((Component)currentFieldsLbl, cc.xy(1, y));
        pb.add((Component)UIHelper.createScrollPane(this.formatEditor), cc.xy(1, ++y));
        pb.add((Component)addFieldPB.getPanel(), cc.xy(1, y += 2));
        JLabel availableFieldsLbl = UIHelper.createI18NFormLabel("DOF_AVAILABLE_FIELDS", 2);
        pb.add((Component)availableFieldsLbl, cc.xy(1, y += 2));
        this.availableFieldsComp = new AvailableFieldsComponent(this.tableInfo, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache);
        pb.add((Component)UIHelper.createScrollPane(this.availableFieldsComp.getTree()), cc.xy(1, ++y));
        y += 2;
        this.availableFieldsComp.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                boolean enable = DataObjFieldFormatSinglePanel.this.availableFieldsComp.getTree().getSelectionCount() > 0;
                DataObjFieldFormatSinglePanel.this.addFieldBtn.setEnabled(enable);
                DataObjFieldFormatSinglePanel.this.sepText.setEnabled(enable);
                DataObjFieldFormatSinglePanel.this.sepLbl.setEnabled(enable);
            }
        });
        this.mainPanelBuilder = pb;
        this.fillWithObjFormatter(this.formatContainer.getSelectedFormatter());
        this.addFormatTextListeners();
        this.addFieldListeners();
    }

    private void updateUIEnabled() {
        this.okButton.setEnabled(!this.isInError() && StringUtils.isNotEmpty((String)this.formatEditor.getText()));
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (!flag) {
            this.formatContainer.getSelectedFormatter().setSingle(null);
        }
    }

    public void addFieldListeners() {
        this.addFieldBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataObjFieldFormatSinglePanel.this.addField();
            }
        });
        this.availableFieldsComp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataObjFieldFormatSinglePanel.this.addField();
                }
            }
        });
    }

    public void addFormatTextListeners() {
        this.formatEditor.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                if (!DataObjFieldFormatSinglePanel.this.ignoreFmtChange) {
                    DataObjFieldFormatSinglePanel.this.formatChanged();
                }
            }
        });
        this.sepText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            void changed(DocumentEvent e) {
                if (AppPreferences.hasRemotePrefs()) {
                    AppPreferences.getRemote().put("DOF_SEP", DataObjFieldFormatSinglePanel.this.sepText.getText());
                }
            }
        });
    }

    public void formatChanged() {
        this.setFormatterFromTextPane(this.formatContainer.getSelectedFormatter());
        this.setHasChanged(true);
    }

    public void addField() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.availableFieldsComp.getTree().getLastSelectedPathComponent();
        if (node == null || !node.isLeaf() || !(node.getUserObject() instanceof DataObjDataFieldWrapper)) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj instanceof DataObjDataFieldWrapper) {
            DataObjDataFieldWrapper wrapper = (DataObjDataFieldWrapper)obj;
            String sep = this.sepText.getText();
            if (StringUtils.isNotEmpty((String)sep)) {
                try {
                    DefaultStyledDocument doc = (DefaultStyledDocument)this.formatEditor.getStyledDocument();
                    if (doc.getLength() > 0) {
                        doc.insertString(doc.getLength(), sep, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.insertFieldIntoTextEditor(wrapper);
            this.setHasChanged(true);
        }
    }

    @Override
    public void fillWithObjFormatter(DataObjSwitchFormatter switchFormatter) {
        if (switchFormatter != null) {
            this.fillWithObjFormatter(switchFormatter.getSingle());
        } else {
            this.fillWithObjFormatter((DataObjDataFieldFormatIFace)null);
        }
    }

    protected void fillWithObjFormatter(DataObjDataFieldFormatIFace singleFormatter) {
        this.ignoreFmtChange = true;
        try {
            this.formatEditor.setText("");
            if (singleFormatter == null) {
                return;
            }
            Document doc = this.formatEditor.getDocument();
            DataObjDataField[] fields = singleFormatter.getFields();
            if (fields == null) {
                return;
            }
            DataObjDataField[] dataObjDataFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                DataObjDataField field = dataObjDataFieldArray[n2];
                try {
                    doc.insertString(doc.getLength(), field.getSep(), null);
                    this.insertFieldIntoTextEditor(new DataObjDataFieldWrapper(field));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        finally {
            this.ignoreFmtChange = false;
        }
    }

    protected void insertFieldIntoTextEditor(DataObjDataFieldWrapper wrapper) {
        this.formatEditor.insertComponent(new FieldDefinitionComp(wrapper));
    }

    @Override
    public boolean isInError() {
        return super.isInError() || !this.formatContainer.getSelectedFormatter().hasFormatters();
    }

    protected void setFormatterFromTextPane(DataObjSwitchFormatter formatter) {
        DefaultStyledDocument doc = (DefaultStyledDocument)this.formatEditor.getStyledDocument();
        String text = this.formatEditor.getText();
        int docLen = doc.getLength();
        int lastFieldPos = 0;
        Vector<DataObjDataField> fields = new Vector<DataObjDataField>();
        int i = 0;
        while (i < docLen) {
            Element element = doc.getCharacterElement(i);
            AttributeSet attrs = element.getAttributes();
            Object obj = attrs.getAttribute(StyleConstants.ComponentAttribute);
            if (obj instanceof FieldDefinitionComp) {
                String sepStr = lastFieldPos <= i - 1 ? text.substring(lastFieldPos, i) : "";
                FieldDefinitionComp fieldDefBtn = (FieldDefinitionComp)obj;
                DataObjDataField fmtField = fieldDefBtn.getValue();
                fmtField.setSep(sepStr);
                fields.add(fmtField);
                lastFieldPos = i + 1;
            }
            ++i;
        }
        DataObjDataField[] fieldsArray = new DataObjDataField[fields.size()];
        int i2 = 0;
        while (i2 < fields.size()) {
            fieldsArray[i2] = (DataObjDataField)fields.elementAt(i2);
            ++i2;
        }
        DataObjDataFieldFormat singleFormatter = fieldsArray.length == 0 ? null : new DataObjDataFieldFormat("", this.tableInfo.getClassObj(), false, "", "", fieldsArray);
        formatter.setSingle(singleFormatter);
    }

    protected class FieldDefinitionComp
    extends JLabel {
        protected final DataObjDataFieldWrapper dataObjFieldWrapper;

        public FieldDefinitionComp(DataObjDataFieldWrapper dataObjFieldWrapper) {
            this.dataObjFieldWrapper = dataObjFieldWrapper;
            this.setText(dataObjFieldWrapper.toString());
            this.setCursor(Cursor.getDefaultCursor());
            this.setFont(new Font("Arial", 0, 11));
            this.setAlignmentY(0.75f);
            this.setBackground(new Color(0, 0, 0, 30));
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            final JPopupMenu menu = this.createPopupMenu();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FieldDefinitionComp thisBtn = FieldDefinitionComp.this;
                    menu.show(thisBtn, thisBtn.getWidth() / 2, thisBtn.getHeight());
                }
            });
        }

        public DataObjDataField getValue() {
            return this.dataObjFieldWrapper.getFormatterField();
        }

        public JPopupMenu createPopupMenu() {
            final JPopupMenu menu = new JPopupMenu();
            ActionListener placeCursorHereAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int pos = FieldDefinitionComp.this.findFieldButtonPosition();
                    ((FieldDefinitionComp)FieldDefinitionComp.this).DataObjFieldFormatSinglePanel.this.formatEditor.setCaretPosition(pos);
                }
            };
            JMenuItem item = new JMenuItem(UIRegistry.getResourceString("DOF_PLACE_CURSOR_HERE"));
            item.addActionListener(placeCursorHereAL);
            menu.add(item);
            ActionListener deleteMenuAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        int pos = FieldDefinitionComp.this.findFieldButtonPosition();
                        ((FieldDefinitionComp)FieldDefinitionComp.this).DataObjFieldFormatSinglePanel.this.formatEditor.getDocument().remove(pos, 1);
                        DataObjFieldFormatSinglePanel.this.updateUIEnabled();
                        DataObjFieldFormatSinglePanel.this.formatChanged();
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            item = new JMenuItem(UIRegistry.getResourceString("DOF_DELETE_FIELD"));
            item.addActionListener(deleteMenuAL);
            menu.add(item);
            this.createFormatterMenuItem(menu);
            MouseAdapter menuMA = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
            this.addMouseListener(menuMA);
            return menu;
        }

        public int findFieldButtonPosition() {
            DefaultStyledDocument doc = (DefaultStyledDocument)DataObjFieldFormatSinglePanel.this.formatEditor.getStyledDocument();
            int n = doc.getLength();
            Object obj = null;
            int i = 0;
            while (i < n) {
                Element element = doc.getCharacterElement(i);
                AttributeSet attrs = element.getAttributes();
                obj = attrs.getAttribute(StyleConstants.ComponentAttribute);
                if (obj == this) {
                    return i;
                }
                ++i;
            }
            throw new RuntimeException("Button representing field in text pane was not found.");
        }

        public void createFormatterMenuItem(JPopupMenu menu) {
            if (!this.dataObjFieldWrapper.isPureField()) {
                return;
            }
            ActionListener openFormatterAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBFieldInfo fi = FieldDefinitionComp.this.dataObjFieldWrapper.getFormatterField().getFieldInfo();
                    UIFormatterListEdtDlg dlg = new UIFormatterListEdtDlg((Frame)UIRegistry.getTopWindow(), fi, true, ((FieldDefinitionComp)FieldDefinitionComp.this).DataObjFieldFormatSinglePanel.this.uiFieldFormatterMgrCache);
                    dlg.setVisible(true);
                    if (dlg.getBtnPressed() == 1 && dlg.getSelectedFormat() != null) {
                        FieldDefinitionComp.this.setFormatter(dlg.getSelectedFormat());
                    }
                }
            };
            JMenuItem item = new JMenuItem(UIRegistry.getResourceString("DOF_CHANGE_FORMAT"));
            item.addActionListener(openFormatterAL);
            menu.add(item);
        }

        protected void setFormatter(UIFieldFormatterIFace fmt) {
            this.dataObjFieldWrapper.getFormatterField().setUiFieldFormatter(fmt);
        }
    }

    class FilteredDoc
    extends PlainDocument {
        @Override
        public void insertString(int offset, String strArg, AttributeSet attr) throws BadLocationException {
            if (!(StringUtils.contains((String)strArg, (char)'\'') || StringUtils.contains((String)strArg, (char)'\"') || StringUtils.contains((String)strArg, (char)'`'))) {
                super.insertString(offset, strArg, attr);
            }
        }
    }
}

