/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormat;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatPanel;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatSingleDlg;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatterContainerIface;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang.StringUtils;

public class DataObjFieldFormatMultiplePanel
extends DataObjFieldFormatPanel
implements ChangeListener {
    protected static final String FIELD_VALUE_COL = UIRegistry.getResourceString("DOF_FIELD_VALUE");
    protected static final String DISPLAY_FORMAT_COL = UIRegistry.getResourceString("DOF_DISPLAY_FORMAT");
    protected static final String ELLIPSIS_BUTTON_COL = "";
    protected final String ellipsisButtonLabel = "...";
    protected JTable formatSwitchTbl;
    protected EditDeleteAddPanel controlPanel;

    public DataObjFieldFormatMultiplePanel(DBTableInfo tableInfo, DataObjSwitchFormatterContainerIface formatContainer, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache, ChangeListener listener, JButton okButton) {
        super(tableInfo, formatContainer, dataObjFieldFormatMgrCache, uiFieldFormatterMgrCache, listener, okButton);
    }

    @Override
    protected void buildUI() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "10px,f:130px:g,10px,p,15px"), (JPanel)this);
        this.formatSwitchTbl = new JTable(new DefaultTableModel());
        this.formatSwitchTbl.getSelectionModel().addListSelectionListener(new RowListener());
        this.addTableModelListener((DefaultTableModel)this.formatSwitchTbl.getModel());
        this.fillWithObjFormatter(null);
        this.createToolbar();
        JScrollPane sp = UIHelper.createScrollPane(this.formatSwitchTbl);
        sp.setMinimumSize(new Dimension(50, 5));
        sp.setPreferredSize(new Dimension(50, 5));
        pb.add((Component)sp, cc.xy(1, 2));
        pb.add((Component)this.controlPanel, cc.xy(1, 4));
        this.mainPanelBuilder = pb;
    }

    public void enableUIControls() {
        this.okButton.setEnabled(!this.isInError());
        this.controlPanel.getDelBtn().setEnabled(this.formatSwitchTbl.getSelectedRowCount() > 0);
    }

    @Override
    public boolean isInError() {
        return super.isInError() || !this.isValidFormatter();
    }

    @Override
    public PanelBuilder getMainPanelBuilder() {
        return this.mainPanelBuilder;
    }

    protected void addTableModelListener(DefaultTableModel model) {
        TableModelListener tml = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                DefaultTableModel localModel = (DefaultTableModel)e.getSource();
                String columnName = localModel.getColumnName(column);
                if (columnName.equals(FIELD_VALUE_COL)) {
                    int formatColumn = DataObjFieldFormatMultiplePanel.this.formatSwitchTbl.getColumnModel().getColumnIndex(DISPLAY_FORMAT_COL);
                    DataObjDataFieldFormat format = (DataObjDataFieldFormat)localModel.getValueAt(row, formatColumn);
                    String value = (String)localModel.getValueAt(row, column);
                    format.setValue(value);
                    DataObjFieldFormatMultiplePanel.this.enableUIControls();
                }
            }
        };
        model.addTableModelListener(tml);
    }

    protected boolean isValidFormatter() {
        DefaultTableModel model = (DefaultTableModel)this.formatSwitchTbl.getModel();
        if (model.getRowCount() == 0) {
            return false;
        }
        HashSet<String> valueSet = new HashSet<String>();
        int i = 0;
        while (i < model.getRowCount()) {
            int j = 0;
            while (j <= 1) {
                Object obj = model.getValueAt(i, j);
                String value = obj.toString();
                if (obj == null || StringUtils.isEmpty((String)value)) {
                    return false;
                }
                if (j == 0) {
                    if (valueSet.contains(value)) {
                        return false;
                    }
                    valueSet.add(value);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private DefaultTableModel getCleanTableModel() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 1;
            }
        };
        model.addColumn(FIELD_VALUE_COL);
        model.addColumn(DISPLAY_FORMAT_COL);
        model.addColumn(ELLIPSIS_BUTTON_COL);
        this.addTableModelListener(model);
        return model;
    }

    private void createToolbar() {
        ActionListener addAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTableModel model = (DefaultTableModel)DataObjFieldFormatMultiplePanel.this.formatSwitchTbl.getModel();
                DataObjSwitchFormatter fmt = DataObjFieldFormatMultiplePanel.this.formatContainer.getSelectedFormatter();
                DataObjDataFieldFormat fld = new DataObjDataFieldFormat();
                fmt.add(fld);
                model.addRow(new Object[]{fld.getValue(), fld, "..."});
                DataObjFieldFormatMultiplePanel.this.setHasChanged(true);
                DataObjFieldFormatMultiplePanel.this.enableUIControls();
            }
        };
        ActionListener delAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int formatColumn = DataObjFieldFormatMultiplePanel.this.formatSwitchTbl.getColumn(DISPLAY_FORMAT_COL).getModelIndex();
                DefaultTableModel model = (DefaultTableModel)DataObjFieldFormatMultiplePanel.this.formatSwitchTbl.getModel();
                DataObjSwitchFormatter fmt = DataObjFieldFormatMultiplePanel.this.formatContainer.getSelectedFormatter();
                int[] rows = DataObjFieldFormatMultiplePanel.this.formatSwitchTbl.getSelectedRows();
                Integer[] intRows = new Integer[rows.length];
                int i = 0;
                while (i < rows.length) {
                    intRows[i] = new Integer(rows[i]);
                    ++i;
                }
                Arrays.sort(intRows, Collections.reverseOrder());
                Integer[] integerArray = intRows;
                int n = intRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int currentRow = integerArray[n2];
                    fmt.remove((DataObjDataFieldFormatIFace)model.getValueAt(currentRow, formatColumn));
                    model.removeRow(currentRow);
                    ++n2;
                }
                DataObjFieldFormatMultiplePanel.this.formatSwitchTbl.clearSelection();
                DataObjFieldFormatMultiplePanel.this.setHasChanged(true);
                DataObjFieldFormatMultiplePanel.this.enableUIControls();
            }
        };
        this.controlPanel = new EditDeleteAddPanel(null, delAL, addAL);
        this.controlPanel.getAddBtn().setEnabled(true);
    }

    @Override
    public void fillWithObjFormatter(DataObjSwitchFormatter switchFormatter) {
        DefaultTableModel model = this.getCleanTableModel();
        if (switchFormatter != null) {
            Vector<DataObjDataFieldFormatIFace> formatters = new Vector<DataObjDataFieldFormatIFace>(switchFormatter.getFormatters());
            for (DataObjDataFieldFormatIFace formatter : formatters) {
                model.addRow(new Object[]{formatter.getValue(), formatter, "..."});
            }
        }
        this.formatSwitchTbl.setModel(model);
        this.setFormatSwitchTblColumnProperties();
    }

    private void setFormatSwitchTblColumnProperties() {
        TableColumnModel model = this.formatSwitchTbl.getColumnModel();
        TableColumn column = model.getColumn(model.getColumnIndex(FIELD_VALUE_COL));
        column.setMinWidth(20);
        column.setMaxWidth(300);
        column.setPreferredWidth(70);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        column.setCellRenderer(renderer);
        column = model.getColumn(model.getColumnIndex(ELLIPSIS_BUTTON_COL));
        column.setCellRenderer(new EditDataObjFormatButtonRenderer());
        column.setCellEditor(new EditDataObjFormatButtonEditor(UIHelper.createCheckBox()));
        column.setMinWidth(20);
        column.setMaxWidth(20);
        column.setPreferredWidth(20);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.listener.stateChanged(e);
    }

    protected class EditDataObjFormatButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private boolean isPushed;
        private JTable table;
        private int row;

        public EditDataObjFormatButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button = UIHelper.createButton();
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDataObjFormatButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable tableArg, Object value, boolean isSelected, int rowArg, int column) {
            if (isSelected) {
                this.button.setForeground(tableArg.getSelectionForeground());
                this.button.setBackground(tableArg.getSelectionBackground());
            } else {
                this.button.setForeground(tableArg.getForeground());
                this.button.setBackground(tableArg.getBackground());
            }
            this.button.setText("...");
            this.isPushed = true;
            this.table = tableArg;
            this.row = rowArg;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            int formatCol;
            Object fieldObj;
            if (this.isPushed && (fieldObj = this.table.getValueAt(this.row, formatCol = this.table.getColumn(DISPLAY_FORMAT_COL).getModelIndex())) instanceof DataObjDataFieldFormatIFace) {
                DataObjDataFieldFormatIFace formatter = (DataObjDataFieldFormatIFace)fieldObj;
                DataObjFieldFormatSingleDlg dlg = new DataObjFieldFormatSingleDlg((Frame)UIRegistry.getTopWindow(), DataObjFieldFormatMultiplePanel.this.tableInfo, formatter, DataObjFieldFormatMultiplePanel.this.dataObjFieldFormatMgrCache, DataObjFieldFormatMultiplePanel.this.uiFieldFormatterMgrCache);
                dlg.setVisible(true);
                if (dlg.getBtnPressed() == 1) {
                    DataObjSwitchFormatter fmt = DataObjFieldFormatMultiplePanel.this.formatContainer.getSelectedFormatter();
                    DataObjDataFieldFormatIFace field = dlg.getSingleFormatter();
                    fmt.set(this.row, field);
                    this.table.setValueAt(field, this.row, formatCol);
                    int valueCol = this.table.getColumn(FIELD_VALUE_COL).getModelIndex();
                    String value = (String)this.table.getValueAt(this.row, valueCol);
                    field.setValue(value);
                    DataObjFieldFormatMultiplePanel.this.setHasChanged(true);
                    DataObjFieldFormatMultiplePanel.this.enableUIControls();
                }
            }
            this.isPushed = false;
            return new String("...");
        }

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    protected class EditDataObjFormatButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public EditDataObjFormatButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            this.setText("...");
            return this;
        }
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            DataObjFieldFormatMultiplePanel.this.enableUIControls();
        }
    }
}

