/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormat;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIHelper;
import java.io.File;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.LazyInitializationException;

public class DataObjFieldFormatMgr {
    public static final String factoryName = "edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr";
    protected static final Logger log = Logger.getLogger(DataObjFieldFormatMgr.class);
    protected static DataObjFieldFormatMgr instance = null;
    protected static boolean doingLocal = false;
    protected boolean domFound = false;
    protected Hashtable<String, DataObjSwitchFormatter> formatHash = new Hashtable();
    protected Hashtable<Class<?>, DataObjSwitchFormatter> formatClassHash = new Hashtable();
    protected Hashtable<String, DataObjAggregator> aggHash = new Hashtable();
    protected Hashtable<Class<?>, DataObjAggregator> aggClassHash = new Hashtable();
    protected Object[] args = new Object[2];
    protected Hashtable<String, Class<?>> typeHash = new Hashtable();
    protected Hashtable<Class<?>, String> typeHashRevMap = new Hashtable();
    protected String localFileName = null;
    protected boolean hasChanged = false;
    protected AppContextMgr appContextMgr = null;

    protected DataObjFieldFormatMgr() {
        this.init();
        this.load();
    }

    public DataObjFieldFormatMgr(AppContextMgr appContextMgr) {
        this.appContextMgr = appContextMgr;
        this.init();
        this.load();
    }

    public void reset() {
        if (instance != null) {
            instance.save();
        }
        instance = null;
    }

    private void init() {
        this.localFileName = "backstop" + File.separator + "dataobj_formatters.xml";
        Object[] initTypeData = new Object[]{"string", String.class, "int", Integer.class, "long", Long.class, "float", Float.class, "double", Double.class, "boolean", Boolean.class, "bigdecimal", BigDecimal.class, "short", Short.class, "byte", Byte.class};
        int i = 0;
        while (i < initTypeData.length) {
            this.typeHash.put((String)initTypeData[i], (Class)initTypeData[i + 1]);
            this.typeHashRevMap.put((Class)initTypeData[i + 1], (String)initTypeData[i]);
            ++i;
            ++i;
        }
    }

    public AppContextMgr getAppContextMgr() {
        if (this.appContextMgr == null) {
            this.appContextMgr = AppContextMgr.getInstance();
        }
        return this.appContextMgr;
    }

    public void setAppContextMgr(AppContextMgr appContextMgr) {
        this.appContextMgr = appContextMgr;
    }

    public String getStrForType(Class<?> cls) {
        return this.typeHashRevMap.get(cls);
    }

    public DataObjFieldFormatMgr(DataObjFieldFormatMgr source) {
        this.formatHash = (Hashtable)source.getFormatHash().clone();
        this.formatClassHash = (Hashtable)source.getFormatClassHash().clone();
        this.aggHash = (Hashtable)source.getAggHash().clone();
        this.aggClassHash = (Hashtable)source.getAggClassHash().clone();
    }

    public void copyFrom(DataObjFieldFormatMgr source) {
        this.hasChanged = source.hasChanged;
        this.setFormatHash(source.getFormatHash());
        this.setFormatClassHash(source.getFormatClassHash());
        this.setAggHash(source.getAggHash());
        this.setAggClassHash(source.getAggClassHash());
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public static void setDoingLocal(boolean doLocal) {
        doingLocal = doLocal;
    }

    protected Element getDOM() throws Exception {
        return XMLHelper.readDOMFromConfigDir("backstop/dataobj_formatters.xml");
    }

    protected void resetInternal() {
        this.formatHash.clear();
        this.formatClassHash.clear();
        this.aggHash.clear();
        this.aggClassHash.clear();
    }

    public void load() {
        this.resetInternal();
        try {
            Element root = this.getDOM();
            if (root != null) {
                String title;
                String name;
                this.domFound = true;
                List formatters = root.selectNodes("/formatters/format");
                for (Object formatObj : formatters) {
                    Element formatElement = (Element)formatObj;
                    name = formatElement.attributeValue("name");
                    title = formatElement.attributeValue("title");
                    String className = formatElement.attributeValue("class");
                    String format = formatElement.attributeValue("format");
                    boolean isDefault = XMLHelper.getAttr(formatElement, "default", false);
                    if (StringUtils.isEmpty((String)title)) {
                        title = name;
                    }
                    Class<?> dataClass = null;
                    if (StringUtils.isNotEmpty((String)className)) {
                        try {
                            dataClass = Class.forName(className);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(DataObjFieldFormatMgr.class, ex);
                            log.error((Object)("Couldn't load class [" + className + "]"));
                        }
                    } else {
                        log.error((Object)("Class name [" + className + "] is empty and can't be. Skipping."));
                        continue;
                    }
                    Element switchElement = (Element)formatElement.selectObject("switch");
                    if (switchElement != null) {
                        Element external;
                        boolean isSingle = XMLHelper.getAttr(switchElement, "single", false);
                        String switchField = XMLHelper.getAttr(switchElement, "field", null);
                        DataObjSwitchFormatter switchFormatter = new DataObjSwitchFormatter(name, title, isSingle, isDefault, dataClass, switchField);
                        if (this.formatHash.get(name) != null) {
                            throw new RuntimeException("Duplicate formatter name[" + name + "]");
                        }
                        this.formatHash.put(name, switchFormatter);
                        DataObjSwitchFormatter sf = this.formatClassHash.get(dataClass);
                        if (sf == null || isDefault) {
                            DataObjSwitchFormatter curDO;
                            if (isDefault && (curDO = this.formatClassHash.get(dataClass)) != null && curDO.isDefault()) {
                                throw new RuntimeException("There are two default DataObjectFormatters current [" + curDO.getName() + "] adding[" + sf.getName() + "] for class " + dataClass.getSimpleName());
                            }
                            this.formatClassHash.put(dataClass, switchFormatter);
                        }
                        if ((external = (Element)switchElement.selectSingleNode("external")) != null) {
                            String externalClassName = XMLHelper.getAttr(external, "class", null);
                            if (StringUtils.isNotEmpty((String)externalClassName)) {
                                Properties props = new Properties();
                                List paramElements = external.selectNodes("param");
                                for (Object param : paramElements) {
                                    String nameStr = XMLHelper.getAttr((Element)param, "name", null);
                                    String val = ((Element)param).getTextTrim();
                                    if (!StringUtils.isNotEmpty((String)nameStr) || !StringUtils.isNotEmpty((String)val)) continue;
                                    props.put(nameStr, val);
                                }
                                try {
                                    DataObjDataFieldFormatIFace fmt = Class.forName(externalClassName).asSubclass(DataObjDataFieldFormatIFace.class).newInstance();
                                    fmt.init(name, props);
                                    switchFormatter.add(fmt);
                                }
                                catch (Exception ex) {
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(DataObjFieldFormatMgr.class, ex);
                                    log.error((Object)ex);
                                    ex.printStackTrace();
                                }
                                continue;
                            }
                            throw new RuntimeException("The 'class' attribute cannot be empty for an external formatter! [" + name + "]");
                        }
                        DBTableInfo tableInfo = switchFormatter.getTableInfo();
                        List fieldsElements = switchElement.selectNodes("fields");
                        for (Object fieldsObj : fieldsElements) {
                            Element fieldsElement = (Element)fieldsObj;
                            String valueStr = XMLHelper.getAttr(fieldsElement, "value", null);
                            List fldList = fieldsElement.selectNodes("field");
                            DataObjDataField[] fields = new DataObjDataField[fldList.size()];
                            int inx = 0;
                            for (Object fldObj : fldList) {
                                DBRelationshipInfo relInfo;
                                Element fieldElement = (Element)fldObj;
                                String fieldName = fieldElement.getTextTrim();
                                String dataTypeStr = XMLHelper.getAttr(fieldElement, "type", null);
                                String formatStr = XMLHelper.getAttr(fieldElement, "format", null);
                                String sepStr = XMLHelper.getAttr(fieldElement, "sep", null);
                                String formatterName = XMLHelper.getAttr(fieldElement, "formatter", null);
                                String uifieldformatter = XMLHelper.getAttr(fieldElement, "uifieldformatter", null);
                                DBFieldInfo fieldInfo = tableInfo.getFieldByName(fieldName);
                                DBRelationshipInfo dBRelationshipInfo = relInfo = fieldInfo == null ? tableInfo.getRelationshipByName(fieldName) : null;
                                Class classObj = dataTypeStr == null ? (fieldInfo != null ? fieldInfo.getDataClass() : String.class) : this.typeHash.get(dataTypeStr);
                                if (classObj == null) {
                                    log.error((Object)("Couldn't map standard type[" + dataTypeStr + "]"));
                                }
                                fields[inx] = new DataObjDataField(fieldName, classObj, formatStr, sepStr, formatterName, uifieldformatter);
                                fields[inx].setDbInfo(tableInfo, fieldInfo, relInfo, true);
                                ++inx;
                            }
                            switchFormatter.add(new DataObjDataFieldFormat(name, dataClass, isDefault, format, valueStr, fields));
                        }
                        continue;
                    }
                    log.error((Object)("No switch element! [" + name + "]"));
                }
                for (Object aggObj : root.selectNodes("/formatters/aggregators/aggregator")) {
                    Element aggElement = (Element)aggObj;
                    name = aggElement.attributeValue("name");
                    title = aggElement.attributeValue("title");
                    String separator = aggElement.attributeValue("separator");
                    String countStr = aggElement.attributeValue("count");
                    String ending = aggElement.attributeValue("ending");
                    String format = aggElement.attributeValue("format");
                    String ordFldName = XMLHelper.getAttr(aggElement, "orderfieldname", null);
                    boolean isDefault = XMLHelper.getAttr(aggElement, "default", true);
                    String dataClassName = XMLHelper.getAttr(aggElement, "class", null);
                    Integer count = StringUtils.isNotEmpty((String)countStr) && StringUtils.isNumeric((String)countStr) ? Integer.valueOf(Integer.parseInt(countStr)) : null;
                    Class<?> dataClass = null;
                    if (StringUtils.isNotEmpty((String)dataClassName)) {
                        try {
                            dataClass = Class.forName(dataClassName);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(DataObjFieldFormatMgr.class, ex);
                            log.error((Object)("Couldn't load class [" + dataClassName + "]"));
                        }
                    } else {
                        log.error((Object)("Class name [" + dataClassName + "] is empty and can't be. Skipping."));
                        continue;
                    }
                    this.aggHash.put(name, new DataObjAggregator(name, title, dataClass, isDefault, separator, count, ending, format, ordFldName));
                }
            } else {
                log.debug((Object)"Couldn't get resource [DataObjFormatters]");
            }
            if (instance == null) {
                instance = this;
            }
            for (DataObjSwitchFormatter format : DataObjFieldFormatMgr.instance.formatHash.values()) {
                format.setTableAndFieldInfo();
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataObjFieldFormatMgr.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
    }

    public void applyChanges(DataObjFieldFormatMgr source) {
        if (source.hasChanged) {
            this.copyFrom(source);
            this.save();
        } else {
            log.debug((Object)"Not saved = No Changes");
        }
    }

    public void save() {
        DataObjFieldFormatMgr localInstance = DataObjFieldFormatMgr.getInstance();
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<formatters>\n");
        Vector<DataObjSwitchFormatter> formatVector = new Vector<DataObjSwitchFormatter>(localInstance.getFormatHash().values());
        Collections.sort(formatVector, new Comparator<DataObjSwitchFormatter>(){

            @Override
            public int compare(DataObjSwitchFormatter o1, DataObjSwitchFormatter o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (DataObjSwitchFormatter format : formatVector) {
            format.toXML(sb);
        }
        sb.append("  <aggregators>\n");
        Vector<DataObjAggregator> aggVector = new Vector<DataObjAggregator>(localInstance.getAggHash().values());
        Collections.sort(aggVector, new Comparator<DataObjAggregator>(){

            @Override
            public int compare(DataObjAggregator o1, DataObjAggregator o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (DataObjAggregator agg : aggVector) {
            agg.toXML(sb);
        }
        sb.append("  </aggregators>\n");
        sb.append("\n\n</formatters>\n");
        log.debug((Object)sb.toString());
        this.saveXML(sb.toString());
    }

    protected void saveXML(String xml) {
        if (doingLocal) {
            File outFile = XMLHelper.getConfigDir(instance.getLocalFileName());
            try {
                FileUtils.writeStringToFile((File)outFile, (String)xml);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataObjFieldFormatMgr.class, ex);
            }
        }
    }

    public void addFormatter(DataObjSwitchFormatter formatter) {
        this.formatHash.put(formatter.getName(), formatter);
        this.formatClassHash.put(formatter.getDataClass(), formatter);
        this.hasChanged = true;
    }

    public void removeFormatter(DataObjSwitchFormatter formatter) {
        this.formatHash.remove(formatter.getName());
        this.formatClassHash.remove(formatter.getName());
        this.hasChanged = true;
    }

    public DataObjSwitchFormatter getFormatter(String formatName) {
        return this.formatHash.get(formatName);
    }

    public Collection<DataObjSwitchFormatter> getFormatters() {
        return this.formatHash.values();
    }

    private DataObjDataFieldFormatIFace getDataFormatter(Object dataObj, String formatName) {
        DataObjSwitchFormatter switcherFormatter = this.formatHash.get(formatName);
        if (switcherFormatter != null) {
            return switcherFormatter.getDataFormatter(dataObj);
        }
        return null;
    }

    public DataObjSwitchFormatter getDataFormatter(String formatName) {
        return this.formatHash.get(formatName);
    }

    public List<DataObjSwitchFormatter> getFormatterList(Class<?> clazz) {
        Vector<DataObjSwitchFormatter> list = new Vector<DataObjSwitchFormatter>();
        DataObjSwitchFormatter defFormatter = null;
        Enumeration<DataObjSwitchFormatter> e = this.formatHash.elements();
        while (e.hasMoreElements()) {
            DataObjSwitchFormatter f = e.nextElement();
            if (clazz != f.getDataClass()) continue;
            if (f.isDefault() && defFormatter == null) {
                defFormatter = f;
                continue;
            }
            list.add(f);
        }
        if (defFormatter != null) {
            list.insertElementAt(defFormatter, 0);
        }
        return list;
    }

    private Object[] getFieldValues(String[] fieldNames, Object dataObj, DataObjectGettable getter) {
        Object[] values;
        block8: {
            values = null;
            try {
                values = UIHelper.getFieldValues(fieldNames, dataObj, getter);
            }
            catch (LazyInitializationException hbex) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.attach(dataObj);
                        values = UIHelper.getFieldValues(fieldNames, dataObj, getter);
                    }
                    catch (Exception exception) {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (session == null) break block8;
                    session.close();
                }
            }
        }
        return values;
    }

    protected String formatInternal(DataObjDataFieldFormatIFace format, Object dataObj) {
        String restricted = FormHelper.checkForRestrictedValue(dataObj);
        if (restricted != null) {
            return restricted;
        }
        if (format != null) {
            if (format.isDirectFormatter()) {
                return format.format(dataObj);
            }
            DataObjectGettable getter = DataObjectGettableFactory.get(format.getDataClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            if (getter != null) {
                StringBuilder strBuf = new StringBuilder(128);
                DataObjDataField[] dataObjDataFieldArray = format.getFields();
                int n = dataObjDataFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value;
                    DataObjDataField field = dataObjDataFieldArray[n2];
                    Class<Object> fieldClass = field.getType();
                    Object[] values = this.getFieldValues(new String[]{field.getName()}, dataObj, getter);
                    Object object = value = values != null ? values[0] : null;
                    if (fieldClass == Date.class || fieldClass == Calendar.class) {
                        fieldClass = String.class;
                    }
                    if (value != null) {
                        PermissionSettings perm;
                        DBTableInfo tblInfo;
                        if (AppContextMgr.isSecurityOn() && value instanceof FormDataObjIFace && (tblInfo = DBTableIdMgr.getInstance().getByShortClassName(value.getClass().getSimpleName())) != null && (perm = tblInfo.getPermissions()) != null && !perm.canView()) {
                            return "";
                        }
                        if (field.getDataObjFormatterName() != null) {
                            String fmtStr = this.formatInternal(this.getDataFormatter(value, field.getDataObjFormatterName()), value);
                            if (fmtStr != null) {
                                strBuf.append(fmtStr);
                            }
                        } else if (field.getUiFieldFormatterName() != null) {
                            DBFieldInfo fi;
                            UIFieldFormatterIFace fmt = UIFieldFormatterMgr.getInstance().getFormatter(field.getUiFieldFormatterName());
                            DBTableInfo tblInfo2 = DBTableIdMgr.getInstance().getByShortClassName(dataObj.getClass().getSimpleName());
                            if (tblInfo2 != null && (fi = tblInfo2.getFieldByName(field.getName())) != null && fi.getFormatter() != null) {
                                fmt = fi.getFormatter();
                            }
                            if (fmt != null) {
                                strBuf.append(fmt.formatToUI(value));
                            } else {
                                strBuf.append(value);
                            }
                        } else if (value.getClass() == fieldClass) {
                            if (fieldClass == String.class && (field.getFormat() == null || format.equals("%s"))) {
                                if (field.getSep() != null) {
                                    strBuf.append(field.getSep());
                                }
                                strBuf.append(value.toString());
                            } else {
                                String sep = field.getSep();
                                if (sep != null) {
                                    strBuf.append(sep);
                                }
                                if (field.getFormat() != null) {
                                    this.args[0] = value;
                                    Formatter formatter = new Formatter();
                                    formatter.format(field.getFormat(), this.args);
                                    strBuf.append(formatter.toString());
                                    this.args[0] = null;
                                } else {
                                    strBuf.append(value.toString());
                                }
                            }
                        } else {
                            log.error((Object)("Mismatch of types data retrieved as class[" + (value != null ? value.getClass().getSimpleName() : "N/A") + "] and the format requires [" + (field != null ? (fieldClass != null ? fieldClass.getSimpleName() : "N/A 2") : "N/A") + "]"));
                        }
                    }
                    ++n2;
                }
                return strBuf.toString();
            }
        }
        return "";
    }

    protected String formatInternal(DataObjDataFieldFormat format, Object[] dataObjs) {
        DataObjectGettable getter;
        if (format != null && (getter = DataObjectGettableFactory.get(format.getDataClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj")) != null) {
            StringBuilder strBuf = new StringBuilder(128);
            if (dataObjs.length == format.getFields().length) {
                int inx = 0;
                DataObjDataField[] dataObjDataFieldArray = format.getFields();
                int n = dataObjDataFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value;
                    DataObjDataField field = dataObjDataFieldArray[n2];
                    if ((value = dataObjs[inx++]) != null) {
                        if (field.getDataObjFormatterName() != null) {
                            String fmtStr = this.formatInternal(this.getDataFormatter(value, field.getDataObjFormatterName()), value);
                            if (fmtStr != null) {
                                strBuf.append(fmtStr);
                            }
                        } else if (field.getUiFieldFormatterName() != null) {
                            UIFieldFormatterIFace fmt = UIFieldFormatterMgr.getInstance().getFormatter(field.getUiFieldFormatterName());
                            if (fmt != null) {
                                strBuf.append(fmt.formatToUI(value));
                            } else {
                                strBuf.append(value);
                            }
                        } else if (value.getClass() == field.getType()) {
                            if (field.getType() == String.class && (field.getFormat() == null || format.equals("%s"))) {
                                if (field.getSep() != null) {
                                    strBuf.append(field.getSep());
                                }
                                strBuf.append(value.toString());
                            } else {
                                this.args[0] = value;
                                Formatter formatter = new Formatter();
                                formatter.format(format.getFormat(), this.args);
                                strBuf.append(formatter.toString());
                                this.args[0] = null;
                            }
                        } else {
                            log.error((Object)("Mismatch of types data retrieved as class[" + value.getClass().getSimpleName() + "] and the format requires [" + field.getType().getSimpleName() + "]"));
                        }
                    }
                    ++n2;
                }
            } else {
                log.error((Object)("Data Array sent to formatter is not the same length [" + dataObjs.length + "] as the formatter [" + format.getFields().length + "]"));
            }
            return strBuf.toString();
        }
        return "";
    }

    protected String aggregateInternal(Collection<?> items, DataObjAggregator agg) {
        if (agg != null) {
            StringBuilder aggStr = new StringBuilder(128);
            Collection<?> itemsAsCol = items;
            int count = 0;
            for (Object obj : itemsAsCol) {
                if (obj != null) {
                    int aggCount;
                    if (count > 0) {
                        aggStr.append(agg.getSeparator());
                    }
                    if (agg.useIdentity() && obj instanceof FormDataObjIFace) {
                        aggStr.append(((FormDataObjIFace)obj).getIdentityTitle());
                    } else {
                        aggStr.append(this.formatInternal(DataObjFieldFormatMgr.getInstance().getDataFormatter(obj, agg.getFormatName()), obj));
                    }
                    int n = aggCount = agg.getCount() != null ? agg.getCount() : 0;
                    if (aggCount > 0 && count >= aggCount - 1) {
                        String endingStr = agg.getEnding();
                        if (!StringUtils.isNotEmpty((String)endingStr)) break;
                        aggStr.append(endingStr);
                        break;
                    }
                }
                ++count;
            }
            return aggStr.toString();
        }
        log.error((Object)"Aggegrator was null.");
        return null;
    }

    public String format(Object dataObj, String formatName) {
        if (this.domFound && StringUtils.isNotEmpty((String)formatName)) {
            DataObjSwitchFormatter sf = this.formatHash.get(formatName);
            if (sf != null) {
                DataObjDataFieldFormatIFace dff = sf.getDataFormatter(dataObj);
                if (dff != null) {
                    return this.formatInternal(dff, dataObj);
                }
                log.error((Object)("Couldn't find DataObjDataFieldFormat for [" + sf.getName() + "] value[" + dataObj + "]"));
            } else {
                log.error((Object)("Couldn't find DataObjSwitchFormatter for class [" + formatName + "]"));
            }
        }
        return null;
    }

    public String format(Object dataObj, Class<?> dataClass) {
        if (dataObj == null) {
            return "";
        }
        if (this.domFound) {
            DataObjSwitchFormatter sf = this.formatClassHash.get(dataClass);
            if (sf != null) {
                DataObjDataFieldFormatIFace dff = sf.getDataFormatter(dataObj);
                if (dff != null) {
                    return this.formatInternal(dff, dataObj);
                }
                log.error((Object)("Couldn't find DataObjDataFieldFormat for [" + sf.getName() + "] value[" + dataObj + "]"));
            }
            log.error((Object)("Couldn't find DataObjSwitchFormatter for class [" + dataClass.getName() + "]"));
        }
        return null;
    }

    public static String format(Object[] dataObjs, String formatName) {
        throw new RuntimeException("OK, I am used, so come and fix me up!");
    }

    public DataObjAggregator getAggregator(String aggName) {
        return this.aggHash.get(aggName);
    }

    public String aggregate(Collection<?> items, String aggName) {
        if (this.domFound && items != null && items.size() > 0) {
            DataObjAggregator agg = this.aggHash.get(aggName);
            if (agg != null) {
                return this.aggregateInternal(items, agg);
            }
            log.error((Object)("Couldn't find Aggegrator [" + aggName + "]"));
        }
        return "";
    }

    public String aggregate(Collection<?> items, Class<?> dataClass) {
        if (!this.domFound || items == null || dataClass == null) {
            return "";
        }
        DataObjAggregator defAgg = null;
        Enumeration<DataObjAggregator> e = this.aggHash.elements();
        while (e.hasMoreElements()) {
            DataObjAggregator agg = e.nextElement();
            if (dataClass != agg.getDataClass()) continue;
            if (agg.isDefault()) {
                defAgg = agg;
                break;
            }
            if (defAgg != null) continue;
            defAgg = agg;
        }
        if (defAgg != null) {
            return this.aggregateInternal(items, defAgg);
        }
        log.error((Object)("Could find aggregator of class [" + dataClass.getCanonicalName() + "]"));
        return "";
    }

    public List<DataObjAggregator> getAggregatorList(Class<?> clazz) {
        Vector<DataObjAggregator> list = new Vector<DataObjAggregator>();
        DataObjAggregator defFormatter = null;
        Enumeration<DataObjAggregator> e = this.aggHash.elements();
        while (e.hasMoreElements()) {
            DataObjAggregator f = e.nextElement();
            if (clazz != f.getDataClass()) continue;
            if (f.isDefault() && defFormatter == null) {
                defFormatter = f;
                continue;
            }
            list.add(f);
        }
        if (defFormatter != null) {
            list.insertElementAt(defFormatter, 0);
        }
        return list;
    }

    protected static <T> String getUniqueName(String prefix, String separator, Set<String> names) {
        int i = 1;
        String name = String.valueOf(prefix) + separator + Integer.toString(i);
        while (names.contains(name)) {
            name = String.valueOf(prefix) + separator + Integer.toString(++i);
        }
        return name;
    }

    public void addAggregator(DataObjAggregator aggregator) {
        this.aggHash.put(aggregator.getName(), aggregator);
        this.aggClassHash.put(aggregator.getDataClass(), aggregator);
        this.hasChanged = true;
    }

    public void removeAggregator(DataObjAggregator aggregator) {
        this.aggHash.remove(aggregator.getName());
        this.aggClassHash.remove(aggregator.getName());
        this.hasChanged = true;
    }

    public static DataObjFieldFormatMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        if (StringUtils.isEmpty((String)factoryName)) {
            instance = new DataObjFieldFormatMgr();
        } else {
            String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(DataObjFieldFormatMgr.factoryName);
                }
            });
            if (StringUtils.isNotEmpty((String)factoryNameStr)) {
                try {
                    instance = (DataObjFieldFormatMgr)Class.forName(factoryNameStr).newInstance();
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DataObjFieldFormatMgr.class, e);
                    InternalError error = new InternalError("Can't instantiate DataObjFieldFormatMgr factory " + factoryNameStr);
                    error.initCause(e);
                    throw error;
                }
            }
            if (instance == null) {
                instance = new DataObjFieldFormatMgr();
            }
        }
        for (DataObjSwitchFormatter format : DataObjFieldFormatMgr.instance.formatHash.values()) {
            format.setTableAndFieldInfo();
        }
        return instance;
    }

    public Hashtable<String, DataObjSwitchFormatter> getFormatHash() {
        return this.formatHash;
    }

    public void setFormatHash(Hashtable<String, DataObjSwitchFormatter> formatHash) {
        this.formatHash = formatHash;
    }

    public Hashtable<Class<?>, DataObjSwitchFormatter> getFormatClassHash() {
        return this.formatClassHash;
    }

    public void setFormatClassHash(Hashtable<Class<?>, DataObjSwitchFormatter> formatClassHash) {
        this.formatClassHash = formatClassHash;
    }

    public Hashtable<String, DataObjAggregator> getAggHash() {
        return this.aggHash;
    }

    public void setAggHash(Hashtable<String, DataObjAggregator> aggHash) {
        this.aggHash = aggHash;
    }

    public Hashtable<Class<?>, DataObjAggregator> getAggClassHash() {
        return this.aggClassHash;
    }

    public void setAggClassHash(Hashtable<Class<?>, DataObjAggregator> aggClassHash) {
        this.aggClassHash = aggClassHash;
    }

    public static synchronized void clear() {
        instance = null;
    }
}

