/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMultiplePanel;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatSinglePanel;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatterSingleContainer;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;

public class DataObjFieldFormatDlg
extends CustomDialog
implements ChangeListener {
    protected DBTableInfo tableInfo;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected DataObjSwitchFormatter dataObjFormatter;
    protected DataObjFieldFormatSinglePanel fmtSingleEditingPanel;
    protected DataObjFieldFormatMultiplePanel fmtMultipleEditingPanel;
    protected JComboBox valueFieldCbo;
    protected JRadioButton singleDisplayBtn;
    protected JRadioButton multipleDisplayBtn;
    protected JTextField titleText;
    protected JTextField nameText;
    protected EditDeleteAddPanel controlPanel;
    protected JPanel customEditor = null;
    protected boolean hasChanged = false;
    protected boolean isInError = false;
    protected boolean isEditable = true;

    public DataObjFieldFormatDlg(CustomDialog parentDlg, DBTableInfo tableInfo, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache, DataObjSwitchFormatter dataObjFormatter) throws HeadlessException {
        super(parentDlg, UIRegistry.getResourceString("DOF_DLG_TITLE"), true, 7, null);
        this.tableInfo = tableInfo;
        this.dataObjFieldFormatMgrCache = dataObjFieldFormatMgrCache;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.dataObjFormatter = dataObjFormatter;
        this.helpContext = "DOF_EDITOR";
    }

    @Override
    public void createUI() {
        DataObjDataFieldFormatIFace dof;
        super.createUI();
        JLabel titleLbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("DOF_TITLE")) + ":");
        this.titleText = UIHelper.createTextField(32);
        JLabel nameLbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("DOF_NAME")) + ":");
        this.nameText = UIHelper.createTextField(32);
        JLabel typeLbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("DOF_TYPE")) + ":");
        this.singleDisplayBtn = UIHelper.createRadioButton(UIRegistry.getResourceString("DOF_SINGLE"));
        this.multipleDisplayBtn = UIHelper.createRadioButton(String.valueOf(UIRegistry.getResourceString("DOF_MULTIPLE")) + ":");
        this.singleDisplayBtn.setSelected(true);
        CellConstraints cc = new CellConstraints();
        if (this.dataObjFormatter.getFormatters().size() == 1 && (dof = this.dataObjFormatter.getFormatters().iterator().next()).isCustom()) {
            if (dof.hasEditor()) {
                this.customEditor = dof.getCustomEditor(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        DataObjFieldFormatDlg.this.setHasChanged(true);
                    }
                });
            } else {
                this.isEditable = false;
                UIRegistry.showLocalizedMsg("DOF_NO_CST_EDT");
                return;
            }
        }
        if (this.customEditor == null) {
            ButtonGroup displayTypeGrp = new ButtonGroup();
            displayTypeGrp.add(this.singleDisplayBtn);
            displayTypeGrp.add(this.multipleDisplayBtn);
            this.addDisplayTypeRadioButtonListeners();
            DefaultComboBoxModel cboModel = new DefaultComboBoxModel();
            this.valueFieldCbo = UIHelper.createComboBox(cboModel);
            this.addValueFieldsToCombo(null);
            this.addValueFieldCboAL();
            PanelBuilder multipleDisplayPB = new PanelBuilder(new FormLayout("l:p,f:p:g", "p"));
            multipleDisplayPB.add((Component)this.multipleDisplayBtn, cc.xy(1, 1));
            multipleDisplayPB.add((Component)this.valueFieldCbo, cc.xy(2, 1));
            DataObjSwitchFormatterSingleContainer formatterContainer = new DataObjSwitchFormatterSingleContainer(this.dataObjFormatter);
            this.fmtSingleEditingPanel = new DataObjFieldFormatSinglePanel(this.tableInfo, formatterContainer, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache, this, this.getOkBtn());
            this.fmtMultipleEditingPanel = new DataObjFieldFormatMultiplePanel(this.tableInfo, formatterContainer, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache, this, this.getOkBtn());
            PanelBuilder pb = new PanelBuilder(new FormLayout("r:p,4px,f:p:g", "p,2px,p,10px,p,p,10px,f:p:g"));
            int y = 1;
            pb.add((Component)nameLbl, cc.xy(1, y));
            pb.add((Component)this.nameText, cc.xy(3, y));
            pb.add((Component)titleLbl, cc.xy(1, y += 2));
            pb.add((Component)this.titleText, cc.xy(3, y));
            pb.add((Component)typeLbl, cc.xy(1, y += 2));
            pb.add((Component)this.singleDisplayBtn, cc.xy(3, y));
            pb.add((Component)multipleDisplayPB.getPanel(), cc.xy(3, ++y));
            pb.add((Component)this.fmtSingleEditingPanel, cc.xyw(1, y += 2, 3));
            pb.add((Component)this.fmtMultipleEditingPanel, cc.xyw(1, y, 3));
            pb.setDefaultDialogBorder();
            this.contentPanel = pb.getPanel();
        } else {
            PanelBuilder pb = new PanelBuilder(new FormLayout("r:p,4px,f:p:g", "p,6px,p,2px,p,4px,p,10px"));
            int y = 1;
            pb.addSeparator(UIRegistry.getResourceString("DOF_CST_ED"), cc.xyw(1, y, 3));
            pb.add((Component)nameLbl, cc.xy(1, y += 2));
            pb.add((Component)this.nameText, cc.xy(3, y));
            pb.add((Component)titleLbl, cc.xy(1, y += 2));
            pb.add((Component)this.titleText, cc.xy(3, y));
            y += 2;
            String labelStr = this.dataObjFormatter.getFormatters().iterator().next().getLabel();
            if (StringUtils.isNotEmpty((String)labelStr)) {
                pb.add((Component)UIHelper.createFormLabel(labelStr), cc.xy(1, y));
                pb.add((Component)this.customEditor, cc.xy(3, y));
                y += 2;
            } else {
                pb.add((Component)this.customEditor, cc.xyw(1, y, 3));
                y += 2;
            }
            pb.setDefaultDialogBorder();
            this.contentPanel = pb.getPanel();
        }
        this.mainPanel.add(this.contentPanel, "Center");
        this.fillWithObjFormatter(this.dataObjFormatter, true);
        DocumentAdaptor nameChangedDL = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent ev) {
                String name = DataObjFieldFormatDlg.this.nameText.getText();
                String title = DataObjFieldFormatDlg.this.titleText.getText();
                DataObjFieldFormatDlg.this.isInError = StringUtils.isEmpty((String)name) || DataObjFieldFormatDlg.this.dataObjFieldFormatMgrCache.getDataFormatter(name) != null;
                DataObjFieldFormatDlg.this.dataObjFormatter.setName(name);
                DataObjFieldFormatDlg.this.dataObjFormatter.setTitle(title);
                DataObjFieldFormatDlg.this.setHasChanged(true);
            }
        };
        this.titleText.getDocument().addDocumentListener(nameChangedDL);
        this.nameText.getDocument().addDocumentListener(nameChangedDL);
        this.updateUIEnabled();
        this.packWithLargestPanel();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setHasChanged(boolean hasChanged) {
        if (this.hasChanged != hasChanged) {
            this.setWindowModified(hasChanged);
        }
        this.hasChanged = hasChanged;
        this.updateUIEnabled();
    }

    @Override
    protected void okButtonPressed() {
        this.dataObjFormatter.setTitle(this.titleText.getText());
        super.okButtonPressed();
    }

    protected List<DataObjSwitchFormatter> populateFormatterList() {
        DefaultListModel<DataObjSwitchFormatter> listModel = new DefaultListModel<DataObjSwitchFormatter>();
        List<DataObjSwitchFormatter> fmtrs = this.dataObjFieldFormatMgrCache.getFormatterList(this.tableInfo.getClassObj());
        Collections.sort(fmtrs, new ComparatorByStringRepresentation());
        for (DataObjSwitchFormatter format : fmtrs) {
            listModel.addElement(format);
        }
        return fmtrs;
    }

    protected void packWithLargestPanel() {
        if (this.customEditor == null) {
            this.fmtSingleEditingPanel.setVisible(true);
            this.fmtMultipleEditingPanel.setVisible(true);
        } else {
            this.customEditor.setVisible(true);
        }
        this.pack();
        if (this.customEditor == null) {
            this.setVisibleFormatPanel(this.singleDisplayBtn.isSelected() ? this.singleDisplayBtn : this.multipleDisplayBtn);
        }
    }

    protected void addDisplayTypeRadioButtonListeners() {
        ActionListener displayTypeRadioBtnL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JRadioButton) {
                    JRadioButton btn = (JRadioButton)e.getSource();
                    DataObjFieldFormatDlg.this.dataObjFormatter.setSingle(btn == DataObjFieldFormatDlg.this.singleDisplayBtn);
                    if (btn == DataObjFieldFormatDlg.this.singleDisplayBtn) {
                        DataObjFieldFormatDlg.this.fmtSingleEditingPanel.setHasChanged(true);
                    } else {
                        DataObjFieldFormatDlg.this.fmtMultipleEditingPanel.setHasChanged(true);
                    }
                    DataObjFieldFormatDlg.this.setVisibleFormatPanel(btn);
                }
            }
        };
        this.singleDisplayBtn.addActionListener(displayTypeRadioBtnL);
        this.multipleDisplayBtn.addActionListener(displayTypeRadioBtnL);
    }

    public void addValueFieldCboAL() {
        ActionListener valueFieldCboAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataObjFieldFormatDlg.this.valueFieldChanged();
            }
        };
        this.valueFieldCbo.addActionListener(valueFieldCboAL);
    }

    protected void fillWithObjFormatter(DataObjSwitchFormatter fmt, boolean isFirstTime) {
        if (fmt.getTitle() != null) {
            ViewFactory.changeTextFieldUIForDisplay(this.nameText, false);
        }
        this.titleText.setText(fmt.getTitle());
        this.nameText.setText(fmt.getName());
        if (this.customEditor == null) {
            boolean isSingle = fmt.isSingle();
            if (isSingle) {
                this.singleDisplayBtn.setSelected(true);
                this.setVisibleFormatPanel(this.singleDisplayBtn);
                this.fmtSingleEditingPanel.fillWithObjFormatter(fmt);
            } else {
                this.multipleDisplayBtn.setSelected(true);
                this.setVisibleFormatPanel(this.multipleDisplayBtn);
                this.fmtMultipleEditingPanel.fillWithObjFormatter(fmt);
            }
        }
        this.updateValueFieldCombo(fmt);
        this.updateUIEnabled();
        this.setHasChanged(!isFirstTime);
    }

    protected void addValueFieldsToCombo(DataObjSwitchFormatter switchFormatter) {
        DefaultComboBoxModel cboModel = (DefaultComboBoxModel)this.valueFieldCbo.getModel();
        cboModel.removeAllElements();
        List<DBFieldInfo> fields = this.tableInfo.getFields();
        int selectedFieldIndex = -1;
        int i = 0;
        while (i < fields.size()) {
            DBFieldInfo currentField = fields.get(i);
            cboModel.addElement(currentField);
            if (switchFormatter != null && currentField.getName().equals(switchFormatter.getFieldName())) {
                selectedFieldIndex = i;
            }
            ++i;
        }
        if (selectedFieldIndex != -1) {
            this.valueFieldCbo.setSelectedIndex(selectedFieldIndex);
        }
    }

    protected void updateValueFieldCombo(DataObjSwitchFormatter switchFormatter) {
        if (switchFormatter == null || switchFormatter.getFieldName() == null) {
            return;
        }
        if (this.customEditor == null) {
            DefaultComboBoxModel cboModel = (DefaultComboBoxModel)this.valueFieldCbo.getModel();
            cboModel.setSelectedItem(this.tableInfo.getFieldByName(switchFormatter.getFieldName()));
        }
    }

    public void valueFieldChanged() {
        Object obj = this.valueFieldCbo.getSelectedItem();
        if (!(obj instanceof DBFieldInfo)) {
            return;
        }
        DBFieldInfo field = (DBFieldInfo)obj;
        String fieldValueName = field.getName();
        if (this.dataObjFormatter != null) {
            this.dataObjFormatter.setFieldName(fieldValueName);
            this.setHasChanged(true);
        }
    }

    protected void setVisibleFormatPanel(JRadioButton btn) {
        if (this.customEditor == null) {
            this.fmtSingleEditingPanel.setVisible(btn == this.singleDisplayBtn);
            this.fmtMultipleEditingPanel.setVisible(btn == this.multipleDisplayBtn);
            this.updateUIEnabled();
        }
    }

    protected void updateUIEnabled() {
        if (this.customEditor == null) {
            this.valueFieldCbo.setEnabled(this.multipleDisplayBtn.isSelected());
            boolean subPanelInError = false;
            if (this.singleDisplayBtn.isSelected()) {
                subPanelInError = this.fmtSingleEditingPanel.isInError();
            } else {
                subPanelInError = this.fmtMultipleEditingPanel.isInError();
                this.fmtMultipleEditingPanel.enableUIControls();
            }
            this.okBtn.setEnabled(!this.isInError && !subPanelInError && StringUtils.isNotEmpty((String)this.nameText.getText()) && StringUtils.isNotEmpty((String)this.titleText.getText()));
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setHasChanged(true);
    }
}

