/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatDlg;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.FmtListEditorDlgBase;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DataObjFieldFmtListEdtDlg
extends FmtListEditorDlgBase {
    protected DBTableInfo tableInfo;

    public DataObjFieldFmtListEdtDlg(Frame frame, DBTableInfo tableInfo, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache) throws HeadlessException {
        super(frame, "DOF_DLG_AVAIL_TITLE", "DOF_LIST_EDITOR", tableInfo, dataObjFieldFormatMgrCache, uiFieldFormatterMgrCache);
        this.tableInfo = tableInfo;
    }

    @Override
    protected ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList listArg, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)listArg, value, index, isSelected, cellHasFocus);
                DataObjSwitchFormatter doa = (DataObjSwitchFormatter)value;
                label.setText(String.valueOf(doa.toString()) + (doa.isDefault() ? " " + UIRegistry.getResourceString("DOF_DEFAULT") : ""));
                return label;
            }
        };
    }

    @Override
    protected void addItem() {
        DataObjSwitchFormatter newFmt = new DataObjSwitchFormatter(null, null, true, false, this.tableInfo.getClassObj(), "");
        this.editItem(newFmt, true);
    }

    @Override
    protected DefaultListModel createListDataModel() {
        DefaultListModel<DataObjSwitchFormatter> model = new DefaultListModel<DataObjSwitchFormatter>();
        List<DataObjSwitchFormatter> fmtrs = this.dataObjFieldFormatMgrCache.getFormatterList(this.tableInfo.getClassObj());
        Collections.sort(fmtrs, new ComparatorByStringRepresentation());
        for (DataObjSwitchFormatter format : fmtrs) {
            model.addElement(format);
        }
        return model;
    }

    @Override
    protected void deleteSelectedItem() {
        DataObjSwitchFormatter selectedFormat = (DataObjSwitchFormatter)this.list.getSelectedValue();
        if (selectedFormat == null) {
            return;
        }
        this.dataObjFieldFormatMgrCache.removeFormatter(selectedFormat);
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.removeElement(selectedFormat);
        this.setHasChanged(true);
    }

    @Override
    protected void editItem(Object dataObj, boolean isNew) {
        try {
            DataObjSwitchFormatter dataObjFieldFmt = (DataObjSwitchFormatter)dataObj;
            DataObjSwitchFormatter tempCopy = isNew ? dataObjFieldFmt : (DataObjSwitchFormatter)dataObjFieldFmt.clone();
            DataObjFieldFormatDlg dlg = new DataObjFieldFormatDlg(this, this.tableInfo, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache, tempCopy);
            dlg.createUI();
            if (dlg.isEditable()) {
                dlg.setVisible(true);
                if (!dlg.isCancelled()) {
                    if (isNew) {
                        this.dataObjFieldFormatMgrCache.addFormatter(dataObjFieldFmt);
                        this.listModel.addElement(dataObjFieldFmt);
                    } else {
                        this.listModel.removeElement(dataObjFieldFmt);
                        this.dataObjFieldFormatMgrCache.removeFormatter(dataObjFieldFmt);
                        this.dataObjFieldFormatMgrCache.addFormatter(tempCopy);
                        this.listModel.addElement(tempCopy);
                    }
                    this.setHasChanged(true);
                }
            }
        }
        catch (CloneNotSupportedException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataObjFieldFmtListEdtDlg.class, ex);
            ex.printStackTrace();
        }
    }

    @Override
    protected String[] getDEDAToolTipKeys() {
        return new String[]{"", "", "", ""};
    }

    @Override
    protected void setDefaultItem() {
        DataObjSwitchFormatter selected = (DataObjSwitchFormatter)this.list.getSelectedValue();
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        int i = 0;
        while (i < model.getSize()) {
            DataObjSwitchFormatter dof;
            dof.setDefault((dof = (DataObjSwitchFormatter)model.get(i)) == selected);
            this.setHasChanged(true);
            ++i;
        }
        this.list.repaint();
    }
}

