/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldFormatIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.helpers.XMLHelper;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class DataObjDataFieldFormat
implements DataObjDataFieldFormatIFace,
Cloneable {
    protected String name;
    protected Class<?> dataClass;
    protected boolean isDefault;
    protected String format;
    protected String value;
    protected DataObjDataField[] fields;
    protected DBTableInfo tableInfo;

    public DataObjDataFieldFormat() {
        this.value = "";
    }

    public DataObjDataFieldFormat(String name, Class<?> dataClass, boolean isDefault, String format, String value, DataObjDataField[] fields) {
        this.name = name;
        this.dataClass = dataClass;
        this.isDefault = isDefault;
        this.format = format;
        this.value = value;
        this.fields = fields;
        if (this.value == null) {
            this.value = "";
        }
    }

    public String toString() {
        if (this.fields == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        DataObjDataField[] dataObjDataFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjDataField field = dataObjDataFieldArray[n2];
            str.append(field.toString());
            ++n2;
        }
        return str.toString();
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void init(String nameArg, Properties properties) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Class<?> getDataClass() {
        return this.dataClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean isDirectFormatter() {
        return false;
    }

    @Override
    public String getSingleField() {
        if (this.fields.length == 1 && !StringUtils.contains((String)this.fields[0].getName(), (String)".") && this.fields[0].getUiFieldFormatter() == null) {
            return this.fields[0].getName();
        }
        return null;
    }

    @Override
    public String format(Object dataValue) {
        throw new RuntimeException("Not callable because isDirectFormatter is false");
    }

    @Override
    public DataObjDataField[] getFields() {
        return this.fields;
    }

    @Override
    public void setTableAndFieldInfo() {
        this.tableInfo = DBTableIdMgr.getInstance().getByClassName(this.dataClass.getName());
        DataObjDataField[] dataObjDataFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjDataField field = dataObjDataFieldArray[n2];
            field.setTableAndFieldInfo(this.tableInfo);
            ++n2;
        }
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void toXML(StringBuilder sb) {
        String space = "            ";
        sb.append(space);
        sb.append("<fields");
        if (StringUtils.isNotEmpty((String)this.value)) {
            XMLHelper.xmlAttr(sb, "value", this.value);
        }
        sb.append(">\n");
        DataObjDataField[] dataObjDataFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjDataField field = dataObjDataFieldArray[n2];
            field.toXML(sb);
            ++n2;
        }
        sb.append(space);
        sb.append("</fields>\n");
    }

    @Override
    public void setDataObjSwitchFormatter(DataObjSwitchFormatter objFormatter) {
        if (this.fields == null) {
            return;
        }
        DataObjDataField[] dataObjDataFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjDataField fld = dataObjDataFieldArray[n2];
            fld.setObjFormatter(objFormatter);
            ++n2;
        }
    }

    @Override
    public JPanel getCustomEditor(ChangeListener l) {
        return null;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean hasEditor() {
        return false;
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public void doneEditting(boolean wasCancelled) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataObjDataFieldFormat dodff = (DataObjDataFieldFormat)super.clone();
        if (this.fields != null) {
            int i = 0;
            dodff.fields = new DataObjDataField[this.fields.length];
            DataObjDataField[] dataObjDataFieldArray = this.fields;
            int n = this.fields.length;
            int n2 = 0;
            while (n2 < n) {
                DataObjDataField fld = dataObjDataFieldArray[n2];
                dodff.fields[i++] = (DataObjDataField)fld.clone();
                ++n2;
            }
        }
        return dodff;
    }
}

