/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.helpers.XMLHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataObjDataField
implements Cloneable {
    private static final Logger log = Logger.getLogger(DataObjDataField.class);
    protected String name;
    protected Class<?> type;
    protected String format;
    protected String sep;
    protected String uiFieldFormatterName;
    protected String dataObjFormatterName;
    protected DBTableInfo tableInfo;
    protected DBFieldInfo fieldInfo;
    protected DBRelationshipInfo relInfo;
    protected DataObjSwitchFormatter objFormatter;
    protected UIFieldFormatterIFace uiFieldFormatter;

    public DataObjDataField(String name, Class<?> type, String format, String sep, String dataObjFormatterName, String uiFieldFormatterName) {
        this.name = name;
        this.type = type;
        this.format = format;
        this.sep = sep;
        this.dataObjFormatterName = dataObjFormatterName;
        this.uiFieldFormatterName = uiFieldFormatterName;
    }

    public void setDbInfo(DBTableInfo tableInfo, DBFieldInfo fieldInfo, DBRelationshipInfo relInfo, boolean isInitial) {
        this.tableInfo = tableInfo;
        this.fieldInfo = fieldInfo;
        this.relInfo = relInfo;
        if (!isInitial && fieldInfo == null && relInfo == null) {
            this.setTableAndFieldInfo(tableInfo);
        }
    }

    public void setDbInfo(DBTableInfo tableInfo, DBFieldInfo fieldInfo, DBRelationshipInfo relInfo) {
        this.setDbInfo(tableInfo, fieldInfo, relInfo, false);
    }

    public DataObjSwitchFormatter getObjFormatter() {
        return this.objFormatter;
    }

    public void setObjFormatter(DataObjSwitchFormatter objFormatter) {
        this.objFormatter = objFormatter;
    }

    public UIFieldFormatterIFace getUiFieldFormatter() {
        return this.uiFieldFormatter;
    }

    public void setUiFieldFormatter(UIFieldFormatterIFace uiFieldFormatter) {
        this.uiFieldFormatter = uiFieldFormatter;
    }

    public void setSep(String sep) {
        this.sep = sep;
    }

    public boolean isPureField() {
        return StringUtils.isEmpty((String)this.getUiFieldFormatterName()) && StringUtils.isEmpty((String)this.getDataObjFormatterName());
    }

    public void toXML(StringBuilder sb) {
        String spaces = "                ";
        sb.append(spaces);
        sb.append("<field");
        if (this.type != null && this.type != String.class) {
            XMLHelper.xmlAttr(sb, "type", DataObjFieldFormatMgr.getInstance().getStrForType(this.type));
        }
        XMLHelper.xmlAttr(sb, "format", this.format);
        XMLHelper.xmlAttr(sb, "sep", this.sep);
        XMLHelper.xmlAttr(sb, "formatter", this.dataObjFormatterName);
        XMLHelper.xmlAttr(sb, "uifieldformatter", this.uiFieldFormatterName);
        sb.append(">");
        sb.append(this.name);
        sb.append("</field>\n");
    }

    public String toString() {
        String prefix = "";
        if (StringUtils.isNotEmpty((String)this.sep)) {
            prefix = this.sep;
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            return String.valueOf(prefix) + "[" + this.name + "]";
        }
        if (this.objFormatter != null) {
            return String.valueOf(prefix) + "[" + this.objFormatter.getTitle() + "." + this.objFormatter.getFieldName() + "]";
        }
        return String.valueOf(prefix) + "[" + this.tableInfo.getTitle() + "." + this.fieldInfo.getTitle() + "]";
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public String getSep() {
        return this.sep;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDataObjFormatterName() {
        return this.dataObjFormatterName;
    }

    public String getUiFieldFormatterName() {
        return this.uiFieldFormatterName;
    }

    public void setUiFieldFormatterName(String uiFieldFormatterName) {
        this.uiFieldFormatterName = uiFieldFormatterName;
    }

    public DBTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(DBTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public DBRelationshipInfo getRelInfo() {
        return this.relInfo;
    }

    public void setRelInfo(DBRelationshipInfo relInfo) {
        this.relInfo = relInfo;
    }

    public DBFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public void setFieldInfo(DBFieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public void setTableAndFieldInfo(DBTableInfo tableInfo) {
        String[] parts;
        this.setTableInfo(tableInfo);
        if (StringUtils.isNotEmpty((String)this.dataObjFormatterName)) {
            this.objFormatter = DataObjFieldFormatMgr.getInstance().getFormatter(this.dataObjFormatterName);
        }
        if ((parts = this.name.split("\\.")).length == 2) {
            if (StringUtils.isNotEmpty((String)parts[0]) && StringUtils.isNotEmpty((String)parts[1])) {
                DBRelationshipInfo reltnInfo = tableInfo.getRelationshipByName(parts[0]);
                if (reltnInfo != null) {
                    this.setRelInfo(reltnInfo);
                    DBTableInfo otherTable = DBTableIdMgr.getInstance().getByClassName(reltnInfo.getClassName());
                    if (otherTable != null) {
                        DBFieldInfo fi = otherTable.getFieldByName(parts[1]);
                        if (fi != null) {
                            this.setFieldInfo(fi);
                        } else {
                            log.error((Object)("Couldn't find fieldinfo for [" + parts[1] + "]"));
                        }
                    } else {
                        log.error((Object)("Couldn't find tableinfo for [" + reltnInfo.getClassName() + "]"));
                    }
                } else {
                    log.error((Object)("Couldn't find Rel Info for [" + parts[0] + "]"));
                }
            }
            return;
        }
        this.setRelInfo(tableInfo.getRelationshipByName(this.name));
        if (this.relInfo != null) {
            return;
        }
        this.setFieldInfo(tableInfo.getFieldByName(this.name));
    }

    public Object clone() throws CloneNotSupportedException {
        DataObjDataField ddf = (DataObjDataField)super.clone();
        return ddf;
    }
}

