/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatDlg;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class DataObjAggregatorDlg
extends CustomDialog
implements DataChangeListener {
    protected Frame aggDlgFrame;
    protected DBTableInfo tableInfo;
    protected DataObjAggregator selectedAggregator;
    protected boolean newAggregator;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected JComboBox displayCbo;
    protected JComboBox fieldOrderCbo;
    protected ValTextField nameText;
    protected ValTextField titleText;
    protected ValTextField sepText;
    protected ValSpinner countSpinner;
    protected ValTextField endingText;
    protected DocumentListener[] textChangedDL = new DocumentListener[5];
    protected ListSelectionListener aggregatorListSL = null;
    protected ItemListener checkBoxListener = null;
    protected ActionListener cboAL = null;
    protected boolean hasChanged = false;
    protected boolean isNameInError = false;
    protected FormValidator validator = new FormValidator(null);
    protected boolean isNew = false;

    public DataObjAggregatorDlg(CustomDialog parentDlg, DBTableInfo tableInfo, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache, DataObjAggregator selectedAggregator) throws HeadlessException {
        super(parentDlg, UIRegistry.getResourceString("DOA_DLG_TITLE"), true, 7, null);
        this.tableInfo = tableInfo;
        this.dataObjFieldFormatMgrCache = dataObjFieldFormatMgrCache;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.selectedAggregator = selectedAggregator;
        this.helpContext = "DOA_EDITOR";
        this.validator.addDataChangeListener(this);
        this.validator.addEnableRule("DOA_ENDING", "DOA_COUNT.getIntValue() > 0");
    }

    protected JLabel createI18NFormLabelBold(String key) {
        JLabel lbl = UIHelper.createI18NFormLabel(key);
        Font lblFont = lbl.getFont().deriveFont(1);
        lbl.setFont(lblFont);
        return lbl;
    }

    @Override
    public void createUI() {
        super.createUI();
        this.isNew = StringUtils.isEmpty((String)this.selectedAggregator.getName());
        this.validator.setNewObj(this.isNew);
        CellConstraints cc = new CellConstraints();
        PanelBuilder displayPB = new PanelBuilder(new FormLayout("f:p:g,min", "p"));
        this.displayCbo = UIHelper.createComboBox();
        JButton displayDlgBtn = UIHelper.createButton("...");
        displayPB.add((Component)this.displayCbo, cc.xy(1, 1));
        displayPB.add((Component)displayDlgBtn, cc.xy(2, 1));
        this.fieldOrderCbo = UIHelper.createComboBox();
        ActionListener displayDlgBtnAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataObjSwitchFormatter dosf;
                boolean newFormatter;
                if (DataObjAggregatorDlg.this.displayCbo.getSelectedIndex() == 0) {
                    newFormatter = true;
                    dosf = new DataObjSwitchFormatter(null, null, true, false, DataObjAggregatorDlg.this.tableInfo.getClassObj(), "");
                } else {
                    newFormatter = false;
                    dosf = (DataObjSwitchFormatter)DataObjAggregatorDlg.this.displayCbo.getSelectedItem();
                }
                DataObjFieldFormatDlg dlg = new DataObjFieldFormatDlg(null, DataObjAggregatorDlg.this.tableInfo, DataObjAggregatorDlg.this.dataObjFieldFormatMgrCache, DataObjAggregatorDlg.this.uiFieldFormatterMgrCache, dosf);
                dlg.createUI();
                if (dlg.isEditable()) {
                    dlg.setVisible(true);
                    if (dlg.getBtnPressed() == 1) {
                        DataObjAggregatorDlg.this.selectedAggregator.setFormatName(dosf.getName());
                        if (newFormatter) {
                            DataObjAggregatorDlg.this.dataObjFieldFormatMgrCache.addFormatter(dosf);
                        }
                        DataObjAggregatorDlg.this.updateDisplayCombo();
                    }
                }
            }
        };
        displayDlgBtn.addActionListener(displayDlgBtnAL);
        this.titleText = new ValTextField(10);
        this.nameText = new ValTextField(10){

            @Override
            public UIValidatable.ErrorType validateState() {
                UIValidatable.ErrorType state = super.validateState();
                if (state == UIValidatable.ErrorType.Valid) {
                    return DataObjAggregatorDlg.this.isNameInError ? UIValidatable.ErrorType.Error : UIValidatable.ErrorType.Valid;
                }
                return state;
            }
        };
        this.sepText = new ValTextField(10);
        this.endingText = new ValTextField(10);
        this.countSpinner = new ValSpinner(0, 10, true, false);
        this.countSpinner.setValue(0);
        JButton valBtn = FormViewObj.createValidationIndicator(this, this.validator);
        PanelBuilder valInfoBtnPB = new PanelBuilder(new FormLayout("f:p:g,p", "p"));
        valInfoBtnPB.add((Component)valBtn, cc.xy(2, 1));
        this.validator.setValidationBtn(valBtn);
        PanelBuilder pb = new PanelBuilder(new FormLayout("r:p,2px,p,f:p:g", UIHelper.createDuplicateJGoodiesDef("p", "2px", 11)));
        int y = 1;
        JLabel tableTitleLbl = UIHelper.createI18NFormLabel("FFE_TABLE");
        JLabel tableTitleValueLbl = UIHelper.createLabel(this.tableInfo.getTitle());
        tableTitleValueLbl.setBackground(Color.WHITE);
        tableTitleValueLbl.setOpaque(true);
        pb.add((Component)tableTitleLbl, cc.xy(1, y));
        pb.add((Component)tableTitleValueLbl, cc.xyw(3, y, 2));
        pb.addSeparator(" ", cc.xyw(1, y += 2, 3));
        pb.add((Component)this.createI18NFormLabelBold("DOA_NAME"), cc.xy(1, y += 2));
        this.add(pb, this.nameText, "DOA_NAME", "DOA_NAME.getText().length() > 0", cc.xyw(3, y, 2));
        pb.add((Component)this.createI18NFormLabelBold("DOA_TITLE"), cc.xy(1, y += 2));
        this.add(pb, this.titleText, "DOA_TITLE", "DOA_TITLE.getText().length() > 0", cc.xyw(3, y, 2));
        pb.add((Component)this.createI18NFormLabelBold("DOA_DISPLAY"), cc.xy(1, y += 2));
        pb.add((Component)displayPB.getPanel(), cc.xyw(3, y, 2));
        pb.add((Component)this.createI18NFormLabelBold("DOA_SEP"), cc.xy(1, y += 2));
        this.add(pb, this.sepText, "DOA_SEP", "DOA_SEP.getText().length() > 0", cc.xyw(3, y, 2));
        pb.add((Component)this.createI18NFormLabelBold("DOA_COUNT"), cc.xy(1, y += 2));
        this.add(pb, this.countSpinner, "DOA_COUNT", null, cc.xyw(3, y, 2));
        pb.add((Component)UIHelper.createI18NFormLabel("DOA_ENDING"), cc.xy(1, y += 2));
        this.add(pb, this.endingText, "DOA_ENDING", "DOA_ENDING.getText().length() > 0", cc.xyw(3, y, 2));
        pb.add((Component)UIHelper.createI18NFormLabel("DOA_SORT_BY"), cc.xy(1, y += 2));
        this.add(pb, this.fieldOrderCbo, "DOA_DEFAULT", null, cc.xy(3, y));
        pb.add((Component)valInfoBtnPB.getPanel(), cc.xyw(3, y += 2, 2));
        y += 2;
        pb.setBorder(BorderFactory.createEmptyBorder(14, 14, 0, 14));
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.fillWithObjAggregator(this.selectedAggregator);
        this.updateUIEnabled();
        this.addComboBoxActionListeners();
        if (!this.isNew) {
            ViewFactory.changeTextFieldUIForDisplay(this.nameText, false);
        }
        this.validator.resetFields();
        this.validator.setEnabled(true);
        this.validator.setHasChanged(false);
        this.pack();
        if (this.isNew) {
            this.nameText.getDocument().addDocumentListener(new DocumentAdaptor(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DataObjAggregatorDlg.this.isNameInError = DataObjAggregatorDlg.this.dataObjFieldFormatMgrCache.getAggregator(DataObjAggregatorDlg.this.nameText.getText()) != null;
                    DataObjAggregatorDlg.this.validator.validateForm();
                    DataObjAggregatorDlg.this.updateUIEnabled();
                }
            });
        }
    }

    protected void add(PanelBuilder pb, JComponent comp, String ident, String valRule, CellConstraints cc) {
        pb.add((Component)comp, cc);
        if (comp instanceof UIValidatable) {
            if (comp instanceof ValTextField) {
                this.validator.hookupTextField((ValTextField)comp, ident, true, UIValidator.Type.Changed, valRule, false);
            } else if (comp instanceof ValComboBox) {
                DataChangeNotifier dcn = this.validator.hookupComponent(comp, ident, UIValidator.Type.Changed, valRule, false);
                ((ValComboBox)comp).getComboBox().addActionListener(dcn);
            } else if (comp instanceof ValSpinner) {
                DataChangeNotifier dcn = this.validator.hookupComponent(comp, ident, UIValidator.Type.Changed, valRule, false);
                ((ValSpinner)comp).addChangeListener(dcn);
            }
            this.validator.addUILabel(ident, UIHelper.createI18NLabel(ident));
            if (comp instanceof UIValidatable) {
                ((UIValidatable)((Object)comp)).setRequired(true);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.createUI();
            Dimension size = this.getPreferredSize();
            size.width = Math.max(400, size.width);
            this.setSize(size);
        }
        super.setVisible(visible);
    }

    private void addComboBoxActionListeners() {
        if (this.cboAL == null) {
            this.cboAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object item;
                    if (e.getSource() == DataObjAggregatorDlg.this.displayCbo) {
                        Object item2 = DataObjAggregatorDlg.this.displayCbo.getSelectedItem();
                        if (item2 instanceof DataObjSwitchFormatter) {
                            DataObjSwitchFormatter fmt = (DataObjSwitchFormatter)item2;
                            DataObjAggregatorDlg.this.selectedAggregator.setFormatName(fmt.getName());
                            DataObjAggregatorDlg.this.setHasChanged(true);
                        }
                    } else if (e.getSource() == DataObjAggregatorDlg.this.fieldOrderCbo && (item = DataObjAggregatorDlg.this.fieldOrderCbo.getSelectedItem()) instanceof DBFieldInfo) {
                        DBFieldInfo fi = (DBFieldInfo)item;
                        DataObjAggregatorDlg.this.selectedAggregator.setOrderFieldName(fi.getName());
                        DataObjAggregatorDlg.this.setHasChanged(true);
                    }
                }
            };
        }
        this.displayCbo.addActionListener(this.cboAL);
        this.fieldOrderCbo.addActionListener(this.cboAL);
    }

    protected void updateDisplayCombo() {
        DataObjAggregator tempAgg = this.selectedAggregator;
        DefaultComboBoxModel cboModel = (DefaultComboBoxModel)this.displayCbo.getModel();
        cboModel.removeAllElements();
        List<DataObjSwitchFormatter> fmts = this.dataObjFieldFormatMgrCache.getFormatterList(this.tableInfo.getClassObj());
        cboModel.addElement(UIRegistry.getResourceString("NONE"));
        if (fmts.size() == 0) {
            return;
        }
        int selectedFieldIndex = 0;
        int i = 0;
        while (i < fmts.size()) {
            DataObjSwitchFormatter currentFormat = fmts.get(i);
            cboModel.addElement(currentFormat);
            if (tempAgg != null && currentFormat.getName().equals(tempAgg.getFormatName())) {
                selectedFieldIndex = i + 1;
            }
            ++i;
        }
        this.displayCbo.setSelectedIndex(selectedFieldIndex);
    }

    protected void updateFieldValueCombo() {
        DefaultComboBoxModel cboModel = (DefaultComboBoxModel)this.fieldOrderCbo.getModel();
        cboModel.removeAllElements();
        cboModel.addElement(UIRegistry.getResourceString("NONE"));
        List<DBFieldInfo> fields = this.tableInfo.getFields();
        int selectedFieldIndex = 0;
        int i = 0;
        while (i < fields.size()) {
            DBFieldInfo currentField = fields.get(i);
            cboModel.addElement(currentField);
            if (this.selectedAggregator != null && currentField.getName().equals(this.selectedAggregator.getOrderFieldName())) {
                selectedFieldIndex = i + 1;
            }
            ++i;
        }
        this.fieldOrderCbo.setSelectedIndex(selectedFieldIndex);
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
        if (this.hasChanged != hasChanged) {
            this.setWindowModified(true);
        }
        this.updateUIEnabled();
    }

    protected void fillWithObjAggregator(DataObjAggregator agg) {
        this.selectedAggregator = agg;
        this.titleText.setText(agg.getTitle());
        this.nameText.setText(agg.getName());
        this.sepText.setText(agg.getSeparator());
        this.endingText.setText(agg.getEnding());
        this.countSpinner.setValue(agg.getCount() != null ? agg.getCount() : 0);
        this.updateDisplayCombo();
        this.updateFieldValueCombo();
        this.updateUIEnabled();
    }

    @Override
    protected void okButtonPressed() {
        this.selectedAggregator.setTitle(this.titleText.getText());
        this.selectedAggregator.setName(this.nameText.getText());
        this.selectedAggregator.setSeparator(this.sepText.getText());
        this.selectedAggregator.setEnding(this.endingText.getText());
        if (this.isNew) {
            this.selectedAggregator.setDefault(false);
        }
        this.selectedAggregator.setCount((Integer)this.countSpinner.getValue());
        super.okButtonPressed();
    }

    public DataObjAggregator getSelectedAggregator() {
        return this.selectedAggregator;
    }

    protected void vaidateForm() {
        this.validator.processFormRules();
        this.validator.validateForm();
        this.validator.processFormRules();
    }

    protected void updateUIEnabled() {
        this.endingText.setEnabled((Integer)this.countSpinner.getValue() > 0);
        this.okBtn.setEnabled(this.hasChanged && this.validator.isFormValid() && !this.isNameInError);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void dataChanged(String name, Component comp, DataChangeNotifier dcn) {
        this.vaidateForm();
        this.setHasChanged(true);
    }

    protected class DataObjAggregatorDlgDocumentListener
    implements DocumentListener {
        protected JTextField source;
        protected Method setter;

        public DataObjAggregatorDlgDocumentListener(JTextField source, Method setter) {
            this.source = source;
            this.setter = setter;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changed(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changed(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changed(e);
        }

        protected void changed(DocumentEvent e) {
            try {
                this.setter.invoke((Object)DataObjAggregatorDlg.this.selectedAggregator, this.source.getText());
                DataObjAggregatorDlg.this.setHasChanged(true);
            }
            catch (IllegalAccessException iae) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataObjAggregatorDlg.class, iae);
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataObjAggregatorDlg.class, iae);
                throw new RuntimeException("Illegal Access Exception: " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataObjAggregatorDlg.class, ite);
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataObjAggregatorDlg.class, ite);
                throw new RuntimeException("Invocation Target Exception: " + ite.getMessage());
            }
        }
    }
}

