/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.helpers.XMLHelper;
import org.apache.commons.lang.StringUtils;

public class DataObjAggregator
implements Cloneable {
    protected String name;
    protected String title;
    protected Class<?> dataClass;
    protected boolean isDefault;
    protected String separator;
    protected Integer count = null;
    protected String ending;
    protected String formatName;
    protected String orderFieldName;
    protected boolean useIdentity;

    public DataObjAggregator() {
    }

    public DataObjAggregator(String name, String title, Class<?> dataClass, boolean isDefault, String separator, Integer count, String ending, String formatName, String orderFieldName) {
        this.name = name;
        this.title = title;
        this.isDefault = isDefault;
        this.dataClass = dataClass;
        this.separator = separator;
        this.count = count;
        this.ending = ending;
        this.orderFieldName = orderFieldName;
        this.setFormatName(formatName);
        if (StringUtils.isEmpty((String)this.title)) {
            this.title = this.name;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getEnding() {
        return this.ending;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public String getName() {
        return this.name;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean useIdentity() {
        return this.useIdentity;
    }

    public String getOrderFieldName() {
        return this.orderFieldName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCount(String count) {
        try {
            this.count = Integer.valueOf(count);
        }
        catch (Exception e) {
            this.count = 0;
        }
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setEnding(String ending) {
        this.ending = ending;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
        this.useIdentity = "identity".equals(formatName);
    }

    public void setOrderFieldName(String orderFieldName) {
        this.orderFieldName = orderFieldName;
    }

    public String toString() {
        return StringUtils.isNotEmpty((String)this.title) ? this.title : (StringUtils.isNotEmpty((String)this.name) ? this.name : "");
    }

    public void toXML(StringBuilder sb) {
        XMLHelper.setEmptyAttrOK(true);
        String padding = "\n               ";
        sb.append("    <aggregator");
        XMLHelper.xmlAttr(sb, "name", this.name);
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "title", this.title);
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "class", this.dataClass.getName());
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "default", String.valueOf(this.isDefault));
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "separator", this.separator != null ? this.separator : "");
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "ending", this.ending != null ? this.ending : "");
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "count", this.count != null ? String.valueOf(this.count) : "");
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "format", this.formatName != null ? this.formatName : "");
        sb.append(padding);
        XMLHelper.xmlAttr(sb, "orderfieldname", this.orderFieldName != null ? this.orderFieldName : "");
        sb.append(padding);
        sb.append("/>\n\n");
        XMLHelper.setEmptyAttrOK(false);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

