/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregatorDlg;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.FmtListEditorDlgBase;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DataObjAggListEdtDlg
extends FmtListEditorDlgBase {
    protected DBTableInfo tableInfo;

    public DataObjAggListEdtDlg(Frame frame, DBTableInfo tableInfo, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache) throws HeadlessException {
        super(frame, "DOA_DLG_AVAIL_TITLE", "DOA_LIST_EDITOR", tableInfo, dataObjFieldFormatMgrCache, uiFieldFormatterMgrCache);
        this.tableInfo = tableInfo;
    }

    @Override
    protected ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList listArg, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)listArg, value, index, isSelected, cellHasFocus);
                DataObjAggregator agg = (DataObjAggregator)value;
                label.setText(String.valueOf(agg.toString()) + (agg.isDefault() ? " " + UIRegistry.getResourceString("DOA_DEFAULT") : ""));
                return label;
            }
        };
    }

    @Override
    protected void addItem() {
        DataObjAggregator agg = new DataObjAggregator();
        agg.setDataClass(this.tableInfo.getClassObj());
        this.editItem(agg, true);
    }

    @Override
    protected DefaultListModel createListDataModel() {
        DefaultListModel<DataObjAggregator> model = new DefaultListModel<DataObjAggregator>();
        List<DataObjAggregator> aggs = this.dataObjFieldFormatMgrCache.getAggregatorList(this.tableInfo.getClassObj());
        Collections.sort(aggs, new ComparatorByStringRepresentation());
        for (DataObjAggregator agg : aggs) {
            model.addElement(agg);
        }
        return model;
    }

    @Override
    protected void deleteSelectedItem() {
        DataObjAggregator agg = (DataObjAggregator)this.list.getSelectedValue();
        this.listModel.removeElement(agg);
        this.dataObjFieldFormatMgrCache.removeAggregator(agg);
        this.setHasChanged(true);
    }

    @Override
    protected void editItem(Object dataObj, boolean isNew) {
        try {
            DataObjAggregator agg = (DataObjAggregator)dataObj;
            DataObjAggregator tempCopy = isNew ? agg : (DataObjAggregator)agg.clone();
            DataObjAggregatorDlg dlg = new DataObjAggregatorDlg(this, this.tableInfo, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache, tempCopy);
            dlg.setVisible(true);
            if (!dlg.isCancelled() && dlg.hasChanged()) {
                if (isNew) {
                    if (this.listModel.size() == 0) {
                        tempCopy.setDefault(true);
                    }
                    this.dataObjFieldFormatMgrCache.addAggregator(tempCopy);
                    this.listModel.addElement(tempCopy);
                } else {
                    this.listModel.removeElement(agg);
                    this.dataObjFieldFormatMgrCache.removeAggregator(agg);
                    this.dataObjFieldFormatMgrCache.addAggregator(tempCopy);
                    this.listModel.addElement(tempCopy);
                }
                this.setHasChanged(true);
            }
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataObjAggListEdtDlg.class, ex);
        }
    }

    @Override
    protected String[] getDEDAToolTipKeys() {
        return new String[]{"", "", "", ""};
    }

    @Override
    protected void setDefaultItem() {
        DataObjAggregator selected = (DataObjAggregator)this.list.getSelectedValue();
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        int i = 0;
        while (i < model.getSize()) {
            DataObjAggregator agg;
            agg.setDefault((agg = (DataObjAggregator)model.get(i)) == selected);
            ++i;
        }
        this.setHasChanged(true);
        this.list.repaint();
    }
}

