/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.formatters;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataField;
import edu.ku.brc.af.ui.forms.formatters.DataObjDataFieldWrapper;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.util.Pair;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class AvailableFieldsComponent {
    protected DBTableInfo tableInfo;
    protected HashMap<String, DataObjDataFieldWrapper> fieldsByName = new HashMap();
    protected HashMap<String, Pair<DefaultMutableTreeNode, DefaultMutableTreeNode>> treeInfoHash = new HashMap();
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected JTree availableFieldsTree;

    public AvailableFieldsComponent(DBTableInfo tableInfo, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache) {
        this.tableInfo = tableInfo;
        this.dataObjFieldFormatMgrCache = dataObjFieldFormatMgrCache;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.setupAvailableFieldsTree();
    }

    public static DataObjDataFieldWrapper wrapFieldInfo(DataObjDataField field) {
        if (field == null) {
            return null;
        }
        return new DataObjDataFieldWrapper(field);
    }

    public static DataObjDataField unwrap(Object fieldInfoWrapper) {
        if (!(fieldInfoWrapper instanceof DataObjDataFieldWrapper)) {
            return null;
        }
        DataObjDataFieldWrapper fiWrapper = (DataObjDataFieldWrapper)fieldInfoWrapper;
        return fiWrapper.getFormatterField();
    }

    public JTree getTree() {
        return this.availableFieldsTree;
    }

    public void addMouseListener(MouseListener ma) {
        this.availableFieldsTree.addMouseListener(ma);
    }

    public Object getHashEntry(String key) {
        return this.fieldsByName.get(key);
    }

    public boolean containsKey(String key) {
        return this.fieldsByName.containsKey(key);
    }

    protected void setupAvailableFieldsTree() {
        this.fieldsByName.clear();
        Stack<DBInfoBase> tableStack = new Stack<DBInfoBase>();
        DefaultMutableTreeNode root = this.createTreeNodeRecursive(tableStack, this.tableInfo, 1, 4);
        this.availableFieldsTree = new JTree(root);
        this.availableFieldsTree.getSelectionModel().setSelectionMode(1);
    }

    protected DefaultMutableTreeNode createTreeNodeRecursive(Stack<DBInfoBase> tableStack, DBInfoBase infoBase, int currentLevel, int maxLevel) {
        if (infoBase == null || infoBase.isHidden()) {
            return null;
        }
        DBTableInfo currentTableInfo = null;
        DBRelationshipInfo relInfo = null;
        if (infoBase instanceof DBTableInfo) {
            currentTableInfo = (DBTableInfo)infoBase;
        } else if (infoBase instanceof DBRelationshipInfo) {
            relInfo = (DBRelationshipInfo)infoBase;
            currentTableInfo = DBTableIdMgr.getInstance().getByClassName(relInfo.getClassName());
            if (currentTableInfo == null) {
                return null;
            }
        } else {
            return null;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(infoBase);
        if (currentLevel >= maxLevel) {
            return node;
        }
        for (DBFieldInfo field : currentTableInfo.getFields()) {
            if (field.isHidden()) continue;
            DataObjDataField dataField = new DataObjDataField(this.getFieldNameFromStack(tableStack, field.getName()), field.getDataClass(), null, "", null, null);
            dataField.setDbInfo(currentTableInfo, field, relInfo);
            Object fieldWrapper = new DataObjDataFieldWrapper(dataField);
            this.addWrapper(node, (DataObjDataFieldWrapper)fieldWrapper);
            List<UIFieldFormatterIFace> formatters = this.uiFieldFormatterMgrCache.getFormatterList(field.getTableInfo().getClassObj(), field.getName());
            for (UIFieldFormatterIFace formatter : formatters) {
                dataField = new DataObjDataField(this.getFieldNameFromStack(tableStack, field.getName()), field.getDataClass(), null, "", null, formatter.getName());
                dataField.setDbInfo(currentTableInfo, field, relInfo);
                fieldWrapper = new DataObjDataFieldWrapper(dataField);
                this.addWrapper(node, (DataObjDataFieldWrapper)fieldWrapper);
            }
        }
        if (relInfo != null) {
            Class<?> clazz = currentTableInfo.getClassObj();
            List<DataObjSwitchFormatter> formatters = this.dataObjFieldFormatMgrCache.getFormatterList(clazz);
            for (DataObjSwitchFormatter formatter : formatters) {
                DataObjDataField dataField = new DataObjDataField(this.getFieldNameFromStack(tableStack, relInfo.getName()), clazz, null, "", formatter.getName(), null);
                dataField.setDbInfo(currentTableInfo, null, relInfo);
                DataObjDataFieldWrapper fieldWrapper = new DataObjDataFieldWrapper(dataField);
                this.addWrapper(node, fieldWrapper);
            }
        }
        for (DBRelationshipInfo rel : currentTableInfo.getRelationships()) {
            boolean isToOne;
            boolean bl = isToOne = DBRelationshipInfo.RelationshipType.ManyToOne.equals((Object)rel.getType()) || DBRelationshipInfo.RelationshipType.OneToOne.equals((Object)rel.getType()) || rel.isLikeManyToOne();
            if (rel.isHidden() || !isToOne) continue;
            tableStack.add(rel);
            DefaultMutableTreeNode child = this.createTreeNodeRecursive(tableStack, rel, currentLevel + 1, maxLevel);
            if (child != null) {
                node.add(child);
            }
            tableStack.pop();
        }
        return node;
    }

    private void addWrapper(DefaultMutableTreeNode node, DataObjDataFieldWrapper fieldWrapper) {
        boolean okToUpdate;
        String key = fieldWrapper.toString();
        DataObjDataFieldWrapper dfw = this.fieldsByName.get(key);
        boolean bl = okToUpdate = dfw != null && dfw.getFormatterField().getFieldInfo() == null && fieldWrapper.getFormatterField().getFieldInfo() != null;
        if (dfw == null || okToUpdate) {
            if (okToUpdate) {
                Pair<DefaultMutableTreeNode, DefaultMutableTreeNode> oldPair = this.treeInfoHash.get(key);
                ((DefaultMutableTreeNode)oldPair.first).remove((MutableTreeNode)oldPair.second);
            }
            DefaultMutableTreeNode nodeWrapper = new DefaultMutableTreeNode(fieldWrapper);
            node.add(nodeWrapper);
            this.fieldsByName.put(key, fieldWrapper);
            this.treeInfoHash.put(key, new Pair<DefaultMutableTreeNode, DefaultMutableTreeNode>(node, nodeWrapper));
        }
    }

    private String getFieldNameFromStack(Stack<DBInfoBase> tableStack, String fieldName) {
        StringBuilder sb = new StringBuilder();
        for (DBInfoBase infoBase : tableStack) {
            sb.append(String.valueOf(infoBase.getName()) + ".");
        }
        sb.append(fieldName);
        return sb.toString();
    }
}

