/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.ui.forms.ViewSetMgr;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.helpers.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.apache.commons.io.FileUtils;

public class ViewSetMgrManager {
    public static final String BACKSTOP = "backstop";
    protected static Stack<ViewSetMgr> stack = new Stack();

    public static void pushViewMgr(ViewSetMgr viewMgr) {
        stack.push(viewMgr);
    }

    public static void refresh() {
        ViewSetMgrManager.clear(true);
        if (stack.size() == 0) {
            ViewSetMgrManager.pushViewMgr(new ViewSetMgr("BackStop", new File(XMLHelper.getConfigDirPath(String.valueOf(File.separator) + BACKSTOP)), false));
        }
    }

    public static void clear(boolean keepBackStop) {
        ViewSetMgr vsm;
        while (keepBackStop && stack.size() > 1 || !keepBackStop && stack.size() > 0) {
            ViewSetMgr vm = stack.pop();
            vm.clearAll();
        }
        if (stack.size() > 0 && (vsm = stack.peek()) != null) {
            File bsDir = new File(XMLHelper.getConfigDirPath(String.valueOf(File.separator) + BACKSTOP));
            if (!vsm.getContextDir().getAbsoluteFile().equals(bsDir.getAbsoluteFile())) {
                vsm.clearAll();
                stack.pop();
            }
        }
    }

    public static ViewIFace getView(String viewSetName, String viewName) {
        int inx = stack.size() - 1;
        while (inx >= 0) {
            ViewIFace view;
            ViewSetMgr viewMgr = (ViewSetMgr)stack.get(inx);
            ViewSetIFace viewSet = viewMgr.getViewSet(viewSetName);
            if (viewSet != null && (view = viewSet.getView(viewName)) != null) {
                return view;
            }
            --inx;
        }
        return null;
    }

    public static void copyViewSet(ViewSetMgr srcVM, ViewSetMgr dstVM, String viewSetName, boolean overwrite) {
        if (overwrite || dstVM.getViewSet(viewSetName) == null) {
            ViewSetIFace vs = srcVM.getViewSet(viewSetName);
            if (vs != null) {
                File srcFile = new File(String.valueOf(srcVM.getContextDir().getAbsolutePath()) + File.separator + vs.getFileName());
                File dstFile = new File(String.valueOf(dstVM.getContextDir().getAbsolutePath()) + File.separator + vs.getFileName());
                try {
                    FileUtils.copyFile((File)srcFile, (File)dstFile);
                    dstVM.addViewSetDef(vs.getType().toString(), vs.getName(), vs.getTitle(), vs.getFileName(), vs.getI18NResourceName());
                }
                catch (IOException ex) {
                    FormDevHelper.appendFormDevError("IOException: ", ex);
                }
            } else {
                FormDevHelper.appendFormDevError("ViewSet [" + viewSetName + "] cannot be found in source ViewSet.");
            }
        } else {
            FormDevHelper.appendFormDevError("ViewSet [" + viewSetName + "] is already in the destination and override was false.");
        }
    }
}

