/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSet;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ViewSetMgr {
    private static final String REGISTRY_FILENAME = "viewset_registry.xml";
    private static final Logger log = Logger.getLogger(ViewSetMgr.class);
    private static SAXReader saxReader = null;
    protected String name;
    protected Hashtable<String, ViewSetIFace> viewsHash = new Hashtable();
    protected File contextDir = null;
    protected boolean registryExists = false;

    public ViewSetMgr(String name, File contextDir) {
        this.name = name;
        this.init(contextDir, true);
    }

    public ViewSetMgr(String name, File contextDir, boolean emptyIsOK) {
        this.name = name;
        this.init(contextDir, emptyIsOK);
    }

    public String getName() {
        return this.name;
    }

    public void addViewSetDef(String typeStr, String nameArg, String title, String fileName, String i18NResourceName) {
        if (this.isViewSetNameInUse(nameArg)) {
            throw new RuntimeException("ViewSet Name[" + nameArg + "] is in use.");
        }
        ViewSet viewSet = new ViewSet(ViewSet.parseType(typeStr), nameArg, title, fileName, this.contextDir);
        viewSet.setI18NResourceName(i18NResourceName);
        this.viewsHash.put(viewSet.getName(), viewSet);
    }

    public void addViewSet(ViewSet viewSet) {
        this.viewsHash.put(viewSet.getName(), viewSet);
    }

    public void clearAll() {
        this.reset();
        this.viewsHash.clear();
    }

    public void reset() {
        Enumeration<ViewSetIFace> e = this.viewsHash.elements();
        while (e.hasMoreElements()) {
            e.nextElement().cleanUp();
        }
    }

    public boolean isViewSetNameInUse(String viewSetName) {
        return this.viewsHash.get(viewSetName) != null;
    }

    public boolean isViewInUse(String viewSetName, String viewName) {
        return this.getView(viewSetName, viewName) != null;
    }

    public ViewIFace getView(String viewSetName, String viewName) {
        ViewSetIFace viewSet = null;
        if (StringUtils.isNotEmpty((String)viewSetName)) {
            viewSet = this.viewsHash.get(viewSetName);
        } else {
            for (ViewSetIFace vs : this.viewsHash.values()) {
                for (ViewIFace view : vs.getViews().values()) {
                    if (!view.getName().equals(viewName)) continue;
                    return view;
                }
            }
        }
        if (viewSet != null) {
            return viewSet.getView(viewName);
        }
        return null;
    }

    public ViewSetIFace getViewSet(String viewSetName) {
        if (viewSetName == null) {
            List<ViewSetIFace> userVS = this.getUserViewSets();
            if (userVS.size() == 1) {
                return userVS.get(0);
            }
            log.error((Object)"User ViewSets:");
            for (ViewSetIFace vs : userVS) {
                log.error((Object)vs.getName());
            }
            FormDevHelper.showFormDevError("There are multiple User ViewSets so I don't know which one to choose for the default.");
            return null;
        }
        return this.viewsHash.get(viewSetName);
    }

    public List<ViewSetIFace> getViewSets() {
        return Collections.list(this.viewsHash.elements());
    }

    public List<ViewSetIFace> getUserViewSets() {
        ArrayList<ViewSetIFace> list = new ArrayList<ViewSetIFace>();
        Enumeration<ViewSetIFace> e = this.viewsHash.elements();
        while (e.hasMoreElements()) {
            ViewSetIFace vs = e.nextElement();
            if (vs.getType() != ViewSetIFace.Type.User) continue;
            list.add(vs);
        }
        return list;
    }

    public void setContextDir(File contextDir) {
        this.contextDir = contextDir;
    }

    public File getContextDir() {
        return this.contextDir;
    }

    public boolean isRegistryExists() {
        return this.registryExists;
    }

    protected void init(Element rootDOM) {
        if (rootDOM != null) {
            Iterator i = rootDOM.elementIterator("file");
            while (i.hasNext()) {
                Element fileElement = (Element)i.next();
                String fName = XMLHelper.getAttr(fileElement, "name", null);
                if (!this.isViewSetNameInUse(fName)) {
                    String typeStr = XMLHelper.getAttr(fileElement, "type", "system");
                    String title = XMLHelper.getAttr(fileElement, "title", null);
                    String fileName = XMLHelper.getAttr(fileElement, "file", null);
                    if (StringUtils.isEmpty((String)typeStr)) {
                        FormDevHelper.appendFormDevError("ViewSet type cannot be null!");
                        return;
                    }
                    if (StringUtils.isEmpty((String)title)) {
                        FormDevHelper.appendFormDevError("ViewSet title cannot be null!");
                        return;
                    }
                    if (StringUtils.isEmpty((String)fileName)) {
                        FormDevHelper.appendFormDevError("ViewSet file cannot be null!");
                        return;
                    }
                    File viewSetFile = new File(this.contextDir.getAbsoluteFile() + File.separator + fileName);
                    if (!viewSetFile.exists()) {
                        FormDevHelper.appendFormDevError("ViewSet file cannot be found at[" + viewSetFile.getAbsolutePath() + "]");
                        return;
                    }
                    ViewSet viewSet = new ViewSet(ViewSet.parseType(typeStr), fName, title, fileName, this.contextDir);
                    this.viewsHash.put(viewSet.getName(), viewSet);
                    continue;
                }
                String msg = "ViewSet Name[" + fName + "] is in use.";
                log.error((Object)msg);
                FormDevHelper.appendFormDevError(msg);
            }
        } else {
            String msg = "The root element for the document was null!";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
        }
    }

    protected void init(File contextDirArg, boolean emptyIsOK) {
        this.contextDir = contextDirArg;
        this.registryExists = false;
        if (contextDirArg != null) {
            log.debug((Object)contextDirArg.getAbsoluteFile());
            File vsRegFile = new File(contextDirArg.getAbsoluteFile() + File.separator + REGISTRY_FILENAME);
            if (vsRegFile.exists()) {
                this.registryExists = true;
                try {
                    Document document = ViewSetMgr.readFileToDOM4J(new FileInputStream(vsRegFile));
                    Element root = document.getRootElement();
                    this.init(root);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ViewSetMgr.class, ex);
                }
            } else if (!emptyIsOK) {
                throw new ConfigurationException(vsRegFile.getAbsoluteFile() + " doesn't exist.");
            }
        }
    }

    public void save() throws IOException {
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(this.contextDir.getAbsoluteFile() + File.separator + REGISTRY_FILENAME));
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            output.write("<files>\n");
            Enumeration<ViewSetIFace> e = this.viewsHash.elements();
            while (e.hasMoreElements()) {
                ViewSetIFace viewSet = e.nextElement();
                output.write("      <file type=\"" + viewSet.getType().toString() + "\" name=\"" + viewSet.getName() + "\" title=\"" + viewSet.getTitle() + "\" file=\"" + viewSet.getFileName() + "\"/>\n");
            }
            output.write("</files>\n");
        }
        finally {
            if (output != null) {
                output.flush();
                output.close();
            }
        }
    }

    public static Document readFileToDOM4J(FileInputStream fileInputStream) throws Exception {
        if (saxReader == null) {
            saxReader = new SAXReader();
        }
        boolean doValidation = false;
        saxReader.setValidation(doValidation);
        return saxReader.read((InputStream)fileInputStream);
    }
}

