/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.BrowseBtnPanel;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.TextFieldFromPickListTable;
import edu.ku.brc.af.ui.db.TextFieldWithInfo;
import edu.ku.brc.af.ui.forms.BrowserLauncherBtn;
import edu.ku.brc.af.ui.forms.CollapsableSeparator;
import edu.ku.brc.af.ui.forms.EditViewCompSwitcherPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.IconViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.PanelViewable;
import edu.ku.brc.af.ui.forms.RecordSetTableViewObj;
import edu.ku.brc.af.ui.forms.ResultSetControllerListener;
import edu.ku.brc.af.ui.forms.SubViewBtn;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.ViewBuilderIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.formatters.GenericStringUIFieldFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellCommand;
import edu.ku.brc.af.ui.forms.persist.FormCellField;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellLabel;
import edu.ku.brc.af.ui.forms.persist.FormCellPanel;
import edu.ku.brc.af.ui.forms.persist.FormCellSeparatorIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellSubView;
import edu.ku.brc.af.ui.forms.persist.FormCellSubViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.FormRowIFace;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.FormViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValBrowseBtnPanel;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextField;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldIFace;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextFieldSingle;
import edu.ku.brc.af.ui.forms.validation.ValListBox;
import edu.ku.brc.af.ui.forms.validation.ValPasswordField;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.af.ui.forms.validation.ValSpinner;
import edu.ku.brc.af.ui.forms.validation.ValTextArea;
import edu.ku.brc.af.ui.forms.validation.ValTextAreaBrief;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.af.ui.forms.validation.ValTristateCheckBox;
import edu.ku.brc.af.ui.forms.validation.ValidatedJPanel;
import edu.ku.brc.af.ui.weblink.WebLinkButton;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.plugins.SeriesProcCatNumPlugin;
import edu.ku.brc.ui.ColorChooser;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandActionWrapper;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconButton;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ImageDisplay;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewFactory {
    public static final String factoryName = "edu.ku.brc.af.ui.forms.ViewFactory";
    private static final Logger log = Logger.getLogger(ViewFactory.class);
    private static final String LF = "\\n";
    private static ViewFactory instance = null;
    private static ColorWrapper viewFieldColor = null;
    private static boolean doFixLabels = true;
    private static boolean isFormTransparent = false;

    protected ViewFactory() {
    }

    public static void setDoFixLabels(boolean doFixLabels) {
        ViewFactory.doFixLabels = doFixLabels;
    }

    public JPanel createIconPanel(JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        JButton btn = UIHelper.createButton("...");
        panel.add((Component)btn, "West");
        panel.add((Component)comp, "East");
        return panel;
    }

    public Viewable buildViewable(ViewIFace view, AltViewIFace altView, MultiView parentView, int options, String cellName, Color bgColor) {
        ResultSetControllerListener viewable;
        MultiView parentsMV;
        ViewDefIFace viewDef;
        if (viewFieldColor == null) {
            viewFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "viewfieldcolor");
        }
        if ((viewDef = altView.getViewDef()) == null) {
            String msg = String.format("The ViewDef is null for View '%s' AltView '%s'", view.getName(), altView.getName());
            FormDevHelper.appendFormDevError(msg);
            UIRegistry.showError(msg);
            return null;
        }
        Class<?> dataClass = null;
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
        MultiView multiView = parentsMV = parentView != null ? parentView.getMultiViewParent() : null;
        if (tableInfo == null && parentsMV != null && cellName != null) {
            DBTableChildIFace childInfo;
            tableInfo = DBTableIdMgr.getInstance().getByClassName(parentsMV.getView().getClassName());
            if (tableInfo != null && (childInfo = tableInfo.getItemByName(cellName)) != null) {
                dataClass = childInfo.getDataClass();
            }
        } else {
            try {
                dataClass = Class.forName(view.getClassName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (viewDef.getType() == ViewDefIFace.ViewType.form) {
            viewable = this.buildFormViewable(view, altView, parentView, options, cellName, dataClass, bgColor);
            return viewable;
        }
        if (viewDef.getType() == ViewDefIFace.ViewType.table || viewDef.getType() == ViewDefIFace.ViewType.formtable) {
            viewable = this.buildTableViewable(view, altView, parentView, options, cellName, dataClass, bgColor);
            return viewable;
        }
        if (viewDef.getType() == ViewDefIFace.ViewType.field) {
            return null;
        }
        if (viewDef.getType() == ViewDefIFace.ViewType.iconview) {
            return new IconViewObj(view, altView, parentView, options, cellName, dataClass);
        }
        if (viewDef.getType() == ViewDefIFace.ViewType.rstable) {
            return this.buildRecordSetTableViewable(view, altView, parentView, options, cellName, dataClass, bgColor);
        }
        FormDevHelper.appendFormDevError("Form Type not covered by builder [" + (Object)((Object)viewDef.getType()) + "]");
        return null;
    }

    public static JTextField createTextField(FormValidator validator, FormCellField cellField, DBFieldInfo fieldInfo, boolean isRequired, PickListDBAdapterIFace adapter) {
        ValTextField txtField;
        String validationRule = cellField.getValidationRule();
        ValTextField valTextField = null;
        if (validator != null && (isRequired || StringUtils.isNotEmpty((String)validationRule) || cellField.isChangeListenerOnly())) {
            valTextField = new ValTextField(cellField.getTxtCols(), adapter);
            valTextField.setRequired(isRequired);
            valTextField.setViewOnly(cellField.isReadOnly());
            validator.hookupTextField(valTextField, cellField.getIdent(), isRequired, UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), cellField.isChangeListenerOnly() && !isRequired);
            txtField = valTextField;
            valTextField.setEditable(!cellField.isReadOnly());
            if (fieldInfo != null && fieldInfo.getLength() > -1) {
                valTextField.setLimit(fieldInfo.getLength());
            }
        } else if (adapter != null) {
            valTextField = new ValTextField(cellField.getTxtCols(), adapter);
            valTextField.setViewOnly(cellField.isReadOnly());
            if (fieldInfo.getLength() > -1) {
                valTextField.setLimit(fieldInfo.getLength());
            }
            txtField = valTextField;
            valTextField.setEditable(false);
        } else {
            valTextField = new ValTextField(cellField.getTxtCols());
            valTextField.setViewOnly(cellField.isReadOnly());
            if (fieldInfo != null && fieldInfo.getLength() > -1) {
                valTextField.setLimit(fieldInfo.getLength());
            }
            txtField = valTextField;
        }
        ViewFactory.addTextFieldPopup(valTextField, valTextField, false);
        return txtField;
    }

    public static JTextField createPasswordField(FormValidator validator, FormCellField cellField, boolean isRequired) {
        ValPasswordField txt;
        String validationRule = cellField.getValidationRule();
        ValPasswordField textField = null;
        if (validator != null && (isRequired || StringUtils.isNotEmpty((String)validationRule) || cellField.isChangeListenerOnly())) {
            String maxLenStr = cellField.getProperties().getProperty("maxlen");
            if (StringUtils.isNotEmpty((String)maxLenStr) && StringUtils.isNumeric((String)maxLenStr)) {
                int maxlen = Integer.parseInt(maxLenStr);
                textField = new ValPasswordField(new ValPlainTextDocument(maxlen), "", cellField.getTxtCols());
            } else {
                textField = new ValPasswordField(cellField.getTxtCols());
            }
            textField.setRequired(isRequired);
            textField.setEncrypted(cellField.isEncrypted());
            validator.hookupTextField(textField, cellField.getIdent(), isRequired, UIValidator.parseValidationType(cellField.getValidationType()), validationRule, cellField.isChangeListenerOnly());
            txt = textField;
        } else {
            txt = new ValPasswordField(cellField.getTxtCols());
        }
        return txt;
    }

    public static JComponent createFormattedTextField(FormValidator validator, FormCellField cellField, Class<?> tableClass, int len, String uiFormatterName, boolean isViewOnly, boolean isRequired, boolean allEditOK) {
        boolean isPartialOK = cellField.getPropertyAsBoolean("ispartial", false);
        boolean isFromUIFmtOverride = cellField.getPropertyAsBoolean("fromuifmt", false);
        Integer suggestedNumCols = cellField.getPropertyAsInteger("cols", null);
        if (validator != null) {
            JComponent textField;
            UIFieldFormatterIFace formatter = UIFieldFormatterMgr.getInstance().getFormatter(uiFormatterName);
            if (formatter == null) {
                String msg = "Field[" + cellField.getName() + "] is missing formatter by name [" + uiFormatterName + "]";
                log.debug((Object)msg);
                FormDevHelper.appendFormDevError(msg);
                formatter = new GenericStringUIFieldFormatter("Temp", tableClass, cellField.getName(), "", len);
            }
            if (formatter.isDate() || formatter.isNumeric()) {
                textField = new ValFormattedTextFieldSingle(uiFormatterName, isViewOnly, isPartialOK, suggestedNumCols);
                ((ValFormattedTextFieldSingle)textField).setRequired(isRequired);
                validator.hookupTextField((JTextComponent)textField, cellField.getIdent(), isRequired, UIValidator.Type.Changed, cellField.getValidationRule(), false);
                ViewFactory.addTextFieldPopup((GetSetValueIFace)((Object)textField), (JTextField)textField, formatter.isDate());
                if (isViewOnly) {
                    ViewFactory.changeTextFieldUIForDisplay((JTextField)textField, cellField.getPropertyAsBoolean("transparent", false));
                } else {
                    ((JTextComponent)textField).setEditable(!cellField.isReadOnly());
                }
                ((ValFormattedTextFieldSingle)textField).setFromUIFmtOverride(isFromUIFmtOverride);
                return textField;
            }
            textField = new ValFormattedTextField(formatter, isViewOnly, allEditOK, isPartialOK);
            ((ValFormattedTextField)textField).setRequired(isRequired);
            ((ValFormattedTextField)textField).setFromUIFmtOverride(isFromUIFmtOverride);
            DataChangeNotifier dcn = validator.hookupComponent(textField, cellField.getIdent(), UIValidator.Type.Changed, cellField.getValidationRule(), false);
            if (cellField.isRequired()) {
                ((ValFormattedTextField)textField).addDocumentListener(dcn);
            }
            ((ValFormattedTextField)textField).setChangeListener(dcn);
            return textField;
        }
        if (isViewOnly) {
            ValFormattedTextFieldSingle vtfs;
            UIFieldFormatterIFace formatter = UIFieldFormatterMgr.getInstance().getFormatter(uiFormatterName);
            if (formatter == null) {
                formatter = new GenericStringUIFieldFormatter("Temp", tableClass, cellField.getName(), "", len);
                vtfs = new ValFormattedTextFieldSingle(formatter, isViewOnly, false);
            } else {
                vtfs = new ValFormattedTextFieldSingle(uiFormatterName, isViewOnly, false, suggestedNumCols);
            }
            ViewFactory.changeTextFieldUIForDisplay(vtfs, cellField.getPropertyAsBoolean("transparent", false));
            return vtfs;
        }
        ValFormattedTextField vtf = new ValFormattedTextField(uiFormatterName, isViewOnly, allEditOK, isPartialOK);
        vtf.setEnabled(!cellField.isReadOnly());
        vtf.setRequired(isRequired);
        vtf.setFromUIFmtOverride(isFromUIFmtOverride);
        return vtf;
    }

    public static void addTextFieldPopup(final GetSetValueIFace destObj, JTextField textField, boolean doAddDate) {
        if (textField != null) {
            JPopupMenu popupMenu = new JPopupMenu();
            if (doAddDate) {
                AbstractAction aa = new AbstractAction("Clear It"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
                        if (scrDateFormat != null) {
                            destObj.setValue(scrDateFormat.format(Calendar.getInstance()), "");
                        } else {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            destObj.setValue(sdf.format(Calendar.getInstance()), "");
                        }
                    }
                };
                UIHelper.createLocalizedMenuItem(popupMenu, "ViewFactory.CURR_DATE", "", "", true, (ActionListener)aa);
                KeyStroke ctrlShiftT = KeyStroke.getKeyStroke(84, 192);
                textField.getInputMap().put(ctrlShiftT, "SetCurrentDate");
                textField.getActionMap().put("SetCurrentDate", aa);
            }
            String clearField = "ClearField";
            AbstractAction clearAction = new AbstractAction(clearField){

                @Override
                public void actionPerformed(ActionEvent e) {
                    destObj.setValue("", "");
                }
            };
            UIHelper.createLocalizedMenuItem(popupMenu, "ViewFactory.CLEAR", "", "", true, (ActionListener)clearAction);
            textField.getInputMap().put(KeyStroke.getKeyStroke("F3"), clearField);
            textField.getActionMap().put(clearField, clearAction);
            textField.add(popupMenu);
            textField.setComponentPopupMenu(popupMenu);
        }
    }

    public static JTextArea createTextArea(FormValidator validator, FormCellField cellField, boolean isRequired, DBFieldInfo fieldInfo) {
        boolean doValidation = validator != null && (isRequired || StringUtils.isNotEmpty((String)cellField.getValidationRule()) || cellField.isChangeListenerOnly());
        ValTextArea textArea = new ValTextArea(cellField.getTxtRows(), cellField.getTxtCols());
        if (doValidation && fieldInfo != null && fieldInfo.getLength() > 0) {
            textArea.setDocument(new ValPlainTextDocument(fieldInfo.getLength()));
        }
        textArea.setRequired(isRequired);
        textArea.setRows(cellField.getTxtRows());
        if (doValidation && validator != null) {
            validator.hookupTextField(textArea, cellField.getIdent(), isRequired, UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), cellField.isChangeListenerOnly() && !isRequired);
        }
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(!cellField.isReadOnly() && validator != null);
        return textArea;
    }

    public static ValTextAreaBrief createTextAreaBrief(FormValidator validator, FormCellField cellField, boolean isRequired, DBFieldInfo fieldInfo) {
        boolean doValidation = validator != null && (isRequired || StringUtils.isNotEmpty((String)cellField.getValidationRule()) || cellField.isChangeListenerOnly());
        ValTextAreaBrief textArea = new ValTextAreaBrief(cellField.getTxtRows(), cellField.getTxtCols());
        if (doValidation && fieldInfo != null && fieldInfo.getLength() > 0) {
            textArea.setDocument(new ValPlainTextDocument(fieldInfo.getLength()));
        }
        textArea.setRequired(isRequired);
        textArea.initialize(validator != null);
        textArea.setRows(cellField.getTxtRows());
        if (doValidation && validator != null) {
            validator.hookupTextField(textArea, cellField.getIdent(), isRequired, UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), cellField.isChangeListenerOnly() && !isRequired);
        }
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(!cellField.isReadOnly() && validator != null);
        return textArea;
    }

    public static JList createList(FormValidator validator, FormCellField cellField, boolean isRequired) {
        ValListBox valList;
        Object[] initArray = null;
        String dataStr = cellField.getProperty("data");
        if (StringUtils.isNotEmpty((String)dataStr)) {
            initArray = StringUtils.split((String)dataStr, (String)",");
            int i = 0;
            while (i < initArray.length) {
                initArray[i] = ((String)initArray[i]).trim();
                ++i;
            }
        }
        ValListBox valListBox = valList = initArray == null ? new ValListBox() : new ValListBox(initArray);
        if (validator != null && (isRequired || StringUtils.isNotEmpty((String)cellField.getValidationRule()))) {
            DataChangeNotifier dcn = validator.hookupComponent(valList, cellField.getIdent(), UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), false);
            valList.getModel().addListDataListener(dcn);
            valList.addFocusListener(dcn);
        }
        valList.setRequired(isRequired);
        valList.setVisibleRowCount(cellField.getPropertyAsInt("rows", 15));
        return valList;
    }

    public static ValComboBoxFromQuery createQueryComboBox(FormValidator validator, FormCellField cellField, boolean isRequired, boolean doAdjustQuery) {
        String cbxName = cellField.getProperty("name");
        if (StringUtils.isNotEmpty((String)cbxName)) {
            int btnOpts = 0;
            btnOpts |= cellField.getPropertyAsBoolean("editbtn", true) ? 1 : 0;
            btnOpts |= cellField.getPropertyAsBoolean("newbtn", true) ? 2 : 0;
            btnOpts |= cellField.getPropertyAsBoolean("searchbtn", true) ? 4 : 0;
            int n = cellField.getPropertyAsBoolean("clonebtn", false) ? 8 : 0;
            String helpContext = cellField.getProperty("hc");
            ValComboBoxFromQuery cbx = TypeSearchForQueryFactory.getInstance().createValComboBoxFromQuery(cbxName, btnOpts |= n, cellField.getFormatName(), helpContext);
            if (cbx != null) {
                cbx.setRequired(isRequired);
                cbx.setSearchDlgName(cellField.getProperty("searchdlg"));
                cbx.setDisplayDlgName(cellField.getProperty("displaydlg"));
                if (validator != null) {
                    DataChangeNotifier dcn = validator.hookupComponent(cbx, cellField.getIdent(), UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), false);
                    cbx.addListSelectionListener(dcn);
                    cbx.addFocusListener(dcn);
                }
                cbx.setCellName(cellField.getName());
                cbx.setDoAdjustQuery(doAdjustQuery);
            } else {
                UIRegistry.showLocalizedError("ERR_NEED_SHUTDOWN");
            }
            return cbx;
        }
        FormDevHelper.appendFormDevError("CBX Name for ValComboBoxFromQuery [" + cbxName + "] is empty!");
        return null;
    }

    public static ValComboBox createValComboBox(FormValidator validator, FormCellField cellField, PickListDBAdapterIFace adapter, boolean isRequired) {
        boolean makeEditable = cellField.getPropertyAsBoolean("editable", false);
        ValComboBox cbx = null;
        if (adapter != null) {
            cbx = new ValComboBox(adapter);
        } else {
            Object[] initArray = null;
            String data = cellField.getProperty("data");
            if (StringUtils.isNotEmpty((String)data)) {
                initArray = StringUtils.split((String)data, (String)",");
                int i = 0;
                while (i < initArray.length) {
                    initArray[i] = ((String)initArray[i]).trim();
                    ++i;
                }
            }
            cbx = initArray == null || initArray.length == 0 ? new ValComboBox(makeEditable) : new ValComboBox(initArray, makeEditable);
        }
        cbx.setRequired(isRequired);
        if (validator != null && (isRequired || cellField.isChangeListenerOnly() || StringUtils.isNotEmpty((String)cellField.getValidationRule()))) {
            DataChangeNotifier dcn = validator.hookupComponent(cbx, cellField.getIdent(), UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), cellField.isChangeListenerOnly());
            cbx.getComboBox().addActionListener(dcn);
            cbx.addChangeListener(dcn);
            if (dcn.getValidationType() == UIValidator.Type.Focus) {
                cbx.addFocusListener(dcn);
            }
        }
        return cbx;
    }

    public static void changeTextFieldUIForDisplay(JTextField textField, boolean isTransparent) {
        ViewFactory.changeTextFieldUIForDisplay(textField, null, isTransparent);
    }

    public static void changeTextFieldUIForDisplay(JTextField textField, Color borderColor, boolean isTransparent) {
        Insets insets = textField.getBorder().getBorderInsets(textField);
        if (borderColor != null) {
            textField.setBorder(BorderFactory.createMatteBorder(Math.min(insets.top, 3), Math.min(insets.left, 3), Math.min(insets.bottom, 3), Math.min(insets.right, 3), borderColor));
        } else {
            textField.setBorder(BorderFactory.createEmptyBorder(Math.min(insets.top, 3), Math.min(insets.left, 3), Math.min(insets.bottom, 3), Math.min(insets.right, 3)));
        }
        textField.setForeground(Color.BLACK);
        textField.setEditable(false);
        textField.setOpaque(!isTransparent);
        if (isTransparent) {
            textField.setBackground(null);
        } else if (viewFieldColor != null) {
            textField.setBackground(viewFieldColor.getColor());
        }
    }

    public static void changeTextFieldUIForEdit(JTextField textField, Border border, Color fgColor, Color bgColor, boolean isOpaque) {
        textField.setBorder(border);
        textField.setForeground(fgColor);
        textField.setEditable(true);
        textField.setFocusable(true);
        textField.setOpaque(isOpaque);
        textField.setBackground(bgColor);
    }

    public static JScrollPane changeTextAreaForDisplay(JTextArea ta) {
        Insets insets = ta.getBorder().getBorderInsets(ta);
        ta.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.bottom));
        ta.setForeground(Color.BLACK);
        ta.setEditable(false);
        ta.setBackground(viewFieldColor.getColor());
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(ta);
        insets = scrollPane.getBorder().getBorderInsets(scrollPane);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.bottom));
        return scrollPane;
    }

    public static JScrollPane createDisplayTextArea(FormCellFieldIFace cellField) {
        JTextArea ta = new JTextArea(cellField.getTxtRows(), cellField.getTxtCols());
        return ViewFactory.changeTextAreaForDisplay(ta);
    }

    public static TextFieldWithInfo createTextFieldWithInfo(FormCellField cellField, MultiView parent) {
        TextFieldWithInfo textFieldInfo = null;
        String txtName = cellField.getProperty("name");
        if (StringUtils.isNotEmpty((String)txtName)) {
            textFieldInfo = TypeSearchForQueryFactory.getInstance().getTextFieldWithInfo(txtName, cellField.getFormatName());
            if (textFieldInfo != null) {
                textFieldInfo.setMultiView(parent);
                textFieldInfo.setFrameTitle(cellField.getProperty("title"));
                JTextField textField = textFieldInfo.getTextField();
                textField.setColumns(cellField.getTxtCols());
                String displayInfoDialogName = cellField.getProperty("displaydlg");
                if (StringUtils.isNotEmpty((String)displayInfoDialogName)) {
                    textFieldInfo.setDisplayInfoDialogName(displayInfoDialogName);
                }
                ViewFactory.changeTextFieldUIForDisplay(textField, false);
            } else {
                String msg = "Could TypeSearchForQueryFactory.getTextFieldWithInfo(" + txtName + ")";
                log.error((Object)msg);
                FormDevHelper.appendFormDevError(msg);
            }
        } else {
            String msg = "textfieldinfo Name for textFieldWithInfo [" + txtName + "] is empty!";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
        }
        return textFieldInfo;
    }

    public static ImageDisplay createImageDisplay(FormCellField cellField, AltViewIFace.CreationMode mode, FormValidator validator) {
        String urlStr;
        String[] wh;
        int w = 150;
        int h = 150;
        String sizeDefStr = cellField.getProperty("size");
        if (StringUtils.isNotEmpty((String)sizeDefStr) && (wh = StringUtils.split((String)sizeDefStr, (String)",")).length == 2) {
            try {
                w = Integer.parseInt(wh[0]);
                h = Integer.parseInt(wh[1]);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ViewFactory.class, ex);
                log.error((Object)("size prop for Image is incorrect [" + sizeDefStr + "]"));
            }
        }
        boolean imageInEdit = mode == AltViewIFace.CreationMode.EDIT;
        String editModeStr = cellField.getProperty("edit");
        if (StringUtils.isNotEmpty((String)editModeStr)) {
            imageInEdit = editModeStr.toLowerCase().equals("true");
        }
        ImageDisplay imgDisp = new ImageDisplay(w, h, imageInEdit, cellField.getPropertyAsBoolean("border", true));
        if (validator != null) {
            DataChangeNotifier dcn = validator.hookupComponent(imgDisp, cellField.getIdent(), UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), false);
            imgDisp.addPropertyChangeListener("imageURL", dcn);
            if (dcn.getValidationType() == UIValidator.Type.Focus) {
                imgDisp.addFocusListener(dcn);
            }
        }
        if (StringUtils.isNotEmpty((String)(urlStr = cellField.getProperty("url")))) {
            imgDisp.setValue(urlStr, "");
        } else {
            String name = cellField.getProperty("icon");
            if (StringUtils.isNotEmpty((String)name)) {
                IconManager.IconSize sz;
                boolean loadIt = true;
                String iconSize = cellField.getProperty("iconsize");
                if (StringUtils.isNotEmpty((String)iconSize) && (sz = IconManager.getIconSize(Integer.parseInt(iconSize), false, false)) != null) {
                    imgDisp.setImage(IconManager.getImage(name, sz));
                    loadIt = false;
                }
                if (loadIt) {
                    imgDisp.setImage(IconManager.getIcon(name));
                }
            }
        }
        return imgDisp;
    }

    private JButton createFormButton(FormCellIFace fcf, String text) {
        String tooltip = fcf.getProperty("tooltip");
        String iconName = fcf.getProperty("icon");
        String sizeStr = fcf.getProperty("size");
        if (StringUtils.isNotEmpty((String)text)) {
            return UIHelper.createButton(text);
        }
        if (StringUtils.isNotEmpty((String)iconName)) {
            int iconSize = StringUtils.isNotEmpty((String)sizeStr) && StringUtils.isNumeric((String)sizeStr) ? Integer.parseInt(sizeStr) : 16;
            IconManager.IconSize iSize = IconManager.getIconSize(iconSize, false, false);
            IconButton iconBtn = new IconButton(IconManager.getIcon(iconName, iSize), true);
            iconBtn.setEnabled(true);
            iconBtn.setToolTipText(UIRegistry.getResourceString(tooltip));
            return iconBtn;
        }
        return UIHelper.createButton("?");
    }

    protected static UIPluginable createPlugin(MultiView parent, FormValidator validator, FormCellField cellField, boolean isViewMode, boolean isRequired) {
        String pluginName = cellField.getProperty("name");
        if (StringUtils.isEmpty((String)pluginName)) {
            String msg = "Creating plugin and the name property was missing. [" + cellField.getName() + "]";
            log.error((Object)msg);
            FormDevHelper.appendFormDevError(msg);
            return null;
        }
        Class<?> pluginClass = TaskMgr.getUIPluginClassForName(pluginName);
        if (pluginClass != null && UIPluginable.class.isAssignableFrom(pluginClass)) {
            JComponent pluginUI;
            UIPluginable uiPlugin;
            block8: {
                DBFieldInfo fInfo;
                DBTableInfo tInfo;
                uiPlugin = pluginClass.asSubclass(UIPluginable.class).newInstance();
                uiPlugin.setCellName(cellField.getName());
                Properties props = (Properties)cellField.getProperties().clone();
                if (uiPlugin instanceof WebLinkButton && (tInfo = DBTableIdMgr.getInstance().getByClassName(parent.getView().getClassName())) != null && (fInfo = tInfo.getFieldByName(cellField.getName())) != null && StringUtils.isEmpty((String)((String)props.get("weblink"))) && StringUtils.isNotEmpty((String)fInfo.getWebLinkName())) {
                    props.put("weblink", fInfo.getWebLinkName());
                }
                if (uiPlugin instanceof UIValidatable) {
                    ((UIValidatable)((Object)uiPlugin)).setRequired(isRequired);
                }
                uiPlugin.initialize(props, isViewMode);
                pluginUI = uiPlugin.getUIComponent();
                if (uiPlugin instanceof GetSetValueIFace) break block8;
                FormDevHelper.appendFormDevError("Plugin of class [" + pluginClass.getName() + "] doesn't implement the GetSetValueIFace!");
                return null;
            }
            try {
                if (validator != null) {
                    DataChangeNotifier dcn = validator.hookupComponent(pluginUI, cellField.getIdent(), UIValidator.parseValidationType(cellField.getValidationType()), cellField.getValidationRule(), false);
                    uiPlugin.addChangeListener(dcn);
                }
                return uiPlugin;
            }
            catch (Exception ex) {
                log.error((Object)ex);
                ex.printStackTrace();
                FormDevHelper.appendFormDevError(ex);
            }
        }
        log.error((Object)("Couldn't find plugin by name[" + pluginName + "]"));
        return null;
    }

    protected SubViewBtn createSubViewBtn(MultiView mvParent, FormCellSubViewIFace subviewDef, ViewIFace view, SubViewBtn.DATA_TYPE dataType, int options, Properties props, Class<?> classToCreate, AltViewIFace.CreationMode mode) {
        return new SubViewBtn(mvParent, subviewDef, view, dataType, options, props, classToCreate, mode);
    }

    protected boolean createItem(DBTableInfo parentTableInfo, DBTableChildIFace childInfo, MultiView parent, FormViewDefIFace formViewDef, FormValidator validator, ViewBuilderIFace viewBldObj, AltViewIFace.CreationMode mode, HashMap<String, JLabel> labelsForHash, Object currDataObj, FormCellIFace cell, boolean isEditOnCreateOnly, int rowInx, BuildInfoStruct bi) {
        String visProp;
        FormCellSubView cellSubView;
        bi.compToAdd = null;
        bi.compToReg = null;
        bi.doAddToValidator = true;
        bi.doRegControl = true;
        if (isEditOnCreateOnly) {
            EditViewCompSwitcherPanel evcsp = new EditViewCompSwitcherPanel(cell);
            bi.compToAdd = evcsp;
            bi.compToReg = evcsp;
            if (validator != null) {
                DataChangeNotifier dcn = validator.hookupComponent(evcsp, cell.getIdent(), UIValidator.Type.Changed, null, false);
                evcsp.setDataChangeNotifier(dcn);
            }
        } else if (cell.getType() == FormCellIFace.CellType.label) {
            FormCellLabel cellLabel = (FormCellLabel)cell;
            String lblStr = cellLabel.getLabel();
            if (cellLabel.isRecordObj()) {
                JComponent riComp;
                bi.compToAdd = riComp = viewBldObj.createRecordIndentifier(lblStr, cellLabel.getIcon());
            } else {
                String lStr = "  ";
                int align = 4;
                boolean useColon = StringUtils.isNotEmpty((String)cellLabel.getLabelFor());
                if (lblStr.equals("##")) {
                    bi.isDerivedLabel = true;
                    cellLabel.setDerived(true);
                } else {
                    String alignProp = cellLabel.getProperty("align");
                    align = StringUtils.isNotEmpty((String)alignProp) ? (alignProp.equals("left") ? 2 : (alignProp.equals("center") ? 0 : 4)) : (useColon ? 4 : 2);
                    lStr = StringUtils.isNotEmpty((String)lblStr) ? (useColon ? String.valueOf(lblStr) + ":" : lblStr) : "  ";
                }
                if (lStr.indexOf(LF) > -1) {
                    lStr = "<html>" + StringUtils.replace((String)lStr, (String)LF, (String)"<br>") + "</html>";
                }
                JLabel lbl = UIHelper.createLabel(lStr, align);
                String colorStr = cellLabel.getProperty("fg");
                if (StringUtils.isNotEmpty((String)colorStr)) {
                    lbl.setForeground(UIHelper.parseRGB(colorStr));
                }
                labelsForHash.put(cellLabel.getLabelFor(), lbl);
                bi.compToAdd = lbl;
                viewBldObj.addLabel(cellLabel, lbl);
            }
            bi.doAddToValidator = false;
            bi.doRegControl = false;
        } else if (cell.getType() == FormCellIFace.CellType.field) {
            DBFieldInfo fieldInfo;
            FormCellField cellField = (FormCellField)cell;
            bi.isRequired = bi.isRequired || cellField.isRequired() || childInfo != null && childInfo.isRequired();
            DBRelationshipInfo relInfo = null;
            DBFieldInfo dBFieldInfo = fieldInfo = childInfo instanceof DBFieldInfo ? (DBFieldInfo)childInfo : null;
            if (fieldInfo != null && fieldInfo.isHidden()) {
                FormDevHelper.appendLocalizedFormDevError("ViewFactory.FORM_FIELD_HIDDEN", cellField.getIdent(), cellField.getName(), formViewDef.getName());
            } else {
                DBRelationshipInfo dBRelationshipInfo = relInfo = childInfo instanceof DBRelationshipInfo ? (DBRelationshipInfo)childInfo : null;
                if (fieldInfo != null && fieldInfo.isHidden()) {
                    FormDevHelper.appendLocalizedFormDevError("ViewFactory.FORM_REL_HIDDEN", cellField.getIdent(), cellField.getName(), formViewDef.getName());
                }
            }
            FormCellFieldIFace.FieldType uiType = cellField.getUiType();
            PickListDBAdapterIFace adapter = null;
            String pickListName = cellField.getPickListName();
            if (childInfo != null && StringUtils.isEmpty((String)pickListName) && fieldInfo != null) {
                pickListName = fieldInfo.getPickListName();
            }
            if (StringUtils.isNotEmpty((String)pickListName) && ((adapter = PickListDBAdapterFactory.getInstance().create(pickListName, false)) == null || adapter.getPickList() == null)) {
                FormDevHelper.appendFormDevError("PickList Adapter [" + pickListName + "] cannot be null!");
                return false;
            }
            if (mode == AltViewIFace.CreationMode.VIEW) {
                if (uiType == FormCellFieldIFace.FieldType.combobox && cellField.getDspUIType() != FormCellFieldIFace.FieldType.textpl) {
                    if (adapter != null) {
                        uiType = FormCellFieldIFace.FieldType.textpl;
                        cellField.setDspUIType(uiType);
                    } else {
                        uiType = cellField.getDspUIType();
                    }
                } else {
                    uiType = cellField.getDspUIType();
                }
            } else if (uiType == FormCellFieldIFace.FieldType.querycbx && AppContextMgr.isSecurityOn()) {
                PermissionSettings perm;
                DBTableInfo tblInfo;
                DBTableInfo dBTableInfo = tblInfo = childInfo != null ? DBTableIdMgr.getInstance().getByShortClassName(childInfo.getDataClass().getSimpleName()) : null;
                if (tblInfo != null && (perm = tblInfo.getPermissions()) != null && (perm.isViewOnly() || !perm.canView())) {
                    uiType = FormCellFieldIFace.FieldType.textfieldinfo;
                }
            }
            Class<?> fieldClass = childInfo != null ? childInfo.getDataClass() : null;
            String uiFormatName = cellField.getUIFieldFormatterName();
            if (mode == AltViewIFace.CreationMode.EDIT && uiType == FormCellFieldIFace.FieldType.text && fieldClass != null) {
                if (fieldClass == String.class && fieldInfo != null) {
                    if (fieldInfo.getFormatter() != null) {
                        uiFormatName = fieldInfo.getFormatter().getName();
                        uiType = FormCellFieldIFace.FieldType.formattedtext;
                    }
                } else if (fieldClass == Integer.class || fieldClass == Long.class || fieldClass == Short.class || fieldClass == Byte.class || fieldClass == Double.class || fieldClass == Float.class || fieldClass == BigDecimal.class) {
                    uiType = FormCellFieldIFace.FieldType.formattedtext;
                    uiFormatName = "Numeric" + fieldClass.getSimpleName();
                }
            }
            boolean isReq = cellField.isRequired() || fieldInfo != null && fieldInfo.isRequired() || relInfo != null && relInfo.isRequired();
            cellField.setRequired(isReq);
            switch (uiType) {
                case text: {
                    bi.compToAdd = ViewFactory.createTextField(validator, cellField, fieldInfo, isReq, adapter);
                    bi.doAddToValidator = validator == null;
                    break;
                }
                case formattedtext: {
                    JComponent tfStart;
                    Class<?> tableClass = null;
                    try {
                        tableClass = Class.forName(formViewDef.getClassName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bi.compToAdd = tfStart = ViewFactory.createFormattedTextField(validator, cellField, tableClass, fieldInfo != null ? fieldInfo.getLength() : 0, uiFormatName, mode == AltViewIFace.CreationMode.VIEW, isReq, cellField.getPropertyAsBoolean("alledit", false));
                    if (cellField.getPropertyAsBoolean("series", false)) {
                        JComponent tfEnd = ViewFactory.createFormattedTextField(validator, cellField, tableClass, fieldInfo != null ? fieldInfo.getLength() : 0, uiFormatName, mode == AltViewIFace.CreationMode.VIEW, isReq, cellField.getPropertyAsBoolean("alledit", false));
                        SeriesProcCatNumPlugin plugin = new SeriesProcCatNumPlugin((ValFormattedTextFieldIFace)((Object)tfStart), (ValFormattedTextFieldIFace)((Object)tfEnd));
                        bi.compToAdd = plugin.getUIComponent();
                        viewBldObj.registerPlugin(cell, plugin);
                        bi.doRegControl = false;
                    }
                    bi.doAddToValidator = validator == null;
                    break;
                }
                case label: {
                    JLabel label = UIHelper.createLabel("", 2);
                    bi.compToAdd = label;
                    break;
                }
                case dsptextfield: {
                    if (StringUtils.isEmpty((String)cellField.getPickListName())) {
                        JTextField text = UIHelper.createTextField(cellField.getTxtCols());
                        ViewFactory.changeTextFieldUIForDisplay(text, cellField.getPropertyAsBoolean("transparent", false));
                        bi.compToAdd = text;
                        break;
                    }
                    bi.compToAdd = ViewFactory.createTextField(validator, cellField, fieldInfo, isReq, adapter);
                    bi.doAddToValidator = validator == null;
                    break;
                }
                case textfieldinfo: {
                    bi.compToAdd = ViewFactory.createTextFieldWithInfo(cellField, parent);
                    break;
                }
                case image: {
                    bi.compToAdd = ViewFactory.createImageDisplay(cellField, mode, validator);
                    bi.doAddToValidator = validator != null;
                    break;
                }
                case url: {
                    BrowserLauncherBtn blb = new BrowserLauncherBtn(cellField.getProperty("title"));
                    bi.compToAdd = blb;
                    bi.doAddToValidator = false;
                    break;
                }
                case combobox: {
                    bi.compToAdd = ViewFactory.createValComboBox(validator, cellField, adapter, isReq);
                    bi.doAddToValidator = validator != null;
                    break;
                }
                case checkbox: {
                    String lblStr = cellField.getLabel();
                    if (lblStr.equals("##")) {
                        bi.isDerivedLabel = true;
                        cellField.setDerived(true);
                    }
                    ValCheckBox checkbox = new ValCheckBox(lblStr, isReq, cellField.isReadOnly() || mode == AltViewIFace.CreationMode.VIEW);
                    if (validator != null) {
                        DataChangeNotifier dcn = validator.createDataChangeNotifer(cellField.getIdent(), checkbox, validator.createValidator(checkbox, UIValidator.Type.Changed));
                        checkbox.addActionListener(dcn);
                        checkbox.addItemListener(dcn);
                    }
                    bi.compToAdd = checkbox;
                    break;
                }
                case tristate: {
                    String lblStr = cellField.getLabel();
                    if (lblStr.equals("##")) {
                        bi.isDerivedLabel = true;
                        cellField.setDerived(true);
                    }
                    ValTristateCheckBox tristateCB = new ValTristateCheckBox(lblStr, isReq, cellField.isReadOnly() || mode == AltViewIFace.CreationMode.VIEW);
                    if (validator != null) {
                        DataChangeNotifier dcn = validator.createDataChangeNotifer(cellField.getIdent(), tristateCB, null);
                        tristateCB.addActionListener(dcn);
                    }
                    bi.compToAdd = tristateCB;
                    break;
                }
                case spinner: {
                    String minStr = cellField.getProperty("min");
                    int min = StringUtils.isNotEmpty((String)minStr) ? Integer.parseInt(minStr) : 0;
                    String maxStr = cellField.getProperty("max");
                    int max = StringUtils.isNotEmpty((String)maxStr) ? Integer.parseInt(maxStr) : 0;
                    ValSpinner spinner = new ValSpinner(min, max, isReq, cellField.isReadOnly() || mode == AltViewIFace.CreationMode.VIEW);
                    if (validator != null) {
                        DataChangeNotifier dcn = validator.createDataChangeNotifer(cellField.getIdent(), spinner, validator.createValidator(spinner, UIValidator.Type.Changed));
                        spinner.addChangeListener(dcn);
                    }
                    bi.compToAdd = spinner;
                    break;
                }
                case password: {
                    bi.compToAdd = ViewFactory.createPasswordField(validator, cellField, isReq);
                    bi.doAddToValidator = validator == null;
                    break;
                }
                case dsptextarea: {
                    bi.compToAdd = ViewFactory.createDisplayTextArea(cellField);
                    break;
                }
                case textarea: {
                    JTextArea ta = ViewFactory.createTextArea(validator, cellField, isReq, fieldInfo);
                    JScrollPane scrollPane = new JScrollPane(ta);
                    scrollPane.setHorizontalScrollBarPolicy(30);
                    scrollPane.setVerticalScrollBarPolicy(UIHelper.isMacOS() ? 22 : 20);
                    ta.setLineWrap(true);
                    ta.setWrapStyleWord(true);
                    bi.doAddToValidator = validator == null;
                    bi.compToReg = ta;
                    bi.compToAdd = scrollPane;
                    break;
                }
                case textareabrief: {
                    DBFieldInfo fi;
                    String title = "";
                    DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(formViewDef.getClassName());
                    if (ti != null && (fi = ti.getFieldByName(cellField.getName())) != null) {
                        title = fi.getTitle();
                    }
                    ValTextAreaBrief txBrief = ViewFactory.createTextAreaBrief(validator, cellField, isReq, fieldInfo);
                    txBrief.setTitle(title);
                    bi.doAddToValidator = validator == null;
                    bi.compToReg = txBrief;
                    bi.compToAdd = txBrief.getUIComponent();
                    break;
                }
                case browse: {
                    JTextField textField = ViewFactory.createTextField(validator, cellField, null, isReq, null);
                    if (textField instanceof ValTextField) {
                        ValBrowseBtnPanel bbp = new ValBrowseBtnPanel((ValTextField)textField, cellField.getPropertyAsBoolean("dirsonly", false), cellField.getPropertyAsBoolean("forinput", true));
                        bi.compToAdd = bbp;
                        break;
                    }
                    BrowseBtnPanel bbp = new BrowseBtnPanel(textField, cellField.getPropertyAsBoolean("dirsonly", false), cellField.getPropertyAsBoolean("forinput", true));
                    bi.compToAdd = bbp;
                    break;
                }
                case querycbx: {
                    ValComboBoxFromQuery cbx = ViewFactory.createQueryComboBox(validator, cellField, isReq, cellField.getPropertyAsBoolean("adjustquery", true));
                    cbx.setMultiView(parent);
                    cbx.setFrameTitle(cellField.getProperty("title"));
                    bi.compToAdd = cbx;
                    bi.doAddToValidator = validator == null;
                    break;
                }
                case list: {
                    JList list = ViewFactory.createList(validator, cellField, isReq);
                    JScrollPane scrollPane = new JScrollPane(list);
                    scrollPane.setHorizontalScrollBarPolicy(30);
                    scrollPane.setVerticalScrollBarPolicy(UIHelper.isMacOS() ? 22 : 20);
                    bi.doAddToValidator = validator == null;
                    bi.compToReg = list;
                    bi.compToAdd = scrollPane;
                    break;
                }
                case colorchooser: {
                    ColorChooser colorChooser = new ColorChooser(Color.BLACK);
                    if (validator != null) {
                        DataChangeNotifier dcn = validator.createDataChangeNotifer(cellField.getName(), colorChooser, null);
                        colorChooser.addPropertyChangeListener("setValue", dcn);
                    }
                    bi.compToAdd = colorChooser;
                    break;
                }
                case button: {
                    JButton btn = this.createFormButton(cellField, cellField.getProperty("title"));
                    bi.compToAdd = btn;
                    break;
                }
                case progress: {
                    bi.compToAdd = UIHelper.createProgressBar(0, 100);
                    break;
                }
                case plugin: {
                    UIPluginable uip = ViewFactory.createPlugin(parent, validator, cellField, mode == AltViewIFace.CreationMode.VIEW, isReq);
                    if (uip != null) {
                        bi.compToAdd = uip.getUIComponent();
                        viewBldObj.registerPlugin(cell, uip);
                    } else {
                        bi.compToAdd = new JPanel();
                        log.error((Object)("Couldn't create UIPlugin [" + cellField.getName() + "] ID:" + cellField.getIdent()));
                    }
                    bi.doRegControl = false;
                    break;
                }
                case textpl: {
                    TextFieldFromPickListTable txt = new TextFieldFromPickListTable(adapter, cellField.getTxtCols());
                    ViewFactory.changeTextFieldUIForDisplay(txt, cellField.getPropertyAsBoolean("transparent", false));
                    bi.compToAdd = txt;
                    break;
                }
                default: {
                    FormDevHelper.appendFormDevError("Don't recognize uitype=[" + (Object)((Object)uiType) + "]");
                    break;
                }
            }
        } else if (cell.getType() == FormCellIFace.CellType.separator) {
            DBTableInfo ti;
            String className;
            FormCellSeparatorIFace fcs = (FormCellSeparatorIFace)cell;
            String collapsableName = fcs.getCollapseCompName();
            String label = fcs.getLabel();
            if ((StringUtils.isEmpty((String)label) || label.equals("##")) && StringUtils.isNotEmpty((String)(className = fcs.getProperty("forclass"))) && (ti = DBTableIdMgr.getInstance().getByShortClassName(className)) != null) {
                label = ti.getTitle();
            }
            Component sep = viewBldObj.createSeparator(label);
            if (StringUtils.isNotEmpty((String)collapsableName)) {
                CollapsableSeparator collapseSep = new CollapsableSeparator(sep, false, null);
                if (bi.collapseSepHash == null) {
                    bi.collapseSepHash = new HashMap();
                }
                bi.collapseSepHash.put(collapseSep, collapsableName);
                sep = collapseSep;
            }
            bi.doRegControl = cell.getName().length() > 0;
            bi.compToAdd = (JComponent)sep;
            bi.doRegControl = StringUtils.isNotEmpty((String)cell.getIdent());
            bi.doAddToValidator = false;
        } else if (cell.getType() == FormCellIFace.CellType.command) {
            FormCellCommand cellCmd = (FormCellCommand)cell;
            JButton btn = this.createFormButton(cell, cellCmd.getLabel());
            if (cellCmd.getCommandType().length() > 0) {
                btn.addActionListener(new CommandActionWrapper(new CommandAction(cellCmd.getCommandType(), cellCmd.getAction(), "")));
            }
            bi.doAddToValidator = false;
            bi.compToAdd = btn;
        } else if (cell.getType() == FormCellIFace.CellType.iconview) {
            cellSubView = (FormCellSubView)cell;
            String subViewName = cellSubView.getViewName();
            ViewIFace subView = AppContextMgr.getInstance().getView(cellSubView.getViewSetName(), subViewName);
            if (subView != null) {
                if (parent != null) {
                    int options = 2 | (MultiView.isOptionOn(parent.getCreateOptions(), 4) ? 4 : 0);
                    options |= cellSubView.getPropertyAsBoolean("nosep", false) ? 1024 : 0;
                    MultiView multiView = new MultiView(parent, cellSubView.getName(), subView, parent.getCreateWithMode(), options |= cellSubView.getPropertyAsBoolean("nosepmorebtn", false) ? 2048 : 0, null);
                    parent.addChildMV(multiView);
                    multiView.setClassToCreate(this.getClassToCreate(parent, cell));
                    log.debug((Object)("[" + (Object)((Object)cell.getType()) + "] [" + cell.getName() + "] col: " + bi.colInx + " row: " + rowInx + " colspan: " + cell.getColspan() + " rowspan: " + cell.getRowspan()));
                    viewBldObj.addSubView(cellSubView, multiView, bi.colInx, rowInx, cellSubView.getColspan(), 1);
                    viewBldObj.closeSubView(cellSubView);
                    bi.curMaxRow = rowInx;
                    bi.colInx += cell.getColspan() + 1;
                } else {
                    log.error((Object)("buildFormView - parent is NULL for subview [" + subViewName + "]"));
                }
            } else {
                log.error((Object)("buildFormView - Could find subview's with ViewSet[" + cellSubView.getViewSetName() + "] ViewName[" + subViewName + "]"));
            }
            bi.colInx += 2;
        } else if (cell.getType() == FormCellIFace.CellType.subview) {
            cellSubView = (FormCellSubView)cell;
            String subViewName = cellSubView.getViewName();
            ViewIFace subView = AppContextMgr.getInstance().getView(cellSubView.getViewSetName(), subViewName);
            if (subView != null) {
                if (!viewBldObj.shouldFlatten()) {
                    if (parent != null) {
                        boolean useBtn;
                        ViewIFace parentView = parent.getView();
                        Properties props = cellSubView.getProperties();
                        boolean isSingle = cellSubView.isSingleValueFromSet();
                        boolean isACollection = false;
                        try {
                            Class<?> cls = Class.forName(parentView.getClassName());
                            Field fld = this.getFieldFromDotNotation(cellSubView, cls);
                            if (fld != null) {
                                isACollection = Collection.class.isAssignableFrom(fld.getType());
                            } else {
                                log.error((Object)("Couldn't find field [" + cellSubView.getName() + "] in class [" + parentView.getClassName() + "]"));
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)("Couldn't find field [" + cellSubView.getName() + "] in class [" + parentView.getClassName() + "]"));
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(ViewFactory.class, ex);
                        }
                        if (isSingle) {
                            isACollection = true;
                        }
                        boolean useNoScrollbars = UIHelper.getProperty(props, "noscrollbars", false);
                        int options = (isACollection && !isSingle ? 1 : 32) | 2 | (MultiView.isOptionOn(parent.getCreateOptions(), 4) ? 4 : 0) | (mode == AltViewIFace.CreationMode.EDIT ? 16 : 0) | (useNoScrollbars ? 64 : 0);
                        options |= cellSubView.getPropertyAsBoolean("nosep", false) ? 1024 : 0;
                        options |= cellSubView.getPropertyAsBoolean("nosepmorebtn", false) ? 2048 : 0;
                        options |= cellSubView.getPropertyAsBoolean("collapse", false) ? 4096 : 0;
                        if (!isACollection || isSingle) {
                            options &= 0xFFFFFF7F;
                        }
                        if (useBtn = UIHelper.getProperty(props, "btn", false)) {
                            SubViewBtn.DATA_TYPE dataType = isSingle ? SubViewBtn.DATA_TYPE.IS_SINGLESET_ITEM : (isACollection ? SubViewBtn.DATA_TYPE.IS_SET : (cellSubView.getName().equals("this") ? SubViewBtn.DATA_TYPE.IS_THIS : SubViewBtn.DATA_TYPE.IS_SET));
                            SubViewBtn subViewBtn = ViewFactory.getInstance().createSubViewBtn(parent, cellSubView, subView, dataType, options, props, this.getClassToCreate(parent, cell), mode);
                            subViewBtn.setHelpContext(props.getProperty("hc", null));
                            bi.doAddToValidator = false;
                            bi.compToAdd = subViewBtn;
                            String visProp2 = cell.getProperty("visible");
                            if (StringUtils.isNotEmpty((String)visProp2) && visProp2.equalsIgnoreCase("false") && bi.compToAdd != null) {
                                bi.compToAdd.setVisible(false);
                            }
                            try {
                                this.addControl(validator, viewBldObj, rowInx, cell, bi);
                            }
                            catch (IndexOutOfBoundsException ex) {
                                String msg = "Error adding control type: `" + (Object)((Object)cell.getType()) + "` id: `" + cell.getIdent() + "` name: `" + cell.getName() + "` on row: " + rowInx + " column: " + bi.colInx + "\n" + ex.getMessage();
                                UIRegistry.showError(msg);
                                return false;
                            }
                            bi.doRegControl = false;
                            bi.compToAdd = null;
                        } else {
                            Color bgColor = this.getBackgroundColor(props, parent.getBackground());
                            if (UIHelper.getProperty(props, "addsearch", false)) {
                                options |= 0x80;
                            }
                            if (UIHelper.getProperty(props, "addadd", false)) {
                                options |= 0x2000;
                            }
                            MultiView multiView = new MultiView(parent, cellSubView.getName(), subView, parent.getCreateWithMode(), cellSubView.getDefaultAltViewType(), options, bgColor, cellSubView);
                            multiView.setClassToCreate(this.getClassToCreate(parent, cell));
                            this.setBorder(multiView, cellSubView.getProperties());
                            parent.addChildMV(multiView);
                            viewBldObj.addSubView(cellSubView, multiView, bi.colInx, rowInx, cellSubView.getColspan(), 1);
                            viewBldObj.closeSubView(cellSubView);
                            Viewable viewable = multiView.getCurrentView();
                            if (viewable != null) {
                                if (viewable instanceof TableViewObj) {
                                    ((TableViewObj)viewable).setVisibleRowCount(cellSubView.getTableRows());
                                }
                                if (viewable.getValidator() != null && childInfo != null) {
                                    viewable.getValidator().setRequired(childInfo.isRequired());
                                }
                            }
                            bi.colInx += cell.getColspan() + 1;
                        }
                        bi.curMaxRow = rowInx;
                    } else {
                        log.error((Object)("buildFormView - parent is NULL for subview [" + subViewName + "]"));
                        bi.colInx += 2;
                    }
                } else {
                    viewBldObj.addSubView(cellSubView, parent, bi.colInx, rowInx, cellSubView.getColspan(), 1);
                    AltViewIFace altView = subView.getDefaultAltView();
                    FormViewDefIFace subFormViewDef = (FormViewDefIFace)altView.getViewDef();
                    DBTableInfo sbTableInfo = DBTableIdMgr.getInstance().getByClassName(subView.getClassName());
                    if (subFormViewDef != null) {
                        this.processRows(sbTableInfo, parent, formViewDef, validator, viewBldObj, altView.getMode(), labelsForHash, currDataObj, subFormViewDef.getRows());
                    } else {
                        String msg = String.format("The Altview '%s' has a null ViewDef!", altView.getName());
                        FormDevHelper.appendFormDevError(msg);
                        UIRegistry.showError(msg);
                    }
                    viewBldObj.closeSubView(cellSubView);
                    bi.colInx += cell.getColspan() + 1;
                }
            } else {
                log.error((Object)("buildFormView - Could find subview's with ViewSet[" + cellSubView.getViewSetName() + "] ViewName[" + subViewName + "]"));
            }
        } else if (cell.getType() == FormCellIFace.CellType.statusbar) {
            bi.compToAdd = new JStatusBar();
            bi.doRegControl = true;
            bi.doAddToValidator = false;
        } else if (cell.getType() == FormCellIFace.CellType.panel) {
            bi.doRegControl = false;
            bi.doAddToValidator = false;
            cell.setIgnoreSetGet(true);
            FormCellPanel cellPanel = (FormCellPanel)cell;
            PanelViewable.PanelType panelType = PanelViewable.getType(cellPanel.getPanelType());
            if (panelType == PanelViewable.PanelType.Panel) {
                Color bgColor;
                PanelViewable panelViewable = new PanelViewable(viewBldObj, cellPanel);
                this.processRows(parentTableInfo, parent, formViewDef, validator, panelViewable, mode, labelsForHash, currDataObj, cellPanel.getRows());
                panelViewable.setVisible(cellPanel.getPropertyAsBoolean("visible", true));
                this.setBorder(panelViewable, cellPanel.getProperties());
                if (parent != null && (bgColor = this.getBackgroundColor(cellPanel.getProperties(), parent.getBackground())) != null && bgColor != parent.getBackground()) {
                    panelViewable.setOpaque(true);
                    panelViewable.setBackground(bgColor);
                }
                bi.compToAdd = panelViewable;
                bi.doRegControl = true;
                bi.compToReg = panelViewable;
            } else if (panelType == PanelViewable.PanelType.ButtonBar) {
                bi.compToAdd = PanelViewable.buildButtonBar(this.processRows(viewBldObj, cellPanel.getRows()));
            } else {
                FormDevHelper.appendFormDevError("Panel Type is not implemented.");
                return false;
            }
        }
        if (StringUtils.isNotEmpty((String)(visProp = cell.getProperty("visible"))) && visProp.equalsIgnoreCase("false") && bi.compToAdd != null) {
            bi.compToAdd.setVisible(false);
        }
        return true;
    }

    protected void processRows(DBTableInfo tableInfo, MultiView parent, FormViewDefIFace formViewDef, FormValidator validator, ViewBuilderIFace viewBldObj, AltViewIFace.CreationMode mode, HashMap<String, JLabel> labelsForHash, Object currDataObj, List<FormRowIFace> formRows) {
        BuildInfoStruct bi = new BuildInfoStruct();
        bi.curMaxRow = 1;
        int rowInx = 1;
        boolean hasRequiredOrDerivedField = false;
        for (FormRowIFace row : formRows) {
            bi.colInx = 1;
            for (FormCellIFace cell : row.getCells()) {
                DBTableChildIFace childInfo = null;
                String cellName = cell.getName();
                if (tableInfo != null && StringUtils.isNotEmpty((String)cellName)) {
                    childInfo = tableInfo.getItemByName(cellName);
                }
                boolean isEditOnCreateOnly = false;
                if (mode == AltViewIFace.CreationMode.EDIT && cell.getType() == FormCellIFace.CellType.field) {
                    isEditOnCreateOnly = ((FormCellField)cell).getPropertyAsBoolean("editoncreate", false);
                    ((FormCellField)cell).setEditOnCreate(true);
                }
                if (!this.createItem(tableInfo, childInfo, parent, formViewDef, validator, viewBldObj, mode, labelsForHash, currDataObj, cell, isEditOnCreateOnly, rowInx, bi)) {
                    return;
                }
                if (bi.compToAdd != null) {
                    try {
                        this.addControl(validator, viewBldObj, rowInx, cell, bi);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        String msg = "Error adding control type: `" + (Object)((Object)cell.getType()) + "` id: `" + cell.getIdent() + "` name: `" + cell.getName() + "` on row: " + rowInx + " column: " + bi.colInx + "\n" + ex.getMessage();
                        UIRegistry.showError(msg);
                        return;
                    }
                }
                if (isEditOnCreateOnly) {
                    EditViewCompSwitcherPanel evcsp = (EditViewCompSwitcherPanel)bi.compToReg;
                    evcsp.setParentValidator(validator);
                    BuildInfoStruct bi2 = new BuildInfoStruct();
                    bi2.curMaxRow = 1;
                    bi2.colInx = 1;
                    this.createItem(tableInfo, childInfo, parent, formViewDef, evcsp.getValidator(), viewBldObj, AltViewIFace.CreationMode.EDIT, labelsForHash, currDataObj, cell, false, rowInx, bi2);
                    JComponent editCompReg = bi2.compToReg;
                    JComponent editCompAdd = bi2.compToAdd;
                    this.createItem(tableInfo, childInfo, parent, formViewDef, null, viewBldObj, AltViewIFace.CreationMode.VIEW, labelsForHash, currDataObj, cell, false, rowInx, bi2);
                    JComponent viewCompReg = bi2.compToReg;
                    JComponent viewCompAdd = bi2.compToAdd;
                    evcsp.set(editCompReg, editCompAdd, viewCompReg, viewCompAdd);
                }
                if (bi.isRequired || (childInfo == null || !childInfo.isRequired()) && (!(cell instanceof FormCellFieldIFace) || !((FormCellFieldIFace)cell).isRequired())) continue;
                bi.isRequired = true;
                ((FormCellFieldIFace)cell).setRequired(true);
            }
            if (bi.isRequired || bi.isDerivedLabel) {
                hasRequiredOrDerivedField = true;
            }
            rowInx += 2;
        }
        if (bi.collapseSepHash != null && bi.collapseSepHash.size() > 0) {
            for (CollapsableSeparator collapseSep : bi.collapseSepHash.keySet()) {
                Component comp = viewBldObj.getControlByName(bi.collapseSepHash.get(collapseSep));
                if (comp == null) continue;
                collapseSep.setInnerComp(comp);
            }
        }
        viewBldObj.doneBuilding();
        if (doFixLabels && (hasRequiredOrDerivedField || viewBldObj.hasRequiredFields())) {
            viewBldObj.fixUpRequiredDerivedLabels();
        }
    }

    protected void addControl(FormValidator validator, ViewBuilderIFace viewBldObj, int rowInx, FormCellIFace cell, BuildInfoStruct bi) {
        int colspan = cell.getColspan();
        int rowspan = cell.getRowspan();
        viewBldObj.addControlToUI(bi.compToAdd, bi.colInx, rowInx, colspan, rowspan);
        if (bi.doRegControl) {
            viewBldObj.registerControl(cell, bi.compToReg == null ? bi.compToAdd : bi.compToReg);
        }
        bi.curMaxRow = Math.max(bi.curMaxRow, rowspan + rowInx);
        if (validator != null && bi.doAddToValidator) {
            validator.addUIComp(cell.getIdent(), bi.compToReg == null ? bi.compToAdd : bi.compToReg);
        }
        bi.colInx += colspan + 1;
    }

    protected Field getFieldFromDotNotation(FormCellSubView cellSubView, Class<?> dataClass) {
        Class<?> parentCls = dataClass;
        String[] fieldNames = StringUtils.split((String)cellSubView.getName(), (String)".");
        int i = 0;
        while (i < fieldNames.length) {
            block9: {
                try {
                    if (fieldNames[i].equals("this")) break block9;
                    Field fld = null;
                    try {
                        fld = parentCls.getDeclaredField(fieldNames[i]);
                    }
                    catch (NoSuchFieldException ex) {
                        UIRegistry.showError(String.format("There is no field named '%s' for class %s", fieldNames[i], parentCls));
                        String parentTitle = parentCls.getSimpleName();
                        DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(parentCls.getName());
                        if (ti != null) {
                            parentTitle = ti.getTitle();
                        }
                        UIRegistry.showError(String.format(UIRegistry.getResourceString("INVALID_FIELD_NAME"), fieldNames[i], parentTitle));
                    }
                    if (fld != null) {
                        if (i == fieldNames.length - 1) {
                            return fld;
                        }
                        parentCls = fld.getType();
                    } else {
                        log.error((Object)("Couldn't find field [" + cellSubView.getName() + "] in class [" + parentCls.getSimpleName() + "]"));
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ViewFactory.class, ex);
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    protected Class<?> getClassToCreate(MultiView multiView, FormCellIFace cell) {
        DBTableChildIFace tblChild;
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(multiView.getView().getClassName());
        if (tableInfo != null && (tblChild = tableInfo.getItemByName(cell.getName())) != null) {
            return tblChild.getDataClass();
        }
        return null;
    }

    protected void setBorder(JComponent comp, Properties props) {
        String borderType;
        if (props != null && StringUtils.isNotEmpty((String)(borderType = props.getProperty("border")))) {
            if (borderType.equals("etched")) {
                comp.setBorder(BorderFactory.createEtchedBorder());
            } else if (borderType.equals("lowered")) {
                comp.setBorder(BorderFactory.createBevelBorder(1));
            } else if (borderType.equals("raised")) {
                comp.setBorder(BorderFactory.createBevelBorder(0));
            } else if (borderType.equals("empty")) {
                comp.setBorder(BorderFactory.createEmptyBorder());
            } else if (borderType.equals("line")) {
                Color color = Color.LIGHT_GRAY;
                String borderColor = props.getProperty("bordercolor");
                if (StringUtils.isNotEmpty((String)borderColor)) {
                    try {
                        color = UIHelper.parseRGB(borderColor);
                    }
                    catch (ConfigurationException ex) {
                        log.error((Object)ex);
                    }
                }
                comp.setBorder(BorderFactory.createLineBorder(color));
            }
        }
    }

    protected Color getBackgroundColor(Properties props, Color bgColor) {
        String colorStr;
        if (props != null && StringUtils.isNotEmpty((String)(colorStr = props.getProperty("bgcolor")))) {
            if (colorStr.endsWith("%")) {
                try {
                    int percent = Integer.parseInt(colorStr.substring(0, colorStr.length() - 1));
                    double per = (double)percent / 100.0;
                    int r = Math.min((int)((double)bgColor.getRed() * per), 255);
                    int g = Math.min((int)((double)bgColor.getGreen() * per), 255);
                    int b = Math.min((int)((double)bgColor.getBlue() * per), 255);
                    return new Color(r, g, b);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ViewFactory.class, ex);
                    log.error((Object)ex);
                }
            } else {
                try {
                    return UIHelper.parseRGB(colorStr);
                }
                catch (ConfigurationException ex) {
                    log.error((Object)ex);
                }
            }
        }
        return bgColor;
    }

    public void setMVBackground(MultiView parent, Color bgColor) {
        for (MultiView mv : parent.getKids()) {
            this.setMVBackground(mv, bgColor);
        }
        for (Viewable viewable : parent.getViewables()) {
            viewable.getUIComponent().setBackground(bgColor);
        }
    }

    protected JButton[] processRows(ViewBuilderIFace viewBldObj, List<FormRowIFace> formRows) {
        ArrayList<JButton> btns = new ArrayList<JButton>();
        for (FormRowIFace row : formRows) {
            for (FormCellIFace cell : row.getCells()) {
                if (cell.getType() != FormCellIFace.CellType.command) continue;
                FormCellCommand cellCmd = (FormCellCommand)cell;
                JButton btn = this.createFormButton(cell, cellCmd.getLabel());
                if (cellCmd.getCommandType().length() > 0) {
                    btn.addActionListener(new CommandActionWrapper(new CommandAction(cellCmd.getCommandType(), cellCmd.getAction(), "")));
                }
                viewBldObj.registerControl(cell, btn);
                btns.add(btn);
            }
        }
        JButton[] btnsArray = new JButton[btns.size()];
        int i = 0;
        for (JButton b : btns) {
            btnsArray[i++] = b;
        }
        btns.clear();
        return btnsArray;
    }

    public FormViewObj buildFormViewable(ViewIFace view, AltViewIFace altView, MultiView parentView, int options, String cellName, Class<?> dataClass, Color bgColor) {
        FormViewObj formViewObj;
        DBTableInfo tableInfo;
        FormValidator validator;
        ValidatedJPanel validatedPanel;
        HashMap<String, JLabel> labelsForHash;
        FormViewDef formViewDef;
        block12: {
            MultiView parentsMV;
            formViewDef = (FormViewDef)altView.getViewDef();
            labelsForHash = new HashMap<String, JLabel>();
            validatedPanel = null;
            validator = null;
            if (altView.isValidated()) {
                validatedPanel = new ValidatedJPanel();
                validator = validatedPanel.getFormValidator();
                validator.setDataChangeNotification(true);
            }
            tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
            MultiView multiView = parentsMV = parentView != null ? parentView.getMultiViewParent() : null;
            if (tableInfo == null && parentsMV != null) {
                tableInfo = DBTableIdMgr.getInstance().getByClassName(parentsMV.getView().getClassName());
            }
            if ((formViewObj = new FormViewObj(view, altView, parentView, validator, options, cellName, dataClass, bgColor)).isBuildValid()) break block12;
            return null;
        }
        try {
            Object currDataObj = formViewObj.getCurrentDataObj();
            this.processRows(tableInfo, parentView, formViewDef, validator, formViewObj, altView.getMode(), labelsForHash, currDataObj, formViewDef.getRows());
            formViewObj.addUsageNotes();
            if (validatedPanel != null) {
                validatedPanel.addPanel(formViewObj.getPanel());
                Map<String, Component> mapping = formViewObj.getControlMapping();
                for (String id : mapping.keySet()) {
                    validatedPanel.addValidationComp(id, mapping.get(id));
                }
                Hashtable<String, String> enableRules = formViewDef.getEnableRules();
                FormValidator fv = validatedPanel.getFormValidator();
                formViewObj.setValidator(fv);
                fv.setName(formViewDef.getName());
                if (parentView != null) {
                    fv.setTopLevel(parentView.isTopLevel());
                }
                if (enableRules != null) {
                    for (String id : enableRules.keySet()) {
                        fv.addEnableRule(id, (String)enableRules.get(id));
                    }
                }
                for (String idFor : labelsForHash.keySet()) {
                    fv.addUILabel(idFor, labelsForHash.get(idFor));
                }
                formViewObj.setFormComp(validatedPanel);
            } else {
                formViewObj.setFormComp(formViewObj.getPanel());
            }
            return formViewObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ViewFactory.class, e);
            log.error((Object)("buildPanel - Outer Name[" + altView.getName() + "]"));
            return null;
        }
    }

    public TableViewObj buildTableViewable(ViewIFace view, AltViewIFace altView, MultiView parentView, int options, String cellName, Class<?> dataClass, Color bgColor) {
        try {
            ViewDefIFace viewDef = altView.getViewDef();
            FormValidator validator = null;
            if (altView.isValidated()) {
                ValidatedJPanel validatedPanel = new ValidatedJPanel();
                validator = validatedPanel.getFormValidator();
                validator.setDataChangeNotification(true);
            }
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
            MultiView parentsMV = parentView.getMultiViewParent();
            if (tableInfo == null && parentsMV != null) {
                tableInfo = DBTableIdMgr.getInstance().getByClassName(parentsMV.getView().getClassName());
            }
            if (viewDef instanceof FormViewDef) {
                FormViewDefIFace formViewDef = (FormViewDefIFace)viewDef;
                HashMap<String, JLabel> labelsForHash = new HashMap<String, JLabel>();
                TableViewObj tableViewObj = new TableViewObj(view, altView, parentView, validator, options, cellName, dataClass, bgColor);
                this.processRows(tableInfo, parentView, formViewDef, null, tableViewObj, altView.getMode(), labelsForHash, validator, formViewDef.getRows());
                return tableViewObj;
            }
            FormViewDefIFace formViewDef = (FormViewDefIFace)altView.getViewDef();
            HashMap<String, JLabel> labelsForHash = new HashMap<String, JLabel>();
            TableViewObj tableViewObj = new TableViewObj(view, altView, parentView, null, options, cellName, dataClass, bgColor);
            this.processRows(tableInfo, parentView, formViewDef, null, tableViewObj, altView.getMode(), labelsForHash, validator, formViewDef.getRows());
            return tableViewObj;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ViewFactory.class, e);
            log.error((Object)("buildPanel - Outer Name[" + altView.getName() + "]"));
            e.printStackTrace();
            return null;
        }
    }

    public TableViewObj buildRecordSetTableViewable(ViewIFace view, AltViewIFace altView, MultiView parentView, int options, String cellName, Class<?> dataClass, Color bgColor) {
        RecordSetTableViewObj rsTableViewObj = null;
        try {
            ViewDefIFace viewDef = altView.getViewDef();
            if (viewDef instanceof FormViewDef) {
                FormViewDefIFace formViewDef = (FormViewDefIFace)viewDef;
                HashMap<String, JLabel> labelsForHash = new HashMap<String, JLabel>();
                rsTableViewObj = new RecordSetTableViewObj(view, altView, parentView, null, 0, cellName, dataClass, bgColor);
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                this.processRows(tableInfo, parentView, formViewDef, null, rsTableViewObj, altView.getMode(), labelsForHash, null, formViewDef.getRows());
                return rsTableViewObj;
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ViewFactory.class, e);
            log.error((Object)("buildPanel - Outer Name[" + altView.getName() + "]"));
            e.printStackTrace();
        }
        return rsTableViewObj;
    }

    public static Viewable createFormView(MultiView multiView, ViewIFace view, String altName, Object data, int options, String cellName) {
        return ViewFactory.createFormView(multiView, view, altName, data, options, cellName, null);
    }

    public static Viewable createFormView(MultiView multiView, ViewIFace view, String altName, Object data, int options, String cellName, Color bgColor) {
        Viewable viewable;
        AltViewIFace altView;
        if (viewFieldColor == null) {
            viewFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "viewfieldcolor");
        }
        if ((altView = view.getAltView(altName)) != null && (viewable = ViewFactory.getInstance().buildViewable(view, altView, multiView, options, cellName, bgColor)) != null) {
            if (data != null) {
                viewable.setDataObj(data);
            }
            return viewable;
        }
        return null;
    }

    public static boolean isFormTransparent() {
        return isFormTransparent;
    }

    public static void setFormTransparent(boolean isFormTransparent) {
        ViewFactory.isFormTransparent = isFormTransparent;
    }

    public static ViewFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(ViewFactory.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = (ViewFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AppContextMgr.class, e);
                InternalError error = new InternalError("Can't instantiate ViewFactory factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        instance = new ViewFactory();
        return instance;
    }

    class BuildInfoStruct {
        public HashMap<CollapsableSeparator, String> collapseSepHash = null;
        public int curMaxRow = 0;
        public JComponent compToAdd = null;
        public JComponent compToReg = null;
        public boolean doAddToValidator = true;
        public boolean doRegControl = true;
        public int colInx = 0;
        public boolean isRequired = false;
        public boolean isDerivedLabel = false;

        BuildInfoStruct() {
        }

        public void clear() {
            this.curMaxRow = 0;
            this.compToAdd = null;
            this.compToReg = null;
            this.doAddToValidator = true;
            this.doRegControl = true;
            this.colInx = 0;
            this.isRequired = false;
            this.isDerivedLabel = false;
            if (this.collapseSepHash != null) {
                this.collapseSepHash.clear();
            }
        }
    }
}

