/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.CarryForwardInfo;
import edu.ku.brc.af.ui.forms.ControlBarPanel;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DraggableRecordIdentifier;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MenuSwitcherPanel;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.RestrictablePanel;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.ResultSetControllerListener;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.ViewBuilderIFace;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellField;
import edu.ku.brc.af.ui.forms.persist.FormCellFieldIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellLabel;
import edu.ku.brc.af.ui.forms.persist.FormCellLabelIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellSubView;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.af.ui.forms.persist.FormViewDef;
import edu.ku.brc.af.ui.forms.persist.FormViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.TableViewDef;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValidationListener;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Orderable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

public class TableViewObj
implements Viewable,
ViewBuilderIFace,
ValidationListener,
ResultSetControllerListener,
AppPrefsChangeListener {
    private static final Logger log = Logger.getLogger(TableViewObj.class);
    protected static CellConstraints cc = new CellConstraints();
    protected DataProviderSessionIFace session = null;
    protected boolean doingAction = false;
    protected boolean isEditing = false;
    protected boolean isSavable = false;
    protected boolean formIsInNewDataMode = false;
    protected MultiView mvParent = null;
    protected ViewIFace view;
    protected AltViewIFace altView;
    protected ViewDefIFace viewDef;
    protected FormViewDefIFace formViewDef;
    protected int options;
    protected String cellName = null;
    protected List<MultiView> kids = new ArrayList<MultiView>();
    protected Vector<AltViewIFace> altViewsList = null;
    protected TableViewDef tableViewDef;
    protected DataObjectGettable dataGetter = null;
    protected Class<?> classToCreate = null;
    protected String searchName = null;
    protected Stack<FormCellSubView> subViewStack = new Stack();
    protected StringBuilder fullObjPath = new StringBuilder();
    protected int skipControls = 0;
    protected Hashtable<String, ColumnInfo> controlsByName = new Hashtable();
    protected Hashtable<String, ColumnInfo> controlsById = new Hashtable();
    protected Vector<ColumnInfo> columnList = new Vector();
    protected FormValidator formValidator = null;
    protected FormDataObjIFace parentDataObj = null;
    protected Object dataObj = null;
    protected Set<Object> origDataSet = null;
    protected Vector<Object> dataObjList = null;
    protected Vector<Object> newObjsList = new Vector();
    protected Object[] singleItemArray = new Object[1];
    protected DateWrapper scrDateFormat;
    protected boolean isLoaded = false;
    protected boolean isSkippingAttach = false;
    protected Boolean isRestricted = null;
    protected String restrictedStr = null;
    protected String dataClassName;
    protected String dataSetFieldName;
    protected RestrictablePanel mainComp = null;
    protected ControlBarPanel controlPanel = null;
    protected ResultSetController rsController = null;
    protected Vector<Object> list = null;
    protected boolean ignoreSelection = false;
    protected JButton saveBtn = null;
    protected JButton validationInfoBtn = null;
    protected boolean wasNull = false;
    protected MenuSwitcherPanel switcherUI;
    protected JComboBox selectorCBX = null;
    protected int mainCompRowInx = 1;
    protected boolean addSearch;
    protected boolean includeAddBtn;
    protected boolean doSpecialAdd;
    protected JButton searchButton = null;
    protected JButton editButton = null;
    protected JButton newButton = null;
    protected JButton deleteButton = null;
    protected JPanel sepController = null;
    protected BusinessRulesIFace businessRules = null;
    protected Class<?> dataClass;
    protected DraggableRecordIdentifier draggableRecIdentifier = null;
    protected CarryForwardInfo carryFwdInfo = null;
    protected boolean doCarryForward = false;
    protected Object carryFwdDataObj = null;
    protected ColTableModel model;
    protected JTable table;
    protected JScrollPane tableScroller;
    protected JPanel orderablePanel;
    protected boolean isLoading = false;
    protected JButton orderUpBtn = null;
    protected JButton orderDwnBtn = null;
    protected boolean doOrdering = false;
    private PermissionSettings perm = null;

    public TableViewObj(ViewIFace view, AltViewIFace altView, MultiView mvParent, FormValidator formValidator, int options, String cellName, Class<?> dataClass, Color bgColor) {
        this.view = view;
        this.altView = altView;
        this.mvParent = mvParent;
        this.options = options;
        this.viewDef = altView.getViewDef();
        this.formValidator = formValidator;
        this.cellName = cellName;
        this.dataClass = dataClass;
        this.businessRules = view.createBusinessRule();
        this.dataGetter = altView.getViewDef().getDataGettable();
        this.formViewDef = (FormViewDefIFace)altView.getViewDef();
        this.scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
        AppPreferences.getRemote().addChangeListener("ui.formatting.viewfieldcolor", this);
        boolean createViewSwitcher = MultiView.isOptionOn(options, 2);
        boolean hideSaveBtn = MultiView.isOptionOn(options, 8);
        this.isEditing = MultiView.isOptionOn(options, 16) && altView.getMode() == AltViewIFace.CreationMode.EDIT;
        this.addSearch = mvParent != null && MultiView.isOptionOn(mvParent.getOptions(), 128);
        this.includeAddBtn = mvParent != null && MultiView.isOptionOn(mvParent.getOptions(), 8192);
        this.doSpecialAdd = this.addSearch && this.includeAddBtn;
        this.setValidator(formValidator);
        boolean addController = mvParent != null && view.getAltViews().size() > 1;
        this.mainComp = new RestrictablePanel(new BorderLayout());
        this.mainComp.setBackground(bgColor);
        if (mvParent == null) {
            this.mainComp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        if (addController) {
            boolean saveWasAdded = false;
            if (createViewSwitcher) {
                this.altViewsList = new Vector();
                boolean overrideViewMode = MultiView.isOptionOn(options, 4) || this.isEditing;
                AltViewIFace.CreationMode tempMode = null;
                if (overrideViewMode && altView.getMode() == AltViewIFace.CreationMode.VIEW) {
                    tempMode = altView.getMode();
                    altView.setMode(AltViewIFace.CreationMode.EDIT);
                }
                this.switcherUI = FormViewObj.createMenuSwitcherPanel(mvParent, view, altView, this.altViewsList, this.mainComp, cellName, dataClass);
                if (tempMode != null) {
                    altView.setMode(tempMode);
                }
                if (this.altViewsList.size() > 0) {
                    if (this.isEditing) {
                        String delTTStr = ResultSetController.createTooltip(this.addSearch ? "RemoveRecordTT" : "DeleteRecordTT", view.getObjTitle());
                        this.deleteButton = UIHelper.createIconBtnTT(this.addSearch ? "Eraser16" : "DeleteRecord", IconManager.IconSize.Std16, delTTStr, false, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (TableViewObj.this.deleteButton.isEnabled()) {
                                    TableViewObj.this.deleteButton.setEnabled(false);
                                    TableViewObj.this.deleteRow(TableViewObj.this.table.getSelectedRow());
                                }
                            }
                        });
                        if (this.addSearch) {
                            String srchTTStr = ResultSetController.createTooltip("SearchForRecordTT", view.getObjTitle());
                            DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByClassName(view.getClassName());
                            if (tblInfo != null) {
                                this.searchName = tblInfo.getSearchDialog();
                                if (StringUtils.isEmpty((String)this.searchName)) {
                                    this.searchName = "";
                                    log.error((Object)("The Search Dialog Name is empty or missing for class[" + view.getClassName() + "]"));
                                }
                            } else {
                                log.error((Object)("Couldn't find TableInfo for class[" + view.getClassName() + "]"));
                            }
                            this.searchButton = UIHelper.createIconBtnTT(this.addSearch ? "SearchAdd" : "Search", IconManager.IconSize.Std16, srchTTStr, false, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (TableViewObj.this.searchButton.isEnabled()) {
                                        TableViewObj.this.searchButton.setEnabled(false);
                                        try {
                                            TableViewObj.this.doSearch();
                                        }
                                        finally {
                                            TableViewObj.this.searchButton.setEnabled(true);
                                        }
                                    }
                                }
                            });
                            this.searchButton.setEnabled(true);
                            String saTTStr = ResultSetController.createTooltip("SearchAddRecordTT", view.getObjTitle());
                            this.searchButton.setToolTipText(saTTStr);
                        } else {
                            String edtTTStr = ResultSetController.createTooltip("EditRecordTT", view.getObjTitle());
                            this.editButton = UIHelper.createIconBtnTT("EditForm", IconManager.IconSize.Std16, edtTTStr, false, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (TableViewObj.this.editButton.isEnabled()) {
                                        TableViewObj.this.editButton.setEnabled(false);
                                        try {
                                            TableViewObj.this.editRow(TableViewObj.this.table.getSelectedRow(), false);
                                        }
                                        finally {
                                            TableViewObj.this.editButton.setEnabled(true);
                                        }
                                    }
                                }
                            });
                        }
                        if (this.doSpecialAdd || !this.addSearch) {
                            String newTTStr = ResultSetController.createTooltip("NewRecordTT", view.getObjTitle());
                            this.newButton = UIHelper.createIconBtnTT("CreateObj", IconManager.IconSize.Std16, newTTStr, false, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (TableViewObj.this.newButton.isEnabled()) {
                                        TableViewObj.this.newButton.setEnabled(false);
                                        try {
                                            TableViewObj.this.editRow(TableViewObj.this.table.getSelectedRow(), true);
                                        }
                                        finally {
                                            TableViewObj.this.newButton.setEnabled(true);
                                        }
                                    }
                                }
                            });
                        }
                        boolean isAbove = mvParent != null && mvParent.getSeparator() != null;
                        int cnt = (this.deleteButton != null ? 1 : 0) + (this.searchButton != null ? 1 : 0) + (this.editButton != null ? 1 : 0) + (this.newButton != null ? 1 : 0);
                        PanelBuilder builder = new PanelBuilder(new FormLayout(String.valueOf(isAbove ? "1px," : "f:1px:g,") + UIHelper.createDuplicateJGoodiesDef("p", "1px", cnt), "p"));
                        int x = 2;
                        if (this.newButton != null) {
                            builder.add((Component)this.newButton, cc.xy(x, 1));
                            x += 2;
                        }
                        if (this.deleteButton != null) {
                            builder.add((Component)this.deleteButton, cc.xy(x, 1));
                            x += 2;
                        }
                        if (this.editButton != null) {
                            builder.add((Component)this.editButton, cc.xy(x, 1));
                            x += 2;
                        }
                        if (this.searchButton != null) {
                            builder.add((Component)this.searchButton, cc.xy(x, 1));
                            x += 2;
                        }
                        builder.getPanel().setBackground(bgColor);
                        if (isAbove) {
                            this.sepController = builder.getPanel();
                        } else {
                            comps.add(builder.getPanel());
                        }
                        if (this.saveBtn != null) {
                            comps.add(this.saveBtn);
                            saveWasAdded = true;
                        }
                    } else {
                        this.editButton = UIHelper.createButton("InfoIcon", UIRegistry.getResourceString("ViewRecord"), IconManager.IconSize.Std16, true);
                        this.editButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (TableViewObj.this.editButton.isEnabled()) {
                                    TableViewObj.this.editButton.setEnabled(false);
                                    try {
                                        TableViewObj.this.editRow(TableViewObj.this.table.getSelectedRow(), false);
                                    }
                                    finally {
                                        TableViewObj.this.editButton.setEnabled(true);
                                    }
                                }
                            }
                        });
                        PanelBuilder builder = new PanelBuilder(new FormLayout("f:1px:g,p,10px", "p"));
                        builder.add((Component)this.editButton, cc.xy(2, 1));
                        if (mvParent != null && mvParent.getSeparator() != null) {
                            this.sepController = builder.getPanel();
                        } else {
                            comps.add(builder.getPanel());
                        }
                        builder.getPanel().setBackground(bgColor);
                    }
                    this.updateUI(false);
                    if (this.switcherUI != null) {
                        comps.add(this.switcherUI);
                    }
                }
            }
            if (!saveWasAdded && altView.getMode() == AltViewIFace.CreationMode.EDIT) {
                JButton valInfoBtn;
                if (mvParent != null && mvParent.isTopLevel() && !hideSaveBtn && this.saveBtn != null && this.saveBtn != null) {
                    comps.add(this.saveBtn);
                }
                if ((valInfoBtn = FormViewObj.createValidationIndicator(this.mainComp, this.getValidator())) != null) {
                    comps.add(valInfoBtn);
                }
            }
        }
        if (this.businessRules != null) {
            this.businessRules.initialize(this);
        }
        if (comps.size() > 0 || addController) {
            this.controlPanel = new ControlBarPanel(bgColor);
            this.controlPanel.addComponents(comps, false);
            this.mainComp.add((Component)this.controlPanel, "South");
        }
        if (AppContextMgr.isSecurityOn()) {
            String shortClasName = MultiView.getClassNameFromParentMV(dataClass, mvParent, cellName);
            this.setPermsFromTableInfo(shortClasName != null ? shortClasName : view.getClassName());
        } else {
            this.perm = new PermissionSettings(15);
        }
    }

    private void setPermsFromTableInfo(String className) {
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(className);
        if (tableInfo != null) {
            this.perm = SecurityMgr.getInstance().getPermission("DO." + tableInfo.getShortClassName().toLowerCase());
            this.isRestricted = !this.perm.canView();
            if (this.isRestricted.booleanValue()) {
                this.restrictedStr = UIRegistry.getResourceString("RESTRICTED");
            }
            if (this.deleteButton != null) {
                this.deleteButton.setVisible(this.perm.canDelete());
            }
            if (this.editButton != null) {
                this.editButton.setVisible(this.perm.canModify());
            }
            if (this.newButton != null) {
                this.newButton.setVisible(this.perm.canAdd());
            }
        }
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    @Override
    public MultiView getMVParent() {
        return this.mvParent;
    }

    private void doSearch() {
        if (StringUtils.isNotEmpty((String)this.searchName)) {
            ViewBasedSearchDialogIFace dlg = UIRegistry.getViewbasedFactory().createSearchDialog(UIHelper.getWindow(this.mainComp), this.searchName);
            dlg.setMultipleSelection(true);
            dlg.getDialog().setModal(true);
            dlg.getDialog().setVisible(true);
            if (!dlg.isCancelled()) {
                List<Object> newDataObjects = dlg.getSelectedObjects();
                boolean doSetNewDataObj = true;
                if (this.businessRules != null && newDataObjects != null) {
                    if (this.businessRules.doesSearchObjectRequireNewParent()) {
                        throw new RuntimeException("NOT IMPLMENTED!");
                    }
                    for (Object dObj : newDataObjects) {
                        if (!this.businessRules.isOkToAssociateSearchObject(this.parentDataObj, dObj)) {
                            UIRegistry.showLocalizedError(this.businessRules.getMessagesAsString());
                            return;
                        }
                        this.businessRules.processSearchObject(!doSetNewDataObj ? this.dataObj : null, dObj);
                    }
                }
                if (newDataObjects != null && newDataObjects.size() > 0 && doSetNewDataObj) {
                    if (this.dataObjList != null && this.origDataSet != null) {
                        this.dataObjList.addAll(newDataObjects);
                        this.origDataSet.addAll(newDataObjects);
                        for (Object dObj : newDataObjects) {
                            this.parentDataObj.addReference((FormDataObjIFace)dObj, this.dataSetFieldName, true);
                            if (this.isSavable || !this.addSearch || this.mvParent == null || ((FormDataObjIFace)dObj).getId() == null) continue;
                            this.mvParent.getTopLevel().addToBeSavedItem(dObj);
                        }
                        if (this.rsController != null) {
                            int len = this.dataObjList.size();
                            this.rsController.setLength(len);
                            this.rsController.setIndex(len - 1, false);
                        }
                        this.model.fireDataChanged();
                        if (this.addSearch && this.mvParent != null && this.mvParent.getTopLevel().getCurrentValidator() != null) {
                            this.mvParent.getTopLevel().getCurrentValidator().setHasChanged(true);
                            this.mvParent.getTopLevel().getCurrentValidator().validateForm();
                        }
                        this.newObjsList.addAll(newDataObjects);
                    } else {
                        this.setDataObj(newDataObjects.get(0));
                    }
                    this.setDataIntoUI();
                    if (this.formValidator != null) {
                        this.formValidator.validateForm();
                    }
                }
            }
        } else {
            log.error((Object)"The search name is empty is there one defined in the display tag for the XML?");
        }
    }

    @Override
    public void setClassToCreate(Class<?> classToCreate) {
        this.classToCreate = classToCreate;
        if (this.perm == null && this.classToCreate != null) {
            this.setPermsFromTableInfo(classToCreate.getName());
        }
    }

    public void setVisibleRowCount(int rows) {
        UIHelper.setVisibleRowCount(this.table, rows);
    }

    public void setVisibleRowCountForHeight(int rows) {
        UIHelper.setVisibleRowCountForHeight(this.table, rows);
    }

    protected void configColumns() {
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        BiColorTableCellRenderer renderer = new BiColorTableCellRenderer(true);
        TableColumnModel tableColModel = this.table.getColumnModel();
        int i = 0;
        while (i < tableColModel.getColumnCount()) {
            tableColModel.getColumn(i).setCellRenderer(renderer);
            ++i;
        }
    }

    protected void buildTable() {
        this.model = new ColTableModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setFocusable(false);
        this.configColumns();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    TableViewObj.this.updateUI(!lsm.isSelectionEmpty());
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = TableViewObj.this.table.getSelectedRow();
                    TableViewObj.this.editRow(index, false);
                }
            }
        });
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.tableScroller = new JScrollPane(this.table, 20, 30);
        this.orderablePanel = new JPanel(new BorderLayout());
        this.orderablePanel.add((Component)this.tableScroller, "Center");
        this.mainComp.add((Component)this.orderablePanel, "Center");
        this.initColumnSizes(this.table);
    }

    protected void reorderItems(int startInx) {
        int i = startInx;
        while (i < this.dataObjList.size()) {
            Object obj = this.dataObjList.get(i);
            if (obj instanceof Orderable) {
                Orderable orderable = (Orderable)obj;
                orderable.setOrderIndex(i);
            }
            ++i;
        }
        this.model.fireDataChanged();
        this.tellMultiViewOfChange();
    }

    protected void orderUp() {
        int inx = this.table.getSelectedRow();
        if (inx > -1) {
            Object item = this.dataObjList.get(inx);
            this.dataObjList.remove(inx);
            this.dataObjList.insertElementAt(item, inx - 1);
            this.reorderItems(inx - 1);
        }
        this.table.getSelectionModel().setSelectionInterval(inx - 1, inx - 1);
        this.tellMultiViewOfChange();
    }

    protected void orderDown() {
        int inx = this.table.getSelectedRow();
        if (inx > -1) {
            Object item = this.dataObjList.get(inx);
            this.dataObjList.remove(inx);
            this.dataObjList.insertElementAt(item, inx + 1);
            this.reorderItems(inx);
        }
        this.table.getSelectionModel().setSelectionInterval(inx + 1, inx + 1);
    }

    protected void updateUI(boolean hasSelection) {
        int inx;
        if (this.editButton != null) {
            this.editButton.setEnabled(hasSelection);
        }
        if (this.deleteButton != null) {
            inx = this.table != null ? this.table.getSelectedRow() : -1;
            Object item = inx > -1 ? this.dataObjList.get(inx) : null;
            this.deleteButton.setEnabled(hasSelection && (this.businessRules == null || this.businessRules.okToEnableDelete(item)));
        }
        if (this.doOrdering && this.table != null) {
            inx = this.table.getSelectedRow();
            this.orderUpBtn.setEnabled(inx > 0);
            this.orderDwnBtn.setEnabled(inx > -1 && inx < this.table.getRowCount() - 1);
        }
        this.updateUIEnabled();
    }

    private void updateUIEnabled() {
        if (this.newButton != null) {
            this.newButton.setEnabled(this.parentDataObj != null);
        }
    }

    protected void tellMultiViewOfChange() {
        if (this.formValidator != null) {
            this.formValidator.setHasChanged(true);
            this.formValidator.wasValidated(null);
        }
    }

    protected void editRow(int rowIndex, boolean isNew) {
        int inx;
        FormDataObjIFace origObj = null;
        FormDataObjIFace dObj = null;
        if (isNew) {
            if (this.businessRules != null && this.businessRules.canCreateNewDataObject()) {
                this.businessRules.createNewObj(true, null);
            } else {
                dObj = this.classToCreate != null ? FormHelper.createAndNewDataObj(this.classToCreate, this.businessRules) : FormHelper.createAndNewDataObj(this.view.getClassName(), this.businessRules);
                dObj = this.editRow(dObj, rowIndex, isNew);
            }
        } else {
            dObj = (FormDataObjIFace)this.dataObjList.get(rowIndex);
            if (dObj == null) {
                return;
            }
            origObj = dObj;
            dObj = this.editRow(dObj, rowIndex, isNew);
        }
        if (origObj != null && origObj != dObj && (inx = this.dataObjList.indexOf(origObj)) > -1) {
            this.dataObjList.removeElementAt(inx);
            this.dataObjList.insertElementAt(dObj, inx);
        }
    }

    @Override
    public void setNewObject(FormDataObjIFace newDataObj) {
        this.editRow(newDataObj, this.table.getSelectedRow(), true);
    }

    protected FormDataObjIFace editRow(FormDataObjIFace dObjArg, int rowIndex, boolean isNew) {
        ViewBasedDisplayIFace dialog;
        FormDataObjIFace dObj = dObjArg;
        if (!this.doSpecialAdd && this.parentDataObj != null && this.isEditing && isNew) {
            this.parentDataObj.addReference(dObj, this.dataSetFieldName);
        }
        if ((dialog = FormHelper.createDataObjectDialog(this.mainComp, dObj, this.isEditing, isNew)) != null) {
            MultiView realParent;
            MultiView multiView;
            block40: {
                multiView = dialog.getMultiView();
                realParent = this.mvParent.getMultiViewParent();
                if (realParent != null) {
                    realParent.addChildMV(multiView);
                }
                multiView.addCurrentValidator();
                if (isNew && multiView.getCurrentViewAsFormViewObj() != null) {
                    multiView.getCurrentViewAsFormViewObj().getBusinessRules().addChildrenToNewDataObjects(dObj);
                }
                dialog.setParentData(this.parentDataObj);
                DataProviderSessionIFace localSession = null;
                try {
                    try {
                        FormViewObj fvo;
                        if (!this.isSkippingAttach) {
                            block38: {
                                if (dObj.getId() != null) {
                                    localSession = DataProviderFactory.getInstance().createSession();
                                    localSession.attach(dObj);
                                    try {
                                        localSession.attach(dObj);
                                    }
                                    catch (HibernateException ex) {
                                        String msg = ex.getMessage();
                                        if (!StringUtils.isNotEmpty((String)msg)) break block38;
                                        StringUtils.contains((String)msg, (String)"dirty collection");
                                    }
                                }
                            }
                            dialog.setSession(localSession);
                        }
                        if (isNew && (fvo = dialog.getMultiView().getCurrentViewAsFormViewObj()) != null) {
                            fvo.setCreatingNewObject(true);
                            if (fvo.getBusinessRules() != null) {
                                fvo.getBusinessRules().afterCreateNewObj(dObj);
                            }
                        }
                        dialog.setData(dObj);
                        if (localSession != null) {
                            localSession.close();
                            localSession = null;
                        }
                        dialog.setSession(null);
                        dialog.createUI();
                        if (this.addSearch && this.includeAddBtn && this.isEditing && isNew) {
                            dialog.setDoSave(true);
                            dialog.getOkBtn().setText(UIRegistry.getResourceString("SAVE"));
                        }
                        dialog.showDisplay(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(TableViewObj.class, ex);
                        if (localSession != null) {
                            localSession.close();
                        }
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    if (localSession != null) {
                        localSession.close();
                    }
                    throw throwable;
                }
                if (localSession != null) {
                    localSession.close();
                }
            }
            multiView.removeCurrentValidator();
            if (realParent != null) {
                realParent.removeChildMV(multiView);
            }
            if (this.isEditing) {
                if (dialog.getBtnPressed() == 1) {
                    dialog.getMultiView().getDataFromUI();
                    if (this.mvParent != null) {
                        Object daObj;
                        this.tellMultiViewOfChange();
                        Object object = daObj = dialog.getMultiView().getCurrentViewAsFormViewObj() != null ? dialog.getMultiView().getCurrentViewAsFormViewObj().getCurrentDataObj() : null;
                        if (daObj == null) {
                            daObj = dialog.getMultiView().getData();
                        }
                        FormDataObjIFace formDataObjIFace = dObj = daObj instanceof FormDataObjIFace ? (FormDataObjIFace)daObj : dObj;
                        if (isNew) {
                            if (daObj instanceof Orderable) {
                                int maxOrder = -1;
                                for (Object obj : this.dataObjList) {
                                    if (!(obj instanceof Orderable)) continue;
                                    maxOrder = Math.max(((Orderable)obj).getOrderIndex(), maxOrder);
                                }
                                ((Orderable)daObj).setOrderIndex(maxOrder + 1);
                                if (this.orderUpBtn == null) {
                                    this.addOrderablePanel();
                                }
                            }
                            this.dataObjList.add(daObj);
                            if (this.dataObjList != null && this.dataObjList.size() > 0 && this.dataObjList.get(0) instanceof Comparable) {
                                Collections.sort(this.dataObjList);
                            }
                            if (this.origDataSet != null) {
                                this.origDataSet.add(daObj);
                            }
                            this.model.setValueAt(daObj, 0, this.dataObjList.size() - 1);
                        }
                        this.model.fireDataChanged();
                        this.table.invalidate();
                        this.table.repaint();
                        MultiView comp = this.mvParent.getTopLevel();
                        comp.validate();
                        comp.repaint();
                    }
                    if (this.doSpecialAdd && this.parentDataObj != null && this.isEditing && isNew) {
                        this.parentDataObj.addReference(dObj, this.dataSetFieldName);
                    }
                } else if (dialog.isCancelled()) {
                    if (this.parentDataObj != null && this.isEditing && isNew) {
                        this.parentDataObj.removeReference(dObj, this.dataSetFieldName);
                    }
                    if (this.mvParent.getMultiViewParent() != null) {
                        if (this.mvParent.getMultiViewParent().getCurrentValidator() != null) {
                            this.mvParent.getMultiViewParent().getCurrentValidator().validateForm();
                        }
                        multiView.getCurrentViewAsFormViewObj().doWasCacelled();
                    }
                }
            }
            dialog.dispose();
        } else if (this.parentDataObj != null) {
            this.parentDataObj.removeReference(dObj, this.dataSetFieldName);
        }
        return dObj;
    }

    protected void addOrderablePanel() {
        this.doOrdering = true;
        this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "ES_RES_MOVE_UP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TableViewObj.this.orderUp();
            }
        });
        this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "ES_RES_MOVE_DOWN", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TableViewObj.this.orderDown();
            }
        });
        PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
        upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
        upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
        this.orderablePanel.add((Component)upDownPanel.getPanel(), "East");
        this.orderablePanel.validate();
        this.orderablePanel.invalidate();
        this.orderablePanel.doLayout();
    }

    protected void deleteRow(int rowIndex) {
        FormDataObjIFace dObj = (FormDataObjIFace)this.dataObjList.get(rowIndex);
        if (dObj != null) {
            Object[] delBtnLabels = new Object[]{UIRegistry.getResourceString(this.addSearch ? "Remove" : "Delete"), UIRegistry.getResourceString("CANCEL")};
            int rv = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage(this.addSearch ? "ASK_REMOVE" : "ASK_DELETE", dObj.getIdentityTitle()), UIRegistry.getResourceString(this.addSearch ? "Remove" : "Delete"), 0, 3, null, delBtnLabels, delBtnLabels[1]);
            if (rv == 0) {
                DBTableChildIFace ci;
                boolean doOtherSide = true;
                DBTableInfo parentTblInfo = DBTableIdMgr.getInstance().getByShortClassName(this.parentDataObj.getClass().getSimpleName());
                if (parentTblInfo != null && (ci = parentTblInfo.getItemByName(this.cellName)) instanceof DBRelationshipInfo) {
                    DBRelationshipInfo ri = (DBRelationshipInfo)ci;
                    doOtherSide = ri.getType() == DBRelationshipInfo.RelationshipType.OneToMany;
                    log.debug((Object)ri.getType());
                }
                this.parentDataObj.removeReference(dObj, this.dataSetFieldName, (doOtherSide = false) || this.addSearch);
                if (this.addSearch && this.mvParent != null && dObj.getId() != null) {
                    this.mvParent.getTopLevel().addToBeSavedItem(dObj);
                }
                if (this.addSearch && this.mvParent != null && dObj.getId() != null) {
                    this.mvParent.getTopLevel().addToBeSavedItem(dObj);
                }
                this.dataObjList.remove(rowIndex);
                this.model.fireDataChanged();
                this.table.invalidate();
                MultiView comp = this.mvParent.getTopLevel();
                comp.validate();
                comp.repaint();
                this.reorderItems(rowIndex);
                this.tellMultiViewOfChange();
                this.table.getSelectionModel().clearSelection();
                this.updateUI(false);
                this.mvParent.getTopLevel().getCurrentValidator().setHasChanged(true);
                this.mvParent.getTopLevel().getCurrentValidator().validateForm();
                this.mvParent.getCurrentValidator().setHasChanged(true);
                this.mvParent.getMultiViewParent().getCurrentValidator().validateForm();
                if (!this.addSearch && this.mvParent != null && !this.mvParent.isTopLevel()) {
                    this.mvParent.getTopLevel().addDeletedItem(dObj);
                    String delMsg = this.businessRules != null ? this.businessRules.getDeleteMsg(dObj) : "";
                    UIRegistry.getStatusBar().setText(delMsg);
                }
            }
        }
    }

    private void initColumnSizes(JTable tableArg) {
        ColTableModel tblModel = (ColTableModel)tableArg.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = tableArg.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < tblModel.getColumnCount()) {
            column = tableArg.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = tableArg.getDefaultRenderer(tblModel.getColumnClass(i)).getTableCellRendererComponent(tableArg, tblModel.getValueAt(0, i), false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
            ++i;
        }
    }

    public void refreshDataList() {
        this.dataObjList.clear();
        this.dataObjList.addAll(this.origDataSet);
        this.model.fireDataChanged();
    }

    public JTable getTable() {
        return this.table;
    }

    protected void setValidator(FormValidator formValidator) {
        this.formValidator = formValidator;
        if (formValidator != null && this.mvParent != null) {
            formValidator.addValidationListener(this);
        }
    }

    @Override
    public JComponent getControllerPanel() {
        return this.sepController;
    }

    @Override
    public String getName() {
        return "Table Viewer for Forms";
    }

    public int getId() {
        return -1;
    }

    @Override
    public ViewDefIFace.ViewType getType() {
        return this.tableViewDef.getType();
    }

    @Override
    public Component getUIComponent() {
        if (this.model == null) {
            this.buildTable();
        }
        return this.mainComp;
    }

    @Override
    public boolean isSubform() {
        return false;
    }

    @Override
    public <T> T getCompById(String id) {
        return null;
    }

    @Override
    public JLabel getLabelFor(String id) {
        return null;
    }

    @Override
    public Map<String, Component> getControlMapping() {
        return null;
    }

    @Override
    public FormValidator getValidator() {
        return this.formValidator;
    }

    @Override
    public void setDataObj(Object dataObj) {
        this.dataObj = dataObj;
        if (dataObj instanceof List) {
            this.origDataSet = null;
            this.dataObjList = dataObj instanceof Vector ? (Vector)((List)dataObj) : new Vector((List)dataObj);
            this.newObjsList.addAll(this.dataObjList);
        } else {
            if (this.dataObjList == null) {
                this.dataObjList = new Vector();
            } else {
                this.dataObjList.clear();
            }
            if (dataObj instanceof Set) {
                this.origDataSet = (Set)dataObj;
                ArrayList<Object> newList = Collections.list(Collections.enumeration(this.origDataSet));
                if (newList.size() > 0) {
                    Object firstObj = newList.get(0);
                    if (firstObj instanceof Comparable) {
                        Collections.sort(newList);
                    }
                    if (firstObj instanceof Orderable && this.isEditing && this.orderUpBtn == null) {
                        this.addOrderablePanel();
                    }
                }
                this.dataObjList.addAll(newList);
                this.newObjsList.addAll(newList);
            } else if (!(dataObj instanceof RecordSetIFace) && dataObj != null) {
                this.dataObjList.add(dataObj);
                this.newObjsList.add(dataObj);
            }
        }
        this.setDataIntoUI();
        if (this.table != null) {
            this.table.tableChanged(new TableModelEvent(this.model));
        }
    }

    @Override
    public void setRecordSet(RecordSetIFace recordSet) {
    }

    @Override
    public Object getDataObj() {
        return this.dataObj;
    }

    @Override
    public void setParentDataObj(Object parentDataObj) {
        this.parentDataObj = (FormDataObjIFace)parentDataObj;
        this.updateUIEnabled();
    }

    @Override
    public Object getParentDataObj() {
        return this.parentDataObj;
    }

    @Override
    public void setDataIntoUI() {
        block13: {
            if (this.newObjsList.size() == 0) {
                return;
            }
            if (this.dataObjList != null && this.model != null) {
                DataProviderSessionIFace tmpSession = this.session;
                try {
                    try {
                        if (tmpSession == null) {
                            // empty if block
                        }
                        this.isLoaded = true;
                        int i = 0;
                        while (i < this.dataObjList.size()) {
                            int j = 0;
                            while (j < this.model.getColumnCount()) {
                                this.model.getValueAt(i, j);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(TableViewObj.class, ex);
                        if (this.session == null && tmpSession != null) {
                            tmpSession.close();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (this.session == null && tmpSession != null) {
                        tmpSession.close();
                    }
                    throw throwable;
                }
                if (this.session == null && tmpSession != null) {
                    tmpSession.close();
                }
            }
        }
        this.newObjsList.clear();
    }

    @Override
    public void getDataFromUI() {
    }

    @Override
    public Object getDataFromUIComp(String name) {
        return null;
    }

    @Override
    public void setDataIntoUIComp(String name, Object data) {
    }

    @Override
    public MultiView getSubView(String name) {
        return null;
    }

    @Override
    public void getFieldIds(List<String> fieldIds) {
    }

    @Override
    public void getFieldNames(List<String> fieldNames) {
    }

    @Override
    public void aboutToShow(boolean show) {
        if (this.origDataSet != null && this.list != null) {
            this.origDataSet.size();
            this.list.size();
        }
        if (this.switcherUI != null) {
            this.ignoreSelection = true;
            this.switcherUI.set(this.altView);
            this.ignoreSelection = false;
        }
        if (this.formValidator != null) {
            this.formValidator.validateForm();
        }
    }

    @Override
    public ViewIFace getView() {
        return this.view;
    }

    @Override
    public FormViewDef getViewDef() {
        return (FormViewDef)this.altView.getViewDef();
    }

    @Override
    public AltViewIFace getAltView() {
        return this.altView;
    }

    @Override
    public void hideMultiViewSwitch(boolean hide) {
    }

    @Override
    public void enableMultiViewSwitch(boolean enabled) {
        if (this.switcherUI != null) {
            this.switcherUI.setEnabled(enabled);
            this.switcherUI.repaint();
        }
    }

    @Override
    public void validationWasOK(boolean wasOK) {
    }

    @Override
    public void setSession(DataProviderSessionIFace session) {
        this.session = session;
    }

    @Override
    public void setCellName(String cellName) {
        DBRelationshipInfo rel;
        DBTableInfo parentTI;
        this.cellName = cellName;
        this.dataSetFieldName = cellName;
        if (this.parentDataObj == null) {
            this.dataClassName = this.viewDef.getClassName();
        }
        if (cellName != null && (parentTI = DBTableIdMgr.getInstance().getByClassName(this.mvParent.getMultiViewParent().getView().getClassName())) != null && (rel = parentTI.getRelationshipByName(cellName)) != null) {
            this.isSavable = rel.isSavable();
        }
    }

    @Override
    public void setHasNewData(boolean isNewForm) {
    }

    @Override
    public void registerSaveBtn(JButton saveBtnArg) {
        this.saveBtn = saveBtnArg;
    }

    @Override
    public void updateSaveBtn() {
    }

    @Override
    public void focus() {
    }

    @Override
    public void aboutToShutdown() {
        if (this.businessRules != null) {
            this.businessRules.aboutToShutdown();
        }
    }

    @Override
    public void shutdown() {
        if (this.businessRules != null) {
            this.businessRules.formShutdown();
            this.businessRules = null;
        }
        this.mvParent = null;
        this.tableViewDef = null;
        this.table = null;
        this.tableScroller = null;
        this.mainComp = null;
    }

    protected String appendName(String cName) {
        return String.valueOf(this.fullObjPath.toString()) + (this.fullObjPath.length() > 0 ? "." : "") + cName;
    }

    @Override
    public void addLabel(FormCellLabel formCellLabel, JLabel label) {
        String fullCompName;
        ColumnInfo colInfo;
        if (this.skipControls > 0) {
            return;
        }
        if (formCellLabel != null && StringUtils.isNotEmpty((String)formCellLabel.getLabelFor()) && (colInfo = this.controlsById.get(fullCompName = this.appendName(formCellLabel.getLabelFor()))) == null) {
            colInfo = new ColumnInfo(this.getParentClassName(), formCellLabel, fullCompName, null, null);
            this.controlsById.put(fullCompName, colInfo);
        }
    }

    protected String getParentClassName() {
        FormCellSubView formSubView;
        String className = null;
        FormCellSubView formCellSubView = formSubView = this.subViewStack.size() > 0 ? this.subViewStack.peek() : null;
        if (formSubView != null) {
            className = formSubView.getClassDesc();
        }
        if (StringUtils.isEmpty(className)) {
            className = this.view.getClassName();
        }
        return className;
    }

    @Override
    public void registerControl(FormCellIFace formCell, Component control) {
        if (this.skipControls > 0) {
            return;
        }
        if (formCell != null) {
            Component comp;
            JScrollPane scrollPane;
            String fullCompName = this.appendName(formCell.getName());
            if (control instanceof JScrollPane) {
                scrollPane = (JScrollPane)control;
                comp = scrollPane.getViewport().getView();
            } else {
                scrollPane = null;
                comp = control;
            }
            String fullId = this.appendName(formCell.getIdent());
            ColumnInfo colInfo = this.controlsById.get(fullId);
            if (colInfo == null) {
                colInfo = new ColumnInfo(this.getParentClassName(), formCell, fullCompName, comp, scrollPane);
                this.controlsById.put(fullId, colInfo);
            } else {
                colInfo.setFullCompName(fullCompName);
                colInfo.setFormCell(formCell);
            }
            if (StringUtils.isEmpty((String)colInfo.getLabel())) {
                if (control instanceof JCheckBox) {
                    String cbxLabel = ((JCheckBox)control).getText();
                    if (StringUtils.isEmpty((String)cbxLabel)) {
                        cbxLabel = " ";
                    }
                    colInfo.setLabel(cbxLabel);
                } else {
                    colInfo.setLabel(" ");
                }
            }
            colInfo.setComp(comp);
            colInfo.setScrollPane(scrollPane);
            this.columnList.add(colInfo);
            this.controlsByName.put(fullCompName, colInfo);
        }
    }

    @Override
    public void registerPlugin(FormCellIFace formCell, UIPluginable uip) {
    }

    @Override
    public void addControlToUI(Component control, int rowInx, int colInx, int colSpan, int rowSpan) {
    }

    @Override
    public Component createSeparator(String title) {
        return null;
    }

    @Override
    public JComponent createRecordIndentifier(String title, ImageIcon icon) {
        return null;
    }

    @Override
    public void addSubView(FormCellSubView subFormCell, MultiView subView, int colInx, int rowInx, int colSpan, int rowSpan) {
        this.subViewStack.push(subFormCell);
        if (this.fullObjPath.length() > 0) {
            this.fullObjPath.append(".");
        }
        this.fullObjPath.append(subFormCell.getName());
        String clsName = this.getParentClassName();
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByClassName(clsName);
        if (tblInfo != null) {
            boolean isSet;
            DBRelationshipInfo.RelationshipType type = tblInfo.getRelType(subFormCell.getName());
            boolean bl = isSet = type == DBRelationshipInfo.RelationshipType.OneToMany || type == DBRelationshipInfo.RelationshipType.ManyToMany;
            if (isSet) {
                ++this.skipControls;
                String fullCompName = subFormCell.getName();
                String fullId = this.appendName(subFormCell.getIdent());
                ColumnInfo colInfo = this.controlsById.get(fullId);
                if (colInfo == null) {
                    colInfo = new ColumnInfo(this.getParentClassName(), subFormCell, fullCompName, null, null);
                    this.controlsById.put(fullId, colInfo);
                }
                this.columnList.add(colInfo);
                this.controlsByName.put(fullCompName, colInfo);
            }
        }
    }

    @Override
    public void closeSubView(FormCellSubView subFormCell) {
        this.subViewStack.pop();
        this.fullObjPath.setLength(this.fullObjPath.length() - subFormCell.getName().length());
        if (this.fullObjPath.length() > 1) {
            this.fullObjPath.setLength(this.fullObjPath.length() - 1);
        }
        --this.skipControls;
    }

    @Override
    public boolean shouldFlatten() {
        return true;
    }

    @Override
    public Component getControlByName(String name) {
        return null;
    }

    @Override
    public Component getControlById(String id) {
        return null;
    }

    @Override
    public boolean hasRequiredFields() {
        return false;
    }

    @Override
    public void fixUpRequiredDerivedLabels() {
    }

    @Override
    public void doneBuilding() {
    }

    @Override
    public JComponent getSaveComponent() {
        return null;
    }

    @Override
    public boolean isDataCompleteAndValid(boolean throwAwayOnDiscard) {
        return true;
    }

    @Override
    public void setSkippingAttach(boolean isSkippingAttach) {
        this.isSkippingAttach = isSkippingAttach;
    }

    @Override
    public void wasValidated(UIValidator validator) {
        if (this.validationInfoBtn != null) {
            ImageIcon icon = IconManager.getIcon("ValidationValid");
            UIValidatable.ErrorType state = this.formValidator.getState();
            if (state == UIValidatable.ErrorType.Incomplete) {
                icon = IconManager.getIcon("ValidationWarning", IconManager.IconSize.Std16);
            } else if (state == UIValidatable.ErrorType.Error) {
                icon = IconManager.getIcon("ValidationError");
            }
            this.validationInfoBtn.setIcon(icon);
        }
    }

    @Override
    public void indexChanged(int newIndex) {
        this.dataObj = this.dataObjList.get(newIndex);
        this.setDataIntoUI();
        if (this.saveBtn != null) {
            this.saveBtn.setEnabled(false);
        }
    }

    @Override
    public boolean indexAboutToChange(int oldIndex, int newIndex) {
        return false;
    }

    @Override
    public void newRecordAdded() {
        if (this.mvParent.getMultiViewParent() != null) {
            this.formValidator.setHasChanged(true);
        }
    }

    protected void setColorOnControls(int colorType, Color color) {
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("viewfieldcolor")) {
            ColorWrapper viewFieldColorLocal = AppPrefsCache.getColorWrapper("ui", "formatting", "viewfieldcolor");
            this.setColorOnControls(0, viewFieldColorLocal.getColor());
        }
    }

    public class ColTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return TableViewObj.this.columnList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (TableViewObj.this.columnList != null) {
                String label = TableViewObj.this.columnList.get(column).getLabel();
                return label != null ? label : "xx";
            }
            log.error((Object)"columnList should not be null!");
            return "N/A";
        }

        @Override
        public int getRowCount() {
            if (TableViewObj.this.isLoading || TableViewObj.this.isRestricted != null && TableViewObj.this.isRestricted.booleanValue()) {
                return 1;
            }
            return TableViewObj.this.dataObjList == null ? 0 : TableViewObj.this.dataObjList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (TableViewObj.this.isLoading) {
                return column == 0 && row == 0 ? UIRegistry.getResourceString("LOADING") : "";
            }
            if (TableViewObj.this.isRestricted != null && TableViewObj.this.isRestricted.booleanValue()) {
                return TableViewObj.this.restrictedStr;
            }
            if (TableViewObj.this.columnList != null && TableViewObj.this.dataObjList != null && TableViewObj.this.dataObjList.size() > 0) {
                Object[] dataValues;
                if (!TableViewObj.this.isLoaded) {
                    TableViewObj.this.setDataIntoUI();
                }
                ColumnInfo colInfo = TableViewObj.this.columnList.get(column);
                Object rowObj = TableViewObj.this.dataObjList.get(row);
                if (TableViewObj.this.session != null && TableViewObj.this.session.isOpen() && rowObj instanceof FormDataObjIFace) {
                    TableViewObj.this.session.attach(rowObj);
                }
                if ((dataValues = UIHelper.getFieldValues(new String[]{colInfo.getFullCompName()}, rowObj, TableViewObj.this.dataGetter)) == null || dataValues[0] == null) {
                    return null;
                }
                Object dataVal = dataValues[0];
                String dataObjFormatName = colInfo.getDataObjFormatName();
                if (StringUtils.isNotEmpty((String)dataObjFormatName)) {
                    return DataObjFieldFormatMgr.getInstance().format(dataVal, dataObjFormatName);
                }
                if (dataVal instanceof FormDataObjIFace) {
                    FormDataObjIFace formObj = (FormDataObjIFace)dataVal;
                    String val = DataObjFieldFormatMgr.getInstance().format(dataVal, formObj.getDataClass());
                    if (val != null) {
                        return val;
                    }
                }
                if (dataVal instanceof Set) {
                    Set objSet = (Set)dataVal;
                    if (objSet.size() > 0) {
                        return DataObjFieldFormatMgr.getInstance().aggregate(objSet, objSet.iterator().next().getClass());
                    }
                    return "";
                }
                if (colInfo.getFormCell() instanceof FormCellFieldIFace) {
                    UIFieldFormatterIFace fmt;
                    FormCellFieldIFace fcf = (FormCellFieldIFace)colInfo.getFormCell();
                    String uiFmt = fcf.getUIFieldFormatterName();
                    if (fcf.getDspUIType() == FormCellFieldIFace.FieldType.textpl) {
                        String pickListName;
                        PickListDBAdapterIFace adapter = colInfo.getAdaptor();
                        if (adapter == null && StringUtils.isNotEmpty((String)(pickListName = fcf.getPickListName()))) {
                            adapter = PickListDBAdapterFactory.getInstance().create(pickListName, false);
                            if (adapter == null || adapter.getPickList() == null) {
                                FormDevHelper.showFormDevError("PickList Adapter [" + pickListName + "] cannot be null!");
                                return null;
                            }
                            colInfo.setAdaptor(adapter);
                        }
                        return this.getPickListValue(adapter, dataVal);
                    }
                    if (StringUtils.isNotEmpty((String)uiFmt) && (fmt = UIFieldFormatterMgr.getInstance().getFormatter(uiFmt)) != null) {
                        dataVal = fmt.formatToUI(dataVal);
                    }
                }
                return dataVal instanceof Boolean ? UIRegistry.getResourceString(dataVal.toString()) : dataVal;
            }
            return null;
        }

        protected Object getPickListValue(PickListDBAdapterIFace adapter, Object value) {
            if (value != null && adapter != null) {
                if (adapter.isTabledBased()) {
                    String data = null;
                    boolean isFormObjIFace = value instanceof FormDataObjIFace;
                    Vector<PickListItemIFace> items = adapter.getList();
                    int i = 0;
                    while (i < items.size()) {
                        PickListItemIFace pli = items.get(i);
                        Object valObj = pli.getValueObject();
                        if (valObj != null) {
                            if (isFormObjIFace && valObj instanceof FormDataObjIFace) {
                                if (((FormDataObjIFace)value).getId().intValue() == ((FormDataObjIFace)valObj).getId().intValue()) {
                                    data = pli.getTitle();
                                    break;
                                }
                            } else if (pli.getValue().equals(value.toString())) {
                                data = pli.getTitle();
                                break;
                            }
                        }
                        ++i;
                    }
                    if (data == null) {
                        data = "";
                    }
                    return data;
                }
                if (value != null) {
                    for (PickListItemIFace item : adapter.getList()) {
                        if (item.getValue() == null || !item.getValue().equals(value.toString())) continue;
                        return item.getTitle();
                    }
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (TableViewObj.this.isRestricted != null && TableViewObj.this.isRestricted.booleanValue()) {
                return String.class;
            }
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }

        public void fireDataChanged() {
            this.fireTableDataChanged();
        }
    }

    class ColumnInfo {
        protected FormCellIFace formCell;
        protected FormCellLabelIFace formCellLabel;
        protected String parentClassName;
        protected String fullCompName;
        protected String label;
        protected Component comp;
        protected JScrollPane scrollPane;
        protected String[] fieldNames;
        protected boolean isSet;
        protected String dataObjFormatName = null;
        protected boolean hasDataObjFormatter = false;
        protected PickListDBAdapterIFace adaptor = null;

        public ColumnInfo(String parentClassName, FormCellIFace formCell, String fullCompName, Component comp, JScrollPane scrollPane) {
            if (formCell instanceof FormCellLabelIFace) {
                this.formCell = null;
                this.formCellLabel = (FormCellLabelIFace)formCell;
                this.label = ((FormCellLabelIFace)formCell).getLabel();
            } else {
                this.formCell = formCell;
                if (formCell instanceof FormCellFieldIFace) {
                    this.label = ((FormCellFieldIFace)formCell).getLabel();
                } else if (formCell instanceof FormCellSubView) {
                    DBTableInfo ti;
                    FormCellSubView subViewDef = (FormCellSubView)formCell;
                    DBTableInfo dBTableInfo = ti = subViewDef.getClassDesc() == null ? null : DBTableIdMgr.getInstance().getByClassName(subViewDef.getClassDesc());
                    if (ti != null) {
                        this.label = ti.getTitle();
                    } else {
                        DBTableChildIFace childInfo;
                        ti = DBTableIdMgr.getInstance().getByClassName(parentClassName);
                        if (ti != null && (childInfo = ti.getItemByName(subViewDef.getName())) != null) {
                            this.label = childInfo.getTitle();
                        }
                    }
                }
                this.formCellLabel = null;
            }
            this.parentClassName = parentClassName;
            this.fullCompName = fullCompName;
            this.comp = comp;
            this.scrollPane = scrollPane;
            this.fieldNames = StringUtils.split((String)StringUtils.deleteWhitespace((String)fullCompName), (String)".");
            this.isSet = false;
            this.checkForDataObjFormatter();
            this.checkForSet();
        }

        protected void checkForDataObjFormatter() {
            FormCellField fcf;
            if (this.formCell instanceof FormCellField && ((fcf = (FormCellField)this.formCell).getDspUIType().equals("querycbx") || fcf.getDspUIType().equals("textfieldinfo"))) {
                this.dataObjFormatName = fcf.getProperty("name");
            }
        }

        protected void checkForSet() {
            DBTableInfo tblInfo;
            String name;
            String string = name = this.formCell != null ? this.formCell.getName() : this.formCellLabel.getName();
            if (StringUtils.isNotEmpty((String)name) && (tblInfo = DBTableIdMgr.getInstance().getByClassName(this.parentClassName)) != null) {
                DBRelationshipInfo.RelationshipType type = tblInfo.getRelType(this.formCell.getName());
                this.isSet = type == DBRelationshipInfo.RelationshipType.ManyToMany || type == DBRelationshipInfo.RelationshipType.ManyToOne;
            }
        }

        public String[] getFieldNames() {
            return this.fieldNames;
        }

        public String getFullCompName() {
            return this.fullCompName;
        }

        public void setFullCompName(String fullCompName) {
            this.fullCompName = fullCompName;
            this.fieldNames = StringUtils.split((String)StringUtils.deleteWhitespace((String)fullCompName), (String)".");
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getName() {
            return this.formCell.getName();
        }

        public String getId() {
            return this.formCell.getIdent();
        }

        public Component getComp() {
            return this.comp;
        }

        public void setComp(Component comp) {
            this.comp = comp;
        }

        public void setScrollPane(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
        }

        public FormCellIFace getFormCell() {
            return this.formCell;
        }

        public void setFormCell(FormCellIFace formCell) {
            if (formCell instanceof FormCellLabelIFace) {
                this.formCellLabel = (FormCellLabelIFace)formCell;
            } else {
                this.formCell = formCell;
            }
            this.checkForDataObjFormatter();
            this.checkForSet();
        }

        public FormCellLabelIFace getFormCellLabel() {
            return this.formCellLabel;
        }

        public String getDataObjFormatName() {
            return this.dataObjFormatName;
        }

        public void setEnabled(boolean enabled) {
            this.comp.setEnabled(enabled);
            if (this.scrollPane != null) {
                this.scrollPane.setEnabled(enabled);
            }
        }

        public boolean hasDataObjFormatter() {
            return this.hasDataObjFormatter;
        }

        public void setHasDataObjFormatter(boolean hasDataObjFormatter) {
            this.hasDataObjFormatter = hasDataObjFormatter;
        }

        public PickListDBAdapterIFace getAdaptor() {
            return this.adaptor;
        }

        public void setAdaptor(PickListDBAdapterIFace adaptor) {
            this.adaptor = adaptor;
        }

        public void shutdown() {
            if (this.comp instanceof UIValidatable) {
                ((UIValidatable)((Object)this.comp)).cleanUp();
            }
            this.formCell = null;
            this.comp = null;
            this.scrollPane = null;
        }
    }

    class MyTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected Component comp;
        protected GetSetValueIFace compGetSet;

        public MyTableCellEditor(ColumnInfo colInfo) {
            this.comp = colInfo.getComp();
            this.compGetSet = (GetSetValueIFace)((Object)this.comp);
        }

        @Override
        public Object getCellEditorValue() {
            return this.compGetSet.getValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable tbl, Object value, boolean isSelected, int row, int column) {
            this.compGetSet.setValue(value, null);
            return this.comp;
        }
    }
}

