/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.ResultSetControllerListener;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.af.ui.forms.validation.ValidationListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang.StringUtils;

public class ResultSetController
implements ValidationListener {
    protected static Border enabledBorder = BorderFactory.createLineBorder(new Color(64, 64, 64));
    protected static Border disabledBorder = BorderFactory.createLineBorder(Color.GRAY.brighter());
    protected static Color enabledTxtBG = Color.WHITE;
    protected static Color disabledTxtBG = new Color(225, 225, 225);
    protected List<ResultSetControllerListener> listeners = new ArrayList<ResultSetControllerListener>();
    protected FormValidator formValidator = null;
    protected JPanel panel = null;
    protected JButton firstBtn = null;
    protected JButton prevBtn = null;
    protected JLabel recDisp = null;
    protected JButton nextBtn = null;
    protected JButton lastBtn = null;
    protected JButton newRecBtn = null;
    protected JButton delRecBtn = null;
    protected JButton searchRecBtn = null;
    protected int currentInx = 0;
    protected int lastInx = 0;
    protected int numRecords = 0;
    protected boolean isNewObj = false;
    protected boolean doLayoutBtns;
    private Hashtable<UIHelper.CommandType, JButton> btnsHash = new Hashtable();
    private static Hashtable<UIHelper.CommandType, RSAction<UIHelper.CommandType>> commandsHash = null;
    private static ResultSetController currentFocusedRS = null;
    private static ResultSetController backStopRS = null;

    static {
        ResultSetController.registerFocusListener();
    }

    private ResultSetController() {
    }

    public ResultSetController(FormValidator formValidator, boolean addNewBtn, boolean addDelBtn, boolean addSearchBtn, String objTitle, int len, boolean doLayoutBtns) {
        String objectTitle;
        this.formValidator = formValidator;
        this.doLayoutBtns = doLayoutBtns;
        if (formValidator != null) {
            formValidator.addValidationListener(this);
        }
        if (StringUtils.isEmpty((String)(objectTitle = objTitle)) && StringUtils.isEmpty((String)(objectTitle = UIRegistry.getResourceString("Item")))) {
            objectTitle = "Item";
        }
        this.buildRecordNavBar(addNewBtn, addDelBtn, addSearchBtn, objectTitle);
        this.setLength(len);
    }

    public void setupGotoListener() {
        KeyStroke gotoKS = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String ACTION_KEY = "GOTO";
        InputMap inputMap = this.panel.getInputMap(2);
        ActionMap actionMap = this.panel.getActionMap();
        inputMap.put(gotoKS, ACTION_KEY);
        actionMap.put(ACTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultSetController.this.showGotoRecDlg();
            }
        });
    }

    public static String createTooltip(String ttKey, String objTitle) {
        return String.format(UIRegistry.getResourceString(ttKey), objTitle);
    }

    protected void buildRecordNavBar(boolean addNewBtn, boolean addDelBtn, boolean addSearchBtn, String objTitle) {
        String colDef = "p,2dlu,p,2dlu,max(50dlu;p):grow,2dlu,p,2dlu,p" + (addNewBtn ? ",12px,p" : "") + (addDelBtn ? ",2dlu,p" : "") + (addSearchBtn ? ",2dlu,p" : "");
        Insets insets = new Insets(1, 1, 1, 1);
        DefaultFormBuilder rowBuilder = new DefaultFormBuilder(new FormLayout(colDef, "p"));
        this.firstBtn = UIHelper.createIconBtn("FirstRec", null, null);
        this.prevBtn = UIHelper.createIconBtn("PrevRec", null, null);
        this.btnsHash.put(UIHelper.CommandType.Previous, this.prevBtn);
        this.btnsHash.put(UIHelper.CommandType.First, this.firstBtn);
        this.recDisp = UIHelper.createLabel("  ");
        this.recDisp.setHorizontalAlignment(0);
        this.recDisp.setOpaque(true);
        this.recDisp.setBackground(Color.WHITE);
        this.recDisp.setBorder(enabledBorder);
        this.recDisp.setFont(this.recDisp.getFont().deriveFont(this.recDisp.getFont().getSize2D() - 2.0f));
        MouseAdapter mouseListener = new MouseAdapter(){

            private boolean showIfPopupTrigger(MouseEvent mouseEvent) {
                JPopupMenu popupMenu;
                if (mouseEvent.isPopupTrigger() && (popupMenu = ResultSetController.this.createPopupMenu()) != null && popupMenu.getComponentCount() > 0) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    return true;
                }
                return false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showIfPopupTrigger(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showIfPopupTrigger(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ResultSetController.this.showGotoRecDlg();
                }
            }
        };
        this.recDisp.addMouseListener(mouseListener);
        this.nextBtn = UIHelper.createIconBtn("NextRec", null, null);
        this.lastBtn = UIHelper.createIconBtn("LastRec", null, null);
        this.btnsHash.put(UIHelper.CommandType.Next, this.nextBtn);
        this.btnsHash.put(UIHelper.CommandType.Last, this.lastBtn);
        this.firstBtn.setToolTipText(ResultSetController.createTooltip("GotoFirstRecordTT", objTitle));
        this.prevBtn.setToolTipText(ResultSetController.createTooltip("GotoPreviousRecordTT", objTitle));
        this.nextBtn.setToolTipText(ResultSetController.createTooltip("GotoNextRecordTT", objTitle));
        this.lastBtn.setToolTipText(ResultSetController.createTooltip("GotoLastRecordTT", objTitle));
        this.firstBtn.setOpaque(false);
        this.prevBtn.setOpaque(false);
        this.nextBtn.setOpaque(false);
        this.lastBtn.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        rowBuilder.add((Component)this.firstBtn, cc.xy(1, 1));
        rowBuilder.add((Component)this.prevBtn, cc.xy(3, 1));
        rowBuilder.add((Component)this.recDisp, cc.xy(5, 1));
        rowBuilder.add((Component)this.nextBtn, cc.xy(7, 1));
        rowBuilder.add((Component)this.lastBtn, cc.xy(9, 1));
        int col = 11;
        if (addNewBtn) {
            this.newRecBtn = UIHelper.createIconBtn("NewRecord", null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    for (ResultSetControllerListener rscl : ResultSetController.this.listeners) {
                        rscl.newRecordAdded();
                    }
                }
            });
            this.newRecBtn.setToolTipText(ResultSetController.createTooltip("NewRecordTT", objTitle));
            this.newRecBtn.setEnabled(true);
            this.newRecBtn.setMargin(insets);
            this.btnsHash.put(UIHelper.CommandType.NewItem, this.newRecBtn);
            if (this.doLayoutBtns) {
                rowBuilder.add((Component)this.newRecBtn, cc.xy(col, 1));
                col += 2;
            }
        }
        if (addDelBtn) {
            this.delRecBtn = UIHelper.createIconBtn("DeleteRecord", null, null);
            this.delRecBtn.setToolTipText(ResultSetController.createTooltip("DeleteRecordTT", objTitle));
            this.delRecBtn.setMargin(insets);
            this.btnsHash.put(UIHelper.CommandType.DelItem, this.delRecBtn);
            if (this.doLayoutBtns) {
                rowBuilder.add((Component)this.delRecBtn, cc.xy(col, 1));
                col += 2;
            }
        }
        if (addSearchBtn) {
            this.searchRecBtn = UIHelper.createIconBtn("Search", IconManager.IconSize.Std16, null, null);
            this.searchRecBtn.setToolTipText(ResultSetController.createTooltip("SearchForRecordTT", objTitle));
            this.searchRecBtn.setMargin(insets);
            if (this.doLayoutBtns) {
                rowBuilder.add((Component)this.searchRecBtn, cc.xy(col, 1));
                col += 2;
            }
        }
        this.firstBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ResultSetController.this.firstRecord();
            }
        });
        this.prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ResultSetController.this.prevRecord();
            }
        });
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ResultSetController.this.nextRecord();
            }
        });
        this.lastBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ResultSetController.this.lastRecord();
            }
        });
        rowBuilder.getPanel().setOpaque(false);
        DefaultFormBuilder outerCenteredPanel = new DefaultFormBuilder(new FormLayout("c:p:g", "p"));
        outerCenteredPanel.add((Component)rowBuilder.getPanel(), cc.xy(1, 1));
        this.panel = outerCenteredPanel.getPanel();
        this.panel.setOpaque(false);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = UIHelper.createLocalizedMenuItem("Go to Record", null, null, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultSetController.this.showGotoRecDlg();
            }
        });
        popupMenu.add(mi);
        return popupMenu;
    }

    private void firstRecord() {
        if (this.notifyListenersAboutToChangeIndex(this.currentInx, 0)) {
            this.currentInx = 0;
            this.updateUI();
            this.notifyListeners();
        }
    }

    private void lastRecord() {
        if (this.notifyListenersAboutToChangeIndex(this.currentInx, this.lastInx)) {
            this.currentInx = this.lastInx;
            this.updateUI();
            this.notifyListeners();
        }
    }

    public void prevRecord() {
        if (this.currentInx < 1) {
            return;
        }
        this.setUIEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ResultSetController.this.notifyListenersAboutToChangeIndex(ResultSetController.this.currentInx, ResultSetController.this.currentInx - 1) && ResultSetController.this.currentInx > 0) {
                    --ResultSetController.this.currentInx;
                    ResultSetController.this.updateUI();
                    ResultSetController.this.notifyListeners();
                }
            }
        });
    }

    public void nextRecord() {
        if (this.currentInx > this.numRecords - 2) {
            return;
        }
        this.setUIEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ResultSetController.this.notifyListenersAboutToChangeIndex(ResultSetController.this.currentInx, ResultSetController.this.currentInx + 1)) {
                    ++ResultSetController.this.currentInx;
                    ResultSetController.this.updateUI();
                    ResultSetController.this.notifyListeners();
                }
            }
        });
    }

    protected void showGotoRecDlg() {
        String recNumStr;
        JTextField tf = UIHelper.createTextField(5);
        CellConstraints cc = new CellConstraints();
        DefaultFormBuilder p = new DefaultFormBuilder(new FormLayout("p,2px,f:p:g", "p"));
        p.add((Component)UIHelper.createI18NLabel("RS_NUM_LBL"), cc.xy(1, 1));
        p.add((Component)tf, cc.xy(3, 1));
        p.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog(null, "", true, 3, (Component)p.getPanel());
        dlg.setCustomTitleBar(UIRegistry.getResourceString("RS_JUMP_TITLE"));
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled() && !(recNumStr = tf.getText()).isEmpty() && StringUtils.isNumeric((String)recNumStr)) {
            try {
                int recNum = Integer.parseInt(recNumStr);
                if (recNum > 0 && recNum <= this.lastInx) {
                    this.setIndex(recNum - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.currentInx = 0;
        this.updateUI();
    }

    public void clear() {
        this.currentInx = -1;
        this.numRecords = 0;
        this.lastInx = -1;
        this.updateUI();
    }

    public void setLength(int len) {
        this.currentInx = len > 0 ? 0 : -1;
        this.numRecords = len;
        this.lastInx = this.numRecords - 1;
        this.updateUI();
    }

    public void setIndex(int index, boolean doIndexNotify) {
        if (index < this.numRecords) {
            int oldInx = this.currentInx;
            this.currentInx = index;
            this.updateUI();
            if (doIndexNotify) {
                this.notifyListenersAboutToChangeIndex(oldInx, this.currentInx);
            }
            this.notifyListeners();
        }
    }

    public void setIndex(int index) {
        this.setIndex(index, true);
    }

    public int getLength() {
        return this.numRecords;
    }

    public int getCurrentIndex() {
        return this.currentInx;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void updateUI() {
        if (this.panel == null) {
            return;
        }
        if (this.newRecBtn != null) {
            boolean enable = this.formValidator == null ? false : this.formValidator.isTopLevel() || !(this.formValidator.getParent() != null ? !this.formValidator.getParent().isEnabled() : !this.formValidator.isEnabled());
            this.newRecBtn.setEnabled(enable);
        }
        boolean isNewAndValid = this.newRecBtn == null ? true : this.newRecBtn.isEnabled();
        this.firstBtn.setEnabled(this.currentInx > 0 && isNewAndValid);
        this.prevBtn.setEnabled(this.currentInx > 0 && isNewAndValid);
        this.nextBtn.setEnabled(this.currentInx < this.lastInx && isNewAndValid);
        this.lastBtn.setEnabled(this.currentInx < this.lastInx && isNewAndValid);
        boolean enabled = this.numRecords > 0;
        this.recDisp.setEnabled(enabled);
        this.recDisp.setBorder(enabled ? enabledBorder : disabledBorder);
        this.recDisp.setText(this.numRecords > 0 ? String.valueOf(this.currentInx + 1) + " of " + this.numRecords : " ");
        if (this.delRecBtn != null) {
            this.delRecBtn.setEnabled(this.numRecords > 0);
        }
        this.panel.validate();
    }

    public JLabel getRecDisp() {
        return this.recDisp;
    }

    public JButton getNewRecBtn() {
        return this.newRecBtn;
    }

    public JButton getDelRecBtn() {
        return this.delRecBtn;
    }

    public JButton getSearchRecBtn() {
        return this.searchRecBtn;
    }

    public void addListener(ResultSetControllerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ResultSetControllerListener l) {
        this.listeners.remove(l);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    protected void notifyListeners() {
        for (ResultSetControllerListener rscl : this.listeners) {
            rscl.indexChanged(this.currentInx);
        }
    }

    protected boolean notifyListenersAboutToChangeIndex(int oldIndex, int newIndex) {
        for (ResultSetControllerListener rscl : this.listeners) {
            boolean isOK = rscl.indexAboutToChange(oldIndex, newIndex);
            if (isOK) continue;
            return false;
        }
        return true;
    }

    protected void setUIEnabled(boolean enabled) {
        if (!enabled) {
            this.firstBtn.setEnabled(false);
            this.prevBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
            this.lastBtn.setEnabled(false);
            this.recDisp.setEnabled(false);
            if (this.newRecBtn != null) {
                this.newRecBtn.setEnabled(false);
            }
            if (this.delRecBtn != null) {
                this.delRecBtn.setEnabled(false);
            }
        } else {
            this.updateUI();
        }
    }

    public boolean isNewObj() {
        return this.isNewObj;
    }

    public void setNewObj(boolean isNewObj) {
        this.isNewObj = isNewObj;
        this.updateUI();
    }

    protected void createRSActions() {
        if (commandsHash == null) {
            commandsHash = new Hashtable();
            UIHelper.CommandType[] commandTypeArray = UIHelper.CommandType.values();
            int n = commandTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIHelper.CommandType cmdType = commandTypeArray[n2];
                RSAction action = new RSAction(cmdType);
                commandsHash.put(cmdType, action);
                ++n2;
            }
        }
    }

    protected static void installRS(ResultSetController rsc) {
        if (commandsHash == null && rsc != null) {
            rsc.createRSActions();
        }
        if (commandsHash != null) {
            for (RSAction<UIHelper.CommandType> rsca : commandsHash.values()) {
                JButton btn;
                rsca.setRs(rsc);
                if (rsc == null || (btn = rsc.btnsHash.get((Object)rsca.getType())) == null) continue;
                KeyStroke ks = UIHelper.getKeyStroke(rsca.getType());
                String ACTION_KEY = rsca.getType().toString();
                InputMap inputMap = btn.getInputMap(2);
                ActionMap actionMap = btn.getActionMap();
                inputMap.put(ks, ACTION_KEY);
                actionMap.put(ACTION_KEY, rsca);
                rsca.setBtn(btn);
            }
        }
    }

    private static void registerFocusListener() {
        final KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                FormViewObj fvo;
                Component permanentFocusOwner = null;
                String propName = e.getPropertyName();
                if (propName.equals("permanentFocusOwner")) {
                    permanentFocusOwner = focusManager.getFocusOwner();
                }
                Component comp = permanentFocusOwner;
                while (comp != null && !(comp instanceof MultiView)) {
                    comp = comp.getParent();
                }
                ResultSetController rsc = null;
                boolean fnd = false;
                if (comp instanceof MultiView && (fvo = ((MultiView)comp).getCurrentViewAsFormViewObj()) != null && fvo.getRsController() != null) {
                    rsc = fvo.getRsController();
                    if (currentFocusedRS == null || currentFocusedRS != rsc) {
                        currentFocusedRS = rsc;
                        fnd = true;
                    }
                }
                if (!fnd) {
                    currentFocusedRS = backStopRS;
                }
                ResultSetController.installRS(currentFocusedRS);
            }
        });
    }

    protected static Integer getMneuInt(String key) {
        String str = UIRegistry.getResourceString(key);
        if (StringUtils.isNotEmpty((String)str)) {
            return new Integer(str.charAt(0));
        }
        return null;
    }

    protected static void createMenuItem(JMenuItem menuItem, String titleKey, UIHelper.CommandType cmdType) {
        KeyStroke ks = UIHelper.getKeyStroke(cmdType);
        JMenuItem mi = new JMenuItem(UIRegistry.getInstance().makeAction(commandsHash.get((Object)cmdType), UIRegistry.getResourceString(titleKey), null, "", ks.getKeyCode(), ks));
        menuItem.add(mi);
    }

    public static void addMenuItems(JMenuItem mi) {
        ResultSetController rsc = new ResultSetController();
        rsc.createRSActions();
        ResultSetController.createMenuItem(mi, "DATA_FIRST", UIHelper.CommandType.First);
        ResultSetController.createMenuItem(mi, "DATA_PREVIOUS", UIHelper.CommandType.Previous);
        ResultSetController.createMenuItem(mi, "DATA_NEXT", UIHelper.CommandType.Next);
        ResultSetController.createMenuItem(mi, "DATA_LAST", UIHelper.CommandType.Last);
    }

    public static void setBackStopRS(ResultSetController backStopRS) {
        ResultSetController.backStopRS = backStopRS;
        ResultSetController.installRS(backStopRS);
    }

    @Override
    public void wasValidated(UIValidator validator) {
        if (this.formValidator != null && this.firstBtn.isEnabled() != this.formValidator.isFormValid()) {
            this.setUIEnabled(this.formValidator.isFormValid());
        }
    }

    class RSAction<T>
    extends AbstractAction
    implements PropertyChangeListener {
        protected UIHelper.CommandType type;
        protected ResultSetController rs = null;
        protected JButton btn = null;

        public RSAction(UIHelper.CommandType type) {
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.rs != null && this.btn != null) {
                switch (this.type) {
                    case First: {
                        this.rs.firstRecord();
                        break;
                    }
                    case Previous: {
                        this.rs.prevRecord();
                        break;
                    }
                    case Next: {
                        this.rs.nextRecord();
                        break;
                    }
                    case Last: {
                        this.rs.lastRecord();
                        break;
                    }
                    case Save: {
                        break;
                    }
                    case NewItem: {
                        break;
                    }
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (!enabled || this.rs == null) {
                super.setEnabled(false);
            } else if (this.btn != null) {
                super.setEnabled(this.btn.isEnabled());
            } else {
                super.setEnabled(false);
            }
        }

        public JButton getBtn() {
            return this.btn;
        }

        public void setBtn(JButton btn) {
            if (this.btn != null) {
                this.btn.removePropertyChangeListener(this);
            }
            this.btn = btn;
            if (this.btn != null) {
                super.setEnabled(this.btn.isEnabled());
                this.btn.addPropertyChangeListener(this);
            }
        }

        public UIHelper.CommandType getType() {
            return this.type;
        }

        public ResultSetController getRs() {
            return this.rs;
        }

        public void setRs(ResultSetController rs) {
            this.rs = rs;
            this.setEnabled(rs != null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                super.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }
}

