/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.RestrictablePanel;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RecordSetTableViewObj
extends TableViewObj {
    protected static final Logger log = Logger.getLogger(RecordSetTableViewObj.class);
    protected JPanel southPanel;
    protected boolean dataTypeError;
    protected boolean shouldCloseSession = false;
    protected FormValidator validator = new FormValidator(null){

        @Override
        public boolean isFormValid() {
            return true;
        }
    };
    protected DataProviderSessionIFace tempSession = null;

    public RecordSetTableViewObj(ViewIFace view, AltViewIFace altView, MultiView mvParent, FormValidator formValidator, int options, String cellName, Class<?> dataClass, Color bgColor) {
        super(view, altView, mvParent, formValidator, options, cellName, dataClass, bgColor);
    }

    @Override
    protected void buildTable() {
        super.buildTable();
    }

    protected void initMainComp() {
        this.mainComp = new RestrictablePanel();
        this.mainComp.setLayout(new BorderLayout());
        if (this.mvParent == null) {
            this.mainComp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }
        this.mainComp.add((Component)this.southPanel, "South");
    }

    @Override
    public String getName() {
        return "RecordSetTable View";
    }

    private void processRecordSet(RecordSetIFace recordSet) {
        String sqlStr;
        this.isLoading = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordSetTableViewObj.this.table.tableChanged(new TableModelEvent(RecordSetTableViewObj.this.model));
                RecordSetTableViewObj.this.table.repaint();
            }
        });
        DBTableIdMgr.getInstance().getInClause(recordSet);
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId());
        DataProviderFactory.getInstance().evict(tableInfo.getClassObj());
        if (this.tempSession == null) {
            this.tempSession = DataProviderFactory.getInstance().createSession();
        }
        if (StringUtils.isNotBlank((String)(sqlStr = DBTableIdMgr.getInstance().getQueryForTable(recordSet)))) {
            this.dataObjList.addAll(this.tempSession.getDataList(sqlStr));
            for (Object obj : this.dataObjList) {
                FormDataObjIFace fdi = (FormDataObjIFace)obj;
                fdi.forceLoad();
            }
        }
        if (this.tempSession != null) {
            this.tempSession.close();
            this.tempSession = null;
        }
        this.isLoading = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordSetTableViewObj.this.table.repaint();
            }
        });
    }

    @Override
    public void setDataObj(Object dataObj) {
        if (this.dataObjList == null) {
            this.dataObjList = new Vector();
        } else {
            this.dataObjList.clear();
        }
        if (dataObj instanceof RecordSetIFace) {
            this.dataObj = dataObj;
            RecordSetIFace recordSet = (RecordSetIFace)dataObj;
            this.processRecordSet(recordSet);
        } else if (dataObj instanceof Set) {
            Object firstDataObj;
            this.dataObj = null;
            Set dataSet = (Set)dataObj;
            if (dataSet.size() > 0 && (firstDataObj = dataSet.iterator().next()) instanceof RecordSetIFace) {
                this.dataObj = firstDataObj;
                this.processRecordSet((RecordSetIFace)firstDataObj);
            }
        } else {
            this.dataObj = null;
        }
        if (this.table != null) {
            this.table.tableChanged(new TableModelEvent(this.model));
        }
        if (this.session == null) {
            this.session = this.tempSession;
        }
        this.setDataIntoUI();
    }

    @Override
    public void setSession(DataProviderSessionIFace session) {
        this.session = null;
    }

    @Override
    public Object getDataObj() {
        return this.dataObj;
    }
}

