/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.ViewBasedDisplayIFace;
import edu.ku.brc.af.ui.forms.CollapsableSepExtraCompFactory;
import edu.ku.brc.af.ui.forms.CollapsableSeparator;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.RecordSetTableViewObj;
import edu.ku.brc.af.ui.forms.TableViewObj;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellSubViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewLoader;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MultiView
extends JPanel {
    public static final int NO_OPTIONS = 0;
    public static final int RESULTSET_CONTROLLER = 1;
    public static final int VIEW_SWITCHER = 2;
    public static final int IS_NEW_OBJECT = 4;
    public static final int HIDE_SAVE_BTN = 8;
    public static final int IS_EDITTING = 16;
    public static final int IS_SINGLE_OBJ = 32;
    public static final int NO_SCROLLBARS = 64;
    public static final int ADD_SEARCH_BTN = 128;
    public static final int DONT_ADD_ALL_ALTVIEWS = 256;
    public static final int USE_ONLY_CREATION_MODE = 512;
    public static final int DONT_USE_EMBEDDED_SEP = 1024;
    public static final int NO_MORE_BTN_FOR_SEP = 2048;
    public static final int COLLAPSE_SEPARATOR = 4096;
    public static final int INCLUDE_ADD_BTN = 8192;
    private static final Logger log = Logger.getLogger(MultiView.class);
    protected MultiView mvParent = null;
    protected String cellName = null;
    protected ViewIFace view;
    protected Hashtable<String, Viewable> viewMapByName = new Hashtable();
    protected Object data = null;
    protected Object parentDataObj = null;
    protected JPanel cardPanel;
    protected CardLayout cardLayout = new CardLayout();
    protected Viewable currentViewable = null;
    protected FormValidator currentValidator = null;
    protected Class<?> classToCreate = null;
    protected FormCellIFace cell = null;
    protected PermissionSettings permissions;
    protected boolean editable = false;
    protected AltViewIFace.CreationMode createWithMode = AltViewIFace.CreationMode.NONE;
    protected boolean ignoreDataChanges = false;
    protected boolean isNewForm = false;
    protected int createOptions = 0;
    protected List<MultiView> kids = new ArrayList<MultiView>();
    protected List<ViewBasedDisplayIFace> displayFrames = null;
    protected boolean isSelectorForm;
    protected String selectorValue = null;
    protected boolean doingSelector = false;
    protected Vector<Object> deletedItems = null;
    protected Vector<Object> toBeSavedItems = null;
    protected CollapsableSeparator separator = null;

    public MultiView(MultiView mvParent, String cellName, ViewIFace view, AltViewIFace.CreationMode createWithMode, int options) {
        this(mvParent, cellName, view, createWithMode, null, options, null, null);
    }

    public MultiView(MultiView mvParent, String cellName, ViewIFace view, AltViewIFace.CreationMode createWithMode, int options, Color bgColor) {
        this(mvParent, cellName, view, createWithMode, null, options, bgColor, null);
    }

    public MultiView(MultiView mvParent, String cellName, ViewIFace view, AltViewIFace.CreationMode createWithMode, String defaultAltViewType, int options) {
        this(mvParent, cellName, view, createWithMode, defaultAltViewType, options, null, null);
    }

    public MultiView(MultiView mvParent, String cellName, ViewIFace view, AltViewIFace.CreationMode createWithMode, String defaultAltViewType, int options, Color bgColor, FormCellIFace cell) {
        this.mvParent = mvParent;
        this.cellName = cellName;
        this.view = view;
        this.createWithMode = createWithMode;
        this.createOptions = options | (createWithMode == AltViewIFace.CreationMode.EDIT ? 16 : 0);
        this.cell = cell;
        String title = cell != null ? cell.getProperty("title") : null;
        this.initializeCardPanel(options, title);
        this.isSelectorForm = StringUtils.isNotEmpty((String)view.getSelectorName());
        if (bgColor != null) {
            this.setBackground(bgColor);
        }
        boolean isUsingSwitcher = MultiView.isOptionOn(this.createOptions, 2);
        boolean isUsingOnlyCreationMode = MultiView.isOptionOn(this.createOptions, 512);
        boolean isUsingSelector = StringUtils.isNotEmpty((String)view.getSelectorName());
        if (mvParent == null && ViewLoader.isDoFieldVerification()) {
            ViewLoader.clearFieldVerInfo();
        }
        this.permissions = AppContextMgr.isSecurityOn() ? MultiView.getPremissionFromView(view, MultiView.getClassNameFromParentMV(null, mvParent, cellName)) : new PermissionSettings(15);
        AltViewIFace defaultAltView = this.createDefaultViewable(defaultAltViewType);
        if (isUsingSwitcher) {
            for (AltViewIFace av : view.getAltViews()) {
                if ((!isUsingOnlyCreationMode || av.getMode() != createWithMode) && (isUsingOnlyCreationMode || av.getMode() != createWithMode && mvParent != null)) continue;
                this.createWithMode = av.getMode();
                this.createViewable(av.getName(), cellName);
            }
        } else if (isUsingSelector && defaultAltView.getMode() == AltViewIFace.CreationMode.EDIT) {
            for (AltViewIFace av : view.getAltViews()) {
                if (av.getMode() != createWithMode || av.getMode() != AltViewIFace.CreationMode.EDIT) continue;
                this.createWithMode = av.getMode();
                this.createViewable(av.getName(), cellName);
            }
        } else {
            this.createViewable(defaultAltView.getName(), cellName);
        }
        this.createWithMode = createWithMode;
        this.editable = defaultAltView.getMode() == AltViewIFace.CreationMode.EDIT;
        this.showView(defaultAltView.getName());
        if (this.currentViewable != null) {
            this.currentValidator = this.currentViewable.getValidator();
        }
        if (mvParent == null && ViewLoader.isDoFieldVerification()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewLoader.displayFieldVerInfo();
                }
            });
        }
    }

    public MultiView(MultiView mvParent, String cellName, ViewIFace view, AltViewIFace altView, AltViewIFace.CreationMode createWithMode, int options) {
        this.mvParent = mvParent;
        this.cellName = cellName;
        this.view = view;
        this.createWithMode = createWithMode;
        this.createOptions = options | (createWithMode == AltViewIFace.CreationMode.EDIT ? 16 : 0);
        this.initializeCardPanel(options, null);
        this.permissions = AppContextMgr.isSecurityOn() ? MultiView.getPremissionFromView(view, MultiView.getClassNameFromParentMV(null, mvParent, cellName)) : new PermissionSettings(15);
        AltViewIFace avi = altView != null ? altView : this.createDefaultViewable(null);
        this.createViewable(avi, cellName);
        this.showView(avi.getName());
    }

    private void initializeCardPanel(int options, String title) {
        if (!MultiView.isOptionOn(options, 1024)) {
            DBTableChildIFace childInfo;
            DBTableInfo parentTblInfo;
            this.setLayout(new BorderLayout());
            String titleStr = this.view.getTitle();
            if (StringUtils.isNotEmpty((String)title)) {
                titleStr = title;
            } else if (this.mvParent != null && StringUtils.isNotEmpty((String)this.cellName) && (parentTblInfo = DBTableIdMgr.getInstance().getByClassName(this.mvParent.getView().getClassName())) != null && (childInfo = parentTblInfo.getItemByName(this.cellName)) != null) {
                titleStr = childInfo.getTitle();
            }
            this.cardPanel = new JPanel(this.cardLayout);
            this.cardPanel.setVisible(!MultiView.isOptionOn(options, 4096));
            JComponent extraComp = CollapsableSepExtraCompFactory.getInstance().getComponent("Form", this.view.getClassName());
            this.separator = new CollapsableSeparator(titleStr, !MultiView.isOptionOn(options, 2048), extraComp);
            this.separator.setInnerComp(this.cardPanel);
            this.cardPanel.setOpaque(false);
            this.add((Component)this.separator, (Object)"North");
            this.add((Component)this.cardPanel, (Object)"Center");
        } else {
            this.setLayout(this.cardLayout);
        }
    }

    public String getCellName() {
        return this.cellName;
    }

    public static String getClassNameFromParentMV(Class<?> dataClass, MultiView parent, String cellName) {
        DBTableInfo tblInfo;
        String className;
        String dataClassName;
        String string = dataClassName = dataClass != null ? dataClass.getSimpleName() : null;
        if (dataClassName == null && parent != null && cellName != null && (className = parent.getView().getClassName()) != null && (tblInfo = DBTableIdMgr.getInstance().getByClassName(className)) != null) {
            DBTableChildIFace childInfo = tblInfo.getItemByName(cellName);
            if (childInfo != null) {
                dataClassName = childInfo.getDataClass().getSimpleName();
            } else {
                log.debug((Object)("Couldn't find cellName[" + cellName + "] for table[" + tblInfo.getName() + "]"));
            }
        }
        return dataClassName;
    }

    public static PermissionSettings getPremissionFromView(ViewIFace view, String shortClassName) {
        String shortClass;
        String string = shortClass = StringUtils.isNotEmpty((String)shortClassName) ? shortClassName : StringUtils.substringAfterLast((String)view.getClassName(), (String)".");
        if (shortClass == null) {
            shortClass = view.getClassName();
        }
        return SecurityMgr.getInstance().getPermission("DO." + shortClass.toLowerCase());
    }

    public PermissionSettings getPermissions() {
        return this.permissions;
    }

    public CollapsableSeparator getSeparator() {
        return this.separator;
    }

    public void preValidate() {
        FormViewObj formViewObj = this.getCurrentViewAsFormViewObj();
        if (formViewObj != null) {
            formViewObj.getValidator().setHasChanged(true);
            formViewObj.getValidator().wasValidated(null);
        }
    }

    public FormValidator getCurrentValidator() {
        if (this.currentViewable != null) {
            return this.currentViewable.getValidator();
        }
        return null;
    }

    public Component getFirstFocusable() {
        FormViewObj formView = this.getCurrentViewAsFormViewObj();
        if (formView != null) {
            return formView.getFirstFocusable();
        }
        return null;
    }

    public Collection<Viewable> getViewables() {
        return this.viewMapByName.values();
    }

    public void getDataFromUI() {
        Enumeration<Viewable> e = this.viewMapByName.elements();
        while (e.hasMoreElements()) {
            Viewable viewable = e.nextElement();
            if (viewable.getValidator() != null && viewable.getValidator().hasChanged()) {
                viewable.getDataFromUI();
            }
            if (!(viewable instanceof RecordSetTableViewObj)) continue;
            viewable.getDataFromUI();
        }
    }

    public void focus() {
        if (this.currentViewable != null) {
            this.currentViewable.focus();
        }
    }

    public void initSubViews() {
        FormViewObj fvo = this.getCurrentViewAsFormViewObj();
        if (fvo != null) {
            fvo.initSubViews();
        }
    }

    public ViewIFace getView() {
        return this.view;
    }

    public List<MultiView> getKids() {
        return this.kids;
    }

    public int getOptions() {
        return this.createOptions;
    }

    public void aboutToShow(boolean show) {
        if (this.currentViewable != null) {
            this.currentViewable.aboutToShow(show);
        }
        this.showDisplayFrames(show);
    }

    public boolean isNewForm() {
        return this.isNewForm;
    }

    public void setIsNewForm(boolean isNewForm, boolean traverseKids) {
        this.isNewForm = isNewForm;
        Enumeration<Viewable> e = this.viewMapByName.elements();
        while (e.hasMoreElements()) {
            Viewable viewable = e.nextElement();
            if (viewable.getValidator() == null) continue;
            FormValidator fv = viewable.getValidator();
            fv.setUIValidatorsToNew(isNewForm);
            if (!isNewForm) {
                fv.setUIValidatorsToNotChanged();
            }
            viewable.setHasNewData(isNewForm);
        }
        if (traverseKids) {
            for (MultiView mv : this.kids) {
                mv.setIsNewForm(isNewForm, traverseKids);
            }
        }
    }

    public void clearValidators() {
        if (this.currentValidator != null) {
            this.currentValidator.setUIValidatorsToNotChanged();
        }
    }

    public boolean hasChanged() {
        return !this.ignoreDataChanges && this.currentValidator != null && this.currentValidator.hasChanged();
    }

    public boolean isTopLevel() {
        return this.mvParent == null;
    }

    public MultiView getTopLevel() {
        if (this.mvParent == null) {
            return this;
        }
        MultiView top = this.mvParent;
        while (top != null && top.getMultiViewParent() != null) {
            top = top.mvParent;
        }
        return top;
    }

    protected AltViewIFace createDefaultViewable(String defAltViewType) {
        AltViewIFace altView = this.createWithMode != null ? this.view.getDefaultAltViewWithMode(this.createWithMode, defAltViewType) : this.view.getDefaultAltView(this.createWithMode, defAltViewType);
        return altView;
    }

    public String getViewName() {
        return this.view.getName();
    }

    protected boolean add(Viewable viewable, String name) {
        if (this.viewMapByName.get(name) != null) {
            log.error((Object)("Adding a Viewable by a name that is already used[" + name + "]"));
            return false;
        }
        viewable.setCellName(this.cellName);
        this.viewMapByName.put(name, viewable);
        if (this.separator != null) {
            this.cardPanel.add(viewable.getUIComponent(), name);
            JComponent controllerPanel = viewable.getControllerPanel();
            if (controllerPanel == null) {
                controllerPanel = new JPanel();
                controllerPanel.setPreferredSize(new Dimension(0, 0));
            }
            this.separator.addToSubPanel(controllerPanel, name);
        } else {
            this.add(viewable.getUIComponent(), (Object)name);
        }
        return true;
    }

    public void setRecordSetItemList(FormViewObj fvo, DBTableInfo tableInfo, List<RecordSetItemIFace> recordSetItemList) {
        for (Viewable viewable : this.viewMapByName.values()) {
            if (viewable == fvo || !(viewable instanceof FormViewObj)) continue;
            ((FormViewObj)viewable).setRecordSetItemList(tableInfo, recordSetItemList);
        }
    }

    public void showView(AltViewIFace altView) {
        if (this.hasChanged()) {
            if (this.currentViewable != null && this.currentViewable.isDataCompleteAndValid(false)) {
                this.showView(altView.getName());
            }
        } else {
            this.showView(altView.getName());
        }
    }

    public void showView(String name) {
        Viewable viewable = this.viewMapByName.get(name);
        if (viewable == null) {
            viewable = this.createViewable(name, null);
        }
        Vector<ViewState> viewStateList = null;
        if (viewable != null) {
            FormViewObj fvo;
            if (this.currentViewable != null) {
                fvo = this.getCurrentViewAsFormViewObj();
                if (fvo != null) {
                    viewStateList = fvo.collectionViewState();
                }
                this.currentViewable.aboutToShow(false);
                if (this.currentViewable.getAltView().getMode() == AltViewIFace.CreationMode.EDIT) {
                    this.currentViewable.getDataFromUI();
                }
                if (this.currentValidator != null) {
                    this.adjustValidationTree(this, this.currentValidator, false);
                }
            }
            this.currentViewable = viewable;
            this.currentViewable.aboutToShow(true);
            this.currentViewable.setParentDataObj(this.parentDataObj);
            this.currentValidator = this.currentViewable.getValidator();
            this.createWithMode = this.currentViewable.getAltView().getMode();
            this.editable = this.createWithMode == AltViewIFace.CreationMode.EDIT;
            this.setData(this.data, false);
            this.setFormForSelector();
            if (viewStateList != null && (fvo = this.getCurrentViewAsFormViewObj()) != null) {
                this.setViewState(viewStateList, this.createWithMode, 0);
            }
            if (this.separator != null) {
                this.cardLayout.show(this.cardPanel, name);
                this.separator.showSubPanel(name);
            } else {
                this.cardLayout.show(this, name);
            }
            if (this.currentValidator != null) {
                if (this.mvParent != null && this.mvParent.getCurrentValidator() != null) {
                    this.adjustValidationTree(this.mvParent, this.mvParent.getCurrentValidator(), true);
                } else {
                    this.adjustValidationTree(this, this.currentValidator, true);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandDispatcher.dispatch(new CommandAction("Data_Entry", "ViewWasShown", MultiView.this.currentViewable));
                }
            });
        } else {
            log.error((Object)"Viewable was null and shouldn't have been!");
        }
    }

    public Viewable createViewable(String altViewName, String cellNameArg) {
        List<AltViewIFace> list = this.view.getAltViews();
        int inx = 0;
        for (AltViewIFace altView : list) {
            if (altViewName.equals(altView.getName())) {
                return this.createViewable(altView, cellNameArg);
            }
            ++inx;
        }
        log.error((Object)("Couldn't find Alt View [" + altViewName + "]in AltViewIFace List"));
        return null;
    }

    protected Viewable createViewable(AltViewIFace altView, String cellNameArg) {
        ViewIFace newView = AppContextMgr.getInstance().getView(this.view.getViewSetName(), altView.getView().getName());
        if (newView != null) {
            int tmpCreateOptions = this.createOptions | (this.createWithMode == AltViewIFace.CreationMode.EDIT ? 16 : 0);
            Viewable viewable = ViewFactory.createFormView(this, newView, altView.getName(), this.data, tmpCreateOptions, cellNameArg, this.getBackground());
            if (viewable != null) {
                if (this.add(viewable, altView.getName())) {
                    if (viewable instanceof TableViewObj && this.cell instanceof FormCellSubViewIFace) {
                        ((TableViewObj)viewable).setVisibleRowCount(((FormCellSubViewIFace)this.cell).getTableRows());
                    }
                    if (this.mvParent != null) {
                        viewable.getUIComponent().validate();
                        viewable.getUIComponent().doLayout();
                    }
                    this.validate();
                    this.invalidate();
                    this.doLayout();
                    return viewable;
                }
            } else {
                log.error((Object)("The Viewable could not be created for some reason View[" + newView + "] AltViewIFace[" + altView.getName() + "] Options[" + this.createOptions + "]"));
            }
        } else {
            log.error((Object)("Unable to load form ViewSetName [" + this.currentViewable.getView().getViewSetName() + "] Name[" + altView.getName() + "]"));
        }
        return null;
    }

    protected void adjustValidationTree(MultiView parent, FormValidator parentVal, boolean doAdd) {
        parentVal.clearKids();
        if (parent != null) {
            for (MultiView kid : parent.kids) {
                FormValidator kidVal = kid.getCurrentValidator();
                if (kidVal == null) continue;
                if (doAdd) {
                    parentVal.add(kid.getCurrentValidator());
                    kidVal.setParent(parentVal);
                }
                this.adjustValidationTree(kid, kidVal, doAdd);
            }
        }
    }

    protected void addCurrentValidator() {
        if (this.currentViewable != null) {
            this.currentValidator = this.currentViewable.getValidator();
            if (this.currentValidator != null && this.mvParent != null) {
                FormValidator parentVal = this.mvParent.getCurrentValidator();
                if (parentVal != null) {
                    parentVal.add(this.currentValidator);
                    this.currentValidator.setParent(parentVal);
                }
                this.adjustValidationTree(this, this.currentValidator, true);
            }
        } else {
            log.error((Object)"CurrentViewable can't be null");
        }
    }

    protected void removeCurrentValidator() {
        if (this.currentValidator != null) {
            this.adjustValidationTree(this.mvParent, this.currentValidator, false);
            FormValidator parentVal = this.currentValidator.getParent();
            if (parentVal != null) {
                parentVal.remove(this.currentValidator);
            }
            this.currentValidator.setParent(null);
        }
    }

    public MultiView getMultiViewParent() {
        return this.mvParent;
    }

    public void setMultiViewParent(MultiView parent) {
        this.mvParent = parent;
    }

    public void addChildMV(MultiView kidMV) {
        this.kids.add(kidMV);
        kidMV.setMultiViewParent(this);
    }

    public void removeChildMV(MultiView kidMV) {
        this.kids.remove(kidMV);
        kidMV.setMultiViewParent(null);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public AltViewIFace.CreationMode getCreateWithMode() {
        return this.createWithMode;
    }

    public void setDataIntoParent(Object dObj) {
        this.data = dObj;
    }

    public void setData(Object data) {
        this.setData(data, true);
    }

    protected void setJustDataObj(Object dObj) {
        this.data = dObj;
    }

    protected void setData(Object data, boolean doSelector) {
        if (this.currentViewable == null) {
            return;
        }
        for (Viewable v : this.viewMapByName.values()) {
            v.enableMultiViewSwitch(false);
        }
        this.data = data;
        this.ignoreDataChanges = true;
        boolean doSetData = true;
        if (doSelector) {
            doSetData = this.setFormForSelector();
        }
        if (doSetData) {
            this.currentViewable.setDataObj(data);
        }
        if (this.isTopLevel() && this.currentViewable != null) {
            this.currentViewable.updateSaveBtn();
        }
        if (this.isTopLevel()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MultiView.this.currentViewable != null) {
                        MultiView.this.currentViewable.focus();
                    }
                }
            });
        }
        for (Viewable v : this.viewMapByName.values()) {
            v.enableMultiViewSwitch(true);
        }
        this.ignoreDataChanges = false;
    }

    protected boolean setFormForSelector() {
        if (this.doingSelector) {
            return true;
        }
        this.doingSelector = true;
        boolean doSetData = true;
        boolean cacheIgnoreDataChanges = this.ignoreDataChanges;
        this.ignoreDataChanges = true;
        this.selectorValue = null;
        if (this.isSelectorForm) {
            AltViewIFace altView = this.currentViewable.getAltView();
            this.currentViewable.setDataObj(this.data);
            String selectorName = altView.getSelectorName();
            DataObjectGettable getter = this.currentViewable.getViewDef().getDataGettable();
            Object selectorDataVal = getter.getFieldValue(this.currentViewable.getDataObj(), selectorName);
            if (selectorDataVal != null) {
                String newSelectorValue = selectorDataVal.toString();
                if (this.selectorValue == null || !this.selectorValue.equals(newSelectorValue)) {
                    this.selectorValue = newSelectorValue;
                    for (AltViewIFace av : this.view.getAltViews()) {
                        if (!StringUtils.isNotEmpty((String)av.getSelectorName()) || !av.getSelectorValue().equals(this.selectorValue) || altView.getMode() != av.getMode()) continue;
                        Viewable oldViewable = this.currentViewable;
                        this.showView(av.getName());
                        if (oldViewable == this.currentViewable) break;
                        this.currentViewable.setDataObj(this.data);
                        doSetData = false;
                        break;
                    }
                }
            }
        }
        this.ignoreDataChanges = cacheIgnoreDataChanges;
        this.doingSelector = false;
        return doSetData;
    }

    public Object getData() {
        if (this.data instanceof Collection) {
            return this.currentViewable.getDataObj();
        }
        return this.data;
    }

    public boolean isAllValidationOK() {
        if (this.currentValidator != null) {
            this.currentValidator.isFormValid();
        }
        return true;
    }

    public void validateAll() {
        if (this.currentValidator != null) {
            this.currentValidator.validateForm();
        }
    }

    public void setParentDataObj(Object parentDataObj) {
        this.parentDataObj = parentDataObj;
        for (Viewable v : this.viewMapByName.values()) {
            v.setParentDataObj(parentDataObj);
        }
        for (MultiView kidMV : this.kids) {
            kidMV.setParentDataObj(parentDataObj);
        }
    }

    public void setClassToCreate(Class<?> classToCreateArg) {
        this.classToCreate = classToCreateArg;
        for (Viewable v : this.viewMapByName.values()) {
            v.setClassToCreate(this.classToCreate);
        }
    }

    public Object getParentDataObj() {
        return this.parentDataObj;
    }

    public void registerDisplayFrame(ViewBasedDisplayIFace frame) {
        if (frame != null) {
            if (this.displayFrames == null) {
                this.displayFrames = new ArrayList<ViewBasedDisplayIFace>();
            }
            this.displayFrames.add(frame);
        } else {
            log.error((Object)"Registering a null frame!");
        }
    }

    public void unregisterDisplayFrame(ViewBasedDisplayIFace frame) {
        if (this.displayFrames != null) {
            this.displayFrames.remove(frame);
        }
    }

    public void showDisplayFrames(boolean show) {
        if (this.displayFrames != null) {
            for (ViewBasedDisplayIFace frame : this.displayFrames) {
                frame.showDisplay(show);
            }
        }
    }

    public Viewable getCurrentView() {
        return this.currentViewable;
    }

    public FormViewObj getCurrentViewAsFormViewObj() {
        return this.currentViewable instanceof FormViewObj ? (FormViewObj)this.currentViewable : null;
    }

    public int getCreateOptions() {
        return this.createOptions;
    }

    public boolean isOKToAddAllAltViews() {
        if (AppContextMgr.isSecurityOn() && this.permissions.isViewOnly()) {
            return false;
        }
        return !MultiView.isOptionOn(this.createOptions, 256);
    }

    public void addDeletedItem(Object deletedItem) {
        if (this.deletedItems == null) {
            this.deletedItems = new Vector();
        }
        boolean addToList = true;
        if (deletedItem instanceof Vector) {
            addToList = false;
        }
        if (addToList) {
            this.deletedItems.add(deletedItem);
        }
    }

    public void addToBeSavedItem(Object toBeSavedItem) {
        if (this.toBeSavedItems == null) {
            this.toBeSavedItems = new Vector();
        }
        boolean addToList = true;
        if (!(toBeSavedItem instanceof FormDataObjIFace)) {
            addToList = false;
        }
        if (addToList) {
            this.toBeSavedItems.add(toBeSavedItem);
        }
    }

    public Vector<Object> getDeletedItems() {
        return this.deletedItems;
    }

    public Vector<Object> getToBeSavedItems() {
        return this.toBeSavedItems;
    }

    public void clearItemsToBeSaved() {
        if (this.toBeSavedItems != null) {
            this.toBeSavedItems.clear();
        }
    }

    public void clearItemsToBeDeleted() {
        if (this.deletedItems != null) {
            this.deletedItems.clear();
        }
    }

    public void setSession(DataProviderSessionIFace session) {
        Enumeration<Viewable> e = this.viewMapByName.elements();
        while (e.hasMoreElements()) {
            e.nextElement().setSession(session);
        }
        for (MultiView mv : this.kids) {
            mv.setSession(session);
        }
    }

    public void updateAutoNumbers() {
        FormViewObj formViewObj = this.getCurrentViewAsFormViewObj();
        if (formViewObj != null) {
            formViewObj.updateAutoNumbers();
        }
        for (MultiView mv : this.kids) {
            mv.updateAutoNumbers();
        }
    }

    public void setViewState(Vector<ViewState> viewStateList, AltViewIFace.CreationMode mode, int vsInx) {
        if (viewStateList != null && vsInx < viewStateList.size()) {
            FormViewObj formViewObj;
            int inx;
            ViewState viewState = viewStateList.get(vsInx);
            if (vsInx > -1 && (inx = viewState.getInx()) > -1 && (formViewObj = this.getCurrentViewAsFormViewObj()) != null && formViewObj.getRsController() != null) {
                formViewObj.getRsController().setIndex(inx);
            }
            for (MultiView mv : this.kids) {
                if (mv.createWithMode != mode) continue;
                mv.setViewState(viewStateList, mode, vsInx + 1);
            }
        }
    }

    public void collectionViewState(Vector<ViewState> viewStateList, AltViewIFace.CreationMode mode, int level) {
        AltViewIFace altView = this.currentViewable.getAltView();
        ViewState viewState = new ViewState(this, this.currentViewable, altView, altView.getViewDef());
        viewStateList.add(viewState);
        FormViewObj formViewObj = this.getCurrentViewAsFormViewObj();
        if (formViewObj != null && formViewObj.getRsController() != null) {
            int curInx = formViewObj.getRsController().getCurrentIndex();
            viewState.setInx(curInx);
        }
        if (this.currentViewable.getDataObj() instanceof FormDataObjIFace) {
            viewState.setIdentity(((FormDataObjIFace)this.currentViewable.getDataObj()).getIdentityTitle());
        }
        for (MultiView mv : this.kids) {
            if (mv.createWithMode != mode) continue;
            mv.collectionViewState(viewStateList, mode, level + 2);
        }
    }

    public void aboutToShutdown() {
        Enumeration<Viewable> e = this.viewMapByName.elements();
        while (e.hasMoreElements()) {
            e.nextElement().aboutToShutdown();
        }
        for (MultiView mv : this.kids) {
            mv.aboutToShutdown();
        }
    }

    public void shutdown() {
        this.mvParent = null;
        this.view = null;
        this.data = null;
        this.parentDataObj = null;
        this.currentViewable = null;
        Enumeration<Viewable> e = this.viewMapByName.elements();
        while (e.hasMoreElements()) {
            e.nextElement().shutdown();
        }
        if (this.currentValidator != null) {
            this.currentValidator.cleanUp();
        }
        for (MultiView mv : this.kids) {
            mv.shutdown();
        }
        this.kids.clear();
        this.shutdownDisplayFrames();
    }

    public void shutdownDisplayFrames() {
        if (this.displayFrames != null) {
            for (ViewBasedDisplayIFace vbd : this.displayFrames) {
                if (vbd != null) {
                    vbd.shutdown();
                    vbd.dispose();
                    continue;
                }
                log.debug((Object)"Display frame was null!");
            }
            this.displayFrames.clear();
        }
    }

    public static boolean isOptionOn(int options, int opt) {
        return (options & opt) == opt;
    }

    public static void printCreateOptions(String msg, int options) {
        log.debug((Object)" ");
        log.debug((Object)msg);
        log.debug((Object)("RESULTSET_CONTROLLER  [" + ((options & 1) == 1 ? "true" : "false") + "]"));
        log.debug((Object)("IS_NEW_OBJECT         [" + ((options & 4) == 4 ? "true" : "false") + "]"));
        log.debug((Object)("VIEW_SWITCHER         [" + ((options & 2) == 2 ? "true" : "false") + "]"));
        log.debug((Object)("HIDE_SAVE_BTN         [" + ((options & 8) == 8 ? "true" : "false") + "]"));
        log.debug((Object)("IS_EDITTING           [" + ((options & 0x10) == 16 ? "true" : "false") + "]"));
        log.debug((Object)("IS_SINGLE_OBJ         [" + ((options & 0x20) == 32 ? "true" : "false") + "]"));
        log.debug((Object)("NO_SCROLLBARS         [" + ((options & 0x40) == 64 ? "true" : "false") + "]"));
        log.debug((Object)("ADD_SEARCH_BTN        [" + ((options & 0x80) == 128 ? "true" : "false") + "]"));
        log.debug((Object)("DONT_ADD_ALL_ALTVIEWS [" + ((options & 0x100) == 256 ? "true" : "false") + "]"));
        log.debug((Object)("USE_ONLY_CREATION_MODE[" + ((options & 0x200) == 512 ? "true" : "false") + "]"));
        log.debug((Object)("DONT_USE_EMBEDDED_SEP [" + ((options & 0x400) == 1024 ? "true" : "false") + "]"));
        log.debug((Object)("NO_MORE_BTN_FOR_SEP   [" + ((options & 0x800) == 2048 ? "true" : "false") + "]"));
        log.debug((Object)("COLLAPSE_SEPARATOR    [" + ((options & 0x1000) == 4096 ? "true" : "false") + "]"));
        log.debug((Object)("INCLUDE_ADD_BTN       [" + ((options & 0x2000) == 8192 ? "true" : "false") + "]"));
        log.debug((Object)" ");
    }

    class ViewState {
        protected MultiView mv;
        protected Viewable viewable;
        protected AltViewIFace altView;
        protected ViewDefIFace viewDef;
        protected int inx;
        protected String identity = null;

        public ViewState(MultiView mv, Viewable viewable, AltViewIFace altView, ViewDefIFace viewDef) {
            this.mv = mv;
            this.viewable = viewable;
            this.altView = altView;
            this.viewDef = viewDef;
            this.inx = -1;
            this.identity = null;
        }

        public String getIdentity() {
            return this.identity;
        }

        public void setIdentity(String identity) {
            this.identity = identity;
        }

        public MultiView getMv() {
            return this.mv;
        }

        public AltViewIFace getAltView() {
            return this.altView;
        }

        public ViewDefIFace getViewDef() {
            return this.viewDef;
        }

        public int getInx() {
            return this.inx;
        }

        public void setInx(int inx) {
            this.inx = inx;
        }

        public Viewable getViewable() {
            return this.viewable;
        }
    }
}

